/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.ExtensionsFactory;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.merge.LinkAttribute;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeAction;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.ModeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;

public class MergeUtils {
    public static Map<EObject, EObject> createClosureMap(List<EObject> closure, ModelType targetModel) {
        HashMap<EObject, EObject> map = new HashMap<EObject, EObject>();
        for (EObject element : closure) {
            if (element.eContainingFeature() == null) continue;
            EObject original = ModelUtils.findElementById((EObject)(element instanceof TypeDeclarationType ? targetModel.getTypeDeclarations() : targetModel), element.eContainingFeature(), MergeUtils.getId(element));
            map.put(element, original);
        }
        return map;
    }

    public static URI createQualifiedUri(URI uri, EObject eObject, boolean qualifyUri) {
        String id = MergeUtils.getId(eObject);
        return qualifyUri && id != null ? uri.appendSegment(eObject.eContainingFeature().getName()).appendSegment(id) : uri;
    }

    public static String getId(EObject eObject) {
        if (eObject instanceof IIdentifiableElement) {
            return ((IIdentifiableElement)eObject).getId();
        }
        if (eObject instanceof TypeDeclarationType) {
            return ((TypeDeclarationType)eObject).getId();
        }
        return null;
    }

    public static String getName(EObject eObject) {
        if (eObject instanceof IIdentifiableElement) {
            return ((IIdentifiableElement)eObject).getName();
        }
        if (eObject instanceof TypeDeclarationType) {
            return ((TypeDeclarationType)eObject).getName();
        }
        return null;
    }

    public static void deleteElement(EObject element, EObject parent) {
        EReference eFtrContainment = element.eContainmentFeature();
        if (eFtrContainment != null) {
            Object containment;
            if (parent == null) {
                parent = element.eContainer();
            }
            if ((containment = parent.eGet((EStructuralFeature)eFtrContainment)) instanceof List) {
                ((List)containment).remove(element);
            } else {
                parent.eUnset((EStructuralFeature)eFtrContainment);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void importElements(EObject eObject, ModelType targetModel, List<EObject> closure, Map<EObject, EObject> map, Map<EObject, MergeAction> reuseReplace, LinkAttribute linkAttribute) {
        void var11_18;
        EObject original;
        Object element;
        void var11_14;
        HashSet<ModelType> roots = new HashSet<ModelType>();
        roots.add(targetModel);
        int i = 0;
        while (i < closure.size()) {
            ModelType containingModel = ModelUtils.findContainingModel(closure.get(i));
            if (containingModel != null) {
                roots.add(containingModel);
            }
            ++i;
        }
        Map refs = CollectionUtils.newMap();
        for (ModelType model : roots) {
            TreeIterator c = model.eAllContents();
            while (c.hasNext()) {
                EObject id;
                AttributeType att;
                IdentifiableReference identifiableReference;
                EObject eObject2 = (EObject)c.next();
                if (!(eObject2 instanceof AttributeType) || (identifiableReference = (att = (AttributeType)eObject2).getReference()) == null || !closure.contains(id = identifiableReference.getIdentifiable())) continue;
                refs.put(identifiableReference, id);
                try {
                    identifiableReference.setIdentifiable(null);
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
        Map reuse = CollectionUtils.newMap();
        Map replace = CollectionUtils.newMap();
        List add = CollectionUtils.newList();
        boolean bl = false;
        while (var11_14 < closure.size()) {
            void var13_25;
            element = closure.get((int)var11_14);
            Object var13_23 = null;
            if (map != null) {
                EObject eObject3 = map.get(element);
            }
            if (var13_25 != null) {
                MergeAction actionId;
                MergeAction action = MergeAction.REPLACE;
                if (reuseReplace != null && (actionId = reuseReplace.get(var13_25)) != null) {
                    action = actionId;
                }
                if (action == MergeAction.REUSE) {
                    reuse.put(element, var13_25);
                } else {
                    if (action != MergeAction.REPLACE) return;
                    replace.put(element, var13_25);
                }
            } else {
                add.add(element);
            }
            ++var11_14;
        }
        for (Map.Entry entry : reuse.entrySet()) {
            EObject eObject4 = (EObject)entry.getKey();
            original = (EObject)entry.getValue();
            EStructuralFeature containingFeature = original.eContainingFeature();
            EObject eContainer = original.eContainer();
            List originalContainer = (List)eContainer.eGet(containingFeature);
            MergeUtils.replace(eObject4, original);
            if (originalContainer.contains(original)) continue;
            originalContainer.add(original);
        }
        for (Map.Entry entry : replace.entrySet()) {
            EObject eObject5 = (EObject)entry.getKey();
            original = (EObject)entry.getValue();
            if (linkAttribute != null) {
                linkAttribute.setLinkInfo(eObject5, eObject5 != eObject);
            }
            if (reuseReplace != null && ShareUtils.isLockableElement(eObject5) && !ShareUtils.isModelShared(targetModel)) {
                UUIDUtils.unsetUUID(eObject5);
            }
            MergeUtils.replace(original, eObject5);
        }
        boolean bl2 = false;
        while (var11_18 < add.size()) {
            void var13_34;
            Object ref;
            element = (EObject)add.get((int)var11_18);
            if (linkAttribute != null) {
                linkAttribute.setLinkInfo((EObject)element, element != eObject);
            }
            Object var13_31 = null;
            if (element instanceof TypeDeclarationType) {
                TypeDeclarationsType typeDeclarationsType = targetModel.getTypeDeclarations();
            } else {
                ModelType modelType = targetModel;
            }
            if (reuseReplace != null && ShareUtils.isLockableElement(element) && !ShareUtils.isModelShared(targetModel)) {
                UUIDUtils.unsetUUID((EObject)element);
            }
            if ((ref = var13_34.eGet(element.eContainingFeature())) instanceof List) {
                ((List)ref).add(element);
            } else {
                var13_34.eSet(element.eContainingFeature(), element);
            }
            ++var11_18;
        }
        for (Map.Entry entry : refs.entrySet()) {
            IdentifiableReference identifiableReference = (IdentifiableReference)entry.getKey();
            EObject element2 = (EObject)entry.getValue();
            EObject original2 = (EObject)reuse.get(element2);
            try {
                identifiableReference.setIdentifiable(original2 == null ? element2 : original2);
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public static void replace(EObject object, EObject replacementObject, boolean preserveContainer) {
        if (preserveContainer) {
            EStructuralFeature containingFeature = replacementObject.eContainingFeature();
            EObject eContainer = replacementObject.eContainer();
            List originalContainer = (List)eContainer.eGet(containingFeature);
            MergeUtils.replace(object, replacementObject);
            if (!originalContainer.contains(replacementObject)) {
                originalContainer.add(replacementObject);
            }
        } else {
            MergeUtils.replace(object, replacementObject);
        }
    }

    public static void replace(EObject object, EObject replacementObject) {
        TreeIterator contents;
        EObject topContainer = object;
        while (topContainer.eContainer() != null) {
            topContainer = topContainer.eContainer();
        }
        if (!(replacementObject instanceof TypeDeclarationType)) {
            MergeUtils.replaceReferences(topContainer, object, replacementObject);
            contents = topContainer.eAllContents();
            while (contents.hasNext()) {
                MergeUtils.replaceReferences((EObject)contents.next(), object, replacementObject);
            }
        }
        try {
            EcoreUtil.replace((EObject)object, (EObject)replacementObject);
        }
        catch (NullPointerException nullPointerException) {}
        if (replacementObject instanceof TypeDeclarationType) {
            MergeUtils.replaceReferences(topContainer, object, replacementObject);
            contents = topContainer.eAllContents();
            while (contents.hasNext()) {
                MergeUtils.replaceReferences((EObject)contents.next(), object, replacementObject);
            }
        }
        if (object instanceof ProcessDefinitionType) {
            MergeUtils.mergeFormalParameter((ProcessDefinitionType)object, (ProcessDefinitionType)replacementObject);
        }
    }

    private static void replaceReferences(EObject source, EObject object, EObject replacementObject) {
        AttributeType attribute;
        IdentifiableReference reference;
        EList crossReferences = source.eCrossReferences();
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)crossReferences.iterator();
        List objects = CollectionUtils.newList();
        List references = CollectionUtils.newList();
        while (featureIterator.hasNext()) {
            objects.add((EObject)featureIterator.next());
            references.add((EReference)featureIterator.feature());
        }
        if (!objects.contains(replacementObject)) {
            int i = 0;
            while (i < objects.size()) {
                List list;
                int index;
                Object target = objects.get(i);
                EReference feature = (EReference)references.get(i);
                if (target == object) {
                    EcoreUtil.replace((EObject)source, (EStructuralFeature)feature, (Object)object, (Object)replacementObject);
                } else if (target instanceof List && (index = (list = (List)target).indexOf(object)) >= 0) {
                    EcoreUtil.replace((EObject)source, (EStructuralFeature)feature, (Object)object, (Object)replacementObject);
                }
                ++i;
            }
        }
        if (source instanceof AttributeType && (reference = (attribute = (AttributeType)source).getReference()) != null && object == reference.getIdentifiable()) {
            reference.setIdentifiable(replacementObject);
        }
    }

    public static void mergeFormalParameter(ProcessDefinitionType source, ProcessDefinitionType target) {
        FormalParameterMappingsType parameterMappings = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
        FormalParametersType formalParameters = XpdlFactory.eINSTANCE.createFormalParametersType();
        FormalParameterMappingsType formalParameterMappings = source.getFormalParameterMappings();
        FormalParametersType referencedParametersType = source.getFormalParameters();
        if (referencedParametersType == null) {
            return;
        }
        for (FormalParameterType referencedParameterType : referencedParametersType.getFormalParameter()) {
            ModeType mode = referencedParameterType.getMode();
            DataType mappedData = formalParameterMappings.getMappedData(referencedParameterType);
            IIdentifiableModelElement modelElement = (IIdentifiableModelElement)MergeUtils.getSameModelElement(mappedData, (ModelType)target.eContainer(), null);
            FormalParameterType parameterType = ModelUtils.cloneFormalParameterType(referencedParameterType, mappedData);
            parameterType.setMode(mode);
            formalParameters.addFormalParameter(parameterType);
            parameterMappings.setMappedData(parameterType, (DataType)modelElement);
        }
        target.setFormalParameters(formalParameters);
        target.setFormalParameterMappings(parameterMappings);
    }

    /*
     * Unable to fully structure code
     */
    public static EObject getSameModelElement(EObject source, ModelType target, Map changedCache) {
        stack = new Stack<EObject>();
        if (source instanceof ModelType) {
            return target;
        }
        if (source instanceof TypeDeclarationsType) {
            return target.getTypeDeclarations();
        }
        if (source instanceof TypeDeclarationType) {
            declarations = target.getTypeDeclarations();
            typeDeclaration = declarations.getTypeDeclaration(((TypeDeclarationType)source).getId());
            return typeDeclaration;
        }
        parent = source.eContainer();
        getParent = false;
        if (parent != null) ** GOTO lbl22
        return null;
lbl-1000:
        // 1 sources

        {
            if (getParent) {
                parent = parent.eContainer();
                if (changedCache != null && (checkParent = (EObject)changedCache.get(parent)) != null) {
                    parent = checkParent;
                }
            }
            if (!(parent instanceof ModelType)) {
                stack.push(parent);
            }
            getParent = true;
lbl22:
            // 2 sources

            ** while (!(parent instanceof ModelType) && parent.eContainer() != null)
        }
lbl23:
        // 1 sources

        if (stack.isEmpty()) {
            return MergeUtils.getSameElement(source, target);
        }
        targetObject = target;
        while (!stack.isEmpty()) {
            child = (EObject)stack.pop();
            parent = MergeUtils.getSameElement(child, targetObject);
            if (parent == null) {
                return null;
            }
            targetObject = parent;
        }
        return MergeUtils.getSameElement(source, targetObject);
    }

    public static EObject getSameElement(EObject source, EObject model) {
        EObject entry;
        Object element;
        if (source instanceof ModelType && model instanceof ModelType) {
            return model;
        }
        String sourceUuid = UUIDUtils.getUUID(source);
        EStructuralFeature feature = source.eContainingFeature();
        if (feature == null) {
            return null;
        }
        if (source instanceof TypeDeclarationType) {
            ModelType theModel = ModelUtils.findContainingModel(model);
            element = theModel.getTypeDeclarations().eGet(feature);
        } else {
            element = model.eGet(feature);
        }
        List list = new ArrayList();
        if (element == null) {
            return null;
        }
        if (!(element instanceof List)) {
            return null;
        }
        list = (List)element;
        int i = 0;
        while (i < list.size()) {
            entry = (EObject)list.get(i);
            String uuid = UUIDUtils.getUUID(entry);
            if (!StringUtils.isEmpty((String)uuid) && !StringUtils.isEmpty((String)sourceUuid) && uuid.equals(sourceUuid)) {
                return entry;
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            entry = (EObject)list.get(i);
            if (entry instanceof IIdentifiableElement && source instanceof IIdentifiableElement && ((IIdentifiableElement)entry).getId() != null && ((IIdentifiableElement)source).getId() != null) {
                if (((IIdentifiableElement)entry).getId().equals(((IIdentifiableElement)source).getId())) {
                    return entry;
                }
            } else if (entry instanceof DiagramType && source instanceof DiagramType) {
                String entryName = ((DiagramType)entry).getName();
                String sourceName = ((DiagramType)source).getName();
                if (entryName == null && sourceName == null) {
                    return entry;
                }
                if (entryName != null && sourceName != null && ((DiagramType)entry).getName().equals(((DiagramType)source).getName())) {
                    return entry;
                }
            } else if (entry instanceof IModelElement && source instanceof IModelElement ? ((IModelElement)entry).getElementOid() == ((IModelElement)source).getElementOid() : entry instanceof TypeDeclarationType && source instanceof TypeDeclarationType && ((TypeDeclarationType)entry).getId().equals(((TypeDeclarationType)source).getId())) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public static void fixDuplicateOids(ModelType model) {
        long highestOid = ModelUtils.getMaxUsedOid(model);
        HashSet<Long> oids = new HashSet<Long>();
        if (model.isSetOid()) {
            oids.add(model.getOid());
        }
        TreeIterator i = model.eAllContents();
        while (i.hasNext()) {
            EObject obj = (EObject)i.next();
            if (!(obj instanceof IModelElement) || !((IModelElement)obj).isSetElementOid()) continue;
            long elementOid = ((IModelElement)obj).getElementOid();
            if (oids.contains(elementOid)) {
                ((IModelElement)obj).setElementOid(highestOid++);
                continue;
            }
            oids.add(((IModelElement)obj).getElementOid());
        }
    }
}

