/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.namespace.QName;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.xmi.NameInfo;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.CwmXmlLoad;
import org.eclipse.stardust.model.xpdl.carnot.util.CwmXmlSave;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;

public class CarnotWorkflowModelResourceImpl
extends XMLResourceImpl {
    private static final String XMLNS_PREFIX = "xmlns";
    private static final String XMLNS_PREFIX_WITH_COLON = "xmlns:";
    public static final String copyright = "Copyright 2000-2009 by SunGard Systeme GmbH";

    public CarnotWorkflowModelResourceImpl(URI uri) {
        super(uri);
    }

    protected XMLHelper createXMLHelper() {
        return new XMLHelperImpl((XMLResource)this){

            public String getURI(String prefix) {
                String uri = super.getURI(prefix);
                if (uri == null && prefix != null && prefix.length() == 0) {
                    return "http://www.carnot.ag/workflowmodel/3.1";
                }
                if ("http://www.wfmc.org/2002/XPDL1.0".equals(uri) || "http://www.wfmc.org/2004/XPDL2.0alpha".equals(uri)) {
                    return "http://www.wfmc.org/2008/XPDL2.1";
                }
                return uri;
            }

            public String getID(EObject obj) {
                return obj instanceof IModelElement ? null : super.getID(obj);
            }

            public String getHREF(EObject obj) {
                URI eProxyURI;
                ModelType model = ModelUtils.findContainingModel(obj);
                if (model != null && model.getExternalPackages() != null && (eProxyURI = ((EObjectImpl)obj).eProxyURI()) != null) {
                    String id = eProxyURI.toString();
                    for (ExternalPackage pkg : model.getExternalPackages().getExternalPackage()) {
                        String path;
                        int ix;
                        String pkgConnectionUri = ExtendedAttributeUtil.getAttributeValue(pkg, "carnot:connection:uri");
                        if (!id.startsWith(pkgConnectionUri) || (ix = (path = id.substring(pkgConnectionUri.length())).indexOf(47)) <= 0) continue;
                        return String.valueOf(path.substring(0, ix)) + ':' + new QName(pkg.getId(), path.substring(ix + 1));
                    }
                }
                return super.getHREF(obj);
            }

            public void populateNameInfo(NameInfo nameInfo, EStructuralFeature feature) {
                String qualifiedName;
                super.populateNameInfo(nameInfo, feature);
                if (nameInfo.getNamespaceURI() == null && ((qualifiedName = nameInfo.getQualifiedName()).equals(CarnotWorkflowModelResourceImpl.XMLNS_PREFIX) || qualifiedName.startsWith(CarnotWorkflowModelResourceImpl.XMLNS_PREFIX_WITH_COLON))) {
                    nameInfo.setNamespaceURI("http://www.w3.org/2000/xmlns/");
                }
            }
        };
    }

    public OutputStream getNewOutputStream() throws IOException {
        return this.getURIConverter().createOutputStream(this.getURI());
    }

    protected XMLLoad createXMLLoad() {
        return new CwmXmlLoad(this.createXMLHelper());
    }

    protected XMLSave createXMLSave() {
        return new CwmXmlSave(this.createXMLHelper());
    }
}

