/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.extensions.dms.data.DmsConstants;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.UnbindActionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.DeclaredTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;

public class UnusedModelElementsSearcher {
    private ModelType model;
    private List processes;
    private List diagrams;
    private Set transitionDatas;
    private Map matchedElements;

    public Map search(ModelType modelType) {
        this.matchedElements = new HashMap();
        this.model = modelType;
        this.processes = this.model.getProcessDefinition();
        this.getTransitionDatas();
        this.getDiagrams();
        this.checkTypeDeclarations();
        this.checkApplications();
        this.checkData();
        this.checkIModelParticipants();
        this.checkLinkTypes();
        return this.matchedElements;
    }

    private void getDiagrams() {
        this.diagrams = new ArrayList();
        for (ProcessDefinitionType process : this.processes) {
            EList<DiagramType> currentDiagrams = process.getDiagram();
            if (currentDiagrams.isEmpty()) continue;
            this.diagrams.addAll(currentDiagrams);
        }
        EList<DiagramType> currentDiagrams = this.model.getDiagram();
        if (!currentDiagrams.isEmpty()) {
            this.diagrams.addAll(currentDiagrams);
        }
    }

    private void getTransitionDatas() {
        this.transitionDatas = new HashSet();
        EList<DataType> datas = this.model.getData();
        ArrayList<TransitionType> transitions = new ArrayList<TransitionType>();
        for (ProcessDefinitionType process : this.processes) {
            EList<TransitionType> processTransitions = process.getTransition();
            if (processTransitions.isEmpty()) continue;
            transitions.addAll((Collection<TransitionType>)processTransitions);
        }
        for (TransitionType transition : transitions) {
            String expression;
            String condition = transition.getCondition();
            if (condition == null || !condition.equals("CONDITION")) continue;
            XmlTextNode type = transition.getExpression();
            String string = expression = type == null ? null : ModelUtils.getCDataString(transition.getExpression().getMixed());
            if (StringUtils.isEmpty((String)expression) || expression.equals("true") || expression.equals("false")) continue;
            for (DataType data : datas) {
                String dataId = data.getId();
                if (expression.indexOf(dataId) == -1) continue;
                this.transitionDatas.add(data);
            }
        }
    }

    private void addModelChildren(List elements) {
        ArrayList modelChildren = (ArrayList)this.matchedElements.get(this.model);
        if (modelChildren == null) {
            modelChildren = new ArrayList();
        }
        modelChildren.addAll(elements);
        this.matchedElements.put(this.model, modelChildren);
    }

    private void checkTypeDeclarations() {
        ArrayList<TypeDeclarationType> elements = new ArrayList<TypeDeclarationType>();
        EList<TypeDeclarationType> typeDeclarations = this.model.getTypeDeclarations().getTypeDeclaration();
        if (typeDeclarations.isEmpty()) {
            return;
        }
        for (TypeDeclarationType typeDeclaration : typeDeclarations) {
            if (this.isTypeDeclarationUsedInDatas(typeDeclaration) || this.isTypeDeclarationUsedInTypeDeclarations(typeDeclaration) || this.isTypeDeclarationUsedInProcesses(typeDeclaration) || this.isElementUsedinApplications(typeDeclaration)) continue;
            elements.add(typeDeclaration);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkApplications() {
        ArrayList<ApplicationType> elements = new ArrayList<ApplicationType>();
        EList<ApplicationType> applications = this.model.getApplication();
        if (applications.isEmpty()) {
            return;
        }
        for (ApplicationType application : applications) {
            if (this.isElementUsedInProcesses(application)) continue;
            elements.add(application);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkData() {
        ArrayList<DataType> elements = new ArrayList<DataType>();
        EList<DataType> datas = this.model.getData();
        if (datas.isEmpty()) {
            return;
        }
        for (DataType data : datas) {
            if (data.isPredefined() || this.isElementUsedInProcesses(data) || this.isDataUsedInConditionalPerformer(data) || this.isDataUsedInOrganization(data) || this.transitionDatas.contains(data)) continue;
            elements.add(data);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkIModelParticipants() {
        ArrayList<IModelParticipant> elements = new ArrayList<IModelParticipant>();
        ArrayList<IModelParticipant> participants = new ArrayList<IModelParticipant>();
        EList<RoleType> roles = this.model.getRole();
        EList<ConditionalPerformerType> conditionalPerformers = this.model.getConditionalPerformer();
        EList<OrganizationType> organizations = this.model.getOrganization();
        if (!roles.isEmpty()) {
            participants.addAll((Collection<IModelParticipant>)roles);
        }
        if (!conditionalPerformers.isEmpty()) {
            participants.addAll((Collection<IModelParticipant>)conditionalPerformers);
        }
        if (!organizations.isEmpty()) {
            participants.addAll((Collection<IModelParticipant>)organizations);
        }
        for (IModelParticipant element : participants) {
            if (element.getId().equals("Administrator") || this.isParticipantUsedInOrganizations(element) || this.isElementUsedInProcesses(element)) continue;
            elements.add(element);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkProcesses() {
        ArrayList elements = new ArrayList();
        EList<ProcessDefinitionType> processes = this.model.getProcessDefinition();
        if (processes.isEmpty()) {
            return;
        }
        for (ProcessDefinitionType process : processes) {
            if (!process.getEventHandler().isEmpty() || !process.getDataPath().isEmpty()) continue;
            process.getExecutingActivities().isEmpty();
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private void checkLinkTypes() {
        ArrayList<LinkTypeType> elements = new ArrayList<LinkTypeType>();
        EList<LinkTypeType> linkTypes = this.model.getLinkType();
        if (linkTypes.isEmpty()) {
            return;
        }
        for (LinkTypeType linkType : linkTypes) {
            if (this.isLinkTypeUsedinDiagrams(linkType)) continue;
            elements.add(linkType);
        }
        if (!elements.isEmpty()) {
            this.addModelChildren(elements);
        }
    }

    private boolean isElementUsedinApplications(EObject element) {
        EList<ApplicationType> applications = this.model.getApplication();
        for (ApplicationType application : applications) {
            EList accessPoints = application.getAccessPoint();
            for (AccessPointType accessPoint : accessPoints) {
                TypeDeclarationType declaration = (TypeDeclarationType)AttributeUtil.getIdentifiable(accessPoint, "carnot:engine:dataType");
                if (declaration == null || !declaration.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLinkTypeUsedinDiagrams(LinkTypeType link) {
        for (DiagramType diagram : this.diagrams) {
            EList<PoolSymbol> pools = diagram.getPoolSymbols();
            int p = 0;
            while (p < pools.size()) {
                PoolSymbol pool = (PoolSymbol)pools.get(p);
                EList<GenericLinkConnectionType> genericLinks = pool.getGenericLinkConnection();
                int i = 0;
                while (i < genericLinks.size()) {
                    GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i);
                    LinkTypeType modelElement = connection.getLinkType();
                    if (modelElement.equals(link)) {
                        return true;
                    }
                    ++i;
                }
                if (this.isLinkTypeUsedinLanes(pool, link)) {
                    return true;
                }
                ++p;
            }
            EList<GenericLinkConnectionType> genericLinks = diagram.getGenericLinkConnection();
            int i = 0;
            while (i < genericLinks.size()) {
                GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i);
                LinkTypeType modelElement = connection.getLinkType();
                if (modelElement.equals(link)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isTypeDeclarationUsedInTypeDeclarations(TypeDeclarationType element) {
        EList<TypeDeclarationType> typeDeclarations = this.model.getTypeDeclarations().getTypeDeclaration();
        for (TypeDeclarationType typeDeclaration : typeDeclarations) {
            List<XSDImport> xsdImports;
            XSDSchema schema = typeDeclaration.getSchema();
            if (schema == null || (xsdImports = TypeDeclarationUtils.getImports(schema)) == null) continue;
            for (XSDImport xsdImport : xsdImports) {
                String nextTypeId;
                String schemaLocation = xsdImport.getSchemaLocation();
                if (schemaLocation == null || !schemaLocation.startsWith("urn:internal:") || !(nextTypeId = schemaLocation.substring("urn:internal:".length())).equals(element.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTypeDeclarationUsedInDatas(TypeDeclarationType element) {
        EList<DataType> datas = this.model.getData();
        for (DataType data : datas) {
            String structuredDataId;
            DataTypeType type = data.getType();
            if (!(type != null && type.getId().equals("struct") ? !StringUtils.isEmpty((String)(structuredDataId = AttributeUtil.getAttributeValue(data, "carnot:engine:dataType"))) && structuredDataId.equals(element.getId()) : this.isDMSDataType(data) && !StringUtils.isEmpty((String)(structuredDataId = AttributeUtil.getAttributeValue(data, DmsConstants.RESOURCE_METADATA_SCHEMA_ATT))) && structuredDataId.equals(element.getId()))) continue;
            return true;
        }
        return false;
    }

    private boolean isTypeDeclarationUsedInProcesses(TypeDeclarationType element) {
        for (ProcessDefinitionType process : this.model.getProcessDefinition()) {
            FormalParametersType parametersType = process.getFormalParameters();
            if (parametersType == null) continue;
            for (FormalParameterType type : parametersType.getFormalParameter()) {
                String declaredTypeId;
                org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType dataType = type.getDataType();
                DeclaredTypeType declaredType = dataType.getDeclaredType();
                if (declaredType == null || StringUtils.isEmpty((String)(declaredTypeId = declaredType.getId())) || !declaredTypeId.equals(element.getId())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isParticipantUsedInOrganizations(IModelParticipant element) {
        EList<OrganizationType> organizations = this.model.getOrganization();
        for (OrganizationType organization : organizations) {
            EList<ParticipantType> participants = organization.getParticipant();
            int cnt = 0;
            while (cnt < participants.size()) {
                IModelParticipant participant = ((ParticipantType)participants.get(cnt)).getParticipant();
                if (participant.equals(element)) {
                    return true;
                }
                ++cnt;
            }
            RoleType role = organization.getTeamLead();
            if (role == null || !role.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isDataUsedInOrganization(DataType element) {
        EList<OrganizationType> organizations = this.model.getOrganization();
        for (OrganizationType organization : organizations) {
            DataType data;
            String dataId;
            if (!AttributeUtil.getBooleanValue(organization, "carnot:engine:bound") || StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue(organization, "carnot:engine:dataId"))) || (data = ModelUtils.findElementById(this.model.getData(), dataId)) == null || !data.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isDataUsedInConditionalPerformer(DataType element) {
        EList<ConditionalPerformerType> conditionalPerformers = this.model.getConditionalPerformer();
        for (ConditionalPerformerType conditionalPerformer : conditionalPerformers) {
            DataType realmData;
            DataType dataType = conditionalPerformer.getData();
            if (dataType != null && dataType.equals(element)) {
                return true;
            }
            String dataId = AttributeUtil.getAttributeValue(conditionalPerformer, "carnot:engine:conditionalPerformer:realmData");
            if (StringUtils.isEmpty((String)dataId) || (realmData = ModelUtils.findElementById(this.model.getData(), dataId)) == null || !realmData.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementUsedInProcesses(EObject element) {
        for (ProcessDefinitionType process : this.processes) {
            if (this.isElementUsedInEventHandlers((List)process.getEventHandler(), element)) {
                return true;
            }
            if (this.isElementUsedInActivities(process, element)) {
                return true;
            }
            if (this.isElementUsedInTriggers(process, element)) {
                return true;
            }
            if (this.isParticipantUsedInProcessDiagrams(process, element)) {
                return true;
            }
            if (this.isDataUsedInProcess(process, element)) {
                return true;
            }
            EList<DataPathType> dataPathList = process.getDataPath();
            for (DataPathType dataPath : dataPathList) {
                DataType data = dataPath.getData();
                if (data == null || !data.equals(element)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDataUsedInProcess(ProcessDefinitionType process, EObject element) {
        if (element instanceof DataType) {
            FormalParameterMappingsType mappings = process.getFormalParameterMappings();
            FormalParametersType formalParameters = process.getFormalParameters();
            if (formalParameters != null && formalParameters.getFormalParameter() != null) {
                for (FormalParameterType type : formalParameters.getFormalParameter()) {
                    DataType mappedData = null;
                    try {
                        mappedData = mappings.getMappedData(type);
                    }
                    catch (NullPointerException nullPointerException) {}
                    if (mappedData == null || !mappedData.equals(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isElementUsedInActivities(ProcessDefinitionType process, EObject element) {
        EList<ActivityType> activities = process.getActivity();
        for (ActivityType activity : activities) {
            if (this.isElementUsedInDataMappings(activity, element)) {
                return true;
            }
            if (this.isElementUsedInEventHandlers((List)activity.getEventHandler(), element)) {
                return true;
            }
            ApplicationType activityApplication = activity.getApplication();
            if (activityApplication != null && activityApplication.equals(element)) {
                return true;
            }
            ProcessDefinitionType activityProcess = activity.getImplementationProcess();
            if (activityProcess != null && activityProcess.equals(element)) {
                return true;
            }
            IModelParticipant activityParticipant = activity.getPerformer();
            if (activityParticipant == null || !activityParticipant.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementUsedInDataMappings(ActivityType activity, EObject element) {
        EList<DataMappingType> dataMappings = activity.getDataMapping();
        for (DataMappingType dataMapping : dataMappings) {
            DataType data = dataMapping.getData();
            if (data == null || !data.equals(element)) continue;
            return true;
        }
        return false;
    }

    private boolean isElementUsedInEventHandlers(List eventHandlers, EObject element) {
        for (EventHandlerType eventHandler : eventHandlers) {
            EList<EventActionType> eventActions = eventHandler.getEventAction();
            for (EventActionType actionType : eventActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
            EList<BindActionType> bindActions = eventHandler.getBindAction();
            for (BindActionType actionType : bindActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
            EList<UnbindActionType> unbindActions = eventHandler.getUnbindAction();
            for (UnbindActionType actionType : unbindActions) {
                if (!(actionType instanceof IExtensibleElement)) continue;
                EList attributes = actionType.getAttribute();
                for (AttributeType attribute : attributes) {
                    IIdentifiableModelElement referencedElement;
                    if (attribute == null || attribute.getReference() == null || (referencedElement = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) == null || !referencedElement.equals(element)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isElementUsedInTriggers(ProcessDefinitionType process, EObject element) {
        EList<TriggerType> triggers = process.getTrigger();
        for (TriggerType trigger : triggers) {
            EList attributes = trigger.getAttribute();
            int a = 0;
            while (a < attributes.size()) {
                EObject referencedElement;
                AttributeType attribute = (AttributeType)attributes.get(a);
                IdentifiableReference reference = attribute.getReference();
                if (reference != null && (referencedElement = reference.getIdentifiable()) != null && referencedElement.equals(element)) {
                    return true;
                }
                ++a;
            }
            EList<ParameterMappingType> mappings = trigger.getParameterMapping();
            int m = 0;
            while (m < mappings.size()) {
                ParameterMappingType mappingType = (ParameterMappingType)mappings.get(m);
                DataType data = mappingType.getData();
                if (data != null && data.equals(element)) {
                    return true;
                }
                ++m;
            }
        }
        return false;
    }

    private boolean isParticipantUsedInProcessDiagrams(ProcessDefinitionType process, EObject element) {
        if (element instanceof IModelParticipant) {
            EList<DiagramType> diagrams = process.getDiagram();
            for (DiagramType diagram : diagrams) {
                EList<PoolSymbol> pools = diagram.getPoolSymbols();
                for (PoolSymbol pool : pools) {
                    if (pool.getLanes().isEmpty()) continue;
                    return this.isParticipantUsedInLanes(pool, element);
                }
            }
        }
        return false;
    }

    private boolean isParticipantUsedInLanes(ISwimlaneSymbol container, EObject element) {
        if (element instanceof IModelParticipant) {
            for (LaneSymbol lane : container.getChildLanes()) {
                IModelParticipant participant = lane.getParticipantReference();
                if (participant != null && participant.equals(element)) {
                    return true;
                }
                if (lane.getChildLanes().isEmpty()) continue;
                return this.isParticipantUsedInLanes(lane, element);
            }
        }
        return false;
    }

    private boolean isLinkTypeUsedinLanes(ISwimlaneSymbol container, LinkTypeType link) {
        for (LaneSymbol lane : container.getChildLanes()) {
            EList<GenericLinkConnectionType> genericLinks = lane.getGenericLinkConnection();
            int i = 0;
            while (i < genericLinks.size()) {
                GenericLinkConnectionType connection = (GenericLinkConnectionType)genericLinks.get(i);
                LinkTypeType modelElement = connection.getLinkType();
                if (modelElement.equals(link)) {
                    return true;
                }
                ++i;
            }
            if (lane.getChildLanes().isEmpty()) continue;
            return this.isLinkTypeUsedinLanes(lane, link);
        }
        return false;
    }

    private boolean isDMSDataType(DataType data) {
        return data.getType().getId().equals("dms-document") || data.getType().getId().equals("dms-document-set") || data.getType().getId().equals("dmsDocument") || data.getType().getId().equals("dmsDocumentList") || data.getType().getId().equals("dmsFolder") || data.getType().getId().equals("dmsFolderList");
    }
}

