/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.util;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.util.DuplicateOidException;

public class ModelOidUtil
extends EContentAdapter {
    private long lastOID = 0L;
    private Map<Long, IModelElement> unsets = CollectionUtils.newMap();
    private Set<Long> oids = CollectionUtils.newSet();
    private boolean enabled = true;
    private boolean valid = false;
    private XMLResource resource;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void notifyChanged(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof IModelElement && notification.getEventType() == 1 && notification.getFeature().equals(CarnotWorkflowModelPackage.eINSTANCE.getIModelElement_ElementOid())) {
            if (!this.valid && this.enabled) {
                throw new DuplicateOidException("invalid setting of oid!");
            }
            this.oids.remove(notification.getOldLongValue());
            this.oids.add(notification.getNewLongValue());
        }
        super.notifyChanged(notification);
    }

    protected synchronized void addAdapter(Notifier notifier) {
        super.addAdapter(notifier);
        if (notifier instanceof IModelElement) {
            this.valid = true;
            IModelElement element = (IModelElement)notifier;
            if (element.isSetElementOid()) {
                long elementOid = element.getElementOid();
                if (this.unsets != null && this.unsets.containsKey(elementOid)) {
                    this.setElementOid(this.unsets.remove(elementOid));
                } else if (this.oids.contains(elementOid)) {
                    element.setElementOid(++this.lastOID);
                    this.oids.add(this.lastOID);
                    if (this.resource != null) {
                        this.resource.setID((EObject)element, new Long(this.lastOID).toString());
                    }
                } else {
                    this.lastOID = Math.max(this.lastOID, elementOid);
                    this.oids.add(elementOid);
                }
            } else {
                this.setElementOid(element);
            }
            this.valid = false;
        }
    }

    protected synchronized void removeAdapter(Notifier notifier) {
        super.removeAdapter(notifier);
        if (notifier instanceof IModelElement) {
            this.oids.remove(((IModelElement)notifier).getElementOid());
        }
    }

    private void setElementOid(IModelElement element) {
        element.setElementOid(++this.lastOID);
        if (this.unsets != null) {
            this.unsets.put(this.lastOID, element);
        }
        this.oids.add(this.lastOID);
    }

    public static ModelOidUtil register(ModelType model, long maxUsedOid, Resource resource) {
        ModelOidUtil m = new ModelOidUtil();
        m.lastOID = maxUsedOid;
        if (resource != null && resource instanceof XMLResource) {
            m.resource = (XMLResource)resource;
        }
        model.eAdapters().add((Object)m);
        m.unsets = null;
        return m;
    }
}

