/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TypeType implements Enumerator
{
    STRING_LITERAL(0, "STRING", "STRING"),
    FLOAT_LITERAL(1, "FLOAT", "FLOAT"),
    INTEGER_LITERAL(2, "INTEGER", "INTEGER"),
    REFERENCE_LITERAL(3, "REFERENCE", "REFERENCE"),
    DATETIME_LITERAL(4, "DATETIME", "DATETIME"),
    BOOLEAN_LITERAL(5, "BOOLEAN", "BOOLEAN"),
    PERFORMER_LITERAL(6, "PERFORMER", "PERFORMER");

    public static final String copyright = "Copyright 2008 by SunGard";
    public static final int STRING = 0;
    public static final int FLOAT = 1;
    public static final int INTEGER = 2;
    public static final int REFERENCE = 3;
    public static final int DATETIME = 4;
    public static final int BOOLEAN = 5;
    public static final int PERFORMER = 6;
    private static final TypeType[] VALUES_ARRAY;
    public static final List<TypeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TypeType[]{STRING_LITERAL, FLOAT_LITERAL, INTEGER_LITERAL, REFERENCE_LITERAL, DATETIME_LITERAL, BOOLEAN_LITERAL, PERFORMER_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TypeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TypeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TypeType get(int value) {
        switch (value) {
            case 0: {
                return STRING_LITERAL;
            }
            case 1: {
                return FLOAT_LITERAL;
            }
            case 2: {
                return INTEGER_LITERAL;
            }
            case 3: {
                return REFERENCE_LITERAL;
            }
            case 4: {
                return DATETIME_LITERAL;
            }
            case 5: {
                return BOOLEAN_LITERAL;
            }
            case 6: {
                return PERFORMER_LITERAL;
            }
        }
        return null;
    }

    private TypeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

