/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2.impl;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.QNameUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.xsd.XSDSchema;

public class ExternalReferenceTypeImpl
extends EObjectImpl
implements ExternalReferenceType {
    public static final String copyright = "Copyright 2008 by SunGard";
    private XSDSchema schema = null;
    protected static final String LOCATION_EDEFAULT = null;
    protected String location = LOCATION_EDEFAULT;
    protected static final String NAMESPACE_EDEFAULT = null;
    protected String namespace = NAMESPACE_EDEFAULT;
    protected static final String XREF_EDEFAULT = null;
    protected String xref = XREF_EDEFAULT;

    protected ExternalReferenceTypeImpl() {
    }

    protected EClass eStaticClass() {
        return XpdlPackage.Literals.EXTERNAL_REFERENCE_TYPE;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String newNamespace) {
        String oldNamespace = this.namespace;
        this.namespace = newNamespace;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldNamespace, (Object)this.namespace));
        }
    }

    @Override
    public String getXref() {
        return this.xref;
    }

    @Override
    public void setXref(String newXref) {
        String oldXref = this.xref;
        this.xref = newXref;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldXref, (Object)this.xref));
        }
    }

    @Override
    public XSDSchema getSchema() {
        if (this.location != null) {
            if (this.location.startsWith("urn:internal:")) {
                return this.getInternalSchema();
            }
            return this.getReferencedSchema();
        }
        return null;
    }

    private XSDSchema getInternalSchema() {
        XpdlTypeType type;
        TypeDeclarationsType declarations;
        TypeDeclarationType internalType;
        String typeId = this.location.substring("urn:internal:".length());
        if (typeId.length() > 0 && (internalType = (declarations = (TypeDeclarationsType)this.eContainer().eContainer()).getTypeDeclaration(typeId)) != null && (type = internalType.getDataType()) instanceof SchemaTypeType) {
            return ((SchemaTypeType)type).getSchema();
        }
        return null;
    }

    private String getWorkspaceRelativePath() {
        TypeDeclarationType declaration = (TypeDeclarationType)this.eContainer();
        return ExtendedAttributeUtil.getAttributeValue(declaration, "carnot:engine:resource:mapping:eclipseWorkspaceFile");
    }

    private XSDSchema loadSchema(String schemaLocation, String namespaceURI) {
        if (StringUtils.isNotEmpty((String)schemaLocation)) {
            try {
                return TypeDeclarationUtils.getSchema(schemaLocation, namespaceURI);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private synchronized XSDSchema getReferencedSchema() {
        if (this.schema == null) {
            String namespaceURI = QNameUtil.parseNamespaceURI(this.xref);
            String workspacePath = this.getWorkspaceRelativePath();
            this.schema = this.loadSchema(workspacePath, namespaceURI);
            if (this.schema == null) {
                String alternateUrl = this.getAlternateURL();
                this.schema = this.loadSchema(alternateUrl, namespaceURI);
            }
            if (this.schema == null) {
                this.schema = this.loadSchema(this.location, namespaceURI);
            }
        }
        return this.schema;
    }

    private String getAlternateURL() {
        TypeDeclarationType declaration = (TypeDeclarationType)this.eContainer();
        String url = ExtendedAttributeUtil.getAttributeValue(declaration, "carnot:engine:resource:mapping:localFile");
        if (url == null) {
            url = this.location;
        }
        if (!url.toLowerCase().startsWith("http://")) {
            try {
                IProject project = ModelUtils.getProjectFromEObject(declaration);
                if (project != null) {
                    url = this.getFileUrl(project, url);
                } else {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int i = 0;
                    while (i < projects.length) {
                        IProject proj = projects[i];
                        url = this.getFileUrl(proj, url);
                        ++i;
                    }
                }
            }
            catch (Throwable throwable) {
                return url;
            }
        }
        return url;
    }

    private String getFileUrl(IProject project, String url) {
        block4: {
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) break block4;
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                int i = 0;
                while (i < roots.length) {
                    IFolder folder;
                    IFile file;
                    IResource resource = roots[i].getCorrespondingResource();
                    if (resource instanceof IFolder && (file = (folder = (IFolder)resource).getFile(url)).exists()) {
                        url = file.toString().substring(1);
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getLocation();
            }
            case 1: {
                return this.getNamespace();
            }
            case 2: {
                return this.getXref();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLocation((String)newValue);
                return;
            }
            case 1: {
                this.setNamespace((String)newValue);
                return;
            }
            case 2: {
                this.setXref((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 1: {
                this.setNamespace(NAMESPACE_EDEFAULT);
                return;
            }
            case 2: {
                this.setXref(XREF_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 1: {
                return NAMESPACE_EDEFAULT == null ? this.namespace != null : !NAMESPACE_EDEFAULT.equals(this.namespace);
            }
            case 2: {
                return XREF_EDEFAULT == null ? this.xref != null : !XREF_EDEFAULT.equals(this.xref);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (location: ");
        result.append(this.location);
        result.append(", namespace: ");
        result.append(this.namespace);
        result.append(", xref: ");
        result.append(this.xref);
        result.append(')');
        return result.toString();
    }
}

