/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2.util;

import java.text.MessageFormat;
import org.eclipse.stardust.model.xpdl.carnot.Model_Messages;

public final class QNameUtil {
    private QNameUtil() {
    }

    public static String toString(String namespaceURI, String localPart) {
        if (namespaceURI == null) {
            return localPart;
        }
        return "{" + namespaceURI + "}" + localPart;
    }

    public static String parseNamespaceURI(String qNameAsString) {
        if (qNameAsString == null) {
            return null;
        }
        if (qNameAsString.length() == 0) {
            return null;
        }
        if (qNameAsString.charAt(0) != '{') {
            return null;
        }
        if (qNameAsString.startsWith("{}")) {
            return null;
        }
        int endOfNamespaceURI = qNameAsString.indexOf(125);
        if (endOfNamespaceURI == -1) {
            throw new IllegalArgumentException(MessageFormat.format(Model_Messages.EXC_CANNOT_PARSE_QNAME_FROM_NULL, qNameAsString));
        }
        return qNameAsString.substring(1, endOfNamespaceURI);
    }

    public static String parseLocalName(String qNameAsString) {
        if (qNameAsString == null) {
            return null;
        }
        if (qNameAsString.length() == 0) {
            return qNameAsString;
        }
        if (qNameAsString.charAt(0) != '{') {
            return qNameAsString;
        }
        if (qNameAsString.startsWith("{}")) {
            return qNameAsString.substring(2);
        }
        int endOfNamespaceURI = qNameAsString.indexOf(125);
        if (endOfNamespaceURI == -1) {
            throw new IllegalArgumentException(MessageFormat.format(Model_Messages.EXC_CANNOT_PARSE_QNAME_FROM_NULL, qNameAsString));
        }
        return qNameAsString.substring(endOfNamespaceURI + 1);
    }
}

