/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.ui.UI_Messages;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class CollisionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button chkUpdate;
    private Button chkRefresh;
    private LabeledText refreshRate;
    private Button chkRetry;
    private LabeledText retryRate;
    private ModifyListener rateListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String refreshValue = CollisionPreferencePage.this.refreshRate.getText().getText();
            boolean isValid = CollisionPreferencePage.this.validate(refreshValue);
            if (isValid) {
                refreshValue = CollisionPreferencePage.this.retryRate.getText().getText();
                isValid = CollisionPreferencePage.this.validate(refreshValue);
            }
            if (!isValid) {
                CollisionPreferencePage.this.setErrorMessage(UI_Messages.CollisionPreferencePage_refreshRateValidation);
                CollisionPreferencePage.this.setValid(false);
            } else {
                CollisionPreferencePage.this.setValid(true);
                CollisionPreferencePage.this.setErrorMessage(null);
            }
        }
    };

    protected Control createContents(Composite parent) {
        Composite panel = FormBuilder.createComposite((Composite)parent, (int)3);
        Group updateGroup = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.CollisionPreferencePage_Update, (int)1, (int)3);
        updateGroup.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.chkUpdate = FormBuilder.createCheckBox((Composite)updateGroup, (String)UI_Messages.CollisionPreferencePage_enableUpdate, (int)3);
        Group refreshGroup = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.CollisionPreferencePage_Refresh, (int)2, (int)3);
        refreshGroup.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.chkRefresh = FormBuilder.createCheckBox((Composite)refreshGroup, (String)UI_Messages.CollisionPreferencePage_enableRefresh, (int)3);
        this.refreshRate = FormBuilder.createLabeledText((Composite)refreshGroup, (String)UI_Messages.CollisionPreferencePage_refreshRate);
        Group retryGroup = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.CollisionPreferencePage_Retry, (int)2, (int)3);
        this.chkRetry = FormBuilder.createCheckBox((Composite)retryGroup, (String)UI_Messages.CollisionPreferencePage_enableRetry, (int)3);
        retryGroup.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.retryRate = FormBuilder.createLabeledText((Composite)retryGroup, (String)UI_Messages.CollisionPreferencePage_retryRate);
        this.setValues();
        return panel;
    }

    private void setValues() {
        this.chkUpdate.setSelection(PlatformUI.getPreferenceStore().getBoolean("collisionUpdate"));
        this.chkRefresh.setSelection(PlatformUI.getPreferenceStore().getBoolean("collisionRefresh"));
        this.refreshRate.getText().setText(PlatformUI.getPreferenceStore().getString("collisionRefreshRate"));
        this.chkRetry.setSelection(PlatformUI.getPreferenceStore().getBoolean("collisionRetry"));
        this.retryRate.getText().setText(PlatformUI.getPreferenceStore().getString("collisionConnectionRetryRate"));
        this.refreshRate.getText().addModifyListener(this.rateListener);
        this.retryRate.getText().addModifyListener(this.rateListener);
    }

    public boolean performOk() {
        PlatformUI.getPreferenceStore().setValue("collisionUpdate", this.chkUpdate.getSelection());
        PlatformUI.getPreferenceStore().setValue("collisionRefresh", this.chkRefresh.getSelection());
        PlatformUI.getPreferenceStore().setValue("collisionRefreshRate", this.refreshRate.getText().getText());
        PlatformUI.getPreferenceStore().setValue("collisionRetry", this.chkRetry.getSelection());
        PlatformUI.getPreferenceStore().setValue("collisionConnectionRetryRate", this.retryRate.getText().getText());
        return true;
    }

    public void init(IWorkbench workbench) {
    }

    private boolean validate(String refreshValue) {
        boolean isValid = true;
        if (StringUtils.isEmpty((String)refreshValue)) {
            isValid = false;
        } else {
            int value = 0;
            try {
                value = Integer.parseInt(refreshValue);
            }
            catch (NumberFormatException numberFormatException) {
                isValid = false;
            }
            if (value < 30 || value > 7200) {
                isValid = false;
            }
        }
        return isValid;
    }
}

