/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.preferences;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.modeling.common.ui.UI_Messages;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DrawingPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button chkHorizontalModeling;
    private Button chkVerticalModeling;
    private Button chkClassicModeOn;
    private Button chkClassicModeOff;
    private Button radioOneSymbolToGrid;
    private Button radioAllSymbolsToGrid;
    private Button radioPromptGrid;
    private Button chkViewForkOnTraversal;
    private Button chkEnableSnapGrid;
    private LabeledText snapGridPixel;
    private LabeledText visibleGridFactor;
    private Button splitAND;
    private Button splitXOR;
    private Button splitPrompt;
    private Button joinAND;
    private Button joinXOR;
    private Button joinPrompt;
    private ModifyListener snapGridListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (!DrawingPreferencePage.this.validateSnapGridValues(DrawingPreferencePage.this.snapGridPixel.getText().getText()) && !DrawingPreferencePage.this.validateSnapGridValues(DrawingPreferencePage.this.visibleGridFactor.getText().getText())) {
                DrawingPreferencePage.this.setErrorMessage(UI_Messages.WorkbenchPreferencePage_SnapGridValidationErrorMessage);
                DrawingPreferencePage.this.setValid(false);
            } else if (!DrawingPreferencePage.this.validateSnapGridValues(DrawingPreferencePage.this.snapGridPixel.getText().getText())) {
                DrawingPreferencePage.this.setErrorMessage(UI_Messages.WorkbenchPreferencePage_SnapGridValidationErrorMessage);
                DrawingPreferencePage.this.setValid(false);
            } else if (!DrawingPreferencePage.this.validateSnapGridValues(DrawingPreferencePage.this.visibleGridFactor.getText().getText())) {
                DrawingPreferencePage.this.setErrorMessage(UI_Messages.WorkbenchPreferencePage_SnapGridValidationErrorMessage);
                DrawingPreferencePage.this.setValid(false);
            } else {
                DrawingPreferencePage.this.setValid(true);
                DrawingPreferencePage.this.setErrorMessage(null);
            }
        }
    };

    public DrawingPreferencePage() {
    }

    public DrawingPreferencePage(String title) {
        super(title);
    }

    public DrawingPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    private boolean validateSnapGridValues(String input) {
        boolean valid = true;
        Pattern pattern = Pattern.compile("^\\d+$");
        if (StringUtils.isEmpty((String)input)) {
            valid = false;
        } else if (input.length() > 2) {
            valid = false;
        } else {
            Matcher pixelMatcher = pattern.matcher(input);
            if (!pixelMatcher.matches()) {
                valid = false;
            } else {
                int value = Integer.parseInt(input);
                if (value <= 0) {
                    valid = false;
                }
            }
        }
        return valid;
    }

    protected Control createContents(Composite parent) {
        Composite panel = FormBuilder.createComposite((Composite)parent, (int)3);
        this.chkViewForkOnTraversal = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_ViewForkOnTraversalLabel, (int)3);
        this.chkEnableSnapGrid = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_EnableSnapToGridLabel, (int)3);
        Group groupSnapGrid = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_SnapGridLabel, (int)2, (int)3);
        groupSnapGrid.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.snapGridPixel = FormBuilder.createLabeledText((Composite)groupSnapGrid, (String)UI_Messages.WorkbenchPreferencePage_SnapGridPixelLabel);
        this.visibleGridFactor = FormBuilder.createLabeledText((Composite)groupSnapGrid, (String)UI_Messages.WorkbenchPreferencePage_VisibleGridFactorLabel);
        Group group = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_ModelingDirectionLabel, (int)3, (int)3);
        group.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.chkVerticalModeling = FormBuilder.createRadioButton((Composite)group, (String)UI_Messages.WorkbenchPreferencePage_VerticalDirection);
        this.chkHorizontalModeling = FormBuilder.createRadioButton((Composite)group, (String)UI_Messages.WorkbenchPreferencePage_HorizontalDirection);
        Button dummyRadioButtonForAligning = FormBuilder.createRadioButton((Composite)group, (String)"ignore me");
        dummyRadioButtonForAligning.setEnabled(false);
        dummyRadioButtonForAligning.setVisible(false);
        Group groupClassicMode = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_DefaultDiagramMode, (int)3, (int)3);
        groupClassicMode.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.chkClassicModeOn = FormBuilder.createRadioButton((Composite)groupClassicMode, (String)UI_Messages.WorkbenchPreferencePage_DiagramMode_On);
        this.chkClassicModeOff = FormBuilder.createRadioButton((Composite)groupClassicMode, (String)UI_Messages.WorkbenchPreferencePage_DiagramMode_Off);
        Button dummyRadioButtonForAligningVintage = FormBuilder.createRadioButton((Composite)groupClassicMode, (String)"ignore me");
        dummyRadioButtonForAligningVintage.setEnabled(false);
        dummyRadioButtonForAligningVintage.setVisible(false);
        Group groupDistributeOption = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_AutoDistribute, (int)3, (int)3);
        groupDistributeOption.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.radioOneSymbolToGrid = FormBuilder.createRadioButton((Composite)groupDistributeOption, (String)UI_Messages.LB_SnapLastSymbol);
        this.radioAllSymbolsToGrid = FormBuilder.createRadioButton((Composite)groupDistributeOption, (String)UI_Messages.LB_SnapAllSymbols);
        this.radioPromptGrid = FormBuilder.createRadioButton((Composite)groupDistributeOption, (String)UI_Messages.LB_Prompt);
        Group splitType = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_DefaultSplitType, (int)3, (int)3);
        splitType.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.splitAND = FormBuilder.createRadioButton((Composite)splitType, (String)UI_Messages.LB_AND);
        this.splitXOR = FormBuilder.createRadioButton((Composite)splitType, (String)UI_Messages.LB_XOR);
        this.splitPrompt = FormBuilder.createRadioButton((Composite)splitType, (String)UI_Messages.LB_Prompt);
        Group joinType = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_DefaultJoinType, (int)3, (int)3);
        joinType.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.joinAND = FormBuilder.createRadioButton((Composite)joinType, (String)UI_Messages.LB_AND);
        this.joinXOR = FormBuilder.createRadioButton((Composite)joinType, (String)UI_Messages.LB_XOR);
        this.joinPrompt = FormBuilder.createRadioButton((Composite)joinType, (String)UI_Messages.LB_Prompt);
        this.updateCheckbox();
        this.updateSpitJoin();
        this.updateAutoDistributeGroup();
        return panel;
    }

    private void updateSpitJoin() {
        this.splitAND.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturesplitAND"));
        this.splitXOR.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturesplitXOR"));
        this.splitPrompt.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturesplitPrompt"));
        this.joinAND.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturejoinAND"));
        this.joinXOR.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturejoinXOR"));
        this.joinPrompt.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturejoinPrompt"));
    }

    private void updateAutoDistributeGroup() {
        this.radioOneSymbolToGrid.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureoneSymbol"));
        this.radioAllSymbolsToGrid.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureallSymbols"));
        this.radioPromptGrid.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnatureprompt"));
    }

    private void updateCheckbox() {
        this.chkViewForkOnTraversal.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.viewForkOnTraversalMode"));
        this.chkEnableSnapGrid.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.snapGridMode"));
        this.snapGridPixel.getText().setText(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.snapGridPixel"));
        this.visibleGridFactor.getText().setText(PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.visibleGridFactor"));
        this.snapGridPixel.getText().addModifyListener(this.snapGridListener);
        this.visibleGridFactor.getText().addModifyListener(this.snapGridListener);
        String direction = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.modelingDirection");
        this.chkVerticalModeling.setSelection(OrientationType.VERTICAL_LITERAL.toString().equals(direction));
        this.chkHorizontalModeling.setSelection(OrientationType.HORIZONTAL_LITERAL.toString().equals(direction));
        boolean classicMode = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.classicMode");
        this.chkClassicModeOn.setSelection(classicMode);
        this.chkClassicModeOff.setSelection(!classicMode);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.viewForkOnTraversalMode", this.chkViewForkOnTraversal.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.snapGridMode", this.chkEnableSnapGrid.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.snapGridPixel", this.snapGridPixel.getText().getText());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.visibleGridFactor", this.visibleGridFactor.getText().getText());
        String direction = "Vertical";
        if (this.chkVerticalModeling.getSelection()) {
            direction = OrientationType.VERTICAL_LITERAL.toString();
        } else if (this.chkHorizontalModeling.getSelection()) {
            direction = OrientationType.HORIZONTAL_LITERAL.toString();
        }
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.modelingDirection", direction);
        boolean classicMode = true;
        if (this.chkClassicModeOn.getSelection()) {
            classicMode = true;
        } else if (this.chkClassicModeOff.getSelection()) {
            classicMode = false;
        }
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.classicMode", classicMode);
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureoneSymbol", this.radioOneSymbolToGrid.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureallSymbols", this.radioAllSymbolsToGrid.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnatureprompt", this.radioPromptGrid.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturesplitAND", this.splitAND.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturesplitXOR", this.splitXOR.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturesplitPrompt", this.splitPrompt.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturejoinAND", this.joinAND.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturejoinXOR", this.joinXOR.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturejoinPrompt", this.joinPrompt.getSelection());
        return true;
    }

    protected void performDefaults() {
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.modelingDirection");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.classicMode");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnatureoneSymbol");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnatureallSymbols");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnatureprompt");
        this.updateCheckbox();
        this.updateSpitJoin();
        this.updateAutoDistributeGroup();
    }
}

