/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.stardust.modeling.common.ui.UI_Messages;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class WorkbenchPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button chkEnableAutoValidation;
    private Text licenseFilePath;
    private Button chkEnableAutoIdGeneration;
    private Button radioFocusModeElement;
    private Button radioFocusModePropertyDialog;
    private Button radioFocusModeEditBox;
    private Button radioAlwaysSwitchActivityType;
    private Button radioNeverSwitchActivityType;
    private Button radioWarnSwitchActivityType;
    private Button chkEnableAutoSubprocessNameGeneration;
    private Button radioReportFormatPDF;
    private Button radioReportFormatHTML;
    private Button radioPromptReportFormat;

    public WorkbenchPreferencePage() {
    }

    public WorkbenchPreferencePage(String title) {
        super(title);
    }

    public WorkbenchPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite panel = FormBuilder.createComposite((Composite)parent, (int)3);
        this.chkEnableAutoValidation = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_autoValidation, (int)3);
        this.chkEnableAutoIdGeneration = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_autoIdGeneration, (int)3);
        this.chkEnableAutoSubprocessNameGeneration = FormBuilder.createCheckBox((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_autoSubprocessNameGeneration, (int)3);
        Group groupSwitchFocusMode = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_SwitchFocusMode, (int)3, (int)3);
        groupSwitchFocusMode.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.radioFocusModeElement = FormBuilder.createRadioButton((Composite)groupSwitchFocusMode, (String)UI_Messages.LB_Element);
        this.radioFocusModePropertyDialog = FormBuilder.createRadioButton((Composite)groupSwitchFocusMode, (String)UI_Messages.LB_PropertyDialog);
        this.radioFocusModeEditBox = FormBuilder.createRadioButton((Composite)groupSwitchFocusMode, (String)UI_Messages.LB_EditBox);
        Group groupSwitchActivityType = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_SwitchAutomaticallyActivityType, (int)3, (int)3);
        groupSwitchActivityType.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.radioAlwaysSwitchActivityType = FormBuilder.createRadioButton((Composite)groupSwitchActivityType, (String)UI_Messages.LB_Always);
        this.radioNeverSwitchActivityType = FormBuilder.createRadioButton((Composite)groupSwitchActivityType, (String)UI_Messages.LB_Never);
        this.radioWarnSwitchActivityType = FormBuilder.createRadioButton((Composite)groupSwitchActivityType, (String)UI_Messages.LB_ShowWarning);
        Group groupReportFormat = FormBuilder.createGroup((Composite)panel, (String)UI_Messages.LB_ReportFormat, (int)3);
        groupReportFormat.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData((int)3));
        this.radioReportFormatHTML = FormBuilder.createRadioButton((Composite)groupReportFormat, (String)"HTML");
        this.radioReportFormatPDF = FormBuilder.createRadioButton((Composite)groupReportFormat, (String)"PDF");
        this.radioPromptReportFormat = FormBuilder.createRadioButton((Composite)groupReportFormat, (String)UI_Messages.LB_Prompt);
        this.licenseFilePath = FormBuilder.createLabeledText((Composite)panel, (String)UI_Messages.WorkbenchPreferencePage_licenseFilePath).getText();
        FormBuilder.createButton((Composite)panel, (String)UI_Messages.BTN_Browse, (SelectionListener)new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(WorkbenchPreferencePage.this.getShell(), 4096);
                dialog.setFilterPath(WorkbenchPreferencePage.this.licenseFilePath.getText());
                String file = dialog.open();
                if (file != null) {
                    WorkbenchPreferencePage.this.licenseFilePath.setText(file);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateCheckbox();
        this.updateSwitchActivityTypeGroup();
        this.updateReportFormats();
        this.updateFocusMode();
        this.licenseFilePath.setText(BpmUiActivator.getDefault().getTraceFilePath());
        return panel;
    }

    private void updateFocusMode() {
        String focusMode = PlatformUI.getPreferenceStore().getString("org.eclipse.stardust.modeling.common.projectnature.focusMode");
        if (StringUtils.isEmpty((String)focusMode)) {
            focusMode = "focusModeElement";
        }
        this.radioFocusModeElement.setSelection(focusMode.equals("focusModeElement"));
        this.radioFocusModePropertyDialog.setSelection(focusMode.equals("focusModeDialog"));
        this.radioFocusModeEditBox.setSelection(focusMode.equals("focusModeEditor"));
    }

    private void updateReportFormats() {
        this.radioReportFormatHTML.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturehtmlReportFormat"));
        this.radioReportFormatPDF.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturepdfReportFormat"));
        this.radioPromptReportFormat.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturepromptReportFormat"));
    }

    private void updateSwitchActivityTypeGroup() {
        this.radioAlwaysSwitchActivityType.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType"));
        this.radioNeverSwitchActivityType.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType"));
        this.radioWarnSwitchActivityType.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType"));
    }

    private void updateCheckbox() {
        this.chkEnableAutoValidation.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoValidation"));
        this.chkEnableAutoIdGeneration.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration"));
        this.chkEnableAutoSubprocessNameGeneration.setSelection(PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration"));
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.autoValidation", this.chkEnableAutoValidation.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration", this.chkEnableAutoIdGeneration.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration", this.chkEnableAutoSubprocessNameGeneration.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType", this.radioAlwaysSwitchActivityType.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType", this.radioNeverSwitchActivityType.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType", this.radioWarnSwitchActivityType.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturehtmlReportFormat", this.radioReportFormatHTML.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturepdfReportFormat", this.radioReportFormatPDF.getSelection());
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnaturepromptReportFormat", this.radioPromptReportFormat.getSelection());
        String focusMode = "focusModeElement";
        if (this.radioFocusModeElement.getSelection()) {
            focusMode = "focusModeElement";
        } else if (this.radioFocusModePropertyDialog.getSelection()) {
            focusMode = "focusModeDialog";
        } else if (this.radioFocusModeEditBox.getSelection()) {
            focusMode = "focusModeEditor";
        }
        PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.focusMode", focusMode);
        BpmUiActivator.getDefault().setTraceFilePath(this.licenseFilePath.getText());
        return true;
    }

    protected void performDefaults() {
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.autoValidation");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnaturehtmlReportFormat");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnaturepdfReportFormat");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnaturepromptReportFormat");
        PlatformUI.getPreferenceStore().setToDefault("org.eclipse.stardust.modeling.common.projectnature.focusMode");
        this.updateCheckbox();
        this.licenseFilePath.setText(BpmUiActivator.getDefault().getTraceFilePath());
    }
}

