/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.util.EventObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jface.util.ListenerList;

public class DelegatingCommandStack
extends CommandStack
implements CommandStackListener,
CommandStackEventListener {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private CommandStack currentCommandStack;
    private ListenerList eventListeners = new ListenerList();

    public CommandStack getCurrentCommandStack() {
        return this.currentCommandStack;
    }

    public void setCurrentCommandStack(CommandStack stack) {
        if (this.currentCommandStack != stack) {
            if (this.currentCommandStack != null) {
                this.currentCommandStack.removeCommandStackEventListener((CommandStackEventListener)this);
                this.currentCommandStack.removeCommandStackListener((CommandStackListener)this);
            }
            this.currentCommandStack = stack;
            this.currentCommandStack.addCommandStackEventListener((CommandStackEventListener)this);
            this.currentCommandStack.addCommandStackListener((CommandStackListener)this);
            this.notifyListeners();
            this.stackChanged(new CommandStackEvent((CommandStack)this, null, 8));
        }
    }

    public boolean canRedo() {
        return this.currentCommandStack == null ? false : this.currentCommandStack.canRedo();
    }

    public boolean canUndo() {
        return this.currentCommandStack == null ? false : this.currentCommandStack.canUndo();
    }

    public void dispose() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.dispose();
        }
    }

    public void execute(Command command) {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.execute(command);
        }
    }

    public void flush() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.flush();
        }
    }

    public Object[] getCommands() {
        return this.currentCommandStack == null ? EMPTY_OBJECT_ARRAY : this.currentCommandStack.getCommands();
    }

    public Command getRedoCommand() {
        return this.currentCommandStack == null ? UnexecutableCommand.INSTANCE : this.currentCommandStack.getRedoCommand();
    }

    public Command getUndoCommand() {
        return this.currentCommandStack == null ? UnexecutableCommand.INSTANCE : this.currentCommandStack.getUndoCommand();
    }

    public int getUndoLimit() {
        return this.currentCommandStack == null ? -1 : this.currentCommandStack.getUndoLimit();
    }

    public boolean isDirty() {
        return this.currentCommandStack == null ? false : this.currentCommandStack.isDirty();
    }

    public void markSaveLocation() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.markSaveLocation();
        }
    }

    public void redo() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.redo();
        }
    }

    public void setUndoLimit(int undoLimit) {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.setUndoLimit(undoLimit);
        }
    }

    public void undo() {
        if (this.currentCommandStack != null) {
            this.currentCommandStack.undo();
        }
    }

    public void addCommandStackEventListener(CommandStackEventListener listener) {
        this.eventListeners.add((Object)listener);
    }

    public void removeCommandStackEventListener(CommandStackEventListener listener) {
        this.eventListeners.remove((Object)listener);
    }

    public String toString() {
        return "DelegatingCommandStack(" + this.currentCommandStack + ")";
    }

    public void stackChanged(CommandStackEvent event) {
        Object[] listeners = this.eventListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((CommandStackEventListener)listeners[i]).stackChanged(event);
            ++i;
        }
    }

    public void commandStackChanged(EventObject event) {
        this.notifyListeners();
    }
}

