/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipantSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PerformsConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.SelectionPopup;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetActivityControlFlowCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetAttributeReferenceCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ActivityCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.LaneParticipantCommandFactory;
import org.eclipse.stardust.modeling.core.editors.tools.CommandCanceledException;
import org.eclipse.stardust.modeling.core.ui.SplitJoinDialog;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DynamicConnectionCommand
extends Command {
    private static final CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static final String CONNECTION_TYPE_SUFFIX = "ConnectionType";
    private static final Map<String, EClass> LINK_TYPE_MAPPING = CollectionUtils.newMap();
    private static final EClass[] DIRECTIONLESS_CONNECTION_TYPES;
    private static final EClass[] UNSUPPORTED_CONNECTION_TYPES;
    private WorkflowModelEditor editor;
    private INodeSymbol sourceSymbol;
    private INodeSymbol targetSymbol;
    private String sourceAnchor;
    private String targetAnchor;
    private Command command;
    private List matchingFeatures;
    private List reverseFeatures;

    static {
        LINK_TYPE_MAPPING.put("org.eclipse.stardust.model.xpdl.IActivity", PKG.getActivitySymbolType());
        LINK_TYPE_MAPPING.put("org.eclipse.stardust.model.xpdl.IData", PKG.getDataSymbolType());
        LINK_TYPE_MAPPING.put("org.eclipse.stardust.model.xpdl.IRole", PKG.getRoleSymbolType());
        LINK_TYPE_MAPPING.put("org.eclipse.stardust.model.xpdl.IProcessDefinition", PKG.getProcessSymbolType());
        LINK_TYPE_MAPPING.put("org.eclipse.stardust.model.xpdl.ITransition", PKG.getTransitionConnectionType());
        LINK_TYPE_MAPPING.put("org.eclipse.stardust.model.xpdl.IOrganization", PKG.getOrganizationSymbolType());
        LINK_TYPE_MAPPING.put("org.eclipse.stardust.model.xpdl.IParticipant", PKG.getIModelParticipantSymbol());
        DIRECTIONLESS_CONNECTION_TYPES = new EClass[]{PKG.getTriggersConnectionType(), PKG.getExecutedByConnectionType(), PKG.getPerformsConnectionType(), PKG.getWorksForConnectionType(), PKG.getTeamLeadConnectionType()};
        UNSUPPORTED_CONNECTION_TYPES = new EClass[]{PKG.getSubProcessOfConnectionType()};
    }

    public DynamicConnectionCommand(WorkflowModelEditor editor) {
        super("Connect");
        this.editor = editor;
    }

    public void setSourceSymbol(INodeSymbol sourceSymbol) {
        this.sourceSymbol = sourceSymbol;
    }

    public void setTargetSymbol(INodeSymbol targetSymbol) {
        this.targetSymbol = targetSymbol;
    }

    public void setSourceAnchorType(String anchorType) {
        this.sourceAnchor = anchorType;
    }

    public void setTargetAnchorType(String anchorType) {
        this.targetAnchor = anchorType;
    }

    public boolean canExecute() {
        return this.targetSymbol == null ? this.isValidSourceSymbol() : this.isValidTargetSymbol();
    }

    public void dispose() {
        this.editor = null;
        this.sourceSymbol = null;
        this.targetSymbol = null;
        if (this.command != null) {
            this.command.dispose();
            this.command = null;
        }
        this.sourceAnchor = null;
        this.targetAnchor = null;
        super.dispose();
    }

    public void execute() {
        Object feature = this.getConnectionFeature();
        if (feature == null) {
            this.cancelCommand();
        }
        this.setLabel(this.computeLabel(feature));
        this.switchSymbols(feature);
        this.command = this.createCommand(feature);
        this.switchSymbols(feature);
        this.command.execute();
    }

    private void switchSymbols(Object feature) {
        if (this.reverseFeatures.contains(feature)) {
            INodeSymbol symbol = this.sourceSymbol;
            this.sourceSymbol = this.targetSymbol;
            this.targetSymbol = symbol;
        }
    }

    public void redo() {
        this.command.redo();
    }

    public void undo() {
        this.command.undo();
    }

    private Command createCommand(Object feature) {
        ActivityType activity;
        CompoundCommand command = new CompoundCommand();
        boolean shouldCreateConnection = true;
        Object[] reference = new Object[1];
        if (feature == PKG.getTriggersConnectionType()) {
            IModelParticipant participant = (IModelParticipant)this.extractModelElement(this.sourceSymbol);
            TriggerType trigger = (TriggerType)this.extractModelElement(this.targetSymbol);
            AttributeType attribute = AttributeUtil.getAttribute((IExtensibleElement)trigger, (String)"carnot:engine:participant");
            if (attribute == null) {
                attribute = AttributeUtil.createAttribute((String)"carnot:engine:participant");
                command.add((Command)new SetValueCmd((EObject)trigger, (EStructuralFeature)PKG.getIExtensibleElement_Attribute(), (Object)attribute));
            }
            command.add((Command)new SetAttributeReferenceCmd(attribute, (EObject)participant));
        }
        if (feature == PKG.getTransitionConnectionType()) {
            this.addIfNotNull(command, this.getCreateTransitionCommand(reference));
        }
        if (feature == PKG.getPerformsConnectionType()) {
            activity = (ActivityType)this.extractModelElement(this.targetSymbol);
            IModelParticipant originalPerformer = activity.getPerformer();
            IModelParticipant newPerformer = (IModelParticipant)this.extractModelElement(this.sourceSymbol);
            if (!ActivityUtil.isInteractive((ActivityType)activity)) {
                if (!this.canChangeImplementation()) {
                    this.cancelCommand();
                }
                command.add(ActivityCommandFactory.getSetImplementationCommand(ActivityImplementationType.MANUAL_LITERAL, activity));
            }
            for (PerformsConnectionType performsConnection : ((ActivitySymbolType)this.targetSymbol).getPerformsConnections()) {
                if (!performsConnection.getParticipantSymbol().getModelElement().equals(originalPerformer)) continue;
                command.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)performsConnection));
            }
            command.add(this.getSetValueCommand((EStructuralFeature)PKG.getActivityType_Performer()));
            if (originalPerformer != null && !originalPerformer.equals(newPerformer)) {
                String message = MessageFormat.format(Diagram_Messages.MSG_Replace_performer_with_performer_for_activity, LaneParticipantCommandFactory.getPerformerName(originalPerformer), LaneParticipantCommandFactory.getPerformerName(newPerformer), activity.getName());
                if (!MessageDialog.openQuestion((Shell)this.editor.getSite().getShell(), (String)Diagram_Messages.MSG_DIA_SET_PERFORMER, (String)message)) {
                    this.cancelCommand();
                }
            }
        }
        if (feature == PKG.getDataMappingConnectionType()) {
            reference[0] = this.getExistingDataMappingConnection();
            shouldCreateConnection = reference[0] == null;
            command.add(this.getDataMappingCommand(reference));
        }
        if (feature == PKG.getExecutedByConnectionType()) {
            command.add(this.getSetValueCommand((EStructuralFeature)PKG.getActivityType_Application()));
            activity = (ActivityType)this.extractModelElement(this.targetSymbol);
            IIdentifiableModelElement modelElement = this.extractModelElement(this.sourceSymbol);
            if (modelElement instanceof ApplicationType) {
                final ApplicationType application = (ApplicationType)modelElement;
                IModelParticipant lanePerformer = GenericUtils.getLanePerformerForActivity(activity);
                if (lanePerformer != null && application.isInteractive()) {
                    command.add((Command)new SetValueCmd((EObject)activity, (EStructuralFeature)PKG.getActivityType_Performer(), (Object)lanePerformer));
                }
                EList dataMappings = activity.getDataMapping();
                for (final DataMappingType dm : dataMappings) {
                    DelegatingCommand myCmd;
                    DataType data;
                    final DirectionType direction = dm.getDirection();
                    if (direction.equals((Object)DirectionType.IN_LITERAL)) {
                        data = dm.getData();
                        command.add((Command)new SetValueCmd((EObject)dm, (EStructuralFeature)PKG.getDataMappingType_Context(), (Object)"application"));
                        myCmd = new DelegatingCommand(){

                            @Override
                            public Command createDelegate() {
                                String accessPointId = DynamicConnectionCommand.this.getAccessPoint(activity, application, data, direction, "application");
                                if (accessPointId != null) {
                                    return new SetValueCmd((EObject)dm, (EStructuralFeature)PKG.getDataMappingType_ApplicationAccessPoint(), (Object)accessPointId);
                                }
                                return null;
                            }
                        };
                        command.add((Command)myCmd);
                        continue;
                    }
                    if (!direction.equals((Object)DirectionType.OUT_LITERAL)) continue;
                    data = dm.getData();
                    if (!org.eclipse.stardust.common.StringUtils.isEmpty((String)dm.getApplicationAccessPoint())) continue;
                    command.add((Command)new SetValueCmd((EObject)dm, (EStructuralFeature)PKG.getDataMappingType_Context(), (Object)"application"));
                    myCmd = new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            String accessPointId = DynamicConnectionCommand.this.getAccessPoint(activity, application, data, direction, "application");
                            if (accessPointId != null) {
                                return new SetValueCmd((EObject)dm, (EStructuralFeature)PKG.getDataMappingType_ApplicationAccessPoint(), (Object)accessPointId);
                            }
                            return null;
                        }
                    };
                    command.add((Command)myCmd);
                }
            }
        }
        if (feature == PKG.getWorksForConnectionType() || feature == PKG.getPartOfConnectionType() || feature == PKG.getTeamLeadConnectionType()) {
            IModelParticipant role = (IModelParticipant)this.extractModelElement(this.sourceSymbol);
            OrganizationType organization = (OrganizationType)this.extractModelElement(this.targetSymbol);
            if (feature == PKG.getTeamLeadConnectionType()) {
                if (organization.getTeamLead() != null) {
                    command.add((Command)UnexecutableCommand.INSTANCE);
                }
                command.add(this.getSetValueCommand((EStructuralFeature)PKG.getOrganizationType_TeamLead(), role));
            } else {
                ParticipantType participant = CarnotWorkflowModelFactory.eINSTANCE.createParticipantType();
                participant.setParticipant(role);
                command.add(this.getSetValueCommand((EStructuralFeature)PKG.getOrganizationType_Participant(), participant));
            }
        }
        if (shouldCreateConnection) {
            CreateConnectionSymbolCommand cmd = feature instanceof EClass ? this.createConnectionCommand((EClass)feature, reference) : this.createGenericLinkCommand((LinkTypeType)feature);
            DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)this.sourceSymbol);
            PoolSymbol pool = DiagramUtil.getDefaultPool((DiagramType)diagram);
            cmd.setParent((EObject)(pool == null ? diagram : pool));
            cmd.setSourceSymbol(this.sourceSymbol);
            cmd.setTargetSymbol(this.targetSymbol);
            cmd.setSourceAnchorType(this.sourceAnchor);
            cmd.setTargetAnchorType(this.targetAnchor);
            command.add((Command)cmd);
        }
        if (feature == PKG.getTransitionConnectionType()) {
            this.addIfNotNull(command, this.createAutomaticJoinCmd());
            this.addIfNotNull(command, this.createAutomaticSplitCmd());
        }
        return command;
    }

    private void addIfNotNull(CompoundCommand command, Command cmd) {
        if (cmd != null) {
            command.add(cmd);
        }
    }

    private Command createAutomaticJoinCmd() {
        if (this.targetSymbol instanceof ActivitySymbolType && !(this.sourceSymbol instanceof StartEventSymbol) && ((ActivitySymbolType)this.targetSymbol).getActivity().getInTransitions().size() == 1) {
            return this.getSetActivityControlFlowCmd(((ActivitySymbolType)this.targetSymbol).getActivity(), FlowControlType.JOIN_LITERAL);
        }
        return null;
    }

    private Command createAutomaticSplitCmd() {
        if (this.sourceSymbol instanceof ActivitySymbolType && ((ActivitySymbolType)this.sourceSymbol).getActivity().getOutTransitions().size() == 1) {
            return this.getSetActivityControlFlowCmd(((ActivitySymbolType)this.sourceSymbol).getActivity(), FlowControlType.SPLIT_LITERAL);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Command getSetActivityControlFlowCmd(ActivityType activity, FlowControlType flow) {
        SplitJoinDialog dialog;
        JoinSplitType type = JoinSplitType.XOR_LITERAL;
        if (flow.equals((Object)FlowControlType.SPLIT_LITERAL)) {
            if (PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturesplitPrompt")) {
                dialog = new SplitJoinDialog(Display.getDefault().getActiveShell(), flow);
                if (dialog.open() != 0) return UnexecutableCommand.INSTANCE;
                type = SplitJoinDialog.isAnd() ? JoinSplitType.AND_LITERAL : JoinSplitType.XOR_LITERAL;
                return new SetActivityControlFlowCmd(this.editor, activity, flow, type){

                    @Override
                    public void execute() {
                        this.canExecute();
                        super.execute();
                    }
                };
            } else {
                type = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturesplitAND") ? JoinSplitType.AND_LITERAL : JoinSplitType.XOR_LITERAL;
            }
            return new /* invalid duplicate definition of identical inner class */;
        } else if (PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturejoinPrompt")) {
            dialog = new SplitJoinDialog(Display.getDefault().getActiveShell(), flow);
            if (dialog.open() != 0) return UnexecutableCommand.INSTANCE;
            type = SplitJoinDialog.isAnd() ? JoinSplitType.AND_LITERAL : JoinSplitType.XOR_LITERAL;
            return new /* invalid duplicate definition of identical inner class */;
        } else {
            type = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnaturejoinAND") ? JoinSplitType.AND_LITERAL : JoinSplitType.XOR_LITERAL;
        }
        return new /* invalid duplicate definition of identical inner class */;
    }

    private DataMappingConnectionType getExistingDataMappingConnection() {
        ActivitySymbolType activitySymbol = (ActivitySymbolType)(this.sourceSymbol instanceof ActivitySymbolType ? this.sourceSymbol : this.targetSymbol);
        DataSymbolType dataSymbol = (DataSymbolType)(this.sourceSymbol instanceof DataSymbolType ? this.sourceSymbol : this.targetSymbol);
        for (DataMappingConnectionType connection : activitySymbol.getDataMappings()) {
            if (connection.getDataSymbol() != dataSymbol) continue;
            return connection;
        }
        return null;
    }

    private Command getDataMappingCommand(final Object[] reference) {
        DirectionType direction;
        ActivitySymbolType activitySymbol = (ActivitySymbolType)(this.sourceSymbol instanceof ActivitySymbolType ? this.sourceSymbol : this.targetSymbol);
        DataSymbolType dataSymbol = (DataSymbolType)(this.sourceSymbol instanceof DataSymbolType ? this.sourceSymbol : this.targetSymbol);
        final ActivityType activity = activitySymbol.getActivity();
        final ApplicationType application = activity.getApplication();
        final DataType data = dataSymbol.getData();
        DirectionType directionType = direction = this.sourceSymbol == dataSymbol ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL;
        if (this.sourceSymbol == activitySymbol) {
            INodeSymbol symbol = this.sourceSymbol;
            this.sourceSymbol = this.targetSymbol;
            this.targetSymbol = symbol;
        }
        String mappingId = !StringUtils.isEmpty(data.getId()) ? data.getId() : (DirectionType.IN_LITERAL == direction ? "in" : (DirectionType.OUT_LITERAL == direction ? "out" : "DataMapping"));
        IdFactory idFactory = new IdFactory(mappingId, null, CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), null);
        EList dataMappings = activity.getDataMapping();
        List idDomain = CollectionUtils.newList((int)dataMappings.size());
        for (DataMappingType mapping : dataMappings) {
            if (direction != mapping.getDirection()) continue;
            idDomain.add(mapping);
        }
        idFactory.computeNames(idDomain, false);
        final String id = idFactory.getId();
        final String context = this.getDataMappingContext(activity);
        CreateModelElementCommand command = new CreateModelElementCommand(0, null, PKG.getDataMappingType()){

            @Override
            protected IModelElement createModelElement() {
                String accessPointId;
                DataMappingType dm = (DataMappingType)super.createModelElement();
                dm.setName(id);
                dm.setId(id);
                dm.setData(data);
                dm.setDirection(direction);
                dm.setContext(context);
                if (application != null && (accessPointId = DynamicConnectionCommand.this.getAccessPoint(activity, application, data, direction, context)) != null) {
                    dm.setApplicationAccessPoint(accessPointId);
                }
                return dm;
            }

            @Override
            public void redo() {
                super.redo();
                ((DataMappingType)this.getModelElement()).setData(data);
                this.updateArrows(reference[0]);
            }

            @Override
            public void undo() {
                super.undo();
                ((DataMappingType)this.getModelElement()).setData(null);
                this.updateArrows(reference[0]);
            }

            private void updateArrows(Object reference2) {
                if (reference2 instanceof DataMappingConnectionType) {
                    DataMappingConnectionType connection = (DataMappingConnectionType)reference2;
                    connection.setStyle(connection.getStyle());
                }
            }
        };
        command.setParent((EObject)activity);
        return command;
    }

    private String getAccessPoint(ActivityType activity, ApplicationType application, DataType data, DirectionType direction, String context) {
        Object dataClass;
        String accessPointId;
        block6: {
            accessPointId = null;
            String referenceClassName = GenericUtils.getReferenceClassName(data);
            dataClass = null;
            if (referenceClassName != null) {
                try {
                    dataClass = Class.forName(referenceClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!GenericUtils.dataHasClassAssigned(data)) break block6;
                    dataClass = referenceClassName;
                }
            }
        }
        List accessPoints = ActivityUtil.getAccessPoints((ActivityType)activity, (boolean)DirectionType.IN_LITERAL.equals((Object)direction), (String)context);
        if (data.getType().getId().equals("primitive")) {
            accessPointId = this.getAccessPoint(activity, accessPoints, data);
        }
        if (accessPointId == null) {
            accessPointId = this.getAccessPoint(activity, dataClass, accessPoints, true, data);
        }
        if (accessPointId == null) {
            accessPointId = this.getAccessPoint(activity, dataClass, accessPoints, false, data);
        }
        return accessPointId;
    }

    private String getAccessPoint(ActivityType activity, Object dataClass, List accessPoints, boolean checkType, DataType data) {
        TypeFinder typeFinder = new TypeFinder((EObject)activity);
        for (AccessPointType accessPoint : accessPoints) {
            DirectionType accessPointDirection = accessPoint.getDirection();
            String attrValue = AccessPointUtil.getTypeAttributeValue((AccessPointType)accessPoint);
            if (GenericUtils.isDMSDataType(data)) {
                DataTypeType type = accessPoint.getType();
                if (type != null && type.getId().equals(data.getType().getId())) {
                    return accessPoint.getId();
                }
            } else if (GenericUtils.isStructuredDataType(data)) {
                String structuredTypeData = GenericUtils.getReferenceClassName(data);
                String structuredType = AttributeUtil.getAttributeValue((IExtensibleElement)accessPoint, (String)"carnot:engine:dataType");
                if (!StringUtils.isEmpty(structuredTypeData) && !StringUtils.isEmpty(structuredType) && structuredTypeData.equals(structuredType)) {
                    return accessPoint.getId();
                }
            }
            if (GenericUtils.isConnected(activity, accessPoint.getId()) || dataClass == null || attrValue == null) continue;
            if (dataClass instanceof Class) {
                try {
                    Class<?> applicationClass = Class.forName(attrValue);
                    if (!(((Class)dataClass).isInterface() ? (DirectionType.IN_LITERAL == accessPointDirection ? applicationClass.isAssignableFrom((Class)dataClass) : ((Class)dataClass).isAssignableFrom(applicationClass)) : (checkType ? applicationClass.equals(dataClass) : (DirectionType.IN_LITERAL == accessPointDirection ? applicationClass.isAssignableFrom((Class)dataClass) : ((Class)dataClass).isAssignableFrom(applicationClass))))) continue;
                    return accessPoint.getId();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    TypeInfo typeInfo = typeFinder.findType(attrValue);
                    if (typeInfo == null || !typeInfo.isSameType(((Class)dataClass).getName())) continue;
                    return accessPoint.getId();
                }
            }
            TypeInfo typeInfo = typeFinder.findType(attrValue);
            if (typeInfo == null || !typeInfo.isSameType((String)dataClass)) continue;
            return accessPoint.getId();
        }
        return null;
    }

    private String getAccessPoint(ActivityType activity, List accessPoints, DataType data) {
        String dataType = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:type");
        for (AccessPointType accessPoint : accessPoints) {
            String attrValue = AccessPointUtil.getTypeAttributeValue((AccessPointType)accessPoint);
            String accessPointId = accessPoint.getId();
            if (GenericUtils.isConnected(activity, accessPoint.getId()) || attrValue == null || accessPointId.indexOf("(") != -1 || !attrValue.equals(dataType)) continue;
            return accessPointId;
        }
        return null;
    }

    private String getDataMappingContext(ActivityType activity) {
        ProcessDefinitionType process;
        if (ActivityImplementationType.ROUTE_LITERAL == activity.getImplementation()) {
            return "default";
        }
        if (ActivityImplementationType.MANUAL_LITERAL == activity.getImplementation()) {
            return "default";
        }
        if (ActivityImplementationType.APPLICATION_LITERAL == activity.getImplementation() && activity.getApplication() != null) {
            ApplicationType application = activity.getApplication();
            if (application.isInteractive()) {
                if (application.getContext().size() > 0) {
                    ContextType context = (ContextType)application.getContext().get(0);
                    return context.getType().getId();
                }
                return "default";
            }
            return "application";
        }
        if (ActivityImplementationType.SUBPROCESS_LITERAL == activity.getImplementation() && activity.getImplementationProcess() != null && (process = activity.getImplementationProcess()).getFormalParameters() != null) {
            return "processInterface";
        }
        return "engine";
    }

    private boolean canChangeImplementation() {
        MessageDialogWithToggle dialog = null;
        if (PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType") && (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.editor.getSite().getShell(), (String)Diagram_Messages.TITLE_ChangeToManualActivity, (String)Diagram_Messages.MSG_ChangeImplTypeActivity, (String)Diagram_Messages.LB_RememberDecision, (boolean)false, (IPreferenceStore)PlatformUI.getPreferenceStore(), (String)"org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType")).getToggleState()) {
            PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType", false);
            PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType", 2 == dialog.getReturnCode());
            PlatformUI.getPreferenceStore().setValue("org.eclipse.stardust.modeling.common.projectnature.neverSwitchActivityType", 3 == dialog.getReturnCode());
        }
        return PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.warnSwitchActivityType") ? 2 == dialog.getReturnCode() : PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.alwaysSwitchActivityType");
    }

    private Command getSetValueCommand(EStructuralFeature feature) {
        IIdentifiableModelElement value = this.extractModelElement(this.sourceSymbol);
        return this.getSetValueCommand(feature, value);
    }

    private Command getSetValueCommand(EStructuralFeature feature, Object value) {
        IIdentifiableModelElement parent = this.extractModelElement(this.targetSymbol);
        return new SetValueCmd((EObject)parent, feature, value);
    }

    private Command getCreateTransitionCommand(final Object[] reference) {
        IIdentifiableModelElement sourceModelElement = this.extractModelElement(this.sourceSymbol);
        final ActivityType sourceActivity = sourceModelElement instanceof ActivityType ? (ActivityType)sourceModelElement : null;
        final ActivityType targetActivity = (ActivityType)this.extractModelElement(this.targetSymbol);
        if (sourceActivity != null && targetActivity != null) {
            for (TransitionType transition : sourceActivity.getOutTransitions()) {
                if (transition.getTo() != targetActivity) continue;
                return null;
            }
            IdFactory id = new IdFactory("Transition", Diagram_Messages.BASENAME_Transition);
            CreateModelElementCommand cmd = new CreateModelElementCommand(1, id, CarnotWorkflowModelPackage.eINSTANCE.getTransitionType()){

                @Override
                protected IModelElement createModelElement() {
                    reference[0] = super.createModelElement();
                    ((TransitionType)reference[0]).setCondition("CONDITION");
                    XmlTextNode expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
                    ((TransitionType)reference[0]).setExpression(expression);
                    ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)"true", (boolean)true);
                    return (IModelElement)reference[0];
                }

                @Override
                public void redo() {
                    super.redo();
                    TransitionType transition = (TransitionType)this.getModelElement();
                    transition.setFrom(sourceActivity);
                    transition.setTo(targetActivity);
                }

                @Override
                public void undo() {
                    super.undo();
                    TransitionType transition = (TransitionType)this.getModelElement();
                    transition.setFrom(null);
                    transition.setTo(null);
                }
            };
            cmd.setParent((EObject)sourceActivity);
            return cmd;
        }
        return null;
    }

    private CreateConnectionSymbolCommand createConnectionCommand(EClass eClass, final Object[] reference) {
        String label = this.computeLabel(eClass);
        IdFactory id = new IdFactory(String.valueOf(label) + Diagram_Messages.LBL_CONNECTION, String.valueOf(label) + Diagram_Messages.LBL_CONNECTION);
        return new CreateConnectionSymbolCommand(id, eClass){

            @Override
            protected IModelElement createModelElement() {
                IConnectionSymbol connection = (IConnectionSymbol)super.createModelElement();
                if (connection instanceof TransitionConnectionType) {
                    connection.setSourceAnchor(this.sourceAnchorType == null ? "center" : this.sourceAnchorType);
                    connection.setTargetAnchor(this.targetAnchorType == null ? "center" : this.targetAnchorType);
                    ((TransitionConnectionType)connection).setTransition((TransitionType)reference[0]);
                }
                return connection;
            }
        };
    }

    private CreateConnectionSymbolCommand createGenericLinkCommand(final LinkTypeType linkType) {
        IdFactory id = new IdFactory("Link", "Link");
        EClass eClass = PKG.getGenericLinkConnectionType();
        return new CreateConnectionSymbolCommand(id, eClass){

            @Override
            protected IModelElement createModelElement() {
                GenericLinkConnectionType link = (GenericLinkConnectionType)super.createModelElement();
                link.setLinkType(linkType);
                return link;
            }
        };
    }

    private Object getConnectionFeature() {
        Object feature = null;
        if (this.matchingFeatures.size() == 1) {
            feature = this.matchingFeatures.get(0);
        } else if (this.matchingFeatures.size() > 1) {
            SelectionPopup popup = new SelectionPopup(this.editor.getSite().getShell());
            popup.setContentProvider((IContentProvider)new ArrayContentProvider());
            popup.setLabelProvider((ILabelProvider)new LabelProvider(){

                public Image getImage(Object element) {
                    if (element instanceof EObject) {
                        return DiagramPlugin.getImage(DynamicConnectionCommand.this.editor.getIconFactory().getIconFor((EObject)element));
                    }
                    return super.getImage(element);
                }

                public String getText(Object element) {
                    if (element instanceof EClass) {
                        String eClassName = ((EClass)element).getName();
                        return this.getExternalLabel(eClassName);
                    }
                    if (element instanceof LinkTypeType) {
                        return ((LinkTypeType)element).getName();
                    }
                    return super.getText(element);
                }

                private String getExternalLabel(String label) {
                    try {
                        Field field = Diagram_Messages.class.getField("ConnectAction_" + label);
                        return (String)field.get(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return label;
                    }
                }
            });
            popup.setInput((Object)this.matchingFeatures);
            feature = popup.open();
        }
        return feature;
    }

    private void cancelCommand() {
        throw new CommandCanceledException(Diagram_Messages.EXC_USER_CANCELLED);
    }

    private IIdentifiableModelElement extractModelElement(INodeSymbol symbol) {
        if (symbol instanceof GatewaySymbol) {
            symbol = ((GatewaySymbol)symbol).getActivitySymbol();
        }
        if (symbol instanceof IModelElementNodeSymbol) {
            return ((IModelElementNodeSymbol)symbol).getModelElement();
        }
        return null;
    }

    private boolean isValidSourceSymbol() {
        if (this.sourceSymbol == null) {
            return false;
        }
        if (this.sourceSymbol.getOutConnectionFeatures().isEmpty()) {
            return false;
        }
        if (this.sourceSymbol instanceof StartEventSymbol && !((StartEventSymbol)this.sourceSymbol).getOutTransitions().isEmpty()) {
            return false;
        }
        return this.isTargetSymbolAvailable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTargetSymbolAvailable() {
        DynamicConnectionCommand helper = new DynamicConnectionCommand(null);
        try {
            helper.setSourceSymbol(this.sourceSymbol);
            DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)this.sourceSymbol);
            if (diagram == null) {
                return false;
            }
            TreeIterator i = diagram.eAllContents();
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                if (!(eObject instanceof INodeSymbol)) continue;
                helper.setTargetSymbol((INodeSymbol)eObject);
                if (!helper.canExecute()) continue;
                return true;
            }
            return false;
        }
        finally {
            helper.dispose();
        }
    }

    private boolean isValidTargetSymbol() {
        if (this.sourceSymbol == this.targetSymbol) {
            return false;
        }
        if (this.targetSymbol.getInConnectionFeatures().isEmpty()) {
            return false;
        }
        if (this.targetSymbol instanceof EndEventSymbol && !this.isValidActivityRelated(this.sourceSymbol)) {
            return false;
        }
        if (this.targetSymbol instanceof OrganizationSymbolType) {
            boolean cfr_ignored_0 = this.sourceSymbol instanceof IModelParticipantSymbol;
        }
        this.computeMatchingFeatures();
        return !this.matchingFeatures.isEmpty();
    }

    private boolean isValidActivityRelated(INodeSymbol symbol) {
        if (symbol instanceof GatewaySymbol) {
            symbol = ((GatewaySymbol)symbol).getActivitySymbol();
        }
        if (symbol instanceof ActivitySymbolType) {
            ActivityType activity = ((ActivitySymbolType)symbol).getActivity();
            return activity != null && activity.getOutTransitions().isEmpty();
        }
        return false;
    }

    private void computeMatchingFeatures() {
        this.matchingFeatures = new ArrayList();
        this.reverseFeatures = new ArrayList();
        this.addMatchingFeatures(this.sourceSymbol, this.targetSymbol);
        this.addMatchingFeatures(this.targetSymbol, this.sourceSymbol);
        this.addGenericLinkFeatures();
    }

    private void addGenericLinkFeatures() {
        ModelType model = ModelUtils.findContainingModel((EObject)this.sourceSymbol);
        if (model == null) {
            return;
        }
        for (LinkTypeType link : model.getLinkType()) {
            EClass sourceClass = LINK_TYPE_MAPPING.get(link.getSourceClass());
            EClass targetClass = LINK_TYPE_MAPPING.get(link.getTargetClass());
            if (sourceClass == null || targetClass == null || !sourceClass.isInstance((Object)this.sourceSymbol) || !targetClass.isInstance((Object)this.targetSymbol) || this.existsLink(link, this.sourceSymbol, this.targetSymbol)) continue;
            this.matchingFeatures.add(link);
        }
    }

    private void addMatchingFeatures(INodeSymbol sourceSymbol, INodeSymbol targetSymbol) {
        boolean reverse = this.sourceSymbol != sourceSymbol;
        List outFeatures = sourceSymbol.getOutConnectionFeatures();
        List inFeatures = targetSymbol.getInConnectionFeatures();
        for (EStructuralFeature in : inFeatures) {
            for (EStructuralFeature out : outFeatures) {
                EClass type = (EClass)out.getEType();
                if (!in.getEType().equals(type) || Arrays.asList(UNSUPPORTED_CONNECTION_TYPES).contains(type) || this.matchingFeatures.contains(type) || reverse && !Arrays.asList(DIRECTIONLESS_CONNECTION_TYPES).contains(type) || !this.matches(out, type, sourceSymbol, targetSymbol)) continue;
                this.matchingFeatures.add(type);
                if (!reverse) continue;
                this.reverseFeatures.add(type);
            }
        }
    }

    private boolean matches(EStructuralFeature out, EClass type, INodeSymbol sourceSymbol, INodeSymbol targetSymbol) {
        if (PKG.getTriggersConnectionType() == type) {
            StartEventSymbol triggerSymbol = null;
            if (targetSymbol != null && targetSymbol instanceof StartEventSymbol) {
                triggerSymbol = (StartEventSymbol)targetSymbol;
            } else if (sourceSymbol != null && sourceSymbol instanceof StartEventSymbol) {
                triggerSymbol = (StartEventSymbol)sourceSymbol;
            }
            TriggerType trigger = triggerSymbol.getTrigger();
            if (trigger == null) {
                return false;
            }
            String triggerTypeId = trigger.getType().getId();
            if (!"manual".equals(triggerTypeId) && !"scan".equals(triggerTypeId)) {
                return false;
            }
            if (!triggerSymbol.getTriggersConnections().isEmpty()) {
                return false;
            }
        }
        if (PKG.getDataMappingConnectionType() == type) {
            ActivityType activity;
            if (PKG.getDataMappingConnectionType().equals(type) && sourceSymbol.eClass().equals(targetSymbol.eClass())) {
                return false;
            }
            ActivitySymbolType activitySymbol = null;
            if (targetSymbol != null && targetSymbol instanceof ActivitySymbolType && ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)(activity = (activitySymbol = (ActivitySymbolType)targetSymbol).getActivity()).getImplementation()) && Boolean.valueOf(AttributeUtil.getAttributeValue((IExtensibleElement)activity, (String)"carnot:engine:subprocess:copyAllData")).booleanValue()) {
                return false;
            }
        } else {
            if (PKG.getTransitionConnectionType() != type) {
                if (!this.isUnique(sourceSymbol.eGet(out), targetSymbol)) {
                    return false;
                }
                if (targetSymbol.getOutConnectionFeatures().contains(out) && !this.isUnique(targetSymbol.eGet(out), sourceSymbol)) {
                    return false;
                }
            }
            if (PKG.getTransitionConnectionType().equals(type) && !this.isValidTransitionConnection(sourceSymbol, targetSymbol)) {
                return false;
            }
            if (PKG.getPartOfConnectionType().equals(type)) {
                if (!this.isValidPartOfConnection(sourceSymbol, targetSymbol)) {
                    return false;
                }
            } else if (PKG.getWorksForConnectionType().equals(type)) {
                if (!this.isValidOrganizationMemberConnection(sourceSymbol, targetSymbol)) {
                    return false;
                }
                IModelParticipant child = (IModelParticipant)this.extractModelElement(sourceSymbol);
                if (child != null && child.getId().equals("Administrator")) {
                    return false;
                }
            } else if (PKG.getTeamLeadConnectionType().equals(type)) {
                OrganizationType parent = (OrganizationType)this.extractModelElement(targetSymbol);
                IModelParticipant child = (IModelParticipant)this.extractModelElement(sourceSymbol);
                if (parent == null || child == null) {
                    return false;
                }
                if (parent.getTeamLead() == child) {
                    return false;
                }
                if (child.getId().equals("Administrator")) {
                    return false;
                }
                return parent.getTeamLead() == null;
            }
            if (PKG.getExecutedByConnectionType().equals(type) && !this.isValidExecutedByConnection(targetSymbol)) {
                return false;
            }
            if (PKG.getPerformsConnectionType().equals(type) && !this.isValidPerformsConnection(targetSymbol)) {
                return false;
            }
        }
        return true;
    }

    private boolean existsLink(LinkTypeType link, INodeSymbol sourceSymbol, INodeSymbol targetSymbol) {
        for (GenericLinkConnectionType conn : link.getLinkInstances()) {
            if (conn.getSourceNode() != sourceSymbol || conn.getTargetNode() != targetSymbol) continue;
            return true;
        }
        return false;
    }

    private boolean isValidPerformsConnection(INodeSymbol targetSymbol) {
        ActivityType activity = (ActivityType)this.extractModelElement(targetSymbol);
        return activity != null;
    }

    private boolean isValidExecutedByConnection(INodeSymbol targetSymbol) {
        ActivityType activity = (ActivityType)this.extractModelElement(targetSymbol);
        return activity != null && ActivityImplementationType.APPLICATION_LITERAL == activity.getImplementation() && activity.getApplication() == null;
    }

    private boolean isValidOrganizationMemberConnection(INodeSymbol sourceSymbol, INodeSymbol targetSymbol) {
        OrganizationType parent;
        IModelParticipant member = (IModelParticipant)this.extractModelElement(sourceSymbol);
        return member != (parent = (OrganizationType)this.extractModelElement(targetSymbol)) && !this.isContained(member, parent);
    }

    private boolean isContained(IModelParticipant child, OrganizationType parent) {
        boolean isContained = false;
        for (ParticipantType participant : parent.getParticipant()) {
            if (participant.getParticipant() != child) continue;
            isContained = true;
        }
        return isContained;
    }

    private boolean isValidPartOfConnection(INodeSymbol sourceSymbol, INodeSymbol targetSymbol) {
        OrganizationType parent;
        OrganizationType child = (OrganizationType)this.extractModelElement(sourceSymbol);
        return child != (parent = (OrganizationType)this.extractModelElement(targetSymbol)) && !this.isChildOrganization(child, parent, new HashSet());
    }

    private boolean isChildOrganization(OrganizationType parent, OrganizationType child, HashSet visited) {
        if (visited.contains(parent)) {
            return false;
        }
        visited.add(parent);
        for (ParticipantType participant : parent.getParticipant()) {
            IModelParticipant modelParticipant = participant.getParticipant();
            if (child != modelParticipant && (!(modelParticipant instanceof OrganizationType) || !this.isChildOrganization((OrganizationType)modelParticipant, child, visited))) continue;
            return true;
        }
        return false;
    }

    private boolean isValidTransitionConnection(INodeSymbol sourceSymbol, INodeSymbol targetSymbol) {
        boolean valid = true;
        if (sourceSymbol instanceof ActivitySymbolType && this.hasGateway((ActivitySymbolType)sourceSymbol, FlowControlType.SPLIT_LITERAL)) {
            valid = false;
        } else if (targetSymbol instanceof ActivitySymbolType && this.hasGateway((ActivitySymbolType)targetSymbol, FlowControlType.JOIN_LITERAL)) {
            valid = false;
        } else if (sourceSymbol instanceof GatewaySymbol && FlowControlType.JOIN_LITERAL == ((GatewaySymbol)sourceSymbol).getFlowKind() && targetSymbol != ((GatewaySymbol)sourceSymbol).getActivitySymbol()) {
            valid = false;
        } else if (targetSymbol instanceof GatewaySymbol && FlowControlType.SPLIT_LITERAL == ((GatewaySymbol)targetSymbol).getFlowKind() && sourceSymbol != ((GatewaySymbol)targetSymbol).getActivitySymbol()) {
            valid = false;
        } else if (sourceSymbol instanceof StartEventSymbol && (targetSymbol instanceof ActivitySymbolType || targetSymbol instanceof GatewaySymbol)) {
            boolean bl = valid = ((StartEventSymbol)sourceSymbol).getOutTransitions().size() == 0;
            if ((!(targetSymbol instanceof ActivitySymbolType) || ((ActivitySymbolType)targetSymbol).getActivity() == null) && targetSymbol instanceof GatewaySymbol) {
                valid = JoinSplitType.XOR_LITERAL.equals((Object)((GatewaySymbol)targetSymbol).getActivitySymbol().getActivity().getJoin());
            }
        } else if (sourceSymbol instanceof ActivitySymbolType && targetSymbol instanceof EndEventSymbol) {
            valid = ((EndEventSymbol)targetSymbol).getInTransitions().size() == 0;
        } else {
            IIdentifiableModelElement sourceModelElement = this.extractModelElement(sourceSymbol);
            IIdentifiableModelElement targetModelElement = this.extractModelElement(targetSymbol);
            if (sourceModelElement instanceof ActivityType && targetModelElement instanceof ActivityType) {
                ActivityType activity = (ActivityType)sourceModelElement;
                for (TransitionType outTransition : activity.getOutTransitions()) {
                    if (outTransition.getTo() != targetModelElement) continue;
                    valid = false;
                    break;
                }
            } else {
                valid = false;
            }
        }
        return valid;
    }

    private boolean hasGateway(ActivitySymbolType type, FlowControlType flow) {
        for (GatewaySymbol gateway : type.getGatewaySymbols()) {
            if (flow != gateway.getFlowKind()) continue;
            return true;
        }
        return false;
    }

    private boolean isUnique(Object outConnections, INodeSymbol toSymbol) {
        if (outConnections instanceof List) {
            Iterator i = ((List)outConnections).iterator();
            while (i.hasNext()) {
                if (toSymbol != ((IConnectionSymbol)i.next()).getTargetNode()) continue;
                return false;
            }
            return true;
        }
        return toSymbol != ((IConnectionSymbol)outConnections).getTargetNode();
    }

    private String computeLabel(Object in) {
        if (in instanceof EClass) {
            String typeName = ((EClass)in).getName();
            return typeName.endsWith(CONNECTION_TYPE_SUFFIX) ? typeName.substring(0, typeName.length() - CONNECTION_TYPE_SUFFIX.length()) : typeName;
        }
        return in instanceof LinkTypeType ? ((LinkTypeType)in).getName() : String.valueOf(in);
    }
}

