/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.modeling.core.editors.IEObjectValidationStatus;
import org.eclipse.stardust.modeling.core.editors.IValidationStatus;
import org.eclipse.stardust.modeling.validation.Issue;

final class ModelElementValidationStatus
implements IEObjectValidationStatus {
    private Map statusPerFeature;
    private List infos;
    private Map eFtrInfos;
    private List warnings;
    private Map eFtrWarnings;
    private List errors;
    private Map eFtrErrors;
    private Set affectedParents;
    private Set childrenWithInfos;
    private Set childrenWithWarnings;
    private Set childrenWithErrors;

    ModelElementValidationStatus() {
    }

    public boolean hasIssues() {
        return this.hasErrors() || this.hasWarnings() || this.hasInfos();
    }

    boolean hasChildrenWithIssues() {
        return !this.getChildrenWithErrors().isEmpty() || !this.getChildrenWithWarnings().isEmpty() || !this.getChildrenWithInfos().isEmpty();
    }

    public boolean hasInfos() {
        return !this.getInfos().isEmpty();
    }

    @Override
    public List getInfos() {
        return ModelElementValidationStatus.nullSafeGetList(this.infos);
    }

    public boolean hasWarnings() {
        return !this.getWarnings().isEmpty();
    }

    @Override
    public List getWarnings() {
        return ModelElementValidationStatus.nullSafeGetList(this.warnings);
    }

    public boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    @Override
    public List getErrors() {
        return ModelElementValidationStatus.nullSafeGetList(this.errors);
    }

    @Override
    public Set getChildrenWithInfos() {
        return ModelElementValidationStatus.nullSafeGetSet(this.childrenWithInfos);
    }

    @Override
    public Set getChildrenWithWarnings() {
        return ModelElementValidationStatus.nullSafeGetSet(this.childrenWithWarnings);
    }

    @Override
    public Set getChildrenWithErrors() {
        return ModelElementValidationStatus.nullSafeGetSet(this.childrenWithErrors);
    }

    @Override
    public IValidationStatus getFeatureStatus(Object feature) {
        IValidationStatus status;
        IValidationStatus iValidationStatus = status = this.statusPerFeature != null ? (IValidationStatus)this.statusPerFeature.get(feature) : null;
        if (status == null) {
            status = new FeatureStatusView(feature);
            if (this.statusPerFeature == null) {
                this.statusPerFeature = new HashMap();
            }
            this.statusPerFeature.put(feature, status);
        }
        return status;
    }

    void addIssue(Issue issue) {
        if (issue.isInfo()) {
            this.infos = ModelElementValidationStatus.addIssue(this.infos, issue);
            this.eFtrInfos = ModelElementValidationStatus.addIssue(this.eFtrInfos, issue.getFeature(), issue);
        } else if (issue.isWarning()) {
            this.warnings = ModelElementValidationStatus.addIssue(this.warnings, issue);
            this.eFtrWarnings = ModelElementValidationStatus.addIssue(this.eFtrWarnings, issue.getFeature(), issue);
        } else if (issue.isError()) {
            this.errors = ModelElementValidationStatus.addIssue(this.errors, issue);
            this.eFtrErrors = ModelElementValidationStatus.addIssue(this.eFtrErrors, issue.getFeature(), issue);
        }
    }

    void removeIssue(Issue issue) {
        if (issue.isInfo()) {
            this.infos = ModelElementValidationStatus.removeIssue(this.infos, issue);
            this.eFtrInfos = ModelElementValidationStatus.removeIssue(this.eFtrInfos, issue.getFeature(), issue);
        } else if (issue.isWarning()) {
            this.warnings = ModelElementValidationStatus.removeIssue(this.warnings, issue);
            this.eFtrWarnings = ModelElementValidationStatus.removeIssue(this.eFtrWarnings, issue.getFeature(), issue);
        } else if (issue.isError()) {
            this.errors = ModelElementValidationStatus.removeIssue(this.errors, issue);
            this.eFtrErrors = ModelElementValidationStatus.removeIssue(this.eFtrErrors, issue.getFeature(), issue);
        }
    }

    Set getAffectedParents() {
        return ModelElementValidationStatus.nullSafeGetSet(this.affectedParents);
    }

    void addAffectedParent(Object parent) {
        if (this.affectedParents == null) {
            this.affectedParents = new HashSet();
        }
        this.affectedParents.add(parent);
    }

    void removeAffectedParent(Object parent) {
        if (this.affectedParents != null) {
            this.affectedParents.remove(parent);
        }
    }

    void clearAffectedParents() {
        if (this.affectedParents != null) {
            this.affectedParents.clear();
        }
    }

    void updateChildStatus(EObject child, ModelElementValidationStatus childStatus) {
        this.childrenWithInfos = ModelElementValidationStatus.updateChildStatus(this.childrenWithInfos, !childStatus.getInfos().isEmpty(), child, childStatus);
        this.childrenWithWarnings = ModelElementValidationStatus.updateChildStatus(this.childrenWithWarnings, !childStatus.getWarnings().isEmpty(), child, childStatus);
        this.childrenWithErrors = ModelElementValidationStatus.updateChildStatus(this.childrenWithErrors, !childStatus.getErrors().isEmpty(), child, childStatus);
    }

    private static List nullSafeGetList(List list) {
        return list == null ? Collections.EMPTY_LIST : list;
    }

    private static List nullSafeGetList(Map eFtrMap, Object eFtr) {
        List list = eFtrMap != null ? (List)eFtrMap.get(eFtr) : null;
        return list == null ? Collections.EMPTY_LIST : list;
    }

    private static Set nullSafeGetSet(Set set) {
        return set == null ? Collections.EMPTY_SET : set;
    }

    private static List addIssue(List issues, Issue issue) {
        if (issues == null) {
            issues = new ArrayList<Issue>();
        }
        if (!issues.contains(issue)) {
            issues.add(issue);
        }
        return issues;
    }

    private static Map addIssue(Map eFtrIssues, Object eFtr, Issue issue) {
        ArrayList<Issue> issues;
        if (eFtrIssues == null) {
            eFtrIssues = new HashMap();
        }
        if ((issues = (ArrayList<Issue>)eFtrIssues.get(eFtr)) == null) {
            issues = new ArrayList<Issue>();
            eFtrIssues.put(eFtr, issues);
        }
        if (!issues.contains(issue)) {
            issues.add(issue);
        }
        return eFtrIssues;
    }

    private static List removeIssue(List issues, Issue issue) {
        if (issues != null) {
            issues.remove(issue);
        }
        return issues;
    }

    private static Map removeIssue(Map eFtrIssues, Object eFtr, Issue issue) {
        List issues;
        if (eFtrIssues != null && (issues = (List)eFtrIssues.get(eFtr)) != null) {
            eFtrIssues.remove(issue);
        }
        return eFtrIssues;
    }

    private static Set updateChildStatus(Set children, boolean doesQualify, EObject child, ModelElementValidationStatus childStatus) {
        if (doesQualify) {
            if (children == null) {
                children = new HashSet<EObject>();
            }
            children.add(child);
        } else if (children != null) {
            children.remove(child);
        }
        return children;
    }

    private final class FeatureStatusView
    implements IValidationStatus {
        private final Object feature;

        FeatureStatusView(Object feature) {
            this.feature = feature;
        }

        public boolean hasIssues() {
            return this.hasErrors() || this.hasWarnings() || this.hasInfos();
        }

        public boolean hasInfos() {
            return !this.getInfos().isEmpty();
        }

        @Override
        public List getInfos() {
            return ModelElementValidationStatus.nullSafeGetList(ModelElementValidationStatus.this.eFtrInfos, this.feature);
        }

        public boolean hasWarnings() {
            return !this.getWarnings().isEmpty();
        }

        @Override
        public List getWarnings() {
            return ModelElementValidationStatus.nullSafeGetList(ModelElementValidationStatus.this.eFtrWarnings, this.feature);
        }

        public boolean hasErrors() {
            return !this.getErrors().isEmpty();
        }

        @Override
        public List getErrors() {
            return ModelElementValidationStatus.nullSafeGetList(ModelElementValidationStatus.this.eFtrErrors, this.feature);
        }

        @Override
        public Set getChildrenWithInfos() {
            return ModelElementValidationStatus.this.getChildrenWithInfos();
        }

        @Override
        public Set getChildrenWithWarnings() {
            return ModelElementValidationStatus.this.getChildrenWithWarnings();
        }

        @Override
        public Set getChildrenWithErrors() {
            return ModelElementValidationStatus.this.getChildrenWithErrors();
        }
    }
}

