/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.Coordinates;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoutingType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.AbstractMerger;
import org.eclipse.stardust.modeling.core.editors.cap.ConnectionUtils;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.LaneUtils;
import org.eclipse.stardust.modeling.core.editors.cap.MergerUtil;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.PlatformUI;

public class DiagramMerger
extends AbstractMerger {
    public static int CREATE_ALL = 0;
    public static int CREATE_SYMBOLS = 1;
    public static int CREATE_SUBPROCESS = 2;
    private int pasteMode;
    private EcoreUtil.Copier transitionCopier = new EcoreUtil.Copier();
    protected List connections = new ArrayList();
    protected List connectionObjects = new ArrayList();
    protected List checkActivities = new ArrayList();
    private List symbols = new ArrayList();
    private WorkflowModelEditor editor;
    private DiagramType sourceDiagram;
    private boolean copyLanes = false;
    private List lanes = new ArrayList();
    private List rawSymbols = new ArrayList();
    private Map laneHierarchies = new HashMap();
    private ISwimlaneSymbol parentLane = null;

    public DiagramMerger(ModelType targetModel, List input, StoreObject storage, int pasteMode) {
        super(targetModel, storage);
        EObject raw;
        int i;
        MergerUtil.setStorage(storage);
        this.pasteMode = pasteMode;
        this.editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.isDiagram = true;
        storage.setIsDiagram(true);
        DiagramEditorPage diagramEditorPage = (DiagramEditorPage)this.editor.getCurrentPage();
        this.targetDiagram = diagramEditorPage.getDiagram();
        this.targetProcess = storage.getTargetProcess();
        this.sourceDiagram = storage.getSourceDiagram();
        if (input.get(0) instanceof LaneSymbol) {
            this.copyLanes = true;
            i = 0;
            while (i < input.size()) {
                LaneSymbol laneSymbol = (LaneSymbol)input.get(i);
                MergerUtil.MergerEntry laneEntry = new MergerUtil.MergerEntry((EObject)laneSymbol, this.copier.copy((EObject)laneSymbol));
                List hierarchy = LaneUtils.createLaneHierarchyCopy(laneSymbol, this.copier);
                this.laneHierarchies.put(laneEntry, hierarchy);
                ++i;
            }
            if (!this.iterateLanes(this.laneHierarchies, false)) {
                return;
            }
            input = new ArrayList();
        }
        if (!this.lanes.isEmpty()) {
            i = 0;
            while (i < this.lanes.size()) {
                MergerUtil.MergerEntry symbolEntry = (MergerUtil.MergerEntry)this.lanes.get(i);
                raw = symbolEntry.getKey();
                MergerUtil.getObjectsFromLane(raw, this.elements, this.globalElements, this.processes, this.activities, this.copier, this.isSameModel);
                ++i;
            }
        }
        i = 0;
        while (i < input.size()) {
            EObject symbol = (EObject)input.get(i);
            MergerUtil.MergerEntry symbolEntry = new MergerUtil.MergerEntry(symbol, this.copier.copy(symbol));
            if (symbol instanceof IModelElementNodeSymbol) {
                IIdentifiableModelElement modelElement;
                if (pasteMode == CREATE_ALL) {
                    MergerUtil.getObjectsFromSymbol((IModelElementNodeSymbol)symbol, this.elements, this.globalElements, this.processes, this.activities, this.copier, this.isSameModel, true);
                } else if (pasteMode == CREATE_SUBPROCESS && (symbol instanceof ActivitySymbolType || symbol instanceof AbstractEventSymbol) && (modelElement = ((IModelElementNodeSymbol)symbol).getModelElement()) != null && !this.elements.containsKey(modelElement)) {
                    this.elements.put(modelElement, this.copier.copy((EObject)modelElement));
                }
            }
            this.symbols.add(symbolEntry);
            ++i;
        }
        if (pasteMode == CREATE_ALL || pasteMode == CREATE_SUBPROCESS) {
            if (pasteMode == CREATE_ALL) {
                this.collectProcessContent();
                if (!this.isSameModel) {
                    this.checkForDialog(targetModel);
                }
            }
            this.collectElements();
        }
        this.copier.copyReferences();
        if (this.copyLanes) {
            FeatureMap.ValueListIterator iter;
            LaneSymbol lane;
            MergerUtil.MergerEntry laneEntry;
            this.iterateLanes(this.laneHierarchies, true);
            if (!this.lanes.isEmpty()) {
                i = 0;
                while (i < this.lanes.size()) {
                    laneEntry = (MergerUtil.MergerEntry)this.lanes.get(i);
                    raw = laneEntry.getKey();
                    lane = (LaneSymbol)raw;
                    iter = lane.getNodes().valueListIterator();
                    while (iter.hasNext()) {
                        EObject element = (EObject)iter.next();
                        if (!(element instanceof INodeSymbol)) continue;
                        this.rawSymbols.add(element);
                    }
                    ++i;
                }
            }
            if (!this.lanes.isEmpty()) {
                i = 0;
                while (i < this.lanes.size()) {
                    laneEntry = (MergerUtil.MergerEntry)this.lanes.get(i);
                    EObject copy = laneEntry.getValue();
                    lane = (LaneSymbol)copy;
                    iter = lane.getNodes().valueListIterator();
                    while (iter.hasNext()) {
                        EObject copySymbol = (EObject)iter.next();
                        IModelElement rawSymbol = null;
                        if (!(copySymbol instanceof INodeSymbol) || (rawSymbol = CopyPasteUtil.getRawSymbolFromList(this.rawSymbols, (INodeSymbol)copySymbol)) == null) continue;
                        MergerUtil.MergerEntry symbolEntry = new MergerUtil.MergerEntry((EObject)rawSymbol, copySymbol);
                        this.symbols.add(symbolEntry);
                    }
                    ++i;
                }
            }
        }
        this.collectConnections();
        this.transitionCopier.copyReferences();
    }

    private void collectConnections() {
        ArrayList<Object> tmpConnections = new ArrayList<Object>();
        DiagramType sourceDiagramCopy = (DiagramType)CopyPasteUtil.getSameModelElement((EObject)this.sourceDiagram, this.storage.getOriginalModelCopy(), null);
        if (sourceDiagramCopy == null) {
            return;
        }
        EList pools = sourceDiagramCopy.getPoolSymbols();
        int i = 0;
        while (i < pools.size()) {
            PoolSymbol pool = (PoolSymbol)pools.get(i);
            FeatureMap.ValueListIterator iter = pool.getConnections().valueListIterator();
            while (iter.hasNext()) {
                LinkTypeType link;
                TransitionType transition;
                EObject element = (EObject)iter.next();
                EObject copy = this.transitionCopier.copy(element);
                MergerUtil.MergerEntry connectionEntry = new MergerUtil.MergerEntry(element, copy);
                if (!(element instanceof IConnectionSymbol)) continue;
                INodeSymbol rawSourceSymbol = ((IConnectionSymbol)element).getSourceNode();
                INodeSymbol rawTargetSymbol = ((IConnectionSymbol)element).getTargetNode();
                INodeSymbol sourceSymbol = (INodeSymbol)MergerUtil.getElementFromList(this.symbols, (EObject)rawSourceSymbol);
                INodeSymbol targetSymbol = (INodeSymbol)MergerUtil.getElementFromList(this.symbols, (EObject)rawTargetSymbol);
                if (sourceSymbol == null || targetSymbol == null) continue;
                this.connections.add(connectionEntry);
                if (this.pasteMode != CREATE_ALL && this.pasteMode != CREATE_SUBPROCESS) continue;
                if (element instanceof TransitionConnectionType && !tmpConnections.contains(transition = ((TransitionConnectionType)element).getTransition()) && transition != null) {
                    MergerUtil.MergerEntry transitionEntry = new MergerUtil.MergerEntry((EObject)transition, this.transitionCopier.copy((EObject)transition));
                    this.connectionObjects.add(transitionEntry);
                    tmpConnections.add(transition);
                }
                if (!(element instanceof GenericLinkConnectionType) || this.isSameModel || tmpConnections.contains(link = ((GenericLinkConnectionType)element).getLinkType())) continue;
                MergerUtil.MergerEntry linkEntry = new MergerUtil.MergerEntry((EObject)link, this.transitionCopier.copy((EObject)link));
                this.connectionObjects.add(linkEntry);
                tmpConnections.add(link);
            }
            EList lanes = pool.getLanes();
            int l = 0;
            while (l < lanes.size()) {
                LaneSymbol lane = (LaneSymbol)lanes.get(l);
                FeatureMap.ValueListIterator iter2 = lane.getConnections().valueListIterator();
                while (iter2.hasNext()) {
                    LinkTypeType link;
                    TransitionType transition;
                    EObject element = (EObject)iter2.next();
                    EObject copy = this.transitionCopier.copy(element);
                    MergerUtil.MergerEntry connectionEntry = new MergerUtil.MergerEntry(element, copy);
                    if (!(element instanceof IConnectionSymbol)) continue;
                    INodeSymbol rawSourceSymbol = ((IConnectionSymbol)element).getSourceNode();
                    INodeSymbol rawTargetSymbol = ((IConnectionSymbol)element).getTargetNode();
                    INodeSymbol sourceSymbol = (INodeSymbol)MergerUtil.getElementFromList(this.symbols, (EObject)rawSourceSymbol);
                    INodeSymbol targetSymbol = (INodeSymbol)MergerUtil.getElementFromList(this.symbols, (EObject)rawTargetSymbol);
                    if (sourceSymbol == null || targetSymbol == null) continue;
                    this.connections.add(connectionEntry);
                    if (this.pasteMode != CREATE_ALL && this.pasteMode != CREATE_SUBPROCESS) continue;
                    if (element instanceof TransitionConnectionType && !tmpConnections.contains(transition = ((TransitionConnectionType)element).getTransition()) && transition != null && transition != null) {
                        MergerUtil.MergerEntry transitionEntry = new MergerUtil.MergerEntry((EObject)transition, this.transitionCopier.copy((EObject)transition));
                        this.connectionObjects.add(transitionEntry);
                        tmpConnections.add(transition);
                    }
                    if (!(element instanceof GenericLinkConnectionType) || this.isSameModel || tmpConnections.contains(link = ((GenericLinkConnectionType)element).getLinkType())) continue;
                    MergerUtil.MergerEntry linkEntry = new MergerUtil.MergerEntry((EObject)link, this.transitionCopier.copy((EObject)link));
                    this.connectionObjects.add(linkEntry);
                    tmpConnections.add(link);
                }
                ++l;
            }
            ++i;
        }
        FeatureMap.ValueListIterator iter = sourceDiagramCopy.getConnections().valueListIterator();
        while (iter.hasNext()) {
            LinkTypeType link;
            TransitionType transition;
            EObject element = (EObject)iter.next();
            EObject copy = this.transitionCopier.copy(element);
            MergerUtil.MergerEntry connectionEntry = new MergerUtil.MergerEntry(element, copy);
            if (!(element instanceof IConnectionSymbol)) continue;
            INodeSymbol rawSourceSymbol = ((IConnectionSymbol)element).getSourceNode();
            INodeSymbol rawTargetSymbol = ((IConnectionSymbol)element).getTargetNode();
            INodeSymbol sourceSymbol = (INodeSymbol)MergerUtil.getElementFromList(this.symbols, (EObject)rawSourceSymbol);
            INodeSymbol targetSymbol = (INodeSymbol)MergerUtil.getElementFromList(this.symbols, (EObject)rawTargetSymbol);
            if (sourceSymbol == null || targetSymbol == null) continue;
            this.connections.add(connectionEntry);
            if (this.pasteMode != CREATE_ALL && this.pasteMode != CREATE_SUBPROCESS) continue;
            if (element instanceof TransitionConnectionType && !tmpConnections.contains(transition = ((TransitionConnectionType)element).getTransition()) && transition != null) {
                MergerUtil.MergerEntry transitionEntry = new MergerUtil.MergerEntry((EObject)transition, this.transitionCopier.copy((EObject)transition));
                this.connectionObjects.add(transitionEntry);
                tmpConnections.add(transition);
            }
            if (!(element instanceof GenericLinkConnectionType) || this.isSameModel || tmpConnections.contains(link = ((GenericLinkConnectionType)element).getLinkType())) continue;
            MergerUtil.MergerEntry linkEntry = new MergerUtil.MergerEntry((EObject)link, this.transitionCopier.copy((EObject)link));
            this.connectionObjects.add(linkEntry);
            tmpConnections.add(link);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void merge() {
        if (!(this.pasteMode != CREATE_ALL && this.pasteMode != CREATE_SUBPROCESS || this.mergeGlobal())) {
            return;
        }
        int i = 0;
        while (i < this.connectionObjects.size()) {
            Map.Entry entry = (Map.Entry)this.connectionObjects.get(i);
            if (!this.mergeElement(entry)) {
                this.modelChanged = false;
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.connectionObjects.size()) {
            Map.Entry entry = (Map.Entry)this.connectionObjects.get(i);
            this.addModelElement(entry, false);
            ++i;
        }
        i = 0;
        while (i < this.symbols.size()) {
            Map.Entry entry = (Map.Entry)this.symbols.get(i);
            this.createSymbol(entry, this.copyLanes);
            ++i;
        }
        this.createConnections();
        this.isDiagram = false;
        for (Map.Entry<EObject, EObject> entry : this.processElements.entrySet()) {
            if (this.mergeElement(entry)) continue;
            this.modelChanged = false;
            return;
        }
        for (Map.Entry entry : this.processElements.entrySet()) {
            this.addModelElement(entry, false);
        }
        if (this.pasteMode == CREATE_ALL || this.pasteMode == CREATE_SUBPROCESS) {
            void var2_13;
            boolean bl = false;
            while (var2_13 < this.checkActivities.size()) {
                JoinSplitType split;
                boolean hasSplitSymbol = false;
                boolean hasJoinSymbol = false;
                ActivitySymbolType symbol = (ActivitySymbolType)this.checkActivities.get((int)var2_13);
                EList gatewaySymbols = symbol.getGatewaySymbols();
                int g = 0;
                while (g < gatewaySymbols.size()) {
                    GatewaySymbol gatewaySymbol = (GatewaySymbol)gatewaySymbols.get(g);
                    FlowControlType type = gatewaySymbol.getFlowKind();
                    if (type.equals((Object)FlowControlType.SPLIT_LITERAL)) {
                        hasSplitSymbol = true;
                    }
                    if (type.equals((Object)FlowControlType.JOIN_LITERAL)) {
                        hasJoinSymbol = true;
                    }
                    ++g;
                }
                ActivityType activity = symbol.getActivity();
                JoinSplitType join = activity.getJoin();
                if (join != null && !hasJoinSymbol) {
                    activity.setJoin(null);
                }
                if ((split = activity.getSplit()) != null && !hasSplitSymbol) {
                    activity.setSplit(null);
                }
                ++var2_13;
            }
        }
    }

    private void createConnections() {
        Dimension coordinatesDifference = null;
        if (this.storage.getTargetEditPart() != null) {
            coordinatesDifference = this.getLocationDifference();
        }
        int i = 0;
        while (i < this.connections.size()) {
            IIdentifiableModelElement modelElement;
            LinkTypeType link;
            Map.Entry entry = (Map.Entry)this.connections.get(i);
            EObject raw = (EObject)entry.getKey();
            EObject copy = (EObject)entry.getValue();
            TransitionType transitionType = null;
            if (raw instanceof TransitionConnectionType) {
                IIdentifiableModelElement modelElement2;
                TransitionType transition;
                RoutingType routingType = ((TransitionConnectionType)raw).getRouting();
                EList rawCoordinates = null;
                if (routingType.equals((Object)RoutingType.EXPLICIT_LITERAL)) {
                    rawCoordinates = ((TransitionConnectionType)raw).getCoordinates();
                }
                if ((transition = ((TransitionConnectionType)raw).getTransition()) != null && (modelElement2 = this.getTargetModelElement((EObject)this.targetProcess, (IIdentifiableModelElement)transition)) != null) {
                    transitionType = (TransitionType)modelElement2;
                    ((TransitionConnectionType)copy).setTransition((TransitionType)modelElement2);
                }
                if (rawCoordinates != null && coordinatesDifference != null) {
                    ((TransitionConnectionType)copy).getCoordinates().clear();
                    int c = 0;
                    while (c < rawCoordinates.size()) {
                        Coordinates rawCoordiante = (Coordinates)rawCoordinates.get(c);
                        Coordinates copyCoordinate = CarnotWorkflowModelPackage.eINSTANCE.getCarnotWorkflowModelFactory().createCoordinates();
                        copyCoordinate.setXPos(rawCoordiante.getXPos() - (double)coordinatesDifference.width);
                        copyCoordinate.setYPos(rawCoordiante.getYPos() - (double)coordinatesDifference.height);
                        ((TransitionConnectionType)copy).getCoordinates().add((Object)copyCoordinate);
                        ++c;
                    }
                }
            }
            if (raw instanceof GenericLinkConnectionType && (link = ((GenericLinkConnectionType)raw).getLinkType()) != null && (modelElement = this.getTargetModelElement((EObject)this.targetProcess, (IIdentifiableModelElement)link)) != null) {
                ((GenericLinkConnectionType)copy).setLinkType((LinkTypeType)modelElement);
            }
            if (raw instanceof IConnectionSymbol) {
                INodeSymbol rawSourceSymbol = ((IConnectionSymbol)raw).getSourceNode();
                INodeSymbol rawTargetSymbol = ((IConnectionSymbol)raw).getTargetNode();
                INodeSymbol sourceSymbol = (INodeSymbol)MergerUtil.getElementFromList(this.symbols, (EObject)rawSourceSymbol);
                INodeSymbol targetSymbol = (INodeSymbol)MergerUtil.getElementFromList(this.symbols, (EObject)rawTargetSymbol);
                if (sourceSymbol != null && targetSymbol != null) {
                    ((IConnectionSymbol)copy).setSourceNode(sourceSymbol);
                    ((IConnectionSymbol)copy).setTargetNode(targetSymbol);
                }
                ISymbolContainer container = (ISymbolContainer)this.storage.getTargetObject();
                EStructuralFeature feature = raw.eContainingFeature();
                if (feature != null) {
                    List list = (List)container.eGet(feature);
                    list.add(copy);
                }
                if (transitionType != null && sourceSymbol != null && targetSymbol != null) {
                    ActivitySymbolType sourceActivitySymbol = null;
                    ActivitySymbolType targetActivitySymbol = null;
                    if (sourceSymbol instanceof GatewaySymbol) {
                        sourceActivitySymbol = ((GatewaySymbol)sourceSymbol).getActivitySymbol();
                    } else if (sourceSymbol instanceof ActivitySymbolType) {
                        sourceActivitySymbol = (ActivitySymbolType)sourceSymbol;
                    }
                    if (targetSymbol instanceof GatewaySymbol) {
                        targetActivitySymbol = ((GatewaySymbol)targetSymbol).getActivitySymbol();
                    } else if (targetSymbol instanceof ActivitySymbolType) {
                        targetActivitySymbol = (ActivitySymbolType)targetSymbol;
                    }
                    if (sourceActivitySymbol != null && targetActivitySymbol != null) {
                        ActivityType fromActivity = sourceActivitySymbol.getActivity();
                        ActivityType toActivity = targetActivitySymbol.getActivity();
                        transitionType.setFrom(fromActivity);
                        transitionType.setTo(toActivity);
                    }
                }
            }
            ++i;
        }
    }

    private boolean iterateLanes(Map hierarchies, boolean create) {
        LaneSymbol storeparentLane = null;
        for (Map.Entry entry : hierarchies.entrySet()) {
            MergerUtil.MergerEntry symbolEntry = (MergerUtil.MergerEntry)entry.getKey();
            EObject raw = symbolEntry.getKey();
            EObject copy = symbolEntry.getValue();
            List checkHierarchy = (List)entry.getValue();
            storeparentLane = (LaneSymbol)this.parentLane;
            if (!create) {
                if (this.checkElementInModel(symbolEntry)) {
                    if (!this.openDialog(symbolEntry)) {
                        return false;
                    }
                    this.changedCache.put(symbolEntry.getKey(), symbolEntry.getValue());
                }
            } else {
                ((LaneSymbol)copy).getChildLanes().clear();
                this.createSymbol(symbolEntry, false);
            }
            if (!((LaneSymbol)raw).getNodes().isEmpty() && !create) {
                this.lanes.add(symbolEntry);
            }
            int i = 0;
            while (i < checkHierarchy.size()) {
                this.parentLane = (ISwimlaneSymbol)copy;
                Object object = checkHierarchy.get(i);
                if (object instanceof Map) {
                    Map childHierarchy = (Map)object;
                    if (!this.iterateLanes(childHierarchy, create)) {
                        return false;
                    }
                } else {
                    symbolEntry = (MergerUtil.MergerEntry)object;
                    raw = symbolEntry.getKey();
                    copy = symbolEntry.getValue();
                    if (!create) {
                        if (this.checkElementInModel(symbolEntry)) {
                            if (!this.openDialog(symbolEntry)) {
                                return false;
                            }
                            this.changedCache.put(symbolEntry.getKey(), symbolEntry.getValue());
                        }
                    } else {
                        ((LaneSymbol)copy).getChildLanes().clear();
                        this.createSymbol(symbolEntry, false);
                    }
                    if (!((LaneSymbol)raw).getNodes().isEmpty() && !create) {
                        this.lanes.add(symbolEntry);
                    }
                }
                ++i;
            }
            this.parentLane = storeparentLane;
        }
        if (!create) {
            this.parentLane = null;
        }
        return true;
    }

    private Dimension getLocationDifference() {
        DiagramEditorPage diagramEditorPage = (DiagramEditorPage)this.editor.getCurrentPage();
        Point newMouseLocation = diagramEditorPage.getMouseLocation();
        Point viewPortPoint = PoolLaneUtils.findViewportPoint((GraphicalEditPart)this.storage.getTargetEditPart());
        newMouseLocation.performTranslate(viewPortPoint.x, viewPortPoint.y);
        Dimension dimension = this.storage.getLocation().getDifference(newMouseLocation);
        return dimension;
    }

    protected void createSymbol(Map.Entry symbolEntry, boolean onlyChange) {
        IIdentifiableModelElement rawModelElement;
        Point newContainerLocation;
        EObject rawSymbol = (EObject)symbolEntry.getKey();
        EObject modelSymbol = (EObject)symbolEntry.getValue();
        DiagramEditorPage diagramEditorPage = (DiagramEditorPage)this.editor.getCurrentPage();
        Point newMouseLocation = diagramEditorPage.getMouseLocation();
        Point location = new Point((double)((INodeSymbol)modelSymbol).getXPos(), (double)((INodeSymbol)modelSymbol).getYPos());
        if (this.storage.getTargetEditPart() != null) {
            newContainerLocation = PoolLaneUtils.getLocation((GraphicalEditPart)this.storage.getTargetEditPart(), ((AbstractGraphicalEditPart)this.storage.getTargetEditPart()).getFigure(), newMouseLocation, true);
            Dimension dimension = this.storage.getLocation().getDifference(location);
            newContainerLocation.x -= dimension.width;
            newContainerLocation.y -= dimension.height;
        } else {
            newContainerLocation = location;
        }
        if (rawSymbol instanceof IModelElementNodeSymbol && (rawModelElement = ((IModelElementNodeSymbol)rawSymbol).getModelElement()) != null) {
            IIdentifiableModelElement modelElement;
            EObject parent = rawModelElement.eContainer();
            if (parent instanceof ProcessDefinitionType) {
                parent = this.storage.getTargetProcess();
            }
            if ((modelElement = this.getTargetModelElement(parent = CopyPasteUtil.getSameModelElement(parent, this.targetModel, null), rawModelElement)) != null) {
                ((IModelElementNodeSymbol)modelSymbol).setModelElement(modelElement);
            }
            if (modelElement instanceof ActivityType) {
                this.checkActivities.add(modelSymbol);
            }
        }
        ConnectionUtils.deleteConnectionsFromSymbol((INodeSymbol)modelSymbol, null);
        if (onlyChange) {
            return;
        }
        if (this.parentLane == null) {
            ((INodeSymbol)modelSymbol).setXPos((long)newContainerLocation.x);
            ((INodeSymbol)modelSymbol).setYPos((long)newContainerLocation.y);
        }
        ISymbolContainer container = (ISymbolContainer)this.storage.getTargetObject();
        if (modelSymbol instanceof LaneSymbol) {
            container = DiagramUtil.getDefaultPool((DiagramType)diagramEditorPage.getDiagram());
        }
        for (EStructuralFeature feature : container.getNodeContainingFeatures()) {
            if (!feature.getEType().equals(modelSymbol.eClass())) continue;
            List list = (List)container.eGet(feature);
            list.add(modelSymbol);
            this.modelChanged = true;
        }
        if (modelSymbol instanceof LaneSymbol) {
            if (this.parentLane != null) {
                ((LaneSymbol)modelSymbol).setParentLane(this.parentLane);
            } else {
                ((LaneSymbol)modelSymbol).setParentLane((ISwimlaneSymbol)this.storage.getTargetEditPart().getModel());
            }
            ((LaneSymbol)modelSymbol).setParentPool(DiagramUtil.getDefaultPool((DiagramType)this.storage.getTargetDiagram()));
            IModelParticipant rawLaneParticipant = ((LaneSymbol)rawSymbol).getParticipantReference();
            if (rawLaneParticipant != null) {
                if (this.isSameModel) {
                    ((LaneSymbol)modelSymbol).setParticipantReference(rawLaneParticipant);
                } else {
                    IIdentifiableModelElement modelElement = this.getTargetModelElement(null, (IIdentifiableModelElement)rawLaneParticipant);
                    if (modelElement != null) {
                        ((LaneSymbol)modelSymbol).setParticipantReference((IModelParticipant)modelElement);
                    }
                }
            }
        }
    }
}

