/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.Code;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.GenericLinkConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipantSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.editors.cap.ContentDecorator;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;

public class MergerUtil {
    public static StoreObject storage;

    public static void setStorage(StoreObject storage) {
        MergerUtil.storage = storage;
    }

    public static void getObjectsFromTrigger(TriggerType trigger, Map globalElements, EcoreUtil.Copier copier) {
        EList attributes = trigger.getAttribute();
        int a = 0;
        while (a < attributes.size()) {
            EObject element;
            AttributeType attribute = (AttributeType)attributes.get(a);
            IdentifiableReference reference = attribute.getReference();
            if (reference != null && (element = reference.getIdentifiable()) != null && element instanceof IModelParticipant) {
                if (!globalElements.containsKey(element)) {
                    globalElements.put(element, copier.copy(element));
                }
                if (element instanceof ConditionalPerformerType) {
                    DataType realmData;
                    String dataId;
                    DataType dataType = ((ConditionalPerformerType)element).getData();
                    if (dataType != null && !globalElements.containsKey(dataType)) {
                        globalElements.put(dataType, copier.copy((EObject)dataType));
                        MergerUtil.checkAuthorizations((EObject)dataType, globalElements, copier);
                    }
                    if (!(StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:conditionalPerformer:realmData"))) || dataType != null && dataType.getId().equals(dataId) || (realmData = (DataType)ModelUtils.findElementById((List)storage.getOriginalModelCopy().getData(), (String)dataId)) == null || globalElements.containsKey(realmData))) {
                        globalElements.put(realmData, copier.copy((EObject)realmData));
                        MergerUtil.checkAuthorizations((EObject)realmData, globalElements, copier);
                    }
                }
            }
            ++a;
        }
        EList mappings = trigger.getParameterMapping();
        int m = 0;
        while (m < mappings.size()) {
            ParameterMappingType mappingType = (ParameterMappingType)mappings.get(m);
            DataType data = mappingType.getData();
            if (!globalElements.containsKey(data)) {
                globalElements.put(data, copier.copy((EObject)data));
                MergerUtil.checkAuthorizations((EObject)data, globalElements, copier);
            }
            ++m;
        }
    }

    public static void getObjectsFromActivity(ActivityType activity, Map globalElements, Map processes, Map elements, EcoreUtil.Copier copier) {
        ApplicationType application;
        IModelParticipant qualityControlPerformer;
        IModelParticipant performer = activity.getPerformer();
        if (performer != null && !globalElements.containsKey(performer)) {
            globalElements.put(performer, copier.copy((EObject)performer));
        }
        if ((qualityControlPerformer = activity.getQualityControlPerformer()) != null && !globalElements.containsKey(qualityControlPerformer)) {
            globalElements.put(qualityControlPerformer, copier.copy((EObject)qualityControlPerformer));
        }
        if (performer != null && performer instanceof ConditionalPerformerType) {
            DataType realmData;
            String dataId;
            DataType dataType = ((ConditionalPerformerType)performer).getData();
            if (dataType != null && !globalElements.containsKey(dataType)) {
                globalElements.put(dataType, copier.copy((EObject)dataType));
                MergerUtil.checkAuthorizations((EObject)dataType, globalElements, copier);
            }
            if (!(StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue((IExtensibleElement)performer, (String)"carnot:engine:conditionalPerformer:realmData"))) || dataType != null && dataType.getId().equals(dataId) || (realmData = (DataType)ModelUtils.findElementById((List)storage.getOriginalModelCopy().getData(), (String)dataId)) == null || globalElements.containsKey(realmData))) {
                globalElements.put(realmData, copier.copy((EObject)realmData));
                MergerUtil.checkAuthorizations((EObject)realmData, globalElements, copier);
            }
        }
        if ((application = activity.getApplication()) != null && !globalElements.containsKey(application)) {
            globalElements.put(application, copier.copy((EObject)application));
        }
        EList dataMappings = activity.getDataMapping();
        for (DataMappingType dataMapping : dataMappings) {
            DataType dataType = dataMapping.getData();
            if (dataType == null || globalElements.containsKey(dataType)) continue;
            globalElements.put(dataType, copier.copy((EObject)dataType));
            MergerUtil.checkAuthorizations((EObject)dataType, globalElements, copier);
        }
        EList eventHandler = activity.getEventHandler();
        int e = 0;
        while (e < eventHandler.size()) {
            EventHandlerType eventHandlerType = (EventHandlerType)eventHandler.get(e);
            EList eventAction = eventHandlerType.getEventAction();
            int a = 0;
            while (a < eventAction.size()) {
                IIdentifiableModelElement result;
                AttributeType attribute;
                EventActionType eventActionType = (EventActionType)eventAction.get(a);
                EventActionTypeType type = eventActionType.getType();
                if (type != null && !elements.containsKey(type)) {
                    elements.put(type, copier.copy((EObject)type));
                }
                if (eventActionType instanceof IExtensibleElement && (attribute = AttributeUtil.getAttribute((IExtensibleElement)eventActionType, (String)"carnot:engine:processDefinition")) != null && attribute.getReference() != null && (result = (IIdentifiableModelElement)attribute.getReference().getIdentifiable()) != null && processes != null && !processes.containsKey(result)) {
                    processes.put(result, copier.copy((EObject)result));
                }
                ++a;
            }
            ++e;
        }
        ProcessDefinitionType subProcess = activity.getImplementationProcess();
        if (subProcess != null && processes != null && !processes.containsKey(subProcess)) {
            processes.put(subProcess, copier.copy((EObject)subProcess));
        }
        EList validQualityCodes = activity.getValidQualityCodes();
        for (Code code : validQualityCodes) {
            if (elements.containsKey(code)) continue;
            elements.put(code, copier.copy((EObject)code));
        }
    }

    static void getObjectsFromSymbol(IModelElementNodeSymbol symbol, Map elements, Map globalElements, Map processes, Map activities, EcoreUtil.Copier copier, boolean isSameModel, boolean isSelected) {
        IIdentifiableModelElement modelElement = symbol.getModelElement();
        if (!isSameModel) {
            MergerUtil.checkAuthorizations((EObject)modelElement, globalElements, copier);
        }
        if (modelElement != null) {
            if (symbol instanceof StartEventSymbol && !isSameModel) {
                MergerUtil.getObjectsFromTrigger((TriggerType)modelElement, globalElements, copier);
            }
            if (symbol instanceof ActivitySymbolType && !isSameModel) {
                if (activities != null && !activities.containsKey(modelElement)) {
                    activities.put(modelElement, copier.copy((EObject)modelElement));
                }
                MergerUtil.getObjectsFromActivity((ActivityType)modelElement, globalElements, processes, elements, copier);
            }
            if (symbol instanceof ProcessSymbolType) {
                if (!processes.containsKey(modelElement)) {
                    processes.put(modelElement, copier.copy((EObject)modelElement));
                }
            } else if (symbol instanceof IModelParticipantSymbol || symbol instanceof ApplicationSymbolType || symbol instanceof DataSymbolType) {
                if (isSelected) {
                    if (!elements.containsKey(modelElement)) {
                        elements.put(modelElement, copier.copy((EObject)modelElement));
                    }
                } else if (!globalElements.containsKey(modelElement)) {
                    globalElements.put(modelElement, copier.copy((EObject)modelElement));
                }
                if (!isSameModel && modelElement instanceof ConditionalPerformerType) {
                    DataType realmData;
                    String dataId;
                    DataType dataType = ((ConditionalPerformerType)modelElement).getData();
                    if (dataType != null && !globalElements.containsKey(dataType)) {
                        globalElements.put(dataType, copier.copy((EObject)dataType));
                    }
                    if (!(StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue((IExtensibleElement)modelElement, (String)"carnot:engine:conditionalPerformer:realmData"))) || dataType != null && dataType.getId().equals(dataId) || (realmData = (DataType)ModelUtils.findElementById((List)storage.getOriginalModelCopy().getData(), (String)dataId)) == null || globalElements.containsKey(realmData))) {
                        globalElements.put(realmData, copier.copy((EObject)realmData));
                    }
                }
            } else if (!elements.containsKey(modelElement)) {
                elements.put(modelElement, copier.copy((EObject)modelElement));
            }
        }
    }

    static void getObjectsFromProcess(EObject raw, Map elements, Map globalElements, EcoreUtil.Copier copier) {
        FormalParameterMappingsType formalParameterMappings = ((ProcessDefinitionType)raw).getFormalParameterMappings();
        FormalParametersType referencedParametersType = ((ProcessDefinitionType)raw).getFormalParameters();
        if (referencedParametersType != null && formalParameterMappings != null) {
            for (FormalParameterType referencedParameterType : referencedParametersType.getFormalParameter()) {
                DataType mappedData = formalParameterMappings.getMappedData(referencedParameterType);
                if (mappedData == null || globalElements.containsKey(mappedData)) continue;
                globalElements.put(mappedData, copier.copy((EObject)mappedData));
                MergerUtil.checkAuthorizations((EObject)mappedData, globalElements, copier);
            }
        }
        EList dataPathList = ((ProcessDefinitionType)raw).getDataPath();
        int d = 0;
        while (d < dataPathList.size()) {
            DataPathType dataPath = (DataPathType)dataPathList.get(d);
            DataType data = dataPath.getData();
            if (data != null && !globalElements.containsKey(data)) {
                globalElements.put(data, copier.copy((EObject)data));
                MergerUtil.checkAuthorizations((EObject)data, globalElements, copier);
            }
            ++d;
        }
        EList diagrams = ((ProcessDefinitionType)raw).getDiagram();
        int d2 = 0;
        while (d2 < diagrams.size()) {
            DiagramType diagram = (DiagramType)diagrams.get(d2);
            MergerUtil.getObjectsFromDiagram((EObject)diagram, elements, globalElements, null, null, copier, false);
            ++d2;
        }
        EList processActivities = ((ProcessDefinitionType)raw).getActivity();
        int i = 0;
        while (i < processActivities.size()) {
            ActivityType activity = (ActivityType)processActivities.get(i);
            MergerUtil.checkAuthorizations((EObject)activity, globalElements, copier);
            MergerUtil.getObjectsFromActivity(activity, globalElements, null, elements, copier);
            ++i;
        }
        EList processTrigger = ((ProcessDefinitionType)raw).getTrigger();
        int i2 = 0;
        while (i2 < processTrigger.size()) {
            TriggerType trigger = (TriggerType)processTrigger.get(i2);
            MergerUtil.getObjectsFromTrigger(trigger, globalElements, copier);
            ++i2;
        }
    }

    static void getObjectsFromLane(EObject raw, Map elements, Map globalElements, Map processes, Map activities, EcoreUtil.Copier copier, boolean isSameModel) {
        LaneSymbol lane = (LaneSymbol)raw;
        IModelParticipant laneParticipant = lane.getParticipantReference();
        if (!isSameModel && laneParticipant != null) {
            if (!globalElements.containsKey(laneParticipant)) {
                globalElements.put(laneParticipant, copier.copy((EObject)laneParticipant));
            }
            if (laneParticipant instanceof ConditionalPerformerType) {
                DataType realmData;
                String dataId;
                DataType dataType = ((ConditionalPerformerType)laneParticipant).getData();
                if (dataType != null && !globalElements.containsKey(dataType)) {
                    globalElements.put(dataType, copier.copy((EObject)dataType));
                }
                if (!(StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue((IExtensibleElement)laneParticipant, (String)"carnot:engine:conditionalPerformer:realmData"))) || dataType != null && dataType.getId().equals(dataId) || (realmData = (DataType)ModelUtils.findElementById((List)storage.getOriginalModelCopy().getData(), (String)dataId)) == null || globalElements.containsKey(realmData))) {
                    globalElements.put(realmData, copier.copy((EObject)realmData));
                }
            }
        }
        FeatureMap.ValueListIterator iter = lane.getNodes().valueListIterator();
        while (iter.hasNext()) {
            EObject symbol = (EObject)iter.next();
            if (!(symbol instanceof IModelElementNodeSymbol)) continue;
            MergerUtil.getObjectsFromSymbol((IModelElementNodeSymbol)symbol, elements, globalElements, processes, activities, copier, isSameModel, false);
        }
        EList genericLinks = lane.getGenericLinkConnection();
        int i = 0;
        while (i < genericLinks.size()) {
            GenericLinkConnectionType link = (GenericLinkConnectionType)genericLinks.get(i);
            LinkTypeType modelElement = link.getLinkType();
            if (!globalElements.containsKey(modelElement)) {
                globalElements.put(modelElement, copier.copy((EObject)modelElement));
            }
            ++i;
        }
    }

    static void getObjectsFromDiagram(EObject raw, Map elements, Map globalElements, Map processes, Map activities, EcoreUtil.Copier copier, boolean isSameModel) {
        EList pools = ((DiagramType)raw).getPoolSymbols();
        int p = 0;
        while (p < pools.size()) {
            PoolSymbol pool = (PoolSymbol)pools.get(p);
            FeatureMap.ValueListIterator iter = pool.getNodes().valueListIterator();
            while (iter.hasNext()) {
                EObject element = (EObject)iter.next();
                if (!(element instanceof IModelElementNodeSymbol)) continue;
                MergerUtil.getObjectsFromSymbol((IModelElementNodeSymbol)element, elements, globalElements, processes, activities, copier, isSameModel, false);
            }
            EList genericLinks = pool.getGenericLinkConnection();
            int i = 0;
            while (i < genericLinks.size()) {
                GenericLinkConnectionType link = (GenericLinkConnectionType)genericLinks.get(i);
                LinkTypeType modelElement = link.getLinkType();
                if (!globalElements.containsKey(modelElement)) {
                    globalElements.put(modelElement, copier.copy((EObject)modelElement));
                }
                ++i;
            }
            EList lanes = pool.getLanes();
            int l = 0;
            while (l < lanes.size()) {
                LaneSymbol lane = (LaneSymbol)lanes.get(l);
                MergerUtil.getObjectsFromLane((EObject)lane, elements, globalElements, processes, activities, copier, isSameModel);
                ++l;
            }
            ++p;
        }
        FeatureMap.ValueListIterator iter = ((DiagramType)raw).getNodes().valueListIterator();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof IModelElementNodeSymbol)) continue;
            MergerUtil.getObjectsFromSymbol((IModelElementNodeSymbol)element, elements, globalElements, processes, activities, copier, isSameModel, false);
        }
        EList genericLinks = ((DiagramType)raw).getGenericLinkConnection();
        int i = 0;
        while (i < genericLinks.size()) {
            GenericLinkConnectionType link = (GenericLinkConnectionType)genericLinks.get(i);
            LinkTypeType modelElement = link.getLinkType();
            if (!globalElements.containsKey(modelElement)) {
                globalElements.put(modelElement, copier.copy((EObject)modelElement));
            }
            ++i;
        }
    }

    static void mergeProcesses(Map processes, Map processesToMerge) {
        for (Map.Entry entry : processesToMerge.entrySet()) {
            ProcessDefinitionType process = (ProcessDefinitionType)entry.getKey();
            EObject copy = (EObject)entry.getValue();
            if (processes.containsKey(process)) continue;
            processes.put(process, copy);
        }
    }

    static Map collectSubProcesses(ProcessDefinitionType scanProcess, EcoreUtil.Copier copier, Map currentProcesses) {
        HashMap allSubProcesses = new HashMap();
        HashMap<EObject, EObject> processes = new HashMap<EObject, EObject>();
        EList activities = scanProcess.getActivity();
        int i = 0;
        while (i < activities.size()) {
            ActivityType activity = (ActivityType)activities.get(i);
            ProcessDefinitionType subProcess = activity.getImplementationProcess();
            if (subProcess != null && !processes.containsKey(subProcess) && !currentProcesses.containsKey(subProcess)) {
                Map subProcesses = null;
                MergerEntry subProcessEntry = new MergerEntry((EObject)subProcess, copier.copy((EObject)subProcess));
                processes.put(subProcessEntry.getKey(), subProcessEntry.getValue());
                currentProcesses.containsKey(subProcess);
                subProcesses = MergerUtil.collectSubProcesses(subProcess, copier, currentProcesses);
                if (subProcesses != null) {
                    MergerUtil.mergeProcesses(allSubProcesses, subProcesses);
                }
            }
            ++i;
        }
        MergerUtil.mergeProcesses(processes, allSubProcesses);
        if (processes.isEmpty()) {
            return null;
        }
        return processes;
    }

    static Map.Entry getEntryFromMap(Map map, EObject element) {
        for (Map.Entry entry : map.entrySet()) {
            EObject raw = (EObject)entry.getKey();
            if (!raw.equals(element)) continue;
            return entry;
        }
        return null;
    }

    static EObject getElementFromList(List entries, EObject element) {
        int i = 0;
        while (i < entries.size()) {
            Object object = entries.get(i);
            Map.Entry entry = object instanceof ContentDecorator ? (Map.Entry)((ContentDecorator)object).getContent() : (Map.Entry)object;
            EObject raw = (EObject)entry.getKey();
            EObject copy = (EObject)entry.getValue();
            if (raw.equals(element)) {
                return copy;
            }
            ++i;
        }
        return null;
    }

    public static boolean containsType(List currentTypes, String idToCheck) {
        int t = 0;
        while (t < currentTypes.size()) {
            TypeDeclarationType td = (TypeDeclarationType)currentTypes.get(t);
            String currentId = td.getId();
            if (currentId.equals(idToCheck)) {
                return true;
            }
            ++t;
        }
        return false;
    }

    public static void checkAllTypeDeclarationReferences(ModelType sourceModel, String typeId, Set xsdFiles, Set tempStructuredData) {
        ExternalReferenceType externalReference;
        TypeDeclarationsType sourceDeclarations = sourceModel.getTypeDeclarations();
        TypeDeclarationType td = sourceDeclarations.getTypeDeclaration(typeId);
        if (td != null && (externalReference = td.getExternalReference()) != null) {
            String location = externalReference.getLocation();
            if (location.startsWith("urn:internal:")) {
                String nextTypeId = location.substring("urn:internal:".length());
                tempStructuredData.add(nextTypeId);
                MergerUtil.checkAllTypeDeclarationReferences(sourceModel, nextTypeId, xsdFiles, tempStructuredData);
            } else if (!location.startsWith("http://")) {
                xsdFiles.add(location);
            }
        }
    }

    public static void checkAllXSDImportReferences(ModelType sourceModel, String typeId, Set xsdFiles, Set tempStructuredData) {
        List xsdImports;
        TypeDeclarationsType sourceDeclarations = sourceModel.getTypeDeclarations();
        TypeDeclarationType td = sourceDeclarations.getTypeDeclaration(typeId);
        XSDSchema schema = td.getSchema();
        if (schema != null && (xsdImports = TypeDeclarationUtils.getImports((XSDSchema)schema)) != null) {
            for (XSDImport xsdImport : xsdImports) {
                String schemaLocation = xsdImport.getSchemaLocation();
                if (schemaLocation == null) continue;
                if (schemaLocation.startsWith("urn:internal:")) {
                    String nextTypeId = schemaLocation.substring("urn:internal:".length());
                    tempStructuredData.add(nextTypeId);
                    MergerUtil.checkAllXSDImportReferences(sourceModel, nextTypeId, xsdFiles, tempStructuredData);
                    continue;
                }
                if (schemaLocation.startsWith("http://")) continue;
                xsdFiles.add(schemaLocation);
            }
        }
    }

    public static void updateTypeDefinition(TypeDeclarationType declaration, ModelType targetModel, Map structuredDataChangedCache) {
        XSDSchema clone = declaration.getSchema();
        Map prefixes = clone.getQNamePrefixToNamespaceMap();
        ArrayList<String> addPrefixes = new ArrayList<String>();
        HashSet set = new HashSet(prefixes.entrySet());
        for (Map.Entry entry : set) {
            XSDTypeDefinition definition;
            if (entry.getKey().equals("xsd")) continue;
            HashSet elements = new HashSet();
            String value = (String)entry.getValue();
            int idx = value.lastIndexOf("/") + 1;
            String elementName = value.substring(idx, value.length());
            idx = value.lastIndexOf("/" + elementName);
            String value2 = value.substring(0, idx);
            idx = value2.lastIndexOf("/") + 1;
            String modelId = value2.substring(idx, value2.length());
            if (!targetModel.getId().equals(modelId)) {
                String prefix;
                TypeDeclarationUtils.removeNameSpace((XSDSchema)clone, (String)elementName, (String)modelId);
                String newElementName = MergerUtil.getValueByKey(structuredDataChangedCache, elementName);
                if (newElementName == null) {
                    newElementName = elementName;
                }
                if (!addPrefixes.contains(prefix = TypeDeclarationUtils.computePrefix((String)newElementName, clone.getQNamePrefixToNamespaceMap().keySet()))) {
                    String nameSpace = TypeDeclarationUtils.computeTargetNamespace((ModelType)targetModel, (String)newElementName);
                    addPrefixes.add(prefix);
                    clone.getQNamePrefixToNamespaceMap().put(prefix, nameSpace);
                }
            }
            if (elementName.equals(declaration.getId())) continue;
            String oldElementName = MergerUtil.getKeyByValue(structuredDataChangedCache, elementName);
            if (oldElementName == null) {
                oldElementName = elementName;
            }
            TypeDeclarationUtils.findElementsForType((TypeDeclarationType)declaration, elements, (String)oldElementName);
            for (XSDElementDeclaration elementDeclaration : elements) {
                elementDeclaration.setTypeDefinition(null);
            }
            String newElementName = MergerUtil.getValueByKey(structuredDataChangedCache, elementName);
            if (newElementName == null) {
                newElementName = elementName;
            }
            if ((definition = TypeDeclarationUtils.getTypeDefinition((TypeDeclarationsType)((TypeDeclarationsType)declaration.eContainer()), (String)newElementName)) == null) continue;
            for (XSDElementDeclaration elementDeclaration : elements) {
                elementDeclaration.setTypeDefinition(definition);
            }
        }
        clone.updateElement(true);
    }

    public static String getKeyByValue(Map structuredDataChangedCache, String value) {
        for (Map.Entry entry : structuredDataChangedCache.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public static String getValueByKey(Map structuredDataChangedCache, String key) {
        for (Map.Entry entry : structuredDataChangedCache.entrySet()) {
            if (!entry.getKey().equals(key)) continue;
            return (String)entry.getValue();
        }
        return null;
    }

    public static void checkAuthorizations(EObject modelElement, Map globalElements, EcoreUtil.Copier copier) {
        List participants;
        if ((modelElement instanceof ProcessDefinitionType || modelElement instanceof DataType || modelElement instanceof ActivityType) && (participants = MergerUtil.getAuthorizationParticipants((IExtensibleElement)modelElement)) != null) {
            int i = 0;
            while (i < participants.size()) {
                IModelParticipant participant = (IModelParticipant)participants.get(i);
                if (!globalElements.containsKey(participant)) {
                    globalElements.put(participant, copier.copy((EObject)participant));
                }
                ++i;
            }
        }
    }

    private static List getAuthorizationParticipants(IExtensibleElement element) {
        ArrayList<EObject> participants = new ArrayList<EObject>();
        EList attributes = element.getAttribute();
        int i = 0;
        while (i < attributes.size()) {
            EObject model;
            AttributeType attribute = (AttributeType)attributes.get(i);
            if (attribute.getName().startsWith("authorization:") && (model = AttributeUtil.getReferenceElement((AttributeType)attribute)) != null) {
                participants.add(model);
            }
            ++i;
        }
        if (!participants.isEmpty()) {
            return participants;
        }
        return null;
    }

    public static Code containsQC(ModelType targetModel, Code raw) {
        String keyValue = raw.getCode();
        if (targetModel.getQualityControl() == null) {
            return null;
        }
        EList codes = targetModel.getQualityControl().getCode();
        for (Code code : codes) {
            if (!code.getCode().equals(keyValue)) continue;
            return code;
        }
        return null;
    }

    static class MergerEntry
    implements Map.Entry<EObject, EObject> {
        private final EObject key;
        private EObject value;

        MergerEntry(EObject key, EObject value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public EObject getKey() {
            return this.key;
        }

        @Override
        public EObject getValue() {
            return this.value;
        }

        @Override
        public EObject setValue(EObject value) {
            EObject oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }
}

