/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.cap;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.cap.AbstractMerger;
import org.eclipse.stardust.modeling.core.editors.cap.MergerUtil;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;

public class OutlineMerger
extends AbstractMerger {
    public OutlineMerger(ModelType targetModel, List input, StoreObject storage) {
        super(targetModel, storage);
        MergerUtil.setStorage(storage);
        int i = 0;
        while (i < input.size()) {
            EObject child = (EObject)input.get(i);
            if (child instanceof DiagramType && child.eContainer() instanceof ModelType) {
                if (!this.isSameModel) {
                    MergerUtil.getObjectsFromDiagram(child, this.elements, this.globalElements, this.processes, this.activities, this.copier, this.isSameModel);
                }
                this.diagrams.put((DiagramType)child, (DiagramType)this.copier.copy(child));
            } else if (child instanceof ProcessDefinitionType) {
                this.processes.put((ProcessDefinitionType)child, (ProcessDefinitionType)this.copier.copy(child));
            } else if (child instanceof ActivityType || child instanceof TriggerType) {
                this.processChildren.put(child, this.copier.copy(child));
                if (!this.isSameModel) {
                    MergerUtil.checkAuthorizations(child, this.globalElements, this.copier);
                }
            } else {
                if (!this.elements.containsKey(child)) {
                    this.elements.put(child, this.copier.copy(child));
                }
                if (!this.isSameModel) {
                    MergerUtil.checkAuthorizations(child, this.globalElements, this.copier);
                    if (child instanceof ConditionalPerformerType) {
                        DataType realmData;
                        String dataId;
                        DataType dataType = ((ConditionalPerformerType)child).getData();
                        if (dataType != null && !this.globalElements.containsKey(dataType)) {
                            this.globalElements.put(dataType, this.copier.copy((EObject)dataType));
                            MergerUtil.checkAuthorizations((EObject)dataType, this.globalElements, this.copier);
                        }
                        if (!(StringUtils.isEmpty((String)(dataId = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)child), (String)"carnot:engine:conditionalPerformer:realmData"))) || dataType != null && dataType.getId().equals(dataId) || (realmData = (DataType)ModelUtils.findElementById((List)storage.getOriginalModelCopy().getData(), (String)dataId)) == null || this.globalElements.containsKey(realmData))) {
                            this.globalElements.put(realmData, this.copier.copy((EObject)realmData));
                            MergerUtil.checkAuthorizations((EObject)realmData, this.globalElements, this.copier);
                        }
                    }
                }
            }
            ++i;
        }
        this.collectProcessContent();
        if (!this.isSameModel) {
            this.checkForDialog(targetModel);
        }
        this.collectElements();
        this.copier.copyReferences();
    }

    @Override
    public void merge() {
        if (!this.mergeGlobal()) {
            return;
        }
        for (Map.Entry<EObject, EObject> entry : this.processElements.entrySet()) {
            if (this.mergeElement(entry)) continue;
            this.modelChanged = false;
            return;
        }
        for (Map.Entry entry : this.processElements.entrySet()) {
            this.addModelElement(entry, false);
        }
        if (!this.processes.isEmpty() && !this.isSameModel) {
            this.fixTransitions();
        }
    }

    private void fixTransitions() {
        for (Map.Entry entry : this.processes.entrySet()) {
            ProcessDefinitionType copy = (ProcessDefinitionType)entry.getValue();
            EList transitions = copy.getTransition();
            for (TransitionType transition : transitions) {
                ActivityType fromActivity = transition.getFrom();
                if (fromActivity == null) continue;
                ActivityType targetFromActivity = (ActivityType)ModelUtils.findElementById((List)copy.getActivity(), (String)fromActivity.getId());
                EList outTransitions = targetFromActivity.getOutTransitions();
                if (!outTransitions.contains((Object)transition)) {
                    outTransitions.add((Object)transition);
                }
                ActivityType toActivity = transition.getTo();
                ActivityType targetToActivity = (ActivityType)ModelUtils.findElementById((List)copy.getActivity(), (String)toActivity.getId());
                EList inTransitions = targetToActivity.getInTransitions();
                if (inTransitions.contains((Object)transition)) continue;
                inTransitions.add((Object)transition);
            }
        }
    }
}

