/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractLabeledIconFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IconFigure;
import org.eclipse.stardust.modeling.core.editors.figures.MyBorderLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class ActivitySymbolFigure
extends AbstractLabeledIconFigure {
    private static final Color BG_GRADIENT_FROM = ColorConstants.white;
    private static final Color BG_GRADIENT_TO = new Color(null, 226, 221, 219);
    private static final Color FG_BORDER = new Color(null, 180, 177, 177);
    private static final String SIZING_TEXT = "MMMMMMMMMMMMMMM";
    private Figure shapeContainer;
    private Figure overlayContainer;
    private Figure blankOverlay;
    private Figure subProcOverlay;
    private Figure loopOverlay;
    private Figure eventOverlay;
    private boolean hasEventIcon = false;
    private Dimension cachedMinSize;

    public ActivitySymbolFigure() {
        super("icons/full/obj16/activity.gif");
        this.setFill(true);
        this.getLabel().setOpaque(false);
        this.add((IFigure)this.shapeContainer, MyBorderLayout.TOP);
        this.overlayContainer = new Figure();
        FlowLayout overlayLayout = new FlowLayout(true);
        overlayLayout.setMajorAlignment(0);
        overlayLayout.setMajorSpacing(0);
        overlayLayout.setMinorSpacing(0);
        this.overlayContainer.setLayoutManager((LayoutManager)overlayLayout);
        this.overlayContainer.setBorder((Border)new MarginBorder(2, 6, -1, 6));
        this.add((IFigure)this.overlayContainer, MyBorderLayout.BOTTOM);
        this.blankOverlay = new IconFigure("icons/full/ovr13/blank.gif");
        this.subProcOverlay = new IconFigure("icons/full/ovr13/plusSignSmall.gif");
        this.loopOverlay = new IconFigure("icons/full/ovr13/loopSign.gif");
        this.setLoopActivity(false);
        this.setSubProcActivity(false);
        this.setEventHandlerType(false, null);
        this.getLabel().setForegroundColor(ColorConstants.black);
        this.getLabel().setTextPlacement(4);
    }

    public Dimension getMinimumSize(int width, int height) {
        if (this.cachedMinSize == null) {
            Dimension labelDim = this.getLabel().getMinimumSize();
            Dimension txtSize = FigureUtilities.getTextExtents((String)SIZING_TEXT, (Font)this.getLabel().getFont());
            Insets insets = this.getLabel().getInsets();
            labelDim.width = Math.max(labelDim.width, txtSize.width + insets.getWidth());
            this.cachedMinSize = super.getMinimumSize(width, height).getCopy();
            insets = this.getInsets();
            this.cachedMinSize.width = Math.max(this.cachedMinSize.width, labelDim.width + insets.getWidth());
        }
        return this.cachedMinSize;
    }

    public Dimension getPreferredSize(int width, int height) {
        Dimension prefSize = super.getPreferredSize(width, height).getCopy();
        Dimension minSize = this.getMinimumSize(width, height);
        prefSize.width = Math.max(minSize.width, prefSize.width);
        prefSize.height = Math.max(minSize.height, prefSize.height);
        prefSize.width = (prefSize.width & 1) == 0 ? prefSize.width + 1 : prefSize.width;
        prefSize.height = (prefSize.height & 1) == 0 ? prefSize.height + 1 : prefSize.height;
        return prefSize;
    }

    @Override
    protected Label createLabel() {
        return new Label();
    }

    public void setEventHandlerType(boolean eventHandler, ActivityType activity) {
        if (activity != null) {
            if (this.hasEventIcon) {
                this.overlayContainer.getChildren().remove(this.eventOverlay);
                this.hasEventIcon = false;
            }
            if (eventHandler) {
                this.eventOverlay = this.getEventOverlay(activity.getEventHandler());
                if (!this.overlayContainer.getChildren().contains(this.eventOverlay)) {
                    if (this.overlayContainer.getChildren().contains(this.blankOverlay)) {
                        this.overlayContainer.remove((IFigure)this.blankOverlay);
                    }
                    if (!this.hasEventIcon) {
                        this.overlayContainer.add((IFigure)this.eventOverlay);
                        this.hasEventIcon = true;
                    }
                    if (this.overlayContainer.getChildren().contains(this.subProcOverlay)) {
                        this.overlayContainer.add((IFigure)this.blankOverlay);
                    }
                    if (this.overlayContainer.getChildren().contains(this.loopOverlay)) {
                        this.overlayContainer.add((IFigure)this.blankOverlay);
                    }
                }
            } else {
                if (this.overlayContainer.getChildren().contains(this.eventOverlay)) {
                    this.overlayContainer.remove((IFigure)this.eventOverlay);
                    this.hasEventIcon = false;
                    if (this.overlayContainer.getChildren().contains(this.blankOverlay)) {
                        this.overlayContainer.remove((IFigure)this.blankOverlay);
                    }
                }
                if (this.overlayContainer.getChildren().isEmpty()) {
                    this.overlayContainer.add((IFigure)this.blankOverlay);
                }
            }
        }
    }

    private Figure getEventOverlay(EList eventHandlerList) {
        if (1 == eventHandlerList.size() && ((EventHandlerType)eventHandlerList.get(0)).getType() != null) {
            EventHandlerType eventHandler = (EventHandlerType)eventHandlerList.get(0);
            return new IconFigure(SpiExtensionRegistry.instance().getTypeIcon(eventHandler.getType().getExtensionPointId(), eventHandler.getType().getId()));
        }
        return new IconFigure("icons/full/obj16/condition.gif");
    }

    public void setLoopActivity(boolean loopActivity) {
        if (loopActivity) {
            if (!this.overlayContainer.getChildren().contains(this.loopOverlay)) {
                if (this.overlayContainer.getChildren().contains(this.blankOverlay)) {
                    this.overlayContainer.remove((IFigure)this.blankOverlay);
                }
                this.overlayContainer.add((IFigure)this.loopOverlay, 0);
                if (this.overlayContainer.getChildren().contains(this.subProcOverlay)) {
                    this.overlayContainer.add((IFigure)this.blankOverlay);
                }
                if (this.overlayContainer.getChildren().contains(this.eventOverlay)) {
                    this.overlayContainer.add((IFigure)this.blankOverlay);
                }
            }
        } else {
            if (this.overlayContainer.getChildren().contains(this.loopOverlay)) {
                this.overlayContainer.remove((IFigure)this.loopOverlay);
                if (this.overlayContainer.getChildren().contains(this.blankOverlay)) {
                    this.overlayContainer.remove((IFigure)this.blankOverlay);
                }
            }
            if (this.overlayContainer.getChildren().isEmpty()) {
                this.overlayContainer.add((IFigure)this.blankOverlay);
            }
        }
    }

    public void setSubProcActivity(boolean subProcActivity) {
        if (subProcActivity) {
            if (!this.overlayContainer.getChildren().contains(this.subProcOverlay)) {
                if (this.overlayContainer.getChildren().contains(this.blankOverlay)) {
                    this.overlayContainer.remove((IFigure)this.blankOverlay);
                }
                this.overlayContainer.add((IFigure)this.subProcOverlay);
                if (this.overlayContainer.getChildren().contains(this.loopOverlay)) {
                    this.overlayContainer.add((IFigure)this.blankOverlay);
                }
                if (this.overlayContainer.getChildren().contains(this.eventOverlay)) {
                    this.overlayContainer.add((IFigure)this.blankOverlay);
                }
            }
        } else {
            if (this.overlayContainer.getChildren().contains(this.subProcOverlay)) {
                this.overlayContainer.remove((IFigure)this.subProcOverlay);
                if (this.overlayContainer.getChildren().contains(this.blankOverlay)) {
                    this.overlayContainer.remove((IFigure)this.blankOverlay);
                }
            }
            if (this.overlayContainer.getChildren().isEmpty()) {
                this.overlayContainer.add((IFigure)this.blankOverlay);
            }
        }
    }

    @Override
    public void setShape(Figure figure) {
        this.overlayContainer.remove((IFigure)this.loopOverlay);
        super.setShape(figure);
        this.overlayContainer.add((IFigure)this.loopOverlay, (Object)MyBorderLayout.CENTER);
    }

    @Override
    protected void doAddShape(Figure shape) {
        if (this.shapeContainer == null) {
            this.shapeContainer = new Figure();
            this.shapeContainer.setLayoutManager((LayoutManager)new MyBorderLayout());
            this.shapeContainer.setBorder((Border)new MarginBorder(1, 6, 0, 6));
        }
        this.shapeContainer.add((IFigure)shape, (Object)MyBorderLayout.LEFT);
    }

    @Override
    protected void doRemoveShape(Figure shape) {
        if (this.shapeContainer != null) {
            this.shapeContainer.remove((IFigure)shape);
        }
    }

    @Override
    protected void doAddLabel(Label label) {
        this.add((IFigure)label, MyBorderLayout.CENTER);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.setToolTip((IFigure)new Label(name));
    }

    public void setBounds(Rectangle rect) {
        int width = (rect.width & 1) == 0 ? rect.width + 1 : rect.width;
        int height = (rect.height & 1) == 0 ? rect.height + 1 : rect.height;
        super.setBounds(new Rectangle(rect.x, rect.y, width, height));
    }

    protected void outlineShape(Graphics graphics) {
        graphics.pushState();
        try {
            int lineWidth = 2;
            if (this.getForegroundColor().equals((Object)this.getDefaultBorderColor())) {
                graphics.setForegroundColor(FG_BORDER);
            }
            graphics.setLineWidth(lineWidth);
            Rectangle f = Rectangle.SINGLETON;
            Rectangle r = this.getBounds();
            f.x = r.x + lineWidth / 2;
            f.y = r.y + lineWidth / 2;
            f.width = r.width - lineWidth;
            f.height = r.height - lineWidth;
            graphics.drawRoundRectangle(f, this.corner.width, this.corner.height);
        }
        finally {
            graphics.popState();
        }
    }

    protected void fillShape(Graphics graphics) {
        graphics.pushState();
        try {
            Rectangle rect = this.getBounds().getCopy();
            rect.width = this.corner.width;
            rect.width += this.corner.width;
            graphics.setBackgroundColor(BG_GRADIENT_FROM);
            graphics.fillRoundRectangle(rect, this.corner.width, this.corner.height);
            rect.x = this.getBounds().right() - this.corner.width;
            rect.width = this.corner.width;
            rect.x -= this.corner.width;
            rect.width += this.corner.width;
            graphics.setBackgroundColor(BG_GRADIENT_TO);
            graphics.fillRoundRectangle(rect, this.corner.width, this.corner.height);
            graphics.setForegroundColor(BG_GRADIENT_FROM);
            rect.x = this.getBounds().x + this.corner.width;
            rect.width = this.getBounds().width - 2 * this.corner.width;
            graphics.fillGradient(rect, false);
        }
        finally {
            graphics.popState();
        }
    }
}

