/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.Collections;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ElUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.DataSymbolFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;

public class DataSymbolNodeEditEditPart
extends AbstractModelElementNodeSymbolEditPart {
    @Override
    public Command getCommand(Request request) {
        Command command = super.getCommand(request);
        if (command instanceof CompoundCommand && request instanceof DirectEditRequest) {
            return this.transitionConditionChangeCommand(request, command);
        }
        return command;
    }

    private Command transitionConditionChangeCommand(Request request, Command command) {
        try {
            DirectEditRequest editRequest = (DirectEditRequest)request;
            String newValue = editRequest.getCellEditor().getValue().toString();
            String computedId = ModelUtils.computeId((String)newValue);
            DataSymbolType dataSymbol = (DataSymbolType)this.getModel();
            DataType dataType = (DataType)dataSymbol.getModelElement();
            ModelType model = (ModelType)this.getEditor().getModel();
            String oldValue = dataType.getId();
            ChangeRecorder targetRecorder = new ChangeRecorder();
            targetRecorder.beginRecording(Collections.singleton(model.eContainer()));
            ElUtils.updateTransitionConditions((DataType)dataType, (String)oldValue, (String)computedId);
            final ChangeDescription change = targetRecorder.endRecording();
            targetRecorder.dispose();
            Command cmd = new Command(){

                public void execute() {
                }

                public void undo() {
                    change.applyAndReverse();
                }

                public void redo() {
                    change.applyAndReverse();
                }
            };
            ((CompoundCommand)command).add(cmd);
            return command;
        }
        catch (Throwable throwable) {
            return super.getCommand(request);
        }
    }

    public DataSymbolNodeEditEditPart(WorkflowModelEditor editor, IModelElementNodeSymbol model, EStructuralFeature[] features, EStructuralFeature[] features2) {
        super(editor, model, DataSymbolFigure.class, features, features2);
    }

    @Override
    protected IFigure createFigure() {
        DataSymbolType symbolModel = (DataSymbolType)this.getModel();
        DataSymbolFigure f = new DataSymbolFigure(this.getIconFactory().getIconFor((EObject)symbolModel));
        f.setLocation(new Point((double)symbolModel.getXPos(), (double)symbolModel.getYPos()));
        f.setName(symbolModel.getModelElement() != null ? symbolModel.getModelElement().getId() : null);
        return f;
    }
}

