/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.utils.ConvertGatewayUtil;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertGatewayAction
extends SelectionAction {
    public ConvertGatewayAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.convertGatewaysAction");
        this.setText(Diagram_Messages.LB_Convert_Gateways);
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && (this.getProcess() != null || this.getModel() != null);
    }

    public void run() {
        ModelType model;
        ProcessDefinitionType element = null;
        ProcessDefinitionType process = this.getProcess();
        if (process != null) {
            element = process;
            Boolean lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)process);
            if (lockedByCurrentUser != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
                ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
                return;
            }
            if (ConvertGatewayUtil.findStartActivity(process) == null) {
                ModelServerUtils.showMessageBox(Diagram_Messages.MSG_INVALID_ACTIVITY_NETWORK);
                return;
            }
        }
        if ((model = this.getModel()) != null) {
            element = model;
            for (ProcessDefinitionType process_ : model.getProcessDefinition()) {
                Boolean lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)process_);
                if (lockedByCurrentUser != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
                    ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
                    return;
                }
                if (process_.getActivity().isEmpty() || ConvertGatewayUtil.findStartActivity(process_) != null) continue;
                ModelServerUtils.showMessageBox(Diagram_Messages.MSG_INVALID_ACTIVITY_NETWORK);
                return;
            }
        }
        ChangeRecorder targetRecorder = new ChangeRecorder();
        targetRecorder.beginRecording(Collections.singleton(ModelUtils.findContainingModel((EObject)element)));
        ConvertGatewayUtil util = new ConvertGatewayUtil((EObject)element);
        util.convert();
        if (util.isModified()) {
            final ChangeDescription change = targetRecorder.endRecording();
            targetRecorder.dispose();
            Command cmd = new Command(){

                public void execute() {
                }

                public void undo() {
                    change.applyAndReverse();
                }

                public void redo() {
                    change.applyAndReverse();
                }
            };
            this.getCommandStack().execute(cmd);
        }
    }

    private ProcessDefinitionType getProcess() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ProcessDefinitionType && !((ProcessDefinitionType)model).getActivity().isEmpty()) {
            return (ProcessDefinitionType)model;
        }
        return null;
    }

    private ModelType getModel() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        ModelType model_ = null;
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ModelType) {
            model_ = (ModelType)model;
        }
        if (model_ != null) {
            if (model_.getProcessDefinition().isEmpty()) {
                return null;
            }
            for (ProcessDefinitionType process : model_.getProcessDefinition()) {
                if (process.getActivity().isEmpty()) continue;
                return model_;
            }
        }
        return null;
    }
}

