/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipantSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.dnd.IGatewayLocator;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementSymbolCreationFactory;
import org.eclipse.stardust.modeling.core.editors.dnd.SymbolCreationFactory;
import org.eclipse.stardust.modeling.core.editors.figures.ActivitySymbolFigure;
import org.eclipse.stardust.modeling.core.editors.figures.GatewayFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ReloadConnectionsRequest;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.tools.SnapCenterToGrid;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;

public class CreateActivityGraphAction
extends SelectionAction {
    private EditPart targetEditPart = null;
    public static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private final WorkflowModelEditor editor;
    protected ActivityType startActivity;
    protected DiagramType diagram;
    private Map activityBlocks = new HashMap();
    private Map figureLocations = new HashMap();
    private List rows = new ArrayList();
    private Map layoutSpecs = new HashMap();
    private Set visitedActivities = new HashSet();
    private boolean isVertical;

    public CreateActivityGraphAction(WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.setId("org.eclipse.stardust.modeling.core.createActivityGraph");
        this.setText(Diagram_Messages.LB_ACTION_CreateActivityGraph);
        this.setDescription(Diagram_Messages.MSG_ACTION_CreateActivityGraph);
        this.editor = part;
    }

    protected boolean calculateEnabled() {
        boolean isProcessDiagram;
        this.targetEditPart = null;
        boolean isDiagram = !this.getSelectedObjects().isEmpty() && this.getSelectedObjects().get(0) instanceof DiagramRootEditPart;
        boolean bl = isProcessDiagram = isDiagram ? ((DiagramType)((DiagramRootEditPart)((Object)this.getSelectedObjects().get(0))).getContents().getModel()).eContainer() instanceof ProcessDefinitionType : false;
        if (isDiagram && isProcessDiagram) {
            DiagramEditPart diagramEditPart = (DiagramEditPart)((DiagramRootEditPart)((Object)this.getSelectedObjects().get(0))).getContents();
            DiagramType diagram = (DiagramType)diagramEditPart.getModel();
            ProcessDefinitionType process = (ProcessDefinitionType)diagram.eContainer();
            Boolean lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)process);
            if (lockedByCurrentUser != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
                return false;
            }
            DiagramModeType diagramMode = diagram.getMode();
            if (diagramMode.equals((Object)DiagramModeType.MODE_450_LITERAL)) {
                this.targetEditPart = PoolLaneUtils.findTargetEditPart((WorkflowModelEditor)this.getWorkbenchPart());
                if (!(this.targetEditPart instanceof AbstractSwimlaneEditPart)) {
                    return false;
                }
                if (this.targetEditPart instanceof LaneEditPart && ((LaneEditPart)this.targetEditPart).getLaneFigure().isCollapsed()) {
                    return false;
                }
                if (PoolLaneUtils.containsLanes(this.targetEditPart)) {
                    return false;
                }
                return !process.getActivity().isEmpty();
            }
            return !process.getActivity().isEmpty();
        }
        return isDiagram && isProcessDiagram;
    }

    public void run() {
        CompoundCommand cmd = new CompoundCommand();
        DiagramEditPart diagramEditPart = (DiagramEditPart)((DiagramRootEditPart)((Object)this.getSelectedObjects().get(0))).getContents();
        this.reset((DiagramType)diagramEditPart.getModel());
        Dialog dialog = this.createDialog();
        if (dialog.open() == 0 && this.startActivity != null) {
            this.populateRows(0, this.startActivity);
            this.layoutSpecs.put(this.startActivity, new LayoutSpec(null, 0, 0));
            this.populateColumns(0, this.startActivity);
            if (!this.isVertical) {
                this.reverseGrid();
            }
            this.createSymbols(cmd, diagramEditPart.getRoot().getViewer());
            if (this.targetEditPart != null) {
                final EditPart useEP = this.targetEditPart;
                cmd.add((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.resizeLane((AbstractSwimlaneEditPart)useEP);
                    }
                });
                cmd.add((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderSiblings(useEP, null);
                    }
                });
            }
            this.execute((Command)cmd);
            PoolLaneUtils.refreshLaneContent();
        }
    }

    private int getPxPerUnit() {
        return SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE;
    }

    private void reverseGrid() {
        ArrayList newRows = new ArrayList();
        HashMap<ActivityType, LayoutSpec> newLayouts = new HashMap<ActivityType, LayoutSpec>();
        int i = 0;
        while (i < this.rows.size()) {
            List elements = (List)this.rows.get(i);
            int j = 0;
            while (j < elements.size()) {
                ActivityType activity = (ActivityType)elements.get(j);
                int col = this.getColumnPlacement(activity);
                LayoutSpec spec = (LayoutSpec)this.layoutSpecs.get(activity);
                newLayouts.put(activity, new LayoutSpec(spec.predecessor, col, spec.predecessor == null ? 0 : 1));
                this.addElement(newRows, activity, col);
                ++j;
            }
            ++i;
        }
        this.rows = newRows;
        this.layoutSpecs = newLayouts;
    }

    private void addElement(List rows, ActivityType activity, int rowId) {
        while (rows.size() <= rowId) {
            rows.add(new ArrayList());
        }
        List row = (List)rows.get(rowId);
        row.add(activity);
    }

    private void reset(DiagramType diagram) {
        this.diagram = diagram;
        this.startActivity = null;
        this.rows.clear();
        this.layoutSpecs.clear();
        this.activityBlocks.clear();
        this.visitedActivities.clear();
        this.isVertical = DiagramPlugin.isVerticalModelling(diagram);
    }

    private void createSymbols(CompoundCommand cmd, final EditPartViewer viewer) {
        ActivityType activity;
        int j;
        CompoundCommand cmdFixDiagramLayout = new CompoundCommand();
        int rowCount = this.rows.size();
        int columnCount = 0;
        int i = 0;
        while (i < rowCount) {
            ArrayList row = (ArrayList)this.rows.get(i);
            int j2 = 0;
            while (j2 < row.size()) {
                int column = this.getColumnPlacement((ActivityType)row.get(j2));
                columnCount = Math.max(columnCount, column + 1);
                ++j2;
            }
            ++i;
        }
        int[] widths = new int[columnCount];
        int[] heights = new int[rowCount];
        int i2 = 0;
        while (i2 < rowCount) {
            ArrayList row = (ArrayList)this.rows.get(i2);
            j = 0;
            while (j < row.size()) {
                activity = (ActivityType)row.get(j);
                int column = this.getColumnPlacement(activity);
                ActivityBlock block = (ActivityBlock)this.activityBlocks.get(activity);
                heights[i2] = Math.max(heights[i2], block.getHeight(this.isVertical) * this.getPxPerUnit());
                widths[column] = Math.max(widths[column], block.getWidth(this.isVertical) * this.getPxPerUnit());
                ++j;
            }
            ++i2;
        }
        i2 = 1;
        while (i2 < heights.length) {
            int n = i2;
            heights[n] = heights[n] + heights[i2 - 1];
            ++i2;
        }
        i2 = 1;
        while (i2 < widths.length) {
            int n = i2;
            widths[n] = widths[n] + widths[i2 - 1];
            ++i2;
        }
        i2 = 0;
        while (i2 < this.rows.size()) {
            ArrayList row = (ArrayList)this.rows.get(i2);
            j = 0;
            while (j < row.size()) {
                Map centers;
                activity = (ActivityType)row.get(j);
                final ActivityBlock block = (ActivityBlock)this.activityBlocks.get(activity);
                int column = this.getColumnPlacement(activity);
                this.figureLocations.put(activity, new HashMap());
                int xleft = column == 0 ? 0 : widths[column - 1];
                int ytop = i2 == 0 ? 0 : heights[i2 - 1];
                int xright = widths[column];
                int ybottom = heights[i2];
                int activityXCenter = (xleft + xright) / 2;
                int activityYCenter = (ytop + ybottom) / 2;
                Point centerActivity = new Point(activityXCenter, activityYCenter);
                Point locData = new Point(this.isVertical ? xleft + this.getPxPerUnit() * 6 / 2 : activityXCenter - this.getPxPerUnit() * (block.data.size() - 1) * 6 / 2, this.isVertical ? activityYCenter - this.getPxPerUnit() * (block.data.size() - 1) * 4 / 2 : ytop + this.getPxPerUnit() * 4 / 2);
                locData = this.renderDataSymbol(cmd, activity, centerActivity, block, DirectionType.IN_LITERAL, locData);
                locData = this.renderDataSymbol(cmd, activity, centerActivity, block, DirectionType.INOUT_LITERAL, locData);
                locData = this.renderDataSymbol(cmd, activity, centerActivity, block, DirectionType.OUT_LITERAL, locData);
                Point locPerformer = new Point(this.isVertical ? xright - this.getPxPerUnit() * 6 / 2 : activityXCenter - this.getPxPerUnit() * block.nApplications * 6 / 2, this.isVertical ? activityYCenter - this.getPxPerUnit() * block.nApplications * 3 / 2 : ybottom - this.getPxPerUnit() * 3 / 2);
                Point locApplication = new Point(this.isVertical ? xright - this.getPxPerUnit() * 6 / 2 : activityXCenter + this.getPxPerUnit() * block.nParticipants * 6 / 2, this.isVertical ? activityYCenter + this.getPxPerUnit() * block.nParticipants * 3 / 2 : ybottom - this.getPxPerUnit() * 3 / 2);
                if (block.nParticipants > 0) {
                    this.createSymbol(cmd, (IIdentifiableModelElement)activity.getPerformer(), centerActivity, null);
                    centers = (Map)this.figureLocations.get(activity);
                    centers.put(activity.getPerformer(), new Pair((Object)centerActivity, (Object)locPerformer));
                }
                if (block.nApplications > 0) {
                    this.createSymbol(cmd, (IIdentifiableModelElement)activity.getApplication(), centerActivity, null);
                    centers = (Map)this.figureLocations.get(activity);
                    centers.put(activity.getApplication(), new Pair((Object)centerActivity, (Object)locApplication));
                }
                centers = (Map)this.figureLocations.get(activity);
                centers.put(activity, new Pair((Object)centerActivity, (Object)centerActivity));
                this.createSymbol(cmd, (IIdentifiableModelElement)activity, centerActivity, new IGatewayLocator(){

                    @Override
                    public Dimension getGatewayLocation(FlowControlType gatewayKind, Dimension activitySize, int gatewaySize) {
                        int width = (activitySize.width - gatewaySize) / 2;
                        int height = 0;
                        if (CreateActivityGraphAction.this.isVertical) {
                            if (FlowControlType.JOIN_LITERAL.equals((Object)gatewayKind)) {
                                height = -3 * CreateActivityGraphAction.this.getPxPerUnit();
                            } else if (FlowControlType.SPLIT_LITERAL.equals((Object)gatewayKind)) {
                                height = 3 * CreateActivityGraphAction.this.getPxPerUnit();
                            }
                        } else if (FlowControlType.JOIN_LITERAL.equals((Object)gatewayKind)) {
                            width -= 3 * CreateActivityGraphAction.this.getPxPerUnit();
                        } else if (FlowControlType.SPLIT_LITERAL.equals((Object)gatewayKind)) {
                            width += 3 * CreateActivityGraphAction.this.getPxPerUnit();
                        }
                        return new Dimension(width, height);
                    }
                });
                cmdFixDiagramLayout.add(new Command(){
                    private boolean firstRun = true;
                    private CompoundCommand cmdReloadConnections = new CompoundCommand();

                    public void execute() {
                        for (ActivitySymbolType symActivity : activity.getActivitySymbols()) {
                            if (symActivity.eContainer() != CreateActivityGraphAction.this.diagram) continue;
                            GraphicalEditPart epActivity = (GraphicalEditPart)viewer.getEditPartRegistry().get(symActivity);
                            if (this.firstRun) {
                                ReloadConnectionsRequest rqReloadConnections = new ReloadConnectionsRequest();
                                Command cmdReloadActivityConnections = epActivity.getCommand((Request)rqReloadConnections);
                                this.addReloadConnectionsCommand(symActivity, cmdReloadActivityConnections, block);
                            }
                            Map centers = (Map)CreateActivityGraphAction.this.figureLocations.get(activity);
                            Point locActivity = (Point)((Pair)centers.get(activity)).getSecond();
                            ActivitySymbolFigure figActivity = (ActivitySymbolFigure)epActivity.getFigure();
                            Dimension szActivity = CreateActivityGraphAction.this.getPreferredSize((Figure)figActivity);
                            symActivity.setXPos((long)(locActivity.x - szActivity.width / 2));
                            symActivity.setYPos((long)(locActivity.y - szActivity.height / 2));
                            for (GatewaySymbol symGateway : symActivity.getGatewaySymbols()) {
                                GatewayFigure figGateway = (GatewayFigure)((GraphicalEditPart)viewer.getEditPartRegistry().get(symGateway)).getFigure();
                                Dimension szGateway = figGateway.getPreferredSize();
                                double gatewayXPos = symActivity.getXPos() + (long)(szActivity.width / 2);
                                double gatewayYPos = symActivity.getYPos() + (long)(szActivity.height / 2);
                                if (FlowControlType.JOIN_LITERAL.equals((Object)symGateway.getFlowKind())) {
                                    if (CreateActivityGraphAction.this.isVertical) {
                                        gatewayYPos -= (double)(CreateActivityGraphAction.this.getPxPerUnit() * 3);
                                    } else {
                                        gatewayXPos -= (double)(CreateActivityGraphAction.this.getPxPerUnit() * 3 + szActivity.width / 2 - szActivity.height / 2);
                                    }
                                } else if (FlowControlType.SPLIT_LITERAL.equals((Object)symGateway.getFlowKind())) {
                                    if (CreateActivityGraphAction.this.isVertical) {
                                        gatewayYPos += (double)(CreateActivityGraphAction.this.getPxPerUnit() * 3);
                                    } else {
                                        gatewayXPos += (double)(CreateActivityGraphAction.this.getPxPerUnit() * 3 + szActivity.width / 2 - szActivity.height / 2);
                                    }
                                }
                                symGateway.setXPos((long)((int)(gatewayXPos -= (double)(szGateway.width / 2))));
                                symGateway.setYPos((long)((int)(gatewayYPos -= (double)(szGateway.height / 2))));
                            }
                            for (IIdentifiableElement node : centers.keySet()) {
                                GraphicalEditPart epNode;
                                Pair mrkLocation = (Pair)centers.get(node);
                                Point oldLocation = (Point)mrkLocation.getFirst();
                                Point newLocation = (Point)mrkLocation.getSecond();
                                DataSymbolType symNode = null;
                                if (node instanceof DataType) {
                                    for (DataSymbolType symData : ((DataType)node).getDataSymbols()) {
                                        if (symData.eContainer() != CreateActivityGraphAction.this.diagram || (long)oldLocation.x != symData.getXPos() || (long)oldLocation.y != symData.getYPos()) continue;
                                        symNode = symData;
                                        break;
                                    }
                                } else if (node instanceof IModelParticipant) {
                                    for (INodeSymbol symParticipant : ((IModelParticipant)node).getSymbols()) {
                                        if (symParticipant.eContainer() != CreateActivityGraphAction.this.diagram || (long)oldLocation.x != symParticipant.getXPos() || (long)oldLocation.y != symParticipant.getYPos()) continue;
                                        symNode = symParticipant;
                                        break;
                                    }
                                } else if (node instanceof ApplicationType) {
                                    for (ApplicationSymbolType symApp : ((ApplicationType)node).getApplicationSymbols()) {
                                        if (symApp.eContainer() != CreateActivityGraphAction.this.diagram || (long)oldLocation.x != symApp.getXPos() || (long)oldLocation.y != symApp.getYPos()) continue;
                                        symNode = symApp;
                                        break;
                                    }
                                }
                                if (symNode == null || (epNode = (GraphicalEditPart)viewer.getEditPartRegistry().get(symNode)) == null) continue;
                                IFigure figNode = epNode.getFigure();
                                Dimension szNode = figNode.getPreferredSize();
                                symNode.setXPos((long)(newLocation.x - szNode.width / 2));
                                symNode.setYPos((long)(newLocation.y - szNode.height / 2));
                            }
                        }
                        if (this.firstRun) {
                            this.cmdReloadConnections.execute();
                        } else {
                            this.cmdReloadConnections.redo();
                        }
                        this.firstRun = false;
                    }

                    public void undo() {
                        this.cmdReloadConnections.undo();
                        super.undo();
                    }

                    private void addReloadConnectionsCommand(ActivitySymbolType symActivity, Command cmd, ActivityBlock block2) {
                        if (cmd instanceof CompoundCommand) {
                            Iterator i = ((CompoundCommand)cmd).getCommands().iterator();
                            while (i.hasNext()) {
                                this.addReloadConnectionsCommand(symActivity, (Command)i.next(), block2);
                            }
                        } else if (cmd instanceof CreateConnectionSymbolCommand) {
                            CreateConnectionSymbolCommand cmdCreateSymbol = (CreateConnectionSymbolCommand)cmd;
                            Object symOther = cmdCreateSymbol.getSourceSymbol() == symActivity ? cmdCreateSymbol.getTargetSymbol() : (cmdCreateSymbol.getTargetSymbol() == symActivity ? cmdCreateSymbol.getSourceSymbol() : null);
                            if (symOther instanceof DataSymbolType && block2.data.containsKey(((DataSymbolType)symOther).getData())) {
                                this.cmdReloadConnections.add(cmd);
                            } else if (symOther instanceof IModelParticipantSymbol && activity.getPerformer() == ((IModelParticipantSymbol)symOther).getModelElement()) {
                                this.cmdReloadConnections.add(cmd);
                            } else if (symOther instanceof ApplicationSymbolType && activity.getApplication() == ((ApplicationSymbolType)symOther).getApplication()) {
                                this.cmdReloadConnections.add(cmd);
                            }
                        }
                    }
                });
                ++j;
            }
            ++i2;
        }
        cmd.add(cmdFixDiagramLayout.unwrap());
    }

    private Dimension getPreferredSize(Figure fig) {
        Dimension dim = fig.getPreferredSize();
        if (dim.width / 2 * 2 == dim.width) {
            ++dim.width;
        }
        if (dim.height / 2 * 2 == dim.height) {
            ++dim.height;
        }
        if (this.targetEditPart != null) {
            dim = SnapGridUtils.getSnapDimension(dim, (AbstractGraphicalEditPart)this.targetEditPart, 2, true);
        }
        return dim;
    }

    private int getColumnPlacement(ActivityType srcActivity) {
        LayoutSpec lSpec = (LayoutSpec)this.layoutSpecs.get(srcActivity);
        int col = lSpec.idxColumn;
        while (lSpec.predecessor != null) {
            lSpec = (LayoutSpec)this.layoutSpecs.get(lSpec.predecessor);
            col += lSpec.idxColumn;
        }
        return col;
    }

    private Point renderDataSymbol(CompoundCommand cmd, ActivityType activity, Point locActivity, ActivityBlock block, DirectionType direction, Point locData) {
        for (DataType data : block.data.keySet()) {
            DirectionType dataDirection = (DirectionType)block.data.get(data);
            if (!direction.equals((Object)dataDirection)) continue;
            this.createSymbol(cmd, (IIdentifiableModelElement)data, locActivity, null);
            Map centers = (Map)this.figureLocations.get(activity);
            centers.put(data, new Pair((Object)locActivity, (Object)locData));
            locData = locData.getTranslated(this.isVertical ? 0 : this.getPxPerUnit() * 6, this.isVertical ? this.getPxPerUnit() * 4 : 0);
        }
        return locData;
    }

    private void createSymbol(CompoundCommand cmd, IIdentifiableModelElement element, Point point, IGatewayLocator locator) {
        SymbolCreationFactory factory = ModelElementSymbolCreationFactory.getFactory(element, locator);
        factory.setLocation(point);
        factory.setEditor(this.editor);
        factory.setEditDomain(this.editor.getEditDomain());
        if (this.targetEditPart != null) {
            factory.setSymbolContainer((ISymbolContainer)this.targetEditPart.getModel());
        } else {
            factory.setSymbolContainer((ISymbolContainer)this.diagram);
        }
        factory.setTransferredModelElement(element);
        cmd.add((Command)factory.getNewObject());
    }

    private Dialog createDialog() {
        return new Dialog(this.getWorkbenchPart().getSite().getShell()){
            Button okButton;

            protected Control createButtonBar(Composite parent) {
                Control control = super.createButtonBar(parent);
                this.okButton = this.getButton(0);
                this.okButton.setEnabled(false);
                return control;
            }

            protected Control createDialogArea(Composite parent) {
                this.getShell().setText(CreateActivityGraphAction.this.getText());
                Composite composite = (Composite)super.createDialogArea(parent);
                GridData gd = (GridData)composite.getLayoutData();
                gd.minimumHeight = 250;
                gd.minimumWidth = 200;
                FormBuilder.createLabel((Composite)composite, (String)CreateActivityGraphAction.this.getDescription());
                ListViewer viewer = new ListViewer(FormBuilder.createList((Composite)composite));
                viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public Image getImage(Object element) {
                        return DiagramPlugin.getImage(CreateActivityGraphAction.this.editor.getIconFactory().getIconFor((EObject)((IIdentifiableModelElement)element)));
                    }

                    public String getText(Object element) {
                        return ((IIdentifiableModelElement)element).getName();
                    }
                });
                viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (event.getSelection() instanceof IStructuredSelection) {
                            (this).CreateActivityGraphAction.this.startActivity = (ActivityType)((IStructuredSelection)event.getSelection()).getFirstElement();
                            if ((this).CreateActivityGraphAction.this.startActivity != null) {
                                okButton.setEnabled(true);
                            }
                        }
                    }
                });
                viewer.add(this.getStartActivities(((ProcessDefinitionType)CreateActivityGraphAction.this.diagram.eContainer()).getActivity()).toArray());
                return composite;
            }

            private List getStartActivities(EList activities) {
                ArrayList<ActivityType> startActivities = new ArrayList<ActivityType>();
                for (ActivityType next : activities) {
                    if (!next.getInTransitions().isEmpty()) continue;
                    startActivities.add(next);
                }
                return startActivities;
            }
        };
    }

    private void populateRows(int rowId, ActivityType activity) {
        this.visitedActivities.add(activity);
        if (!this.activityBlocks.containsKey(activity)) {
            this.activityBlocks.put(activity, new ActivityBlock(activity));
        }
        this.addElement(this.rows, activity, rowId);
        int nextRowId = rowId + 1;
        for (ActivityType followActivity : ActivityUtil.getOutActivities((ActivityType)activity)) {
            if (this.visitedActivities.contains(followActivity)) continue;
            this.populateRows(nextRowId, followActivity);
        }
    }

    private List populateColumns(int idxRow, ActivityType activity) {
        ArrayList<Integer> spread = new ArrayList<Integer>();
        spread.add(new Integer(1));
        if (this.rows.size() > idxRow + 1) {
            List nextRow = (List)this.rows.get(idxRow + 1);
            for (ActivityType followActivity : ActivityUtil.getOutActivities((ActivityType)activity)) {
                if (!nextRow.contains(followActivity) || this.layoutSpecs.containsKey(followActivity)) continue;
                List followSpread = this.populateColumns(idxRow + 1, followActivity);
                int maxSpread = 0;
                int rowId = 0;
                while (rowId < followSpread.size()) {
                    if (spread.size() > 1 + rowId) {
                        maxSpread = Math.max(maxSpread, (Integer)spread.get(1 + rowId));
                    }
                    ++rowId;
                }
                int colBase = maxSpread;
                int rowId2 = 0;
                while (rowId2 < followSpread.size()) {
                    Integer newSpread = new Integer(colBase + (Integer)followSpread.get(rowId2));
                    if (spread.size() > 1 + rowId2) {
                        spread.set(1 + rowId2, newSpread);
                    } else {
                        spread.add(newSpread);
                    }
                    ++rowId2;
                }
                this.layoutSpecs.put(followActivity, new LayoutSpec(activity, idxRow + 1, colBase));
            }
        }
        return spread;
    }

    private static class ActivityBlock {
        public static final int dxParticipant = 6;
        public static final int dxApplication = 6;
        public static final int dxActivity = 8;
        public static final int dyActivity = 4;
        public static final int dxData = 6;
        public static final int dyData = 4;
        public static final int dyParticipant = 3;
        public static final int dyApplication = 3;
        public static final int dxJoinGateway = 3;
        public static final int dyJoinGateway = 3;
        public static final int dxSplitGateway = 3;
        public static final int dySplitGateway = 3;
        public final boolean joinGateway;
        public final boolean splitGateway;
        public final Map data;
        public final int nParticipants;
        public final int nApplications;

        public ActivityBlock(ActivityType activity) {
            this.joinGateway = !JoinSplitType.NONE_LITERAL.equals((Object)activity.getJoin());
            this.splitGateway = !JoinSplitType.NONE_LITERAL.equals((Object)activity.getSplit());
            this.nParticipants = ActivityUtil.isInteractive((ActivityType)activity) && activity.getPerformer() != null ? 1 : 0;
            this.nApplications = activity.getApplication() != null ? 1 : 0;
            this.data = new HashMap();
            for (DataMappingType mapping : activity.getDataMapping()) {
                DirectionType direction = (DirectionType)this.data.get(mapping.getData());
                if (direction == null) {
                    direction = mapping.getDirection();
                } else if (!direction.equals((Object)mapping.getDirection())) {
                    direction = DirectionType.INOUT_LITERAL;
                }
                this.data.put(mapping.getData(), direction);
            }
        }

        public int getWidth(boolean isVertical) {
            if (isVertical) {
                return 14 + Math.max(6, 6);
            }
            int activityWidth = 14;
            int dataWidth = 6 * this.data.size();
            int operationalWidth = 6 * this.nParticipants + 6 * this.nApplications;
            return Math.max(activityWidth, Math.max(dataWidth, operationalWidth));
        }

        public int getHeight(boolean isVertical) {
            if (!isVertical) {
                return 8 + Math.max(3, 3);
            }
            int activityHeight = 10;
            int dataHeight = 4 * this.data.size();
            int operationalHeight = 3 * this.nParticipants + 3 * this.nApplications;
            return Math.max(activityHeight, Math.max(dataHeight, operationalHeight));
        }
    }

    private static class LayoutSpec {
        final ActivityType predecessor;
        final int idxRow;
        final int idxColumn;

        public LayoutSpec(ActivityType predecessor, int idxRow, int idxColumn) {
            this.predecessor = predecessor;
            this.idxRow = idxRow;
            this.idxColumn = idxColumn;
        }
    }
}

