/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipantSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;

public class CreateConnectionAction
extends SelectionAction {
    private static final int MODEL_ORGANIZATION_CONTAINER = 0;
    private static final int PROCESS_ORGANIZATION_CONTAINER = 4;
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    public static final int TRANSITION = 0;
    public static final int DATA_MAPPING = 1;
    public static final int EXECUTED_BY = 2;
    public static final int PERFORMED_BY = 3;
    public static final int PART_OF = 1;
    public static final int WORKS_FOR = 0;
    private WorkflowModelEditor editor;
    private int type;
    private Object selectedObject;
    private boolean isEnabled = false;
    private boolean isOrganizationType = false;

    public CreateConnectionAction(IWorkbenchPart part, int type, String label, Object selectedObject) {
        this(part, type, false, label, selectedObject);
    }

    public CreateConnectionAction(IWorkbenchPart part, int type, boolean isOrganizationType, String label, Object selectedObject) {
        super(part);
        this.editor = (WorkflowModelEditor)part;
        this.setId("org.eclipse.stardust.modeling.core.connection");
        this.setText(label);
        this.type = type;
        this.selectedObject = selectedObject;
        this.isOrganizationType = isOrganizationType;
        this.initAction();
    }

    private void initAction() {
        EClass eClass = null;
        boolean isModelElementSymbolEditPart = this.selectedObject instanceof AbstractModelElementNodeSymbolEditPart;
        if (isModelElementSymbolEditPart) {
            Object model = ((AbstractNodeSymbolEditPart)this.selectedObject).getModel();
            if (!this.isOrganizationType) {
                if (((INodeSymbol)model).eContainer().eContainer() instanceof ProcessDefinitionType) {
                    if (this.type == 0) {
                        eClass = CWM_PKG.getTransitionConnectionType();
                        this.isEnabled = model instanceof ActivitySymbolType || model instanceof StartEventSymbol;
                    } else if (this.type == 1) {
                        eClass = CWM_PKG.getDataMappingConnectionType();
                        this.isEnabled = model instanceof ActivitySymbolType || model instanceof DataSymbolType;
                    } else if (this.type == 2) {
                        eClass = CWM_PKG.getExecutedByConnectionType();
                        this.isEnabled = model instanceof ApplicationSymbolType;
                    } else if (this.type == 3) {
                        eClass = CWM_PKG.getPerformsConnectionType();
                        this.isEnabled = model instanceof IModelParticipantSymbol;
                    }
                }
            } else if (this.type == 0) {
                eClass = CWM_PKG.getWorksForConnectionType();
                this.isEnabled = isModelElementSymbolEditPart && model instanceof RoleSymbolType;
            } else if (this.type == 1) {
                eClass = CWM_PKG.getPartOfConnectionType();
                this.isEnabled = isModelElementSymbolEditPart && model instanceof OrganizationSymbolType;
            }
        }
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor(this.editor.getIconFactory().getIconFor((EObject)eClass)));
    }

    protected boolean calculateEnabled() {
        return this.isEnabled;
    }

    public void run() {
        List paletteContainer = ((DiagramEditorPage)this.editor.getCurrentPage()).getPaletteRoot().getChildren();
        PaletteViewer paletteViewer = ((DiagramEditorPage)this.editor.getCurrentPage()).getPaletteViewer();
        PaletteDrawer drawer = (PaletteDrawer)paletteContainer.get(1);
        List drawerEntries = drawer.getChildren();
        Object obj = this.isOrganizationType ? ((PaletteContainer)drawerEntries.get(drawer.getChildren().size() > 4 ? 4 : 0)).getChildren().get(this.type) : drawerEntries.get(this.type);
        paletteViewer.setActiveTool((ToolEntry)obj);
        this.performMouseDownEvent();
    }

    private void performMouseDownEvent() {
        DiagramEditorPage diagramPage = (DiagramEditorPage)this.editor.getCurrentPage();
        Canvas canvas = (Canvas)diagramPage.getGraphicalViewer().getControl();
        Event event = new Event();
        event.button = 1;
        event.count = 0;
        event.detail = 0;
        event.end = 0;
        event.height = 0;
        event.keyCode = 0;
        event.start = 0;
        event.stateMask = 0;
        event.time = 9516624;
        event.type = 3;
        event.widget = canvas;
        event.width = 0;
        event.x = diagramPage.getMouseLocation().x;
        event.y = diagramPage.getMouseLocation().y;
        canvas.notifyListeners(3, event);
    }
}

