/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.common.ui.IWorkflowModelEditor;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;
import org.eclipse.ui.IWorkbenchPart;

public class ImportConnectionObjectAction
extends SelectionAction {
    public ImportConnectionObjectAction(WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.setId("org.eclipse.stardust.modeling.repository.common.import");
        this.setText(Diagram_Messages.TXT_IMPORT);
    }

    protected boolean calculateEnabled() {
        List<Object> models = this.getModels();
        if (models != null) {
            return !this.isConnectionImportByReference(models);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isConnectionImportByReference(List<Object> models) {
        try {
            EObjectDescriptor desc;
            Proxy p;
            Object cm;
            ConnectionManager cman;
            Connection conn;
            Object o;
            Iterator<Object> i = this.getModels().iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while (!((o = i.next()) instanceof Proxy) || !(conn = (cman = (ConnectionManager)Reflect.getFieldValue((Object)(cm = Reflect.getFieldValue((Object)(p = (Proxy)o), (String)"h")), (String)"this$0")).getConnection((desc = (EObjectDescriptor)Reflect.getFieldValue((Object)cm, (String)"val$desc")).getURI().authority())).getAttribute("importByReference").equals("true"));
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private List<Object> getModels() {
        if (this.getSelectedObjects().size() == 0) {
            return null;
        }
        List selection = this.getSelectedObjects();
        ArrayList<Object> result = new ArrayList<Object>();
        int i = 0;
        while (i < selection.size()) {
            Object entry = this.getSelectedObjects().get(i);
            if (entry instanceof EditPart) {
                Object model = ((EditPart)entry).getModel();
                if (model instanceof IObjectDescriptor) {
                    IObjectDescriptor descriptor = (IObjectDescriptor)model;
                    if (descriptor.getType() instanceof EClass) {
                        result.add(model);
                    }
                } else {
                    return null;
                }
            }
            ++i;
        }
        return result.size() == 0 ? null : result;
    }

    public void run() {
        ConnectionManager manager = (ConnectionManager)this.getWorkbenchPart().getAdapter(ConnectionManager.class);
        try {
            ModelType model = ((IWorkflowModelEditor)this.getWorkbenchPart()).getWorkflowModel();
            IObjectDescriptor[] descriptors = this.getModels().toArray(new IObjectDescriptor[0]);
            Command cmd = manager.linkObject(model, descriptors);
            this.execute(cmd);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

