/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.AbstractMerger;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.DiagramMerger;
import org.eclipse.stardust.modeling.core.editors.cap.OutlineMerger;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.AbstractPasteAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class PasteAction
extends AbstractPasteAction {
    public PasteAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId(ActionFactory.PASTE.getId());
        this.setText(Diagram_Messages.LB_PasteElement);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setToolTipText(Diagram_Messages.LB_PasteElement);
        this.setAccelerator(262230);
        this.clipboard = Clipboard.getDefault();
    }

    protected boolean calculateEnabled() {
        boolean isEnabled = false;
        if (!this.isValidSelection()) {
            return false;
        }
        if (this.isValid != 1) {
            isEnabled = this.isValidForDiagram();
            if (isEnabled) {
                return !this.storage.isCopySymbols();
            }
            return isEnabled;
        }
        isEnabled = this.isValidForOutline();
        if (isEnabled) {
            return !this.storage.isCopySymbols();
        }
        return false;
    }

    public void run() {
        AbstractMerger util;
        Boolean lockedByCurrentUser;
        EObject checkSelection = CopyPasteUtil.getEObjectFromSelection(this.getSelectedObjects().get(0));
        if (!(checkSelection instanceof ModelType) && (lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser(checkSelection)) != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
            ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
            return;
        }
        if (this.storage.getSourceModel().equals(this.targetModel)) {
            this.storage.setSameModel(true);
        } else {
            this.storage.setSameModel(false);
        }
        ChangeRecorder targetRecorder = new ChangeRecorder();
        targetRecorder.beginRecording(Collections.singleton(this.targetModel));
        Integer isValid = CopyPasteUtil.validateSelection(this.copySet, false);
        if (isValid == 1) {
            this.storage.setTargetProcess(CopyPasteUtil.isProcessCategoryNode(this.getSelectedObjects().get(0)));
            util = new OutlineMerger(this.targetModel, this.copySet, this.storage);
        } else {
            ProcessDefinitionType targetProcess;
            EObject targetObject = this.getTargetObject();
            if (targetObject != null && (targetProcess = ModelUtils.findContainingProcess((EObject)targetObject)) != null) {
                this.storage.setTargetProcess(targetProcess);
            }
            util = new DiagramMerger(this.targetModel, this.copySet, this.storage, DiagramMerger.CREATE_ALL);
        }
        util.merge();
        if (util.modelChanged()) {
            CompoundCommand cmd = new CompoundCommand();
            if (isValid != 1) {
                EditPart targetEditPart;
                if (this.copySet.get(0) instanceof LaneSymbol) {
                    this.copyLanes = true;
                }
                if ((targetEditPart = this.storage.getTargetEditPart()) instanceof LaneEditPart || targetEditPart instanceof PoolEditPart) {
                    if (this.copyLanes) {
                        cmd.add((Command)new DelegatingCommand(){

                            @Override
                            public Command createDelegate() {
                                return PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)targetEditPart, new Integer(2));
                            }
                        });
                    } else {
                        cmd.add((Command)new DelegatingCommand(){

                            @Override
                            public Command createDelegate() {
                                return PoolLaneUtils.resizeLane((AbstractSwimlaneEditPart)targetEditPart);
                            }
                        });
                    }
                    cmd.add((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.reorderSiblings(targetEditPart, null);
                        }
                    });
                }
            }
            final ChangeDescription change = targetRecorder.endRecording();
            targetRecorder.dispose();
            cmd.add(new Command(){

                public void execute() {
                }

                public void undo() {
                    change.applyAndReverse();
                }

                public void redo() {
                    change.applyAndReverse();
                }
            });
            this.getCommandStack().execute((Command)cmd);
        } else if (targetRecorder.isRecording()) {
            ChangeDescription changes = targetRecorder.endRecording();
            targetRecorder.dispose();
            changes.apply();
        }
    }
}

