/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.IWorkbenchPart;

public class ShrinkToFitAction
extends SelectionAction {
    public ShrinkToFitAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Diagram_Messages.LB_SHRINK_TO_FIT);
        this.setId("org.eclipse.stardust.modeling.core.shrinkToFitAction");
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && this.getSelectedObjects().get(0) instanceof AbstractSwimlaneEditPart && this.canChange((AbstractSwimlaneEditPart)this.getSelectedObjects().get(0));
    }

    private boolean canChange(AbstractSwimlaneEditPart editPart) {
        Boolean lockedByCurrentUser;
        if (editPart == null) {
            return false;
        }
        ISwimlaneSymbol symbol = editPart.getSwimlaneModel();
        ProcessDefinitionType container = ModelUtils.findContainingProcess((EObject)symbol);
        if (container != null && (lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)container)) != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
            return false;
        }
        if (!PoolLaneUtils.canChange((EditPart)editPart)) {
            return false;
        }
        if (editPart instanceof LaneEditPart && ((LaneEditPart)editPart).getLaneFigure().isCollapsed()) {
            return false;
        }
        if (!PoolLaneUtils.containsSymbols((EditPart)editPart)) {
            return false;
        }
        int[] currentSpace = new int[]{-1, -1, -1, -1};
        return PoolLaneUtils.canShrink(editPart, currentSpace);
    }

    public void run() {
        CompoundCommand cmd = new CompoundCommand();
        AbstractSwimlaneEditPart editPart = (AbstractSwimlaneEditPart)this.getSelectedObjects().get(0);
        cmd.add((Command)PoolLaneUtils.shrinkToFit(editPart));
        this.execute((Command)cmd);
    }
}

