/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.ui.VcsFeedView;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class UnshareModelAction
extends SelectionAction {
    public UnshareModelAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setText(Diagram_Messages.LB_UnshareModel);
        this.setToolTipText(Diagram_Messages.LB_UnshareModel);
        this.setId("org.eclipse.stardust.modeling.core.unshareModelAction");
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/repository_rep.gif"));
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof ModelTreeEditPart) {
            ModelType model = (ModelType)((ModelTreeEditPart)selection).getModel();
            WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(model);
            return editor.getModelServer().isModelShared();
        }
        return false;
    }

    public void run() {
        WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
        if (editor.isChanged()) {
            ModelServerUtils.showMessageBox(Diagram_Messages.MSG_SAVE_MODEL_NEEDED);
            return;
        }
        try {
            Map<String, EObject> localMap = ModelServerUtils.createUuidToElementMap(editor.getWorkflowModel());
            editor.getModelServer().unshare((IProgressMonitor)new NullProgressMonitor());
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
            ModelServerUtils.refreshTreeItems(localMap.values());
        }
        catch (RMSException e) {
            ModelServerUtils.showMessageBox(e.getMessage());
        }
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.stardust.modeling.core.modelserver.ui.VcsFeedView");
        if (view != null) {
            ((VcsFeedView)view).updateAction(true);
        }
    }
}

