/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.properties;

import java.util.EventObject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.ForwardUndoCompoundCommand;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.BpmUiActivator;
import org.eclipse.stardust.modeling.common.ui.IWorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.IPropSheetCmdFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetEntry;

public final class UndoablePropSheetEntry
extends PropertySheetEntry {
    private static final IPropSheetCmdFactory DEFAULT_CMD_FACTORY = new DefaultPropSheetCmdFactory();
    private CommandStack stack;
    private CommandStackListener commandStackListener;

    private UndoablePropSheetEntry() {
    }

    public UndoablePropSheetEntry(CommandStack stack) {
        this.setCommandStack(stack);
    }

    protected PropertySheetEntry createChildEntry() {
        return new UndoablePropSheetEntry();
    }

    public void dispose() {
        if (this.stack != null) {
            this.stack.removeCommandStackListener(this.commandStackListener);
        }
        super.dispose();
    }

    CommandStack getCommandStack() {
        if (this.getParent() != null) {
            return ((UndoablePropSheetEntry)this.getParent()).getCommandStack();
        }
        return this.stack;
    }

    void setCommandStack(CommandStack stack) {
        this.stack = stack;
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject e) {
                UndoablePropSheetEntry.this.refreshFromRoot();
            }
        };
        stack.addCommandStackListener(this.commandStackListener);
    }

    public void resetPropertyValue() {
        CompoundCommand cc = new CompoundCommand();
        if (this.getParent() == null) {
            return;
        }
        boolean change = false;
        Object[] objects = this.getParent().getValues();
        int i = 0;
        while (i < objects.length) {
            IPropertySource source;
            IPropSheetCmdFactory cmdFactory = null;
            if (this.getDescriptor() instanceof IAdaptable) {
                cmdFactory = (IPropSheetCmdFactory)((IAdaptable)this.getDescriptor()).getAdapter(IPropSheetCmdFactory.class);
            }
            if (cmdFactory == null) {
                cmdFactory = DEFAULT_CMD_FACTORY;
            }
            if ((source = this.getPropertySource(objects[i])).isPropertySet(this.getDescriptor().getId())) {
                cc.add(cmdFactory.createResetValueCommand(this.getDescriptor(), source));
                change = true;
            }
            ++i;
        }
        if (change) {
            this.getCommandStack().execute((Command)cc);
            this.refreshFromRoot();
        }
    }

    protected void valueChanged(PropertySheetEntry child) {
        this.valueChanged((UndoablePropSheetEntry)child, (CompoundCommand)new ForwardUndoCompoundCommand());
    }

    void valueChanged(UndoablePropSheetEntry child, CompoundCommand command) {
        CompoundCommand cc = new CompoundCommand();
        command.add((Command)cc);
        int i = 0;
        while (i < this.getValues().length) {
            IPropSheetCmdFactory cmdFactory = null;
            if (child.getDescriptor() instanceof IAdaptable) {
                cmdFactory = (IPropSheetCmdFactory)((IAdaptable)child.getDescriptor()).getAdapter(IPropSheetCmdFactory.class);
            }
            if (cmdFactory == null) {
                cmdFactory = DEFAULT_CMD_FACTORY;
            }
            cc.add(cmdFactory.createSetValueCommand(child, child.getDescriptor(), this.getPropertySource(this.getValues()[i]), child.getValues()[i]));
            ++i;
        }
        if (this.getParent() != null) {
            ((UndoablePropSheetEntry)this.getParent()).valueChanged(this, command);
        } else {
            this.stack.execute((Command)command);
        }
    }

    public CellEditor getEditor(Composite parent) {
        IWorkflowModelEditor editor;
        EObject eObject;
        ModelType model;
        UndoablePropSheetEntry entry = this;
        while (entry.getParent() != null) {
            entry = (UndoablePropSheetEntry)entry.getParent();
        }
        Object object = entry.getEditValue(0);
        if (object instanceof EObject && (model = ModelUtils.findContainingModel((EObject)(eObject = (EObject)object))) != null && (editor = BpmUiActivator.findWorkflowModelEditor((ModelType)model)) != null && editor.requireLock(eObject)) {
            return null;
        }
        return super.getEditor(parent);
    }
}

