/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.tree;

import java.util.Collections;
import org.eclipse.emf.common.ui.celleditor.ExtendedTreeEditor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.util.ElUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetTypeDeclarationIdCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class OutlineTreeEditor
extends ExtendedTreeEditor {
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static final XpdlPackage XPDL_PKG = XpdlPackage.eINSTANCE;
    private EditPartViewer viewer;
    private TextCellEditor editor;
    private ICellEditorListener editorListener;
    private EObject model;
    private String currentValue;

    public OutlineTreeEditor(Tree tree, EditPartViewer editPartViewer) {
        super(tree);
        this.viewer = editPartViewer;
    }

    public void setItem(TreeItem treeItem, Object model) {
        super.setItem(treeItem);
        this.model = (EObject)model;
        this.currentValue = this.getNameFromModel();
        this.createCellEditor(this.tree);
        Rectangle area = treeItem.getBounds();
        if (this.editor != null) {
            this.editor.getControl().setBounds(area);
            this.editor.activate();
            this.editor.setValue((Object)this.getNameFromModel());
            this.editor.getControl().setVisible(true);
            try {
                this.editor.setFocus();
            }
            catch (SWTException sWTException) {}
        }
    }

    private void createCellEditor(Tree tree) {
        this.editor = new TextCellEditor((Composite)tree);
        this.editorListener = new ICellEditorListener(){

            public void applyEditorValue() {
                OutlineTreeEditor.this.editItem(OutlineTreeEditor.this.getItem());
            }

            public void cancelEditor() {
                OutlineTreeEditor.this.bringDown();
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        };
        this.editor.addListener(this.editorListener);
    }

    private String getNameFromModel() {
        if (this.model instanceof IIdentifiableElement) {
            return ((IIdentifiableElement)this.model).getName();
        }
        if (this.model instanceof DiagramType) {
            String diagramName = ((DiagramType)this.model).getName();
            if (diagramName == null) {
                return "";
            }
            return diagramName;
        }
        if (this.model instanceof TypeDeclarationType) {
            return ((TypeDeclarationType)this.model).getName();
        }
        if (this.model instanceof ExternalPackage) {
            return ((ExternalPackage)this.model).getName();
        }
        return "";
    }

    protected void editItem(TreeItem treeItem) {
        if (this.editor == null) {
            return;
        }
        String newValue = (String)this.editor.getValue();
        if (StringUtils.isEmpty((String)newValue.trim())) {
            this.bringDown();
            return;
        }
        if (this.currentValue.equals(newValue)) {
            this.bringDown();
            return;
        }
        String computedId = ModelUtils.computeId((String)newValue);
        EditDomain domain = this.viewer.getEditDomain();
        CompoundCommand command = new CompoundCommand();
        if (this.model instanceof IIdentifiableElement) {
            if (this.model instanceof DataType) {
                ChangeRecorder targetRecorder = new ChangeRecorder();
                targetRecorder.beginRecording(Collections.singleton(this.model.eContainer()));
                ElUtils.updateTransitionConditions((DataType)((DataType)this.model), (String)((DataType)this.model).getId(), (String)computedId);
                final ChangeDescription change = targetRecorder.endRecording();
                targetRecorder.dispose();
                Command cmd = new Command(){

                    public void execute() {
                    }

                    public void undo() {
                        change.applyAndReverse();
                    }

                    public void redo() {
                        change.applyAndReverse();
                    }
                };
                command.add(cmd);
            }
            SetValueCmd cmd = new SetValueCmd(this.model, (EStructuralFeature)CWM_PKG.getIIdentifiableElement_Name(), (Object)newValue);
            command.add((Command)cmd);
            SetValueCmd cmdId = new SetValueCmd(this.model, (EStructuralFeature)CWM_PKG.getIIdentifiableElement_Id(), (Object)computedId);
            command.add((Command)cmdId);
        } else if (this.model instanceof DiagramType) {
            SetValueCmd cmd = new SetValueCmd(this.model, (EStructuralFeature)CWM_PKG.getDiagramType_Name(), (Object)newValue);
            command.add((Command)cmd);
        } else if (this.model instanceof TypeDeclarationType) {
            SetValueCmd cmd = new SetValueCmd(this.model, (EStructuralFeature)XPDL_PKG.getTypeDeclarationType_Name(), (Object)newValue);
            command.add((Command)cmd);
            SetValueCmd cmdId = new SetValueCmd(this.model, (EStructuralFeature)XPDL_PKG.getTypeDeclarationType_Id(), (Object)computedId);
            command.add((Command)cmdId);
            SetTypeDeclarationIdCommand tdCmd = new SetTypeDeclarationIdCommand((TypeDeclarationType)this.model, computedId);
            command.add((Command)tdCmd);
        } else if (this.model instanceof ExternalPackage) {
            SetValueCmd cmd = new SetValueCmd(this.model, (EStructuralFeature)XPDL_PKG.getExternalPackage_Name(), (Object)newValue);
            command.add((Command)cmd);
        }
        domain.getCommandStack().execute((Command)command);
        this.bringDown();
    }

    private void bringDown() {
        this.editor.removeListener(this.editorListener);
        this.editor.deactivate();
        this.editor.dispose();
        this.editor = null;
    }
}

