/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.tree;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DocumentRoot;
import org.eclipse.stardust.model.xpdl.carnot.EventActionTypeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ModelerType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerTypeType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelOutlinePage;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.editors.parts.tree.IdentifiableModelElementTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.OutlineTreeEditor;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.swt.widgets.TreeItem;

public class WorkflowModelTreeEditPartFactory
implements EditPartFactory {
    private static final EStructuralFeature[] processChildren = new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_Diagram(), CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_Activity(), CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_DataPath(), CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_Trigger(), CarnotWorkflowModelPackage.eINSTANCE.getProcessDefinitionType_Transition()};
    private WorkflowModelEditor editor;

    public WorkflowModelTreeEditPartFactory(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    public EditPart createEditPart(EditPart context, final Object model) {
        if (model == null) {
            return null;
        }
        if (model instanceof ChildCategoryNode.Spec) {
            if (Diagram_Messages.LB_Participants.equals(((ChildCategoryNode.Spec)model).label)) {
                return new ChildCategoryNode(this.editor, (ChildCategoryNode.Spec)model){

                    @Override
                    protected List getModelChildren() {
                        List children = super.getModelChildren();
                        Map participantsById = CollectionUtils.newMap();
                        for (Object c : children) {
                            if (!(c instanceof IModelParticipant)) continue;
                            participantsById.put(((IModelParticipant)c).getId(), (IModelParticipant)c);
                        }
                        List toRemove = CollectionUtils.newList();
                        int i = 0;
                        while (i < children.size()) {
                            Object child = children.get(i);
                            if (child instanceof OrganizationType) {
                                OrganizationType organization = (OrganizationType)child;
                                EList participants = organization.getParticipant();
                                int j = 0;
                                while (j < participants.size()) {
                                    IModelParticipant actual;
                                    ParticipantType ref = (ParticipantType)participants.get(j);
                                    IModelParticipant participant = ref.getParticipant();
                                    if (participant != null && (actual = (IModelParticipant)participantsById.get(participant.getId())) != null) {
                                        toRemove.add(actual);
                                    }
                                    ++j;
                                }
                            } else if (!(child instanceof IModelParticipant)) {
                                toRemove.add(child);
                            }
                            ++i;
                        }
                        children.removeAll(toRemove);
                        return children;
                    }
                };
            }
            return new ChildCategoryNode(this.editor, (ChildCategoryNode.Spec)model);
        }
        if (model instanceof DocumentRoot) {
            return new AbstractEObjectTreeEditPart(this.editor, (EObject)((DocumentRoot)model)){

                @Override
                protected void createEditPolicies() {
                    super.createEditPolicies();
                    if (this.getParent() instanceof RootEditPart) {
                        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
                    }
                }

                @Override
                protected List getModelChildren() {
                    return Collections.singletonList(((DocumentRoot)this.getModel()).getModel());
                }
            };
        }
        if (model instanceof ActivityType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((ActivityType)model), this.editor.getIconFactory().getIconFor((EObject)((ActivityType)model)));
        }
        if (model instanceof ApplicationType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((ApplicationType)model), this.editor.getIconFactory().getIconFor((EObject)((ApplicationType)model)));
        }
        if (model instanceof ConditionalPerformerType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((ConditionalPerformerType)model), this.editor.getIconFactory().getIconFor((EObject)((ConditionalPerformerType)model)));
        }
        if (model instanceof DataType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((DataType)model), this.editor.getIconFactory().getIconFor((EObject)((DataType)model)));
        }
        if (model instanceof DataPathType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((DataPathType)model), this.editor.getIconFactory().getIconFor((EObject)((DataPathType)model)));
        }
        if (model instanceof DiagramType) {
            return new AbstractEObjectTreeEditPart(this.editor, (EObject)((DiagramType)model), this.editor.getIconFactory().getIconFor((EObject)((DiagramType)model))){

                @Override
                protected void createEditPolicies() {
                    super.createEditPolicies();
                    this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

                        protected Command getDirectEditCommand(DirectEditRequest request) {
                            return null;
                        }

                        protected void showCurrentEditValue(DirectEditRequest request) {
                        }
                    });
                }

                public void performRequest(Request req) {
                    if (req.getType() == "direct edit") {
                        Boolean lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)this.getModel());
                        if (lockedByCurrentUser == null || lockedByCurrentUser.equals(Boolean.TRUE)) {
                            WorkflowModelOutlinePage outline = (WorkflowModelOutlinePage)this.getEditor().getOutlinePage();
                            TreeItem treeItem = (TreeItem)this.getWidget();
                            OutlineTreeEditor editor = outline.getOutlineTreeEditor();
                            editor.setItem(treeItem, this.getModel());
                            return;
                        }
                        ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
                        return;
                    }
                    super.performRequest(req);
                }

                @Override
                public String getLabel() {
                    String name = ((DiagramType)this.getModel()).getName();
                    return !StringUtils.isEmpty((String)name) ? name : Diagram_Messages.DiagramEditor_PAGENAME_UnnamedDiagram;
                }

                @Override
                public Object getAdapter(Class key) {
                    if (IModelElement.class.equals((Object)key)) {
                        return this.getModel();
                    }
                    return super.getAdapter(key);
                }
            };
        }
        if (model instanceof EventHandlerType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((EventHandlerType)model), this.editor.getIconFactory().getIconFor((EObject)((EventHandlerType)model)));
        }
        if (model instanceof ModelType) {
            return new ModelTreeEditPart(this.editor, (ModelType)model, this.editor.getIconFactory().getIconFor((EObject)((ModelType)model)));
        }
        if (model instanceof ModelerType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((ModelerType)model), this.editor.getIconFactory().getIconFor((EObject)((ModelerType)model)));
        }
        if (model instanceof OrganizationType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((OrganizationType)model), this.editor.getIconFactory().getIconFor((EObject)((OrganizationType)model))){

                @Override
                protected List getModelChildren() {
                    ModelType model = WorkflowModelTreeEditPartFactory.this.editor.getWorkflowModel();
                    Map participantsById = CollectionUtils.newMap();
                    for (OrganizationType org : model.getOrganization()) {
                        participantsById.put(org.getId(), org);
                    }
                    for (RoleType role : model.getRole()) {
                        participantsById.put(role.getId(), role);
                    }
                    OrganizationType organization = (OrganizationType)this.getModel();
                    EList participants = organization.getParticipant();
                    List list = CollectionUtils.newList();
                    int i = 0;
                    while (i < participants.size()) {
                        IModelParticipant participant;
                        IModelParticipant actual;
                        ParticipantType ref = (ParticipantType)participants.get(i);
                        if (ref.getParticipant() != null && (actual = (IModelParticipant)participantsById.get((participant = ref.getParticipant()).getId())) != null) {
                            list.add(actual);
                        }
                        ++i;
                    }
                    Collections.sort(list, ModelUtils.IDENTIFIABLE_COMPARATOR);
                    return list;
                }

                @Override
                public void handleNotification(Notification n) {
                    try {
                        super.handleNotification(n);
                    }
                    catch (NullPointerException nullPointerException) {}
                    switch (n.getEventType()) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            ChildCategoryNode category = this.getCategory();
                            if (category == null) break;
                            category.handleNotification(n);
                        }
                    }
                }

                private ChildCategoryNode getCategory() {
                    EditPart parent = this.getParent();
                    while (parent != null && !(parent instanceof ChildCategoryNode)) {
                        parent = parent.getParent();
                    }
                    return (ChildCategoryNode)parent;
                }
            };
        }
        if (model instanceof ProcessDefinitionType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((ProcessDefinitionType)model), this.editor.getIconFactory().getIconFor((EObject)((ProcessDefinitionType)model)), processChildren){

                @Override
                protected boolean accept(Object o) {
                    if (o instanceof TransitionType && "__internal_relocate_transition__".equals(((TransitionType)o).getId())) {
                        return false;
                    }
                    return super.accept(o);
                }
            };
        }
        if (model instanceof RoleType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((RoleType)model), this.editor.getIconFactory().getIconFor((EObject)((RoleType)model)));
        }
        if (model instanceof TriggerType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((TriggerType)model), this.editor.getIconFactory().getIconFor((EObject)((TriggerType)model)));
        }
        if (model instanceof TransitionType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((TransitionType)model), this.editor.getIconFactory().getIconFor((EObject)((TransitionType)model)));
        }
        if (model instanceof EventActionTypeType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((EventActionTypeType)model), this.editor.getIconFactory().getIconFor((EObject)((EventActionTypeType)model)));
        }
        if (model instanceof ApplicationTypeType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((ApplicationTypeType)model), this.editor.getIconFactory().getIconFor((EObject)((ApplicationTypeType)model)));
        }
        if (model instanceof DataTypeType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((DataTypeType)model), this.editor.getIconFactory().getIconFor((EObject)((DataTypeType)model)));
        }
        if (model instanceof ApplicationContextTypeType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((ApplicationContextTypeType)model), this.editor.getIconFactory().getIconFor((EObject)((ApplicationContextTypeType)model)));
        }
        if (model instanceof LinkTypeType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((LinkTypeType)model), this.editor.getIconFactory().getIconFor((EObject)((LinkTypeType)model)));
        }
        if (model instanceof TriggerTypeType) {
            return new IdentifiableModelElementTreeEditPart(this.editor, (IIdentifiableModelElement)((TriggerTypeType)model), this.editor.getIconFactory().getIconFor((EObject)((TriggerTypeType)model)));
        }
        if (model instanceof ExternalPackages) {
            return new AbstractEObjectTreeEditPart(this.editor, (EObject)((ExternalPackages)model), this.editor.getIconFactory().getIconFor((EObject)((ExternalPackages)model)), new EStructuralFeature[]{XpdlPackage.eINSTANCE.getExternalPackages_ExternalPackage()}){

                @Override
                public String getLabel() {
                    return Diagram_Messages.LABEL_EXTERNAL_MODEL_REFERENCES;
                }
            };
        }
        if (model instanceof ExternalPackage) {
            return new AbstractEObjectTreeEditPart(this.editor, (EObject)((ExternalPackage)model), this.editor.getIconFactory().getIconFor((EObject)((ExternalPackage)model))){

                @Override
                protected void createEditPolicies() {
                    super.createEditPolicies();
                    this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

                        protected Command getDirectEditCommand(DirectEditRequest request) {
                            return null;
                        }

                        protected void showCurrentEditValue(DirectEditRequest request) {
                        }
                    });
                }

                public void performRequest(Request req) {
                    if (req.getType() == "direct edit") {
                        Boolean lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)WorkflowModelTreeEditPartFactory.this.editor.getModel());
                        if (lockedByCurrentUser == null || lockedByCurrentUser.equals(Boolean.TRUE)) {
                            WorkflowModelOutlinePage outline = (WorkflowModelOutlinePage)this.getEditor().getOutlinePage();
                            TreeItem treeItem = (TreeItem)this.getWidget();
                            OutlineTreeEditor editor = outline.getOutlineTreeEditor();
                            editor.setItem(treeItem, this.getModel());
                            return;
                        }
                        ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
                        return;
                    }
                    super.performRequest(req);
                }

                @Override
                public String getLabel() {
                    ExternalPackage decl = (ExternalPackage)model;
                    String label = decl.getName();
                    if (label == null) {
                        label = decl.getId();
                    }
                    return label == null ? Diagram_Messages.LBL_EXTERNAL_PCK : label;
                }
            };
        }
        if (model instanceof TypeDeclarationsType) {
            return new AbstractEObjectTreeEditPart(this.editor, (EObject)((TypeDeclarationsType)model), this.editor.getIconFactory().getIconFor((EObject)((TypeDeclarationsType)model)), new EStructuralFeature[]{XpdlPackage.eINSTANCE.getTypeDeclarationsType_TypeDeclaration()}){

                @Override
                public String getLabel() {
                    return Diagram_Messages.STRUCTURED_DATA_LABEL;
                }
            };
        }
        if (model instanceof TypeDeclarationType) {
            return new AbstractEObjectTreeEditPart(this.editor, (EObject)((TypeDeclarationType)model), this.editor.getIconFactory().getIconFor((EObject)((TypeDeclarationType)model))){

                @Override
                protected void createEditPolicies() {
                    super.createEditPolicies();
                    this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

                        protected Command getDirectEditCommand(DirectEditRequest request) {
                            return null;
                        }

                        protected void showCurrentEditValue(DirectEditRequest request) {
                        }
                    });
                }

                public void performRequest(Request req) {
                    if (req.getType() == "direct edit") {
                        Boolean lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)this.getModel());
                        if (lockedByCurrentUser == null || lockedByCurrentUser.equals(Boolean.TRUE)) {
                            WorkflowModelOutlinePage outline = (WorkflowModelOutlinePage)this.getEditor().getOutlinePage();
                            TreeItem treeItem = (TreeItem)this.getWidget();
                            OutlineTreeEditor editor = outline.getOutlineTreeEditor();
                            editor.setItem(treeItem, this.getModel());
                            return;
                        }
                        ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
                        return;
                    }
                    super.performRequest(req);
                }

                @Override
                public String getLabel() {
                    TypeDeclarationType decl = (TypeDeclarationType)model;
                    String label = decl.getName();
                    if (label == null) {
                        label = decl.getId();
                    }
                    return label == null ? Diagram_Messages.TYPE_DECLARATION_LABEL : label;
                }
            };
        }
        return (EditPart)Platform.getAdapterManager().getAdapter(model, TreeEditPart.class);
    }
}

