/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.tools;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;

public class DiagramViewportAutoexposeHelper
extends ViewportAutoexposeHelper {
    private static final Insets DEFAULT_EXPOSE_THRESHOLD = new Insets(100, 100, 100, 100);
    private Insets threshold = DEFAULT_EXPOSE_THRESHOLD;
    private long lastStepTime = 0L;
    private Point lastWhere;
    private boolean isStopped = false;

    public DiagramViewportAutoexposeHelper(GraphicalEditPart owner) {
        super(owner, DEFAULT_EXPOSE_THRESHOLD);
    }

    public boolean detect(Point where) {
        this.lastStepTime = 0L;
        return super.detect(where);
    }

    public boolean step(Point where) {
        long difference;
        this.lastWhere = this.lastWhere == null ? where : this.lastWhere;
        Viewport port = this.findViewport(this.owner);
        Rectangle rect = Rectangle.SINGLETON;
        port.getClientArea(rect);
        port.translateToParent((Translatable)rect);
        port.translateToAbsolute((Translatable)rect);
        if (rect.contains(where) && rect.crop(this.threshold).contains(where)) {
            return false;
        }
        int scrollOffset = 0;
        if (this.lastStepTime == 0L) {
            this.lastStepTime = System.currentTimeMillis();
        }
        if ((difference = System.currentTimeMillis() - this.lastStepTime) > 0L) {
            scrollOffset = (int)difference / 11;
            this.lastStepTime = System.currentTimeMillis();
        }
        if (scrollOffset == 0) {
            return true;
        }
        rect.crop(this.threshold);
        int region = rect.getPosition(where);
        Point loc = port.getViewLocation();
        if ((region & 4) != 0) {
            if (this.lastWhere.y > where.y) {
                this.isStopped = true;
                return true;
            }
            if (!this.isStopped || this.lastWhere.y < where.y) {
                loc.y += scrollOffset;
                this.isStopped = false;
            }
        } else if ((region & 1) != 0) {
            if (this.lastWhere.y < where.y) {
                this.isStopped = true;
                return true;
            }
            if (!this.isStopped || this.lastWhere.y > where.y) {
                loc.y -= scrollOffset;
                this.isStopped = false;
            }
        }
        if ((region & 0x10) != 0) {
            if (this.lastWhere.x > where.x) {
                this.isStopped = true;
                return true;
            }
            if (!this.isStopped || this.lastWhere.x < where.x) {
                loc.x += scrollOffset;
                this.isStopped = false;
            }
        } else if ((region & 8) != 0) {
            if (this.lastWhere.x < where.x) {
                this.isStopped = true;
                return true;
            }
            if (!this.isStopped || this.lastWhere.x > where.x) {
                loc.x -= scrollOffset;
                this.isStopped = false;
            }
        }
        port.setViewLocation(loc);
        this.lastWhere = where;
        return true;
    }
}

