/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.modeling.validation.util.MethodInfo;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;

public class MethodViewer {
    private TypeFinder finder;
    private AbstractListViewer viewer;
    private boolean constructors;
    private int size;

    public MethodViewer(AbstractListViewer viewer, boolean constructors) {
        this.viewer = viewer;
        this.constructors = constructors;
        viewer.setSorter(new ViewerSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MethodInfo)element).getLabel();
            }
        });
        this.setTypeFinder(this.finder);
    }

    public void setType(IType type) {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.setInput((Object)type);
        }
    }

    public void selectMethod(String methodName) {
        methodName = this.stripBlanks(methodName);
        int i = 0;
        while (i < this.size) {
            MethodInfo method = (MethodInfo)this.viewer.getElementAt(i);
            if (method.getEncoded().equals(methodName)) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)method), true);
            }
            ++i;
        }
    }

    private String stripBlanks(String methodName) {
        StringBuffer sb = new StringBuffer(methodName.length());
        int i = 0;
        while (i < methodName.length()) {
            char c = methodName.charAt(i);
            if (c != ' ') {
                sb.append(c);
            }
            ++i;
        }
        methodName = sb.toString();
        return methodName;
    }

    public String getMethod() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            return ((MethodInfo)selection.getFirstElement()).getEncoded();
        }
        return "";
    }

    public void setTypeFinder(TypeFinder finder) {
        this.finder = finder;
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object object) {
                if (MethodViewer.this.finder == null) {
                    return super.getElements((Object)Collections.EMPTY_LIST);
                }
                IType type = (IType)object;
                List methods = MethodViewer.this.constructors ? MethodViewer.this.finder.getConstructors(type) : MethodViewer.this.finder.getMethods(type);
                MethodViewer.this.size = methods.size();
                return super.getElements((Object)methods);
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput == null) {
                    MethodViewer.this.size = 0;
                }
            }
        });
    }
}

