/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.jobs;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.BindActionType;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.EventActionType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ModelerType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.UnbindActionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationPlugin;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.stardust.modeling.validation.ValidatorRegistry;

public class ModelValidationJob
extends WorkspaceJob {
    private static final String EMF_RES_PREFIX = "/resource/";
    private final ModelType model;
    private final IResource modelFile;
    private Map<String, String> filters;
    private static final String LOCK = "ModelValidationJob.LOCK";
    private final WorkflowModelEditor editor;

    public ModelValidationJob(WorkflowModelEditor workflowModelEditor, ModelType model, Map<String, String> filters) {
        super(Diagram_Messages.TXT_WorkflowModelValidation);
        this.model = model;
        this.editor = workflowModelEditor;
        Resource eResModel = model.eResource();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        String uriEResModel = eResModel.getURI().path();
        if (uriEResModel.startsWith(EMF_RES_PREFIX)) {
            uriEResModel = uriEResModel.substring(EMF_RES_PREFIX.length());
        }
        this.modelFile = wsRoot.findMember(uriEResModel);
        this.filters = filters;
    }

    public ModelType getModel() {
        return this.model;
    }

    public IResource getModelFile() {
        return this.modelFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        String string = LOCK;
        synchronized (LOCK) {
            ValidationPlugin plugin = ValidationPlugin.getDefault();
            if (plugin == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return Status.OK_STATUS;
            }
            ValidationService vs = ValidationService.getInstance();
            try {
                Issue[] issues;
                block20: {
                    ValidatorRegistry.setFilters(this.filters);
                    vs.setProgressMonitor(monitor);
                    this.editor.getEditorChangeTracker().setEnabled(false);
                    issues = vs.validateModel(this.model);
                    if (this.modelFile == null) return Status.OK_STATUS;
                    this.modelFile.deleteMarkers("org.eclipse.stardust.modeling.validation.wfModelValidationMarker", true, 2);
                    plugin = ValidationPlugin.getDefault();
                    if (plugin != null) break block20;
                    IStatus iStatus = Status.OK_STATUS;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return iStatus;
                }
                try {
                    vs.removeMappings(this.modelFile);
                    Map attr = CollectionUtils.newMap();
                    int i = 0;
                    while (i < issues.length) {
                        attr.clear();
                        attr.put("severity", new Integer(issues[i].isError() ? 2 : (issues[i].isWarning() ? 1 : 0)));
                        attr.put("message", this.getLocations(issues[i].getMessage(), issues[i].getModelElement()));
                        attr.put("markerModelElement", issues[i].getModelElement());
                        if (issues[i].getModelElement() != null) {
                            if (issues[i].getModelElement() instanceof IModelElement) {
                                attr.put("wfModelValidationElementId", Long.toString(((IModelElement)issues[i].getModelElement()).getElementOid()));
                            } else if (issues[i].getModelElement() instanceof TypeDeclarationType) {
                                attr.put("wfModelValidationElementId", ((TypeDeclarationType)issues[i].getModelElement()).getId());
                            } else if (issues[i].getModelElement() instanceof ExternalPackage) {
                                attr.put("wfModelValidationElementId", ((ExternalPackage)issues[i].getModelElement()).getId());
                            }
                            String location = this.getLocation(issues[i].getModelElement());
                            if (location != null) {
                                attr.put("location", location);
                            }
                        }
                        IMarker marker = this.modelFile.createMarker("org.eclipse.stardust.modeling.validation.wfModelValidationMarker");
                        marker.setAttributes(attr);
                        vs.createMapping(marker, issues[i]);
                        ++i;
                    }
                }
                catch (CoreException coreException) {}
            }
            finally {
                WorkflowModelEditor.EditorChangeTracker tracker;
                ValidatorRegistry.setFilters(null);
                vs.setProgressMonitor(null);
                if (this.editor != null && (tracker = this.editor.getEditorChangeTracker()) != null) {
                    tracker.setEnabled(true);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return Status.OK_STATUS;
        }
    }

    private String getLocation(EObject modelElement) {
        List path = CollectionUtils.newList();
        while (modelElement != null) {
            if (modelElement instanceof IIdentifiableElement && ((IIdentifiableElement)modelElement).getId() != null) {
                path.add(((IIdentifiableElement)modelElement).getId());
            } else if (modelElement instanceof IModelElement) {
                path.add(String.valueOf(modelElement.eClass().getName()) + "[" + ((IModelElement)modelElement).getElementOid() + "]");
            } else if (modelElement instanceof TypeDeclarationType) {
                path.add(String.valueOf(modelElement.eClass().getName()) + "[" + ((TypeDeclarationType)modelElement).getId() + "]");
            } else if (modelElement instanceof ExternalPackage) {
                path.add(String.valueOf(modelElement.eClass().getName()) + "[" + ((ExternalPackage)modelElement).getId() + "]");
            }
            if (!(modelElement.eContainer() instanceof IModelElement)) break;
            modelElement = (IModelElement)modelElement.eContainer();
        }
        if (!path.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            int i = path.size() - 1;
            while (i >= 0) {
                String s = (String)path.get(i);
                sb.append(s);
                if (i > 0) {
                    sb.append('.');
                }
                --i;
            }
            return sb.toString();
        }
        return null;
    }

    private String getLocations(String message, EObject element) {
        String locations = "";
        if (element != null) {
            EventHandlerType eventHandler;
            ActivityType activity;
            ProcessDefinitionType proc = ModelUtils.findContainingProcess((EObject)element);
            if (proc != null) {
                locations = MessageFormat.format(Diagram_Messages.MSG_ProcessDefinition, locations, proc.getName());
            }
            if ((activity = ModelUtils.findContainingActivity((EObject)element)) != null) {
                locations = MessageFormat.format(Diagram_Messages.MSG_Activity, locations, activity.getName());
            }
            if (element instanceof DataPathType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_DataPath, locations, ((DataPathType)element).getName());
            }
            if ((eventHandler = ModelUtils.findContainingEventHandlerType((EObject)element)) != null) {
                locations = MessageFormat.format(Diagram_Messages.MSG_EventHandler, locations, eventHandler.getName());
            }
            if (element instanceof TriggerType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_Trigger, locations, ((TriggerType)element).getName());
            }
            if (element instanceof TransitionType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_Transition, locations, ((TransitionType)element).getName());
            }
            if (element instanceof EventActionType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_EventAction, locations, ((EventActionType)element).getName());
            }
            if (element instanceof BindActionType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_BindAction, locations, ((BindActionType)element).getName());
            }
            if (element instanceof UnbindActionType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_UnbindAction, locations, ((UnbindActionType)element).getName());
            }
            if (element instanceof DataMappingType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_DataMapping, locations, ((DataMappingType)element).getId());
            }
            if (element instanceof ApplicationType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_Application, ((ApplicationType)element).getName());
            } else if (element instanceof ConditionalPerformerType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_ConditionalPerformer, ((ConditionalPerformerType)element).getName());
            } else if (element instanceof ModelerType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_Modeler, ((ModelerType)element).getName());
            } else if (element instanceof OrganizationType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_Organization, ((OrganizationType)element).getName());
            } else if (element instanceof RoleType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_Role, ((RoleType)element).getName());
            } else if (element instanceof DataType) {
                locations = MessageFormat.format(Diagram_Messages.MSG_Data, ((DataType)element).getName());
            }
        }
        String locationMessage = "";
        locationMessage = locations.length() == 0 ? MessageFormat.format("{0}", message) : MessageFormat.format("{0} ({1})", message, locations);
        return locationMessage;
    }
}

