/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.marker;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.FixInvalidIdsAction;
import org.eclipse.stardust.modeling.core.marker.IResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.MarkerResolution;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.ui.IMarkerResolution;

public class IdentifiableResolutionGenerator
implements IResolutionGenerator {
    @Override
    public boolean hasResolutions(WorkflowModelEditor editor, Issue issue) {
        if (issue.getModelElement() instanceof IIdentifiableElement && CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id().equals(issue.getFeature())) {
            IModelElement element = (IModelElement)issue.getModelElement();
            String id = ((IIdentifiableElement)element).getId();
            if (id == null || id.length() == 0) {
                return true;
            }
            if (this.hasBadCharacters(id)) {
                return true;
            }
            if (!Character.isJavaIdentifierStart(id.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addResolutions(List<IMarkerResolution> list, WorkflowModelEditor editor, Issue issue) {
        String id = null;
        IModelElement element = null;
        if (issue.getFeature().equals(CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id())) {
            element = (IModelElement)issue.getModelElement();
            id = ((IIdentifiableElement)element).getId();
        }
        if (element != null) {
            if (id == null || id.length() == 0) {
                list.add(new MarkerResolution(this.getAction(editor, element, "Create automatic ID")));
            } else if (this.hasBadCharacters(id)) {
                list.add(new MarkerResolution(this.getAction(editor, element, "Convert to valid ID")));
            } else if (!Character.isJavaIdentifierStart(id.charAt(0))) {
                list.add(new MarkerResolution(this.getAction(editor, element, "Convert to valid ID")));
            }
        }
    }

    private boolean hasBadCharacters(String id) {
        int i = 0;
        while (i < id.length()) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IAction getAction(final WorkflowModelEditor editor, final IModelElement element, String label) {
        return new Action(label){

            public void run() {
                FixInvalidIdsAction.run(editor, element);
            }
        };
    }
}

