/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.marker;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TeamLeadConnectionType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.marker.IResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.MarkerResolution;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.ui.IMarkerResolution;

public class OrganizationResolutionGenerator
implements IResolutionGenerator {
    @Override
    public boolean hasResolutions(WorkflowModelEditor editor, Issue issue) {
        if (issue.getModelElement() instanceof OrganizationType) {
            return issue.getFeature().equals(ValidationService.PKG_CWM.getTeamLeadConnectionType_TeamLeadSymbol());
        }
        return false;
    }

    @Override
    public void addResolutions(List<IMarkerResolution> list, final WorkflowModelEditor editor, final Issue issue) {
        if (issue.getFeature().equals(ValidationService.PKG_CWM.getTeamLeadConnectionType_TeamLeadSymbol())) {
            list.add(new MarkerResolution((IAction)new Action(Diagram_Messages.TXT_SET_TEAM_LEADER){

                public void run() {
                    OrganizationType organization = (OrganizationType)issue.getModelElement();
                    for (Object symbol : organization.getSymbols()) {
                        for (TeamLeadConnectionType connection : ((OrganizationSymbolType)symbol).getTeamLead()) {
                            RoleType teamLead = connection.getTeamLeadSymbol().getRole();
                            if (organization.getTeamLead() != null) continue;
                            SetValueCmd cmd = new SetValueCmd((EObject)organization, (EStructuralFeature)ValidationService.PKG_CWM.getOrganizationType_TeamLead(), (Object)teamLead);
                            editor.getEditDomain().getCommandStack().execute((Command)cmd);
                        }
                    }
                }
            }));
        }
    }
}

