/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.marker;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.stardust.engine.core.compatibility.el.DataTypeResolver;
import org.eclipse.stardust.engine.core.compatibility.el.JsConverter;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.marker.IResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.MarkerResolution;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;

public class TransitionResolutionGenerator
implements IResolutionGenerator {
    @Override
    public boolean hasResolutions(WorkflowModelEditor editor, Issue issue) {
        TransitionType transition;
        XmlTextNode expression;
        String expressionValue;
        EObject element = issue.getModelElement();
        return element instanceof TransitionType && CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_Expression().equals(issue.getFeature()) && (expressionValue = ModelUtils.getCDataString((FeatureMap)(expression = (transition = (TransitionType)element).getExpression()).getMixed())) != null && expressionValue.startsWith("carnotEL: ");
    }

    @Override
    public void addResolutions(List<IMarkerResolution> list, final WorkflowModelEditor editor, final Issue issue) {
        EObject element = issue.getModelElement();
        if (element instanceof TransitionType && CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_Expression().equals(issue.getFeature())) {
            list.add(new MarkerResolution((IAction)new Action("Convert to ECMAScript"){

                public void run() {
                    TransitionType transition = (TransitionType)issue.getModelElement();
                    XmlTextNode expression = transition.getExpression();
                    String condition = ModelUtils.getCDataString((FeatureMap)expression.getMixed());
                    if (condition.startsWith("carnotEL: ")) {
                        final ModelType model = editor.getWorkflowModel();
                        JsConverter converter = new JsConverter(new DataTypeResolver(){

                            public String resolveDataType(String dataId) {
                                DataType data = (DataType)ModelUtils.findElementById((List)model.getData(), (String)dataId);
                                if (data == null) {
                                    return null;
                                }
                                DataTypeType type = data.getType();
                                if (type == null) {
                                    return null;
                                }
                                return type.getId();
                            }
                        });
                        String jsCondition = converter.convert(condition.substring("carnotEL: ".length()));
                        if (converter.isSuccessfull()) {
                            expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
                            ModelUtils.setCDataString((FeatureMap)expression.getMixed(), (String)jsCondition, (boolean)true);
                            SetValueCmd cmd = new SetValueCmd((EObject)transition, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getTransitionType_Expression(), (Object)expression);
                            editor.getEditDomain().getCommandStack().execute((Command)cmd);
                        } else {
                            Exception failReason = converter.getFailReason();
                            ErrorDialog.openError((Shell)editor.getSite().getShell(), (String)Diagram_Messages.ERROR_DIA_CONVERSION_FAILED, (String)failReason.getMessage(), (IStatus)new Status(2, DiagramPlugin.getDefault().getBundle().getSymbolicName(), failReason.getMessage(), (Throwable)failReason));
                        }
                    }
                }
            }));
        }
    }
}

