/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.VcsStatus;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionInfo;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionState;

public class LockFileUtils {
    public static String readLockFile(IFile lockFile) {
        String data = null;
        try {
            if (!lockFile.isSynchronized(0)) {
                lockFile.refreshLocal(0, null);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(lockFile.getContents(), "ISO-8859-1"));
            data = reader.readLine();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data;
    }

    public static void setLockFile(IFile lockFile, String data) {
        try {
            lockFile.setContents((InputStream)new ByteArrayInputStream(data.getBytes("ISO-8859-1")), true, false, null);
        }
        catch (Exception exception) {}
    }

    public static boolean hasLockFile(EObject eObject, ModelType model) {
        IFolder lockFolder = LockFileUtils.getLockFolder(eObject, model);
        IFile lockFile = LockFileUtils.getFile(lockFolder, eObject);
        return lockFile != null && lockFile.exists();
    }

    public static IFile getLockFile(EObject eObject) {
        IFolder lockFolder = LockFileUtils.getLockFolder(eObject, ModelUtils.findContainingModel((EObject)eObject));
        return LockFileUtils.getFile(lockFolder, eObject);
    }

    static String getFileName(EObject element, String uuid) {
        return String.valueOf(element.eClass().getName()) + '_' + uuid + ".lck";
    }

    public static IFile getFile(IFolder lockFolder, EObject element) {
        if (lockFolder == null) {
            return null;
        }
        String uuid = UUIDUtils.getUUID((EObject)element);
        if (uuid == null) {
            return null;
        }
        String fileName = LockFileUtils.getFileName(element, uuid);
        return lockFolder.getFile(fileName);
    }

    public static IFolder getLockFolder(EObject element, ModelType model) {
        IFolder lockFolder = ShareUtils.getLockFolder((ModelType)model);
        if (lockFolder == null) {
            return null;
        }
        return LockFileUtils.getLockFolder(element.eClass(), lockFolder);
    }

    static IFolder getLockFolder(EClass eClass, IFolder lockFolder) {
        return lockFolder.getFolder(eClass.getName());
    }

    public static CollisionInfo getInfo(VcsStatus vcsStatus, IFile lockFile) {
        CollisionInfo info;
        block11: {
            if (lockFile != null && !lockFile.isSynchronized(0)) {
                try {
                    lockFile.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            info = CollisionInfo.DEFAULT;
            if (lockFile == null) {
                info = CollisionInfo.ADDED;
            } else if (!lockFile.exists()) {
                info = CollisionInfo.REMOVED;
            } else {
                String content = LockFileUtils.readLockFile(lockFile);
                if (content != null) {
                    int status = 0;
                    try {
                        status = Integer.parseInt(content);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (content.equals(ModelServerUtils.getUser(lockFile))) {
                            info = CollisionInfo.LOCKED_BY_USER;
                        }
                        info = CollisionInfo.LOCKED_BY_OTHER;
                        if (vcsStatus == null) break block11;
                        String lockOwner = vcsStatus.getLockOwner();
                        info = CollisionInfo.create(CollisionState.LOCKED_BY_OTHER, lockOwner == null ? vcsStatus.getLastCommitAuthor() : lockOwner);
                    }
                }
            }
        }
        return info;
    }
}

