/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;

public class ModelCopier
extends EcoreUtil.Copier {
    private static final long serialVersionUID = 1L;

    public void copy(ModelType source, ModelType target) {
        EClass eClass = source.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature feature = eClass.getEStructuralFeature(i);
            if (feature.isChangeable() && !feature.isDerived() && feature instanceof EAttribute) {
                this.copyAttribute((EAttribute)feature, (EObject)source, (EObject)target);
            }
            ++i;
        }
        ConnectionManager connectionManagerTarget = null;
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(target);
        if (editor != null) {
            connectionManagerTarget = editor.getConnectionManager();
        }
        if (connectionManagerTarget == null) {
            connectionManagerTarget = new ConnectionManager(target);
        }
        ConnectionManager connectionManagerSource = new ConnectionManager(source);
        connectionManagerTarget.getAllConnections().clear();
        connectionManagerTarget.save();
        ArrayList all = new ArrayList(connectionManagerSource.getAllConnections());
        for (Connection connection : all) {
            Connection copy = (Connection)EcoreUtil.copy((EObject)connection);
            connectionManagerTarget.setConnectionManager(copy);
            connectionManagerTarget.getAllConnections().add(copy);
        }
        connectionManagerTarget.save();
        ExternalPackages packages = source.getExternalPackages();
        if (packages != null) {
            if (target.getExternalPackages() == null) {
                ExternalPackages createExternalPackages = XpdlFactory.eINSTANCE.createExternalPackages();
                target.setExternalPackages(createExternalPackages);
            } else {
                target.getExternalPackages().getExternalPackage().clear();
            }
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                ExternalPackage copy = (ExternalPackage)EcoreUtil.copy((EObject)pkg);
                target.getExternalPackages().getExternalPackage().add((Object)copy);
            }
        } else {
            target.setExternalPackages(null);
        }
    }
}

