/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.model.xpdl.util.IConnection;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.AbstractMerger;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.OutlineMerger;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;
import org.eclipse.stardust.modeling.core.modelserver.CommitUtil;
import org.eclipse.stardust.modeling.core.modelserver.LockFileUtils;
import org.eclipse.stardust.modeling.core.modelserver.LockUtil;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerHelper;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.RevertUtil;
import org.eclipse.stardust.modeling.core.modelserver.UpdateUtil;
import org.eclipse.stardust.modeling.core.modelserver.Vcs;
import org.eclipse.stardust.modeling.core.modelserver.VcsStatus;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionInfo;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionState;
import org.eclipse.stardust.modeling.core.modelserver.jobs.JobUtils;
import org.eclipse.stardust.modeling.core.modelserver.jobs.StateCache;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ModelServer
extends ModelServerHelper {
    public static final String SHARE = "SHARE";
    public static final String UNSHARE = "UNSHARE";
    public static final String COMMIT = "COMMIT";
    public static final String REVERT = "REVERT";
    public static final String LOCK = "LOCK";
    public static final String LOCK_ALL = "LOCK_ALL";
    public static final String UNLOCK = "UNLOCK";
    public static final String UNLOCK_ALL = "UNLOCK_ALL";
    private boolean isModelShared = false;

    public ModelServer(ModelType model) {
        this.stateCache = new StateCache(this);
        this.model = model;
        this.retryConnection = 1000L * Long.parseLong(PlatformUI.getPreferenceStore().getString("collisionConnectionRetryRate"));
        this.retry = PlatformUI.getPreferenceStore().getBoolean("collisionRetry");
        this.isModelShared();
    }

    public boolean isLockedByUser() {
        if (!this.isModelShared) {
            return true;
        }
        EObject modelElement = this.cachedModelElement;
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)this.cachedModelElement);
        if (process != null) {
            modelElement = process;
        }
        if (ShareUtils.isLockableElement((Object)modelElement)) {
            VcsStatus lockInfo = this.getLockInfo(modelElement);
            if (!lockInfo.isLocked()) {
                return false;
            }
            if (lockInfo.isLocked() && lockInfo.isLockedByCurrentUser()) {
                return true;
            }
            if (lockInfo.getStatus() == 2) {
                return true;
            }
        }
        return false;
    }

    public void dispose() {
        if (this.jobUtils != null) {
            this.jobUtils.dispose();
        }
        this.stateCache = null;
    }

    public StateCache getStateCache() {
        return this.stateCache;
    }

    public boolean isAdaptableShared(IAdaptable adaptable) {
        EObject eObject = ModelUtils.getEObject((IAdaptable)adaptable);
        return this.isElementShared(eObject);
    }

    public boolean isElementShared(EObject eObject) {
        if (eObject == null) {
            return false;
        }
        if (!this.isModelShared()) {
            return false;
        }
        IFile lockFile = LockFileUtils.getLockFile(eObject);
        if (lockFile == null || !lockFile.exists()) {
            return false;
        }
        if (eObject instanceof ModelType) {
            return this.isModelShared();
        }
        return this.isShared(lockFile);
    }

    public boolean isModelShared() {
        if (!this.isProjectShared()) {
            return false;
        }
        IFolder modelLockFolder = this.getModelLockFolder();
        boolean bl = this.isModelShared = modelLockFolder != null && modelLockFolder.exists() && !StringUtils.isEmpty((String)UUIDUtils.getUUID((EObject)this.model));
        if (this.isModelShared) {
            IFile lockFile = LockFileUtils.getLockFile((EObject)this.model);
            this.isModelShared = this.isShared(lockFile);
            if (this.jobUtils == null) {
                this.jobUtils = new JobUtils(this);
            }
            if (this.isModelShared) {
                this.jobUtils.update();
            }
        }
        return this.isModelShared;
    }

    /*
     * Unable to fully structure code
     */
    public void unlockAll(IProgressMonitor monitor) throws RMSException {
        block28: {
            block27: {
                editor = GenericUtils.getWorkflowModelEditor(this.model);
                if (editor == null) {
                    throw new RMSException(Diagram_Messages.EXC_CANNOT_FIND_ASSOCIATED_WORKFLOW_MD_EDITOR, 0);
                }
                lockedElements = this.getStateCache().getAllLockedElements();
                lockfiles = new ArrayList<IFile>();
                if (lockedElements.size() == 0) {
                    return;
                }
                removeFromCache = new ArrayList<EObject>();
                for (EObject eObject : lockedElements) {
                    removeElement = CopyPasteUtil.getSameModelElement(eObject, this.getModel(), null);
                    removeFromCache.add(removeElement);
                }
                for (EObject element : lockedElements) {
                    lockFile = LockFileUtils.getLockFile(element);
                    lockfiles.add(lockFile);
                }
                if (monitor != null) {
                    monitor.beginTask(Diagram_Messages.TASK_UNLOCK_ALL, lockedElements.size() * 8 / 3);
                }
                try {
                    if (monitor != null) {
                        monitor.subTask(Diagram_Messages.TASK_READING_REMONTE_MD);
                    }
                    remoteModel = this.getRemoteModel(true);
                    if (monitor != null) {
                        monitor.worked(lockedElements.size() * 2 / 3);
                    }
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ModelServerUtils.mergeElements3(lockedElements, remoteModel, ModelServer.this.model);
                        }
                    });
                }
                catch (IOException e) {
                    this.refreshLocal(monitor);
                    if (editor != null) {
                        editor.doSave(monitor);
                        editor.getEditDomain().getCommandStack().flush();
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                    throw new RMSException(MessageFormat.format(Diagram_Messages.EXC_UNABLE_TO_READ_REMONTE_MD, new Object[]{e.getMessage()}), 1);
                }
                try {
                    try {
                        vcs = ModelServerUtils.getVcs(this.getProject());
                        for (EObject eObject : lockedElements) {
                            lockFile = LockFileUtils.getLockFile(eObject);
                            if (lockFile == null) continue;
                            try {
                                vcs.forceUnlock(new IFile[]{lockFile}, monitor);
                                LockFileUtils.setLockFile(lockFile, "0");
                                vcs.commit((IResource[])new IFile[]{lockFile}, "UNLOCK_ALL", false, monitor);
                                this.stateCache.setState(eObject, CollisionInfo.DEFAULT);
                            }
                            catch (Exception v0) {
                                this.stateCache.setState(eObject, CollisionInfo.DEFAULT);
                            }
                        }
                        break block27;
                    }
                    catch (Throwable v1) {
                        ** for (eObject : removeFromCache)
                    }
                }
                catch (Throwable var11_18) {
                    ** for (eObject : removeFromCache)
                }
lbl-1000:
                // 1 sources

                {
                    this.stateCache.remove(eObject);
                    continue;
                }
lbl57:
                // 1 sources

                this.refreshLocal(monitor);
                if (editor != null) {
                    editor.doSave(monitor);
                    editor.getEditDomain().getCommandStack().flush();
                }
                if (monitor != null) {
                    monitor.done();
                }
                break block28;
lbl-1000:
                // 1 sources

                {
                    this.stateCache.remove(eObject);
                    continue;
                }
lbl68:
                // 1 sources

                this.refreshLocal(monitor);
                if (editor != null) {
                    editor.doSave(monitor);
                    editor.getEditDomain().getCommandStack().flush();
                }
                if (monitor != null) {
                    monitor.done();
                }
                throw var11_18;
            }
            for (EObject eObject : removeFromCache) {
                this.stateCache.remove(eObject);
            }
            this.refreshLocal(monitor);
            if (editor != null) {
                editor.doSave(monitor);
                editor.getEditDomain().getCommandStack().flush();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public void lockAll(IProgressMonitor monitor) throws RMSException {
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(this.model);
        if (editor == null) {
            throw new RMSException(Diagram_Messages.EXC_CANNOT_FIND_ASSOCIATED_WORKFLOW_MD_EDITOR, 0);
        }
        List<EObject> elements = this.getStateCache().getElementsToLock();
        ArrayList<IFile> lockfiles = new ArrayList<IFile>();
        if (elements.size() == 0) {
            return;
        }
        LockUtil util = new LockUtil(editor);
        util.analyze(monitor);
        String updateElements = util.checkUpdateNeeded(elements);
        if (!StringUtils.isEmpty((String)updateElements)) {
            throw new RMSException(MessageFormat.format(String.valueOf(Diagram_Messages.EXC_UPDATE_NEEDED_FOR) + "\n", updateElements), 0);
        }
        for (EObject element : elements) {
            IFile lockFile = LockFileUtils.getLockFile(element);
            lockfiles.add(lockFile);
        }
        if (monitor != null) {
            monitor.beginTask(Diagram_Messages.TASK_LOCK_ALL_ELEMENTS, elements.size() + 2);
        }
        Vcs vcs = ModelServerUtils.getVcs(this.getProject());
        HashMap<EObject, String> failed = new HashMap<EObject, String>();
        for (EObject eObject : elements) {
            IFile file = LockFileUtils.getLockFile(eObject);
            if (file == null) continue;
            try {
                try {
                    if (monitor != null) {
                        monitor.subTask(this.getLabel(eObject));
                    }
                    this.lock(monitor, vcs, file, true);
                    LockFileUtils.setLockFile(file, ModelServerUtils.getUser(file));
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    this.commitLockFiles(new IResource[]{file}, true, LOCK_ALL);
                    this.stateCache.updateState(eObject, null);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
                catch (RMSException e) {
                    VcsStatus vcsStatus = vcs.getStatus((IResource)file);
                    if (vcsStatus.isLocked() && !vcsStatus.isLockedByCurrentUser()) {
                        String lockOwner = vcsStatus.getLockOwner();
                        CollisionInfo info = CollisionInfo.create(CollisionState.LOCKED_BY_OTHER, lockOwner == null ? vcsStatus.getLastCommitAuthor() : lockOwner);
                        this.stateCache.setState(eObject, info);
                        failed.put(eObject, vcsStatus.getLockOwner());
                    } else if (vcsStatus.isLocked() && vcsStatus.isLockedByCurrentUser()) {
                        this.stateCache.setState(eObject, CollisionInfo.LOCKED_BY_USER);
                    } else {
                        throw e;
                    }
                    this.refreshLocal(monitor);
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.refreshLocal(monitor);
                throw throwable;
            }
            this.refreshLocal(monitor);
        }
        if (!failed.isEmpty()) {
            final String message = LockUtil.getMessageLockedAlready(failed);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ModelServerUtils.showMessageBox(message);
                }
            });
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    public void updateLockFile(IFile file, IProgressMonitor monitor) throws RMSException {
        Vcs vcs = ModelServerUtils.getVcs(this.getProject());
        vcs.update((IResource[])new IFile[]{file}, monitor);
    }

    /*
     * Unable to fully structure code
     */
    public void revert(final RevertUtil revertUtil, IProgressMonitor monitor) throws RMSException {
        block20: {
            block19: {
                if (revertUtil.getSelectedElements().size() == 0) {
                    return;
                }
                if (monitor != null) {
                    monitor.beginTask(Diagram_Messages.TASK_REVERT_CHANGES, revertUtil.getSelectedElements().size());
                }
                removeFromCache = new ArrayList<EObject>();
                try {
                    try {
                        this.enableRefreshStatusJob = false;
                        this.jobUtils.sleep();
                        for (EObject eObject : revertUtil.getSelectedElements()) {
                            removeElement = CopyPasteUtil.getSameModelElement(eObject, this.getModel(), null);
                            if (removeElement == null) continue;
                            removeFromCache.add(removeElement);
                        }
                        if (!revertUtil.getSelectedElementsDeleted().isEmpty()) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    StoreObject storage = new StoreObject();
                                    storage.setCopySymbols(false);
                                    storage.setOriginalModelCopy(revertUtil.getRemoteModel());
                                    storage.setSourceModel(revertUtil.getRemoteModel());
                                    storage.setSameModel(true);
                                    storage.setCollision(StoreObject.UPDATE);
                                    OutlineMerger util = new OutlineMerger(ModelServer.this.model, revertUtil.getSelectedElementsDeleted(), storage);
                                    ((AbstractMerger)util).merge();
                                }
                            });
                        }
                        if (!revertUtil.getSelectedElementsOther().isEmpty()) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ModelServerUtils.mergeElements3(revertUtil.getSelectedElementsOther(), revertUtil.getRemoteModel(), ModelServer.this.model);
                                }
                            });
                        }
                        lockFolder = ShareUtils.getLockFolder((ModelType)this.model);
                        vcs = ModelServerUtils.getVcs(this.getProject());
                        for (EObject eObject : revertUtil.getSelectedElements()) {
                            elementLockFolder = LockFileUtils.getLockFolder(eObject.eClass(), lockFolder);
                            lockFile = LockFileUtils.getFile(elementLockFolder, eObject);
                            if (lockFile == null) continue;
                            vcs.unlock((IResource[])new IFile[]{lockFile}, monitor);
                            LockFileUtils.setLockFile(lockFile, "0");
                            vcs.commit((IResource[])new IFile[]{lockFile}, "REVERT", false, monitor);
                            this.stateCache.setState(eObject, CollisionInfo.DEFAULT);
                        }
                        break block19;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        ** for (eObject : removeFromCache)
                    }
                }
                catch (Throwable var10_17) {
                    ** for (eObject : removeFromCache)
                }
lbl-1000:
                // 1 sources

                {
                    this.stateCache.remove(eObject);
                    continue;
                }
lbl37:
                // 1 sources

                this.refreshLocal(monitor);
                editor = GenericUtils.getWorkflowModelEditor(this.model);
                if (editor != null) {
                    editor.doSave(monitor);
                    editor.getEditDomain().getCommandStack().flush();
                }
                if (monitor != null) {
                    monitor.done();
                }
                this.enableRefreshStatusJob = true;
                this.jobUtils.runRefreshJob();
                break block20;
lbl-1000:
                // 1 sources

                {
                    this.stateCache.remove(eObject);
                    continue;
                }
lbl51:
                // 1 sources

                this.refreshLocal(monitor);
                editor = GenericUtils.getWorkflowModelEditor(this.model);
                if (editor != null) {
                    editor.doSave(monitor);
                    editor.getEditDomain().getCommandStack().flush();
                }
                if (monitor != null) {
                    monitor.done();
                }
                this.enableRefreshStatusJob = true;
                this.jobUtils.runRefreshJob();
                throw var10_17;
            }
            for (EObject eObject : removeFromCache) {
                this.stateCache.remove(eObject);
            }
            this.refreshLocal(monitor);
            editor = GenericUtils.getWorkflowModelEditor(this.model);
            if (editor != null) {
                editor.doSave(monitor);
                editor.getEditDomain().getCommandStack().flush();
            }
            if (monitor != null) {
                monitor.done();
            }
            this.enableRefreshStatusJob = true;
            this.jobUtils.runRefreshJob();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void update(final UpdateUtil updateUtil, IProgressMonitor monitor) throws RMSException {
        block14: {
            block13: {
                editor = GenericUtils.getWorkflowModelEditor(this.model);
                if (editor == null) {
                    throw new RMSException(Diagram_Messages.EXC_CANNOT_FIND_ASSOCIATED_WORKFLOW_MD_EDITOR, 0);
                }
                remoteModelHead = updateUtil.getRemoteModel();
                removeFromCache = new ArrayList<EObject>();
                try {
                    try {
                        this.enableRefreshStatusJob = false;
                        this.jobUtils.sleep();
                        vcs = ModelServerUtils.getVcs(this.getProject());
                        if (!updateUtil.getSelectedElementsNew().isEmpty()) {
                            lockFolder = ShareUtils.getLockFolder((ModelType)this.model);
                            lockfiles = new ArrayList<IFile>();
                            for (EObject element : updateUtil.getSelectedElementsNew()) {
                                elementLockFolder = LockFileUtils.getLockFolder(element.eClass(), lockFolder);
                                lockFile = LockFileUtils.getFile(elementLockFolder, element);
                                lockfiles.add(lockFile);
                            }
                            files = lockfiles.toArray(new IResource[lockfiles.size()]);
                            vcs.update(files, monitor);
                        }
                        if (!updateUtil.getSelectedElementsNew().isEmpty()) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    StoreObject storage = new StoreObject();
                                    storage.setCopySymbols(false);
                                    storage.setOriginalModelCopy(remoteModelHead);
                                    storage.setSourceModel(remoteModelHead);
                                    storage.setSameModel(true);
                                    storage.setCollision(StoreObject.UPDATE);
                                    OutlineMerger util = new OutlineMerger(ModelServer.this.model, updateUtil.getSelectedElementsNew(), storage);
                                    ((AbstractMerger)util).merge();
                                }
                            });
                        }
                        for (EObject eObject : updateUtil.getSelectedElementsRemoved()) {
                            removeElement = CopyPasteUtil.getSameModelElement(eObject, this.getModel(), null);
                            removeFromCache.add(removeElement);
                        }
                        for (EObject eObject : updateUtil.getSelectedElementsChanged()) {
                            removeElement = CopyPasteUtil.getSameModelElement(eObject, this.getModel(), null);
                            removeFromCache.add(removeElement);
                        }
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ModelServerUtils.removeElements(updateUtil.getSelectedElementsRemoved(), ModelServer.this.model, ModelServer.this.getProject(), null);
                            }
                        });
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                ModelServerUtils.mergeElements3(updateUtil.getSelectedElementsChanged(), remoteModelHead, ModelServer.this.model);
                            }
                        });
                        MergeUtils.fixDuplicateOids((ModelType)this.model);
                        break block13;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        ** for (eObject : removeFromCache)
                    }
                }
                catch (Throwable var13_20) {
                    ** for (eObject : removeFromCache)
                }
lbl-1000:
                // 1 sources

                {
                    this.stateCache.remove(eObject);
                    continue;
                }
lbl43:
                // 1 sources

                this.refreshLocal(monitor);
                editor.getEditDomain().getCommandStack().flush();
                editor.doSave(monitor);
                this.enableRefreshStatusJob = true;
                this.jobUtils.runRefreshJob();
                break block14;
lbl-1000:
                // 1 sources

                {
                    this.stateCache.remove(eObject);
                    continue;
                }
lbl53:
                // 1 sources

                this.refreshLocal(monitor);
                editor.getEditDomain().getCommandStack().flush();
                editor.doSave(monitor);
                this.enableRefreshStatusJob = true;
                this.jobUtils.runRefreshJob();
                throw var13_20;
            }
            for (EObject eObject : removeFromCache) {
                this.stateCache.remove(eObject);
            }
            this.refreshLocal(monitor);
            editor.getEditDomain().getCommandStack().flush();
            editor.doSave(monitor);
            this.enableRefreshStatusJob = true;
            this.jobUtils.runRefreshJob();
        }
    }

    public void updateModelFile(IProgressMonitor monitor) throws RMSException {
        IFile modelFile = ModelServerUtils.getModelFile(this.model);
        Vcs vcs = ModelServerUtils.getVcs(this.getProject());
        vcs.update(new IResource[]{modelFile}, monitor);
        vcs.resolve(new IResource[]{modelFile}, monitor);
    }

    public void share() throws RMSException, IOException {
        ModelType remoteModel;
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(this.model);
        if (editor == null) {
            throw new RMSException(Diagram_Messages.EXC_CANNOT_FIND_ASSOCIATED_WORKFLOW_MD_EDITOR, 0);
        }
        final IFile modelFile = ModelServerUtils.getModelFile(this.model);
        final Vcs vcs = ModelServerUtils.getVcs(this.getProject());
        boolean isShared = false;
        try {
            isShared = vcs.isShared((IResource)modelFile, false);
        }
        catch (RMSException e) {
            ModelServerUtils.showMessageBox(e.getMessage());
        }
        if (isShared && !StringUtils.isEmpty((String)UUIDUtils.getUUID((EObject)(remoteModel = this.getRemoteModel(false))))) {
            throw new RMSException(Diagram_Messages.MSG_MODEL_ALREADY_SHARED, 6);
        }
        IRunnableWithProgress commitOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        block10: {
                            monitor.beginTask(String.valueOf(Diagram_Messages.LB_CREATE_CACHE_JOB) + ModelServer.this.getModelName(), 100);
                            ModelServer.this.setCreateLockFilesFinished(null);
                            try {
                                try {
                                    ModelServerUtils.createLockFiles(ModelServer.this.getProject(), ModelServer.this.getModel());
                                    IFolder lockFolder = ShareUtils.getLockFolder((ModelType)ModelServer.this.model);
                                    vcs.add(new IResource[]{modelFile, lockFolder}, monitor);
                                    vcs.commit(new IResource[]{modelFile, lockFolder}, "SHARE/" + ModelServer.this.model.getId(), false, monitor);
                                    IFile file = ModelServer.this.getCacheFile(modelFile, vcs);
                                    modelFile.copy(file.getFullPath(), true, null);
                                }
                                catch (CoreException coreException) {
                                    monitor.worked(100);
                                    monitor.done();
                                    break block10;
                                }
                            }
                            catch (Throwable throwable) {
                                monitor.worked(100);
                                monitor.done();
                                throw throwable;
                            }
                            monitor.worked(100);
                            monitor.done();
                        }
                        ModelServer.this.setCreateLockFilesFinished(Boolean.TRUE);
                    }
                    catch (RMSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    ModelServer.this.refreshLocal(monitor);
                }
            }
        };
        try {
            new ProgressMonitorDialog(editor.getSite().getShell()).run(true, true, commitOperation);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            ModelServerUtils.showMessageBox(t.getMessage());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void unshare(IProgressMonitor monitor) throws RMSException {
        this.enableRefreshStatusJob = false;
        this.jobUtils.cancel();
        this.jobUtils = null;
        Vcs vcs = ModelServerUtils.getVcs(this.project);
        ArrayList<IFile> lockfiles = new ArrayList<IFile>();
        Map<String, EObject> localMap = ModelServerUtils.createUuidToElementMap(this.model);
        for (Map.Entry<String, EObject> entry : localMap.entrySet()) {
            VcsStatus lockInfo;
            EObject element = entry.getValue();
            if (!ShareUtils.isLockableElement((Object)element) || !LockFileUtils.getLockFile(element).exists() || !(lockInfo = this.getLockInfo(element)).isLockedByCurrentUser()) continue;
            IFile file = LockFileUtils.getLockFile(element);
            lockfiles.add(file);
        }
        if (lockfiles.size() > 0) {
            IFile[] files = lockfiles.toArray(new IFile[lockfiles.size()]);
            vcs.unlock((IResource[])files, monitor);
            this.commitLockFiles((IResource[])files, false, "UNSHARE/" + this.model.getId());
        }
        UUIDUtils.unsetUUID((EObject)this.model);
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getTypeDeclarations().getTypeDeclaration());
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getApplication());
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getData());
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getRole());
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getConditionalPerformer());
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getOrganization());
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getProcessDefinition());
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getDiagram());
        ModelServerUtils.unsetUUIDs((List<? extends EObject>)this.model.getLinkType());
        try {
            this.getModelLockFolder().delete(true, monitor);
        }
        catch (CoreException coreException) {
            throw new RMSException(Diagram_Messages.EXC_CANNOT_NOT_DELETE_LOCK_FOLDER, 0);
        }
        this.modelLockFolder = null;
        try {
            this.getProject().refreshLocal(2, monitor);
        }
        catch (CoreException coreException) {}
    }

    public void lock(EObject[] lockables, IProgressMonitor monitor) throws RMSException {
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(this.model);
        if (editor == null) {
            throw new RMSException(Diagram_Messages.EXC_CANNOT_FIND_ASSOCIATED_WORKFLOW_MD_EDITOR, 0);
        }
        if (monitor != null) {
            monitor.beginTask(Diagram_Messages.TASK_LOCK_ELEMENTS, lockables.length + 5);
        }
        LockUtil util = new LockUtil(editor);
        util.analyze(monitor);
        String updateElements = util.checkUpdateNeeded(Arrays.asList(lockables));
        if (!StringUtils.isEmpty((String)updateElements)) {
            throw new RMSException(MessageFormat.format(Diagram_Messages.EXC_UPDATE_NEEDED_FOR, updateElements), 0);
        }
        Vcs vcs = ModelServerUtils.getVcs(this.getProject());
        int i = 0;
        while (i < lockables.length) {
            EObject eObject = lockables[i];
            IFile file = LockFileUtils.getLockFile(eObject);
            if (file == null) {
                return;
            }
            try {
                try {
                    if (monitor != null) {
                        monitor.subTask(this.getLabel(eObject));
                    }
                    this.lock(monitor, vcs, file, true);
                    LockFileUtils.setLockFile(file, ModelServerUtils.getUser(file));
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    this.commitLockFiles(new IResource[]{file}, true, LOCK);
                    this.stateCache.updateState(eObject, null);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                }
                catch (RMSException e) {
                    VcsStatus vcsStatus = vcs.getStatus((IResource)file);
                    if (vcsStatus.isLocked() && !vcsStatus.isLockedByCurrentUser()) {
                        String lockOwner = vcsStatus.getLockOwner();
                        CollisionInfo info = CollisionInfo.create(CollisionState.LOCKED_BY_OTHER, lockOwner == null ? vcsStatus.getLastCommitAuthor() : lockOwner);
                        this.stateCache.setState(eObject, info);
                        throw new RMSException(MessageFormat.format(Diagram_Messages.EXC_ALREADY_LOCKED_BY, vcsStatus.getLockOwner()), 3);
                    }
                    throw e;
                }
            }
            finally {
                this.refreshLocal(monitor);
            }
            ++i;
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    private void lock(IProgressMonitor monitor, Vcs vcs, IFile file, boolean update) throws RMSException {
        try {
            vcs.lock((IResource[])new IFile[]{file}, monitor);
        }
        catch (RMSException e) {
            if (e.getType() == 4 && update) {
                this.updateLockFile(file, monitor);
                this.lock(monitor, vcs, file, false);
            }
            throw e;
        }
    }

    public void lock(IAdaptable adaptable, IProgressMonitor monitor) throws RMSException {
        EObject eObject = ModelUtils.getEObject((IAdaptable)adaptable);
        IFile file = LockFileUtils.getLockFile(eObject);
        if (file == null) {
            return;
        }
        this.lock(new EObject[]{eObject}, monitor);
    }

    public void commitLockFiles(IResource[] lockFiles, boolean keepLock, String comment) throws RMSException {
        Vcs vcs = ModelServerUtils.getVcs(this.getProject());
        try {
            vcs.commit(lockFiles, comment, keepLock, null);
        }
        catch (RMSException rMSException) {}
    }

    public String getLabel(EObject element) {
        String type = element.eClass().getName();
        String name = "";
        if (element instanceof IIdentifiableElement) {
            name = ((IIdentifiableElement)element).getName();
        } else if (element instanceof DiagramType) {
            name = ((DiagramType)element).getName();
        }
        if (element instanceof TypeDeclarationType) {
            name = ((TypeDeclarationType)element).getName();
        }
        return String.valueOf(type) + ": " + name;
    }

    public Image getIcon(Image image, EObject eObjectModel) {
        StateCache stateCache = this.getStateCache();
        CollisionInfo info = stateCache.getState(eObjectModel);
        switch (info.getState()) {
            case LOCKED_BY_USER: {
                return ModelServerUtils.getIconWithOverlay(image, ModelServerUtils.imageLocked, 3);
            }
            case LOCKED_BY_OTHER: {
                return ModelServerUtils.getIconWithOverlay(image, ModelServerUtils.imageProtected, 3);
            }
            case REMOVED: {
                return ModelServerUtils.getIconWithOverlay(image, ModelServerUtils.imageDeleted, 1);
            }
            case ADDED: {
                return ModelServerUtils.getIconWithOverlay(image, ModelServerUtils.imageAdded, 1);
            }
        }
        return ModelServerUtils.getIconWithOverlay(image, ModelServerUtils.imageVCS, 3);
    }

    public void commit(CommitUtil commitUtil, List<EObject> checkedElements, String commitString, boolean keepLocks, IProgressMonitor monitor) throws RMSException {
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(this.model);
        if (editor == null) {
            throw new RMSException(Diagram_Messages.EXC_CANNOT_FIND_ASSOCIATED_WORKFLOW_MD_EDITOR, 0);
        }
        try {
            this.enableRefreshStatusJob = false;
            this.jobUtils.sleep();
            editor.getEditorChangeTracker().setEnabled(false);
            try {
                this.updateModelFile(monitor);
                this.doCommit(commitUtil, checkedElements, commitString, keepLocks, monitor);
                MergeUtils.fixDuplicateOids((ModelType)this.model);
                editor.getEditDomain().getCommandStack().flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        finally {
            this.refreshLocal(monitor);
            editor.doSave(monitor);
            editor.getEditorChangeTracker().setEnabled(true);
            this.enableRefreshStatusJob = true;
            this.jobUtils.runRefreshJob();
        }
    }

    public void refreshLocal(IProgressMonitor monitor) {
        try {
            this.getModelLockFolder().refreshLocal(2, monitor);
        }
        catch (Exception exception) {}
    }

    private void doCommit(CommitUtil commitUtil, List<EObject> checkedElements, String commitString, boolean keepLocks, IProgressMonitor monitor) throws RMSException {
        EObject element;
        boolean userCanceled = false;
        Map<Object, Object> changedCache = new HashMap();
        IFile modelFile = ModelServerUtils.getModelFile(this.model);
        Vcs vcs = ModelServerUtils.getVcs(this.getProject());
        IFolder lockFolder = ShareUtils.getLockFolder((ModelType)this.model);
        ModelType remoteModel = commitUtil.getRemoteModel();
        List<EObject> selectedElementsNew = commitUtil.getSelectedElementsNew();
        if (!selectedElementsNew.isEmpty()) {
            for (EObject newObject : selectedElementsNew) {
                UUIDUtils.setUUID((EObject)newObject);
            }
            StoreObject storage = new StoreObject();
            storage.setCopySymbols(false);
            storage.setOriginalModelCopy(commitUtil.getLocalModel());
            storage.setSourceModel(this.model);
            storage.setSameModel(true);
            storage.setCollision(StoreObject.COMMIT);
            final OutlineMerger util = new OutlineMerger(remoteModel, selectedElementsNew, storage);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    util.merge();
                }
            });
            if (!util.modelChanged()) {
                userCanceled = true;
            } else {
                changedCache = util.getChangedCache();
            }
        }
        if (userCanceled) {
            throw new RMSException(Diagram_Messages.EXC_USER_CANCELED_COMMIT, 7);
        }
        if (!selectedElementsNew.isEmpty()) {
            ArrayList<IFile> lockfiles = new ArrayList<IFile>();
            for (EObject element2 : selectedElementsNew) {
                IFile lockFile;
                EObject sameElement = CopyPasteUtil.getSameModelElement(element2, this.model, null);
                UUIDUtils.setUUID((EObject)sameElement, (String)UUIDUtils.getUUID((EObject)element2));
                try {
                    lockFile = ModelServerUtils.createLockFileIfNotExists(lockFolder, sameElement, 0);
                }
                catch (Exception e) {
                    throw new RMSException(e.getMessage(), 8);
                }
                this.stateCache.setState(element2, CollisionInfo.DEFAULT);
                lockfiles.add(lockFile);
            }
            IResource[] files = lockfiles.toArray(new IResource[lockfiles.size()]);
            vcs.add(files, monitor);
        }
        IResource[] removeFiles = ModelServerUtils.removeElements(commitUtil.getSelectedElementsRemoved(), remoteModel, this.getProject(), this.model);
        if (!commitUtil.getSelectedElementsRemoved().isEmpty()) {
            List<EObject> elements = commitUtil.getSelectedElementsRemoved();
            for (EObject element3 : elements) {
                this.stateCache.remove(element3);
            }
        }
        ArrayList<IFile> lockfiles = new ArrayList<IFile>();
        int i = 0;
        while (i < checkedElements.size()) {
            element = checkedElements.get(i);
            IFolder elementLockFolder = LockFileUtils.getLockFolder(element.eClass(), lockFolder);
            IFile lockFile = LockFileUtils.getFile(elementLockFolder, element);
            if (!keepLocks && !commitUtil.isRemovedElement(element)) {
                LockFileUtils.setLockFile(lockFile, "0");
            }
            lockfiles.add(lockFile);
            ++i;
        }
        ModelServerUtils.mergeElements2(commitUtil.getSelectedElementsChanged(), commitUtil.getLocalModel(), remoteModel);
        try {
            String commitText = ModelServerUtils.convertCommitString(commitString);
            WorkflowModelManager remoteModelManager = new WorkflowModelManager(remoteModel.eResource());
            remoteModelManager.save(URI.createPlatformResourceURI((String)modelFile.getFullPath().toString(), (boolean)false));
            if (removeFiles.length > 0) {
                vcs.delete(removeFiles, monitor);
            }
            lockfiles.add(modelFile);
            IFile[] comitFiles = lockfiles.toArray(new IFile[lockfiles.size()]);
            vcs.commit((IResource[])comitFiles, "COMMIT/" + commitText.trim(), keepLocks, monitor);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!changedCache.isEmpty()) {
            final HashMap cache = changedCache;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    CopyPasteUtil.replaceChangedNames(cache, ModelServer.this.model);
                }
            });
        }
        i = 0;
        while (i < checkedElements.size()) {
            element = checkedElements.get(i);
            if (!commitUtil.isRemovedElement(element)) {
                EObject sameElement = CopyPasteUtil.getSameModelElement(element, this.model, null);
                this.getStateCache().updateState(sameElement, null);
            }
            ++i;
        }
    }

    public boolean requireLock(EObject eObject) {
        if (this.isModelShared()) {
            if (eObject instanceof IConnection) {
                eObject = this.getModel();
            }
            while (eObject != null && !ShareUtils.isLockableElement((Object)eObject)) {
                eObject = eObject.eContainer();
            }
            if (eObject != null) {
                CollisionInfo info = this.getStateCache().getState(eObject);
                CollisionState state = info.getState();
                return state != CollisionState.LOCKED_BY_USER && state != CollisionState.ADDED;
            }
        }
        return false;
    }

    public EObject getLockableElement(EObject eObject) {
        while (eObject != null && !ShareUtils.isLockableElement((Object)eObject)) {
            eObject = eObject.eContainer();
        }
        return eObject;
    }
}

