/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.modelserver.LockFileUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionInfo;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionState;
import org.eclipse.stardust.modeling.core.modelserver.jobs.StateCache;
import org.eclipse.stardust.modeling.core.modelserver.ui.ModelContainer;

public class RevertUtil {
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private WorkflowModelEditor editor;
    private ModelType localModel;
    private ModelType remoteModelHead;
    private Map<String, EObject> localMap;
    private Map<String, EObject> remoteMapHead;
    private List<EObject> lockedElements = new ArrayList<EObject>();
    private List<EObject> deletedElements = new ArrayList<EObject>();
    private List<EObject> otherElements = new ArrayList<EObject>();
    private List<EObject> selectedElements;

    public RevertUtil(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    public WorkflowModelEditor getEditor() {
        return this.editor;
    }

    public List<EObject> getDeletedElements() {
        return this.deletedElements;
    }

    public void analyze(IProgressMonitor monitor) throws RMSException {
        monitor.beginTask(Diagram_Messages.TASK_PREPARING_FOR_REVERT, 3);
        monitor.subTask(Diagram_Messages.TASK_READING_LOCAL_MD);
        ModelServer modelServer = this.editor.getModelServer();
        ModelType model = modelServer.getModel();
        StateCache stateCache = modelServer.getStateCache();
        WorkflowModelManager manager = new WorkflowModelManager();
        Resource resource = model.eResource();
        try {
            manager.load(resource.getURI());
        }
        catch (IOException iOException) {
            throw new RMSException("...", 0);
        }
        this.localModel = manager.getModel();
        monitor.subTask(Diagram_Messages.TASK_READING_REMONTE_MD);
        try {
            this.remoteModelHead = modelServer.getRemoteModel(true);
        }
        catch (IOException iOException) {
            throw new RMSException("...", 1);
        }
        if (this.remoteModelHead == null) {
            throw new RMSException(Diagram_Messages.EXC_JOB_FAILED, 0);
        }
        monitor.subTask(Diagram_Messages.TASK_ANALYZING_DIFFERENCES);
        this.localMap = ModelServerUtils.createUuidToElementMap(this.localModel);
        this.remoteMapHead = ModelServerUtils.createUuidToElementMap(this.remoteModelHead);
        HashMap<String, EObject> remoteMapClone = new HashMap<String, EObject>(this.remoteMapHead);
        HashMap<String, EObject> localMapClone = new HashMap<String, EObject>(this.localMap);
        localMapClone.keySet().removeAll(this.remoteMapHead.keySet());
        remoteMapClone.keySet().removeAll(this.localMap.keySet());
        ArrayList tempNewElements = new ArrayList(remoteMapClone.values());
        for (EObject element : tempNewElements) {
            IFolder folder;
            IFile lockFile;
            if (!LockFileUtils.hasLockFile(element, modelServer.getModel()) || LockFileUtils.getInfo(null, lockFile = LockFileUtils.getFile(folder = LockFileUtils.getLockFolder(element, model), element)) != CollisionInfo.LOCKED_BY_USER) continue;
            this.deletedElements.add(element);
            this.lockedElements.add(element);
        }
        for (Map.Entry<String, EObject> entry : this.localMap.entrySet()) {
            EObject sameElement;
            CollisionInfo stateInfo;
            EObject element = entry.getValue();
            if (!ShareUtils.isLockableElement((Object)element) || !LockFileUtils.hasLockFile(element, modelServer.getModel()) || (stateInfo = stateCache.getState(sameElement = CopyPasteUtil.getSameModelElement(element, model, null))).getState() != CollisionState.LOCKED_BY_USER) continue;
            this.otherElements.add(element);
            this.lockedElements.add(element);
        }
    }

    public List<EObject> getSelectedElementsDeleted() {
        ArrayList<EObject> elements = new ArrayList<EObject>(this.deletedElements);
        elements.retainAll(this.selectedElements);
        return elements;
    }

    public List<EObject> getSelectedElementsOther() {
        ArrayList<EObject> elements = new ArrayList<EObject>(this.otherElements);
        elements.retainAll(this.selectedElements);
        ModelServer modelServer = this.editor.getModelServer();
        ModelType model = modelServer.getModel();
        ArrayList<EObject> tmpElements = new ArrayList<EObject>();
        for (EObject element : elements) {
            EObject sameElement = CopyPasteUtil.getSameElement(element, (EObject)model);
            tmpElements.add(sameElement);
        }
        return tmpElements;
    }

    public List<EObject> getLockedElements() {
        return this.lockedElements;
    }

    public ModelType getLocalModel() {
        return this.localModel;
    }

    public List<EObject> getSelectedElements() {
        return this.selectedElements;
    }

    public void setUpdateContent(ModelContainer.Container container) {
        if (this.lockedElements.contains(this.localModel)) {
            container.setModel(this.localModel);
        }
        ArrayList<EObject> typeDeclarations = new ArrayList<EObject>();
        typeDeclarations.addAll((Collection<EObject>)this.localModel.getTypeDeclarations().getTypeDeclaration());
        typeDeclarations.retainAll(this.lockedElements);
        typeDeclarations.addAll(this.getDeletedElements(XpdlPackage.eINSTANCE.getTypeDeclarationType()));
        if (!typeDeclarations.isEmpty()) {
            container.getTypeDeclarations().getContent().addAll(typeDeclarations);
        }
        ArrayList<EObject> applications = new ArrayList<EObject>();
        applications.addAll((Collection<EObject>)this.localModel.getApplication());
        applications.retainAll(this.lockedElements);
        applications.addAll(this.getDeletedElements(PKG_CWM.getApplicationType()));
        if (!applications.isEmpty()) {
            container.getApplications().getContent().addAll(applications);
        }
        ArrayList<EObject> datas = new ArrayList<EObject>();
        datas.addAll((Collection<EObject>)this.localModel.getData());
        datas.retainAll(this.lockedElements);
        datas.addAll(this.getDeletedElements(PKG_CWM.getDataType()));
        if (!datas.isEmpty()) {
            container.getDatas().getContent().addAll(datas);
        }
        ArrayList<EObject> participants = new ArrayList<EObject>();
        participants.addAll((Collection<EObject>)this.localModel.getRole());
        participants.addAll((Collection<EObject>)this.localModel.getConditionalPerformer());
        participants.addAll((Collection<EObject>)this.localModel.getOrganization());
        participants.retainAll(this.lockedElements);
        participants.addAll(this.getDeletedElements(PKG_CWM.getRoleType()));
        participants.addAll(this.getDeletedElements(PKG_CWM.getConditionalPerformerType()));
        participants.addAll(this.getDeletedElements(PKG_CWM.getOrganizationType()));
        if (!participants.isEmpty()) {
            container.getParticipants().getContent().addAll(participants);
        }
        ArrayList<EObject> processDefinitions = new ArrayList<EObject>();
        processDefinitions.addAll((Collection<EObject>)this.localModel.getProcessDefinition());
        processDefinitions.retainAll(this.lockedElements);
        processDefinitions.addAll(this.getDeletedElements(PKG_CWM.getProcessDefinitionType()));
        if (!processDefinitions.isEmpty()) {
            container.setProcessDefinitions(processDefinitions);
        }
        ArrayList<EObject> diagrams = new ArrayList<EObject>();
        diagrams.addAll((Collection<EObject>)this.localModel.getDiagram());
        diagrams.retainAll(this.lockedElements);
        diagrams.addAll(this.getDeletedElements(PKG_CWM.getDiagramType()));
        if (!diagrams.isEmpty()) {
            container.setDiagrams(diagrams);
        }
        ArrayList<EObject> linkTypes = new ArrayList<EObject>();
        linkTypes.addAll((Collection<EObject>)this.localModel.getLinkType());
        linkTypes.retainAll(this.lockedElements);
        linkTypes.addAll(this.getDeletedElements(PKG_CWM.getLinkTypeType()));
        if (!linkTypes.isEmpty()) {
            container.setLinkTypes(linkTypes);
        }
    }

    private List<EObject> getDeletedElements(EClass model) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        int i = 0;
        while (i < this.deletedElements.size()) {
            EObject element = this.deletedElements.get(i);
            if (element.eClass().equals(model)) {
                elements.add(element);
            }
            ++i;
        }
        return elements;
    }

    public List<EObject> getEObjectsFromSelection(Object[] elements) {
        this.selectedElements = new ArrayList<EObject>();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            if (object instanceof EObject) {
                this.selectedElements.add((EObject)object);
            }
            ++i;
        }
        return this.selectedElements;
    }

    public ModelType getRemoteModel() {
        return this.remoteModelHead;
    }
}

