/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.modelserver.IMergeUtils;
import org.eclipse.stardust.modeling.core.modelserver.LockFileUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionInfo;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionState;
import org.eclipse.stardust.modeling.core.modelserver.jobs.StateCache;
import org.eclipse.stardust.modeling.core.modelserver.ui.ModelContainer;

public class UpdateUtil
implements IMergeUtils {
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private WorkflowModelEditor editor;
    private ModelType localModel;
    private ModelType remoteModelHead;
    private Map<String, EObject> localMap;
    private Map<String, EObject> remoteMapHead;
    private List<EObject> lockedElements = new ArrayList<EObject>();
    private List<EObject> newElements = new ArrayList<EObject>();
    private List<EObject> removedElements = new ArrayList<EObject>();
    private List<EObject> changedElements = new ArrayList<EObject>();
    private List<EObject> unChangedElements = new ArrayList<EObject>();
    private List<EObject> allElements = new ArrayList<EObject>();
    private List<EObject> selectedElements;

    public UpdateUtil(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    public void analyze(IProgressMonitor monitor) throws RMSException {
        monitor.beginTask(Diagram_Messages.TASK_PREPARING_FOR_UPDATE, 3);
        monitor.subTask(Diagram_Messages.TASK_READING_LOCAL_MD);
        ModelServer modelServer = this.editor.getModelServer();
        ModelType model = modelServer.getModel();
        StateCache stateCache = modelServer.getStateCache();
        WorkflowModelManager manager = new WorkflowModelManager();
        Resource resource = model.eResource();
        try {
            manager.load(resource.getURI());
        }
        catch (IOException iOException) {
            throw new RMSException("...", 0);
        }
        this.localModel = manager.getModel();
        monitor.subTask(Diagram_Messages.TASK_REMOTE_MD);
        try {
            this.remoteModelHead = modelServer.getRemoteModel(true);
        }
        catch (IOException iOException) {
            throw new RMSException("...", 1);
        }
        if (this.remoteModelHead == null) {
            throw new RMSException(Diagram_Messages.EXC_JOB_FAILED, 0);
        }
        monitor.subTask(Diagram_Messages.TASK_ANALYZING_DIFFERENCES);
        this.localMap = ModelServerUtils.createUuidToElementMap(this.localModel);
        this.remoteMapHead = ModelServerUtils.createUuidToElementMap(this.remoteModelHead);
        HashMap<String, EObject> remoteMapClone = new HashMap<String, EObject>(this.remoteMapHead);
        HashMap<String, EObject> localMapClone = new HashMap<String, EObject>(this.localMap);
        localMapClone.keySet().removeAll(this.remoteMapHead.keySet());
        this.removedElements.addAll(localMapClone.values());
        remoteMapClone.keySet().removeAll(this.localMap.keySet());
        ArrayList tempNewElements = new ArrayList(remoteMapClone.values());
        for (EObject element : tempNewElements) {
            if (LockFileUtils.hasLockFile(element, modelServer.getModel())) continue;
            this.newElements.add(element);
        }
        if (!this.removedElements.isEmpty()) {
            this.allElements.addAll(this.removedElements);
            this.localMap.values().removeAll(this.removedElements);
        }
        if (!this.newElements.isEmpty()) {
            this.allElements.addAll(this.newElements);
            this.localMap.values().removeAll(this.newElements);
        }
        for (Map.Entry<String, EObject> entry : this.localMap.entrySet()) {
            EObject element = entry.getValue();
            if (!ShareUtils.isLockableElement((Object)element) || !LockFileUtils.hasLockFile(element, modelServer.getModel())) continue;
            boolean changed = ModelServerUtils.isChanged(element, ModelServerUtils.findByUUID(this.remoteModelHead, UUIDUtils.getUUID((EObject)element)));
            if (changed) {
                this.changedElements.add(element);
                EObject sameElement = CopyPasteUtil.getSameModelElement(element, model, null);
                CollisionInfo stateInfo = stateCache.getState(sameElement);
                if (stateInfo.getState() == CollisionState.LOCKED_BY_USER) continue;
                this.allElements.add(element);
                continue;
            }
            this.unChangedElements.add(element);
        }
    }

    public List<EObject> getLockedElements() {
        return this.lockedElements;
    }

    public ModelType getLocalModel() {
        return this.localModel;
    }

    public boolean containsChanges() {
        return !this.allElements.isEmpty();
    }

    public List<EObject> getSelectedElements() {
        return this.selectedElements;
    }

    public List<EObject> getNotSelectedElementsRemoved() {
        ArrayList<EObject> elements = new ArrayList<EObject>(this.removedElements);
        elements.removeAll(this.getSelectedElementsRemoved());
        return elements;
    }

    public List<EObject> getNotSelectedElementsNew() {
        ArrayList<EObject> elements = new ArrayList<EObject>(this.newElements);
        elements.removeAll(this.getSelectedElementsNew());
        return elements;
    }

    public List<EObject> getSelectedElementsNew() {
        ArrayList<EObject> elements = new ArrayList<EObject>(this.newElements);
        elements.retainAll(this.selectedElements);
        return elements;
    }

    public List<EObject> getSelectedElementsRemoved() {
        ArrayList<EObject> elements = new ArrayList<EObject>(this.removedElements);
        elements.retainAll(this.selectedElements);
        return elements;
    }

    public List<EObject> getSelectedElementsChanged() {
        ModelServer modelServer = this.editor.getModelServer();
        ModelType model = modelServer.getModel();
        ArrayList<EObject> tmpChangedElements = new ArrayList<EObject>();
        ArrayList<EObject> elements = new ArrayList<EObject>(this.changedElements);
        elements.retainAll(this.selectedElements);
        for (EObject element : elements) {
            EObject sameElement = CopyPasteUtil.getSameElement(element, (EObject)model);
            tmpChangedElements.add(sameElement);
        }
        return tmpChangedElements;
    }

    public void setUpdateContent(ModelContainer.Container container) {
        if (this.changedElements.contains(this.localModel)) {
            container.setModel(this.localModel);
        }
        ArrayList<EObject> typeDeclarations = new ArrayList<EObject>();
        typeDeclarations.addAll((Collection<EObject>)this.localModel.getTypeDeclarations().getTypeDeclaration());
        typeDeclarations.retainAll(this.allElements);
        typeDeclarations.addAll(this.getAddedElements(XpdlPackage.eINSTANCE.getTypeDeclarationType()));
        if (!typeDeclarations.isEmpty()) {
            container.getTypeDeclarations().getContent().addAll(typeDeclarations);
        }
        ArrayList<EObject> applications = new ArrayList<EObject>();
        applications.addAll((Collection<EObject>)this.localModel.getApplication());
        applications.retainAll(this.allElements);
        applications.addAll(this.getAddedElements(PKG_CWM.getApplicationType()));
        if (!applications.isEmpty()) {
            container.getApplications().getContent().addAll(applications);
        }
        ArrayList<EObject> datas = new ArrayList<EObject>();
        datas.addAll((Collection<EObject>)this.localModel.getData());
        datas.retainAll(this.allElements);
        datas.addAll(this.getAddedElements(PKG_CWM.getDataType()));
        if (!datas.isEmpty()) {
            container.getDatas().getContent().addAll(datas);
        }
        ArrayList<EObject> participants = new ArrayList<EObject>();
        participants.addAll((Collection<EObject>)this.localModel.getRole());
        participants.addAll((Collection<EObject>)this.localModel.getConditionalPerformer());
        participants.addAll((Collection<EObject>)this.localModel.getOrganization());
        participants.retainAll(this.allElements);
        participants.addAll(this.getAddedElements(PKG_CWM.getRoleType()));
        participants.addAll(this.getAddedElements(PKG_CWM.getConditionalPerformerType()));
        participants.addAll(this.getAddedElements(PKG_CWM.getOrganizationType()));
        if (!participants.isEmpty()) {
            container.getParticipants().getContent().addAll(participants);
        }
        ArrayList<EObject> processDefinitions = new ArrayList<EObject>();
        processDefinitions.addAll((Collection<EObject>)this.localModel.getProcessDefinition());
        processDefinitions.retainAll(this.allElements);
        processDefinitions.addAll(this.getAddedElements(PKG_CWM.getProcessDefinitionType()));
        if (!processDefinitions.isEmpty()) {
            container.setProcessDefinitions(processDefinitions);
        }
        ArrayList<EObject> diagrams = new ArrayList<EObject>();
        diagrams.addAll((Collection<EObject>)this.localModel.getDiagram());
        diagrams.retainAll(this.allElements);
        diagrams.addAll(this.getAddedElements(PKG_CWM.getDiagramType()));
        if (!diagrams.isEmpty()) {
            container.setDiagrams(diagrams);
        }
        ArrayList<EObject> linkTypes = new ArrayList<EObject>();
        linkTypes.addAll((Collection<EObject>)this.localModel.getLinkType());
        linkTypes.retainAll(this.allElements);
        linkTypes.addAll(this.getAddedElements(PKG_CWM.getLinkTypeType()));
        if (!linkTypes.isEmpty()) {
            container.setLinkTypes(linkTypes);
        }
    }

    private List<EObject> getAddedElements(EClass model) {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        int i = 0;
        while (i < this.newElements.size()) {
            EObject element = this.newElements.get(i);
            if (element.eClass().equals(model)) {
                elements.add(element);
            }
            ++i;
        }
        return elements;
    }

    public List<EObject> getUnChangedElements() {
        return this.unChangedElements;
    }

    @Override
    public boolean isRemovedElement(EObject element) {
        return this.removedElements.contains(element);
    }

    @Override
    public boolean isNewElement(EObject element) {
        return this.newElements.contains(element);
    }

    @Override
    public boolean hasChanged(EObject element) {
        return this.changedElements.contains(element);
    }

    public List<EObject> getEObjectsFromSelection(Object[] elements) {
        this.selectedElements = new ArrayList<EObject>();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            if (object instanceof EObject) {
                this.selectedElements.add((EObject)object);
            }
            ++i;
        }
        return this.selectedElements;
    }

    public ModelType getRemoteModel() {
        return this.remoteModelHead;
    }
}

