/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.jobs;

import java.util.Calendar;
import org.eclipse.core.resources.IFolder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.jobs.RefreshStatusJob;
import org.eclipse.ui.PlatformUI;

public class JobUtils
implements IPropertyChangeListener {
    private ModelServer modelServer;
    private RefreshStatusJob refreshStatusJob;

    public JobUtils(ModelServer server) {
        this.modelServer = server;
        IPreferenceStore store = PlatformUI.getPreferenceStore();
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public synchronized void runRefreshJob() {
        if (this.refreshStatusJob == null) {
            this.setRefreshStatusJob(new RefreshStatusJob(this.modelServer));
            this.refreshStatusJob.schedule();
        } else {
            long refreshRate = 1000L * Long.parseLong(PlatformUI.getPreferenceStore().getString("collisionRefreshRate"));
            Calendar cal = Calendar.getInstance();
            long current = cal.getTimeInMillis();
            Long previous = this.modelServer.getLastRefresh();
            if (previous == null || current >= previous + refreshRate) {
                if (this.refreshStatusJob.getState() == 1) {
                    this.refreshStatusJob.wakeUp();
                } else {
                    this.refreshStatusJob.schedule();
                }
            } else if (this.refreshStatusJob.getState() == 1) {
                this.refreshStatusJob.wakeUp(previous - current + refreshRate);
            } else {
                this.refreshStatusJob.schedule(previous - current + refreshRate);
            }
        }
    }

    public void update() {
        IFolder modelLockFolder = this.modelServer.getModelLockFolder();
        if (modelLockFolder == null || !modelLockFolder.exists() || StringUtils.isEmpty((String)UUIDUtils.getUUID((EObject)this.modelServer.getModel()))) {
            return;
        }
        if (PlatformUI.getPreferenceStore().getBoolean("collisionRefresh")) {
            this.runRefreshJob();
        } else if (this.refreshStatusJob != null) {
            this.refreshStatusJob.cancel();
            this.refreshStatusJob = null;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("collisionRefresh")) {
            this.update();
        }
        if (event.getProperty().equals("collisionRefreshRate")) {
            this.update();
        }
        if (event.getProperty().equals("collisionRetry")) {
            this.modelServer.setRetry(PlatformUI.getPreferenceStore().getBoolean("collisionRetry"));
        }
        if (event.getProperty().equals("collisionConnectionRetryRate")) {
            this.modelServer.setRetryConnection(1000L * Long.parseLong(PlatformUI.getPreferenceStore().getString("collisionConnectionRetryRate")));
        }
    }

    public void dispose() {
        if (this.refreshStatusJob != null) {
            this.refreshStatusJob.cancel();
            this.refreshStatusJob = null;
        }
    }

    public void sleep() {
        if (this.refreshStatusJob != null) {
            this.refreshStatusJob.sleep();
        }
    }

    public void cancel() {
        if (this.refreshStatusJob != null) {
            this.refreshStatusJob.cancel();
            this.refreshStatusJob = null;
        }
    }

    public void setRefreshStatusJob(RefreshStatusJob job) {
        this.refreshStatusJob = job;
    }
}

