/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.modelserver.LockFileUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.VcsStatus;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionInfo;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionState;
import org.eclipse.swt.widgets.Display;

public class StateCache {
    private Map<EObject, CollisionInfo> cacheMap = new HashMap<EObject, CollisionInfo>();
    private ModelServer modelServer;

    public StateCache(ModelServer server) {
        this.modelServer = server;
    }

    public void remove(EObject eObject) {
        this.cacheMap.remove(eObject);
    }

    public CollisionInfo getState(EObject eObject) {
        EObject element = CopyPasteUtil.getSameModelElement(eObject, this.modelServer.getModel(), null);
        if (element == null) {
            return CollisionInfo.REMOVED;
        }
        CollisionInfo info = this.cacheMap.get(element);
        if (info == null) {
            info = this.updateState(element, null);
        }
        return info == null ? CollisionInfo.DEFAULT : info;
    }

    public CollisionInfo updateState(EObject element, VcsStatus vcsStatus) {
        IFile lockFile = LockFileUtils.getLockFile(element);
        CollisionInfo info = LockFileUtils.getInfo(vcsStatus, lockFile);
        this.setState(element, info);
        return info;
    }

    public synchronized void setState(EObject eObject, CollisionInfo info) {
        final EObject element = CopyPasteUtil.getSameModelElement(eObject, this.modelServer.getModel(), null);
        CollisionInfo oldInfo = this.cacheMap.put(element, info);
        if (!CompareHelper.areEqual((Object)info, (Object)oldInfo)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CreationUtils.refreshTreeItemVisuals(element);
                }
            });
        }
    }

    public boolean isLockedAll() {
        for (Map.Entry<EObject, CollisionInfo> entry : this.cacheMap.entrySet()) {
            CollisionState state = entry.getValue().getState();
            if (state != CollisionState.LOCKED_BY_OTHER && state != CollisionState.REMOVED && state != CollisionState.DEFAULT) continue;
            return false;
        }
        return true;
    }

    public List<EObject> getElementsToLock() {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (Map.Entry<EObject, CollisionInfo> entry : this.cacheMap.entrySet()) {
            CollisionState state = entry.getValue().getState();
            if (state != CollisionState.DEFAULT && state != CollisionState.LOCKED_BY_OTHER) continue;
            elements.add(entry.getKey());
        }
        return elements;
    }

    public List<EObject> getLockedElements() {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (Map.Entry<EObject, CollisionInfo> entry : this.cacheMap.entrySet()) {
            CollisionState state = entry.getValue().getState();
            if (state != CollisionState.LOCKED_BY_USER) continue;
            elements.add(entry.getKey());
        }
        return elements;
    }

    public List<EObject> getAllLockedElements() {
        ArrayList<EObject> elements = new ArrayList<EObject>();
        for (Map.Entry<EObject, CollisionInfo> entry : this.cacheMap.entrySet()) {
            CollisionState state = entry.getValue().getState();
            if (state != CollisionState.LOCKED_BY_USER && state != CollisionState.LOCKED_BY_OTHER) continue;
            elements.add(entry.getKey());
        }
        return elements;
    }
}

