/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.ui;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.modelserver.CommitUtil;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.ui.ModelContainer;
import org.eclipse.stardust.modeling.core.ui.IModelElementContainer;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class CommitDialog
extends Dialog {
    private WorkflowModelEditor editor;
    private ModelContainer input;
    private ModelContainer.Container container;
    private CommitUtil commitUtil;
    private EObject[] preCheckedElements;
    private List<EObject> checkedElements;
    private boolean isValidCommitString = false;
    private static final int MIN_WIDTH = 450;
    private static final int MIN_HEIGHT = 600;
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final String ELEMENTS_COLUMN = "Elements";
    public static final String MERGE_COLUMN = "Merge";
    public static final String KEEPLOCK = "Keep Lock";
    private CheckboxTreeViewer viewer;
    private LabeledText commitText;
    private String commitString;
    private Button keepLockscheckBox;
    private boolean keepLocks = false;
    private ModifyListener commitTextListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            CommitDialog.this.validateCommitText();
        }
    };

    public CommitDialog(WorkflowModelEditor editor, CommitUtil util) {
        super(editor.getSite().getShell());
        this.commitUtil = util;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.editor = editor;
        this.input = new ModelContainer(editor);
        this.container = this.input.getContainer();
    }

    public void setSelection(EObject[] selection) {
        this.preCheckedElements = selection;
    }

    public void create() {
        super.create();
        this.validateSelection(this.viewer.getCheckedElements());
    }

    public Point getInitialSize() {
        return new Point(450, 600);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Diagram_Messages.LB_CommitModelElement);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.MSG_FLUSH_COMMAND_STACK, (int)1);
        Tree tree = new Tree(composite, 67616);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)tree);
        String[] columnPropertiesCommit = new String[]{MERGE_COLUMN};
        this.viewer = new CheckboxTreeViewer(tree);
        this.viewer.setColumnProperties(columnPropertiesCommit);
        TableUtil.createColumns(tree, columnPropertiesCommit);
        TableUtil.setInitialColumnSizes(tree, new int[]{100});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.keepLockscheckBox = FormBuilder.createCheckBox((Composite)composite, (String)KEEPLOCK);
        this.keepLockscheckBox.setSelection(false);
        this.commitText = FormBuilder.createLabeledTextArea((Composite)composite, (String)Diagram_Messages.LBL_COMMENT);
        this.commitText.getText().addModifyListener(this.commitTextListener);
        this.commitUtil.setCommitContent(this.container);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IModelElementContainer) {
                    ((IModelElementContainer)element).setChecked(event.getChecked());
                    CommitDialog.this.viewer.setSubtreeChecked(element, event.getChecked());
                }
                Object[] elements = CommitDialog.this.viewer.getCheckedElements();
                TreePath[] treePaths = CommitDialog.this.viewer.getExpandedTreePaths();
                CommitDialog.this.viewer.refresh();
                CommitDialog.this.viewer.expandAll();
                CommitDialog.this.viewer.setExpandedTreePaths(treePaths);
                CommitDialog.this.viewer.setCheckedElements(elements);
                CommitDialog.this.validateSelection(elements);
            }
        });
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput((Object)this.input);
        this.viewer.expandAll();
        if (!this.commitUtil.getUnChangedElements().isEmpty()) {
            this.viewer.setGrayedElements(this.commitUtil.getUnChangedElements().toArray());
        }
        if (this.preCheckedElements != null && this.preCheckedElements.length != 0) {
            this.viewer.setCheckedElements((Object[])this.preCheckedElements);
        }
        this.validateSelection(this.viewer.getCheckedElements());
        return composite;
    }

    private void validateCommitText() {
        String commitString = this.commitText.getText().getText();
        String validateString = commitString.trim();
        this.isValidCommitString = !StringUtils.isEmpty((String)validateString) && validateString.length() >= 10 && validateString.length() <= 100;
        this.validateDialog();
    }

    private void validateSelection(Object[] elements) {
        this.checkedElements = this.commitUtil.getEObjectsFromSelection(elements);
        this.validateDialog();
    }

    private void validateDialog() {
        if (!this.isValidCommitString) {
            this.commitText.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.commitText.getLabel().setToolTipText(Diagram_Messages.MSG_NO_COMMIT_TEXT);
        } else {
            this.commitText.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            if (this.checkedElements.isEmpty() || !this.isValidCommitString) {
                okButton.setEnabled(false);
            } else {
                okButton.setEnabled(true);
            }
        }
    }

    public List<EObject> getCheckedElements() {
        return this.checkedElements;
    }

    public boolean getKeepLocks() {
        return this.keepLocks;
    }

    public String getCommitString() {
        return this.commitString;
    }

    protected void okPressed() {
        this.commitString = this.commitText.getText().getText();
        this.keepLocks = this.keepLockscheckBox.getSelection();
        super.okPressed();
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ModelContainer) {
                return new Object[]{((ModelContainer)parentElement).getContainer()};
            }
            if (parentElement instanceof IModelElementContainer) {
                return ((IModelElementContainer)parentElement).getContent().toArray();
            }
            return EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return !children.equals(EMPTY_ARRAY);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int index) {
            String returnValue = "";
            if (index == 0) {
                if (element instanceof IModelElementContainer) {
                    return ((IModelElementContainer)element).getLabel();
                }
                if (element instanceof EObject) {
                    return GenericUtils.getElementId((EObject)element);
                }
            }
            return returnValue;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof EObject) {
                    String iconPath = CommitDialog.this.editor.getIconFactory().getIconFor((EObject)element);
                    Image image = DiagramPlugin.getDefault().getImageManager().getImage(iconPath);
                    Image imageWithOverlay = ModelServerUtils.getIconWithOverlay(CommitDialog.this.commitUtil, (EObject)element, image);
                    if (imageWithOverlay != null) {
                        return imageWithOverlay;
                    }
                    return image;
                }
                if (element instanceof IModelElementContainer) {
                    return ((IModelElementContainer)element).getImage();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            if (element instanceof EObject && !CommitDialog.this.commitUtil.hasChanged((EObject)element) && !CommitDialog.this.commitUtil.isRemovedElement((EObject)element) && !CommitDialog.this.commitUtil.isNewElement((EObject)element)) {
                return ColorConstants.gray;
            }
            return ColorConstants.black;
        }
    }
}

