/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.ui;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.UpdateUtil;
import org.eclipse.stardust.modeling.core.modelserver.ui.ModelContainer;
import org.eclipse.stardust.modeling.core.ui.IModelElementContainer;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class UpdateDialog
extends Dialog {
    private WorkflowModelEditor editor;
    private ModelContainer input;
    private EObject[] preCheckedElements;
    private static final int MIN_WIDTH = 450;
    private static final int MIN_HEIGHT = 600;
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final String ELEMENTS_COLUMN = "Elements";
    private CheckboxTreeViewer viewer;
    private List<EObject> selectedElements;
    private UpdateUtil updateUtil;
    private ModelContainer.Container container;

    public UpdateDialog(WorkflowModelEditor editor, UpdateUtil util) {
        super(editor.getSite().getShell());
        this.updateUtil = util;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.editor = editor;
        this.input = new ModelContainer(editor);
        this.container = this.input.getContainer();
    }

    public Point getInitialSize() {
        return new Point(450, 600);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Diagram_Messages.LB_UpdateModel);
    }

    public void setSelection(EObject[] selection) {
        this.preCheckedElements = selection;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        FormBuilder.createLabel((Composite)composite, (String)Diagram_Messages.MSG_FLUSH_COMMAND_STACK, (int)1);
        Tree tree = new Tree(composite, 67616);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)tree);
        String[] columnPropertiesUpdate = new String[]{ELEMENTS_COLUMN};
        this.viewer = new CheckboxTreeViewer(tree);
        this.viewer.setColumnProperties(columnPropertiesUpdate);
        TableUtil.createColumns(tree, columnPropertiesUpdate);
        TableUtil.setInitialColumnSizes(tree, new int[]{100});
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        this.updateUtil.setUpdateContent(this.container);
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IModelElementContainer) {
                    ((IModelElementContainer)element).setChecked(event.getChecked());
                    UpdateDialog.this.viewer.setSubtreeChecked(element, event.getChecked());
                }
                Object[] elements = UpdateDialog.this.viewer.getCheckedElements();
                TreePath[] treePaths = UpdateDialog.this.viewer.getExpandedTreePaths();
                UpdateDialog.this.viewer.refresh();
                UpdateDialog.this.viewer.expandAll();
                UpdateDialog.this.viewer.setExpandedTreePaths(treePaths);
                UpdateDialog.this.viewer.setCheckedElements(elements);
                UpdateDialog.this.selectedElements = UpdateDialog.this.updateUtil.getEObjectsFromSelection(elements);
                UpdateDialog.this.validateSelection();
            }
        });
        this.viewer.setUseHashlookup(true);
        this.viewer.setInput((Object)this.input);
        this.viewer.expandAll();
        if (this.preCheckedElements != null) {
            this.viewer.setCheckedElements((Object[])this.preCheckedElements);
            this.selectedElements = this.updateUtil.getEObjectsFromSelection(this.preCheckedElements);
        }
        this.validateSelection();
        return composite;
    }

    private void validateSelection() {
        this.selectedElements = CollectionUtils.newList();
        Object[] elements = this.viewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            if (object instanceof EObject) {
                this.selectedElements.add((EObject)object);
            }
            ++i;
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            if (this.selectedElements.isEmpty()) {
                okButton.setEnabled(false);
            } else {
                okButton.setEnabled(true);
            }
        }
    }

    public void create() {
        super.create();
        this.validateSelection();
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<EObject> getCheckedElements() {
        return this.selectedElements;
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ModelContainer) {
                return new Object[]{((ModelContainer)parentElement).getContainer()};
            }
            if (parentElement instanceof IModelElementContainer) {
                return ((IModelElementContainer)parentElement).getContent().toArray();
            }
            return EMPTY_ARRAY;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return !children.equals(EMPTY_ARRAY);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TableLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int index) {
            String returnValue = "";
            if (index == 0) {
                if (element instanceof IModelElementContainer) {
                    return ((IModelElementContainer)element).getLabel();
                }
                if (element instanceof EObject) {
                    return GenericUtils.getElementId((EObject)element);
                }
            }
            return returnValue;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof EObject) {
                    String iconPath = UpdateDialog.this.editor.getIconFactory().getIconFor((EObject)element);
                    Image image = DiagramPlugin.getDefault().getImageManager().getImage(iconPath);
                    Image overlay = ModelServerUtils.getIconWithOverlay(UpdateDialog.this.updateUtil, (EObject)element, image);
                    if (overlay == null) {
                        overlay = ModelServerUtils.getIconWithOverlay(image, ModelServerUtils.imageVCS, 3);
                    }
                    return overlay;
                }
                if (element instanceof IModelElementContainer) {
                    return ((IModelElementContainer)element).getImage();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return ColorConstants.black;
        }
    }
}

