/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.IdentifiableLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.ReferencedModelSorter;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class ActivitySubprocessPropertyPage
extends AbstractModelElementPropertyPage {
    private static final String PAGE_ID = "_cwm_subprocess_";
    public static final String[] LABELS = new String[]{Diagram_Messages.LABEL_SyncShared, "Sync Separate", Diagram_Messages.LABEL_AsyncSeparate};
    private LabeledViewer labeledComboViewer;
    private LabeledViewer labeledViewer;
    private Button checkCopyData;
    private ReferencedModelSorter procSorter = new ReferencedModelSorter();
    private IdentifiableLabelProvider labelProvider;
    private boolean loading;
    private Button groupingCheckbox;
    private List<ProcessDefinitionType> processes;
    private ComboViewer comboViewer;
    private ModelType model;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.loading = true;
        ActivityType activity = (ActivityType)element;
        this.model = (ModelType)activity.eContainer().eContainer();
        this.labelProvider.setModel(this.model);
        TableViewer viewer = (TableViewer)this.labeledViewer.getViewer();
        viewer.getTable().removeAll();
        this.processes = this.collectProcessDefinitions(this.model);
        viewer.add(this.processes.toArray());
        this.comboViewer.getCombo().removeAll();
        this.comboViewer.add(SubProcessModeType.VALUES.toArray());
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)activity.getSubProcessMode()));
        if (activity.getImplementationProcess() != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)activity.getImplementationProcess()));
        }
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.labeledViewer, (EObject)element, (EStructuralFeature)PKG_CWM.getActivityType_ImplementationProcess());
        wBndMgr.getModelBindingManager().updateWidgets((Object)element);
        this.checkCopyData.setSelection(Boolean.valueOf(AttributeUtil.getAttributeValue((IExtensibleElement)activity, (String)"carnot:engine:subprocess:copyAllData")).booleanValue());
        this.loading = false;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:subprocess:copyAllData", (Boolean)this.checkCopyData.getSelection());
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.FORMBUILDER_LB_Subprocess);
        Table table = new Table(composite, 2048);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        final TableViewer tableViewer = new TableViewer(table);
        this.labelProvider = new IdentifiableLabelProvider(this.getEditor());
        tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tableViewer.setSorter((ViewerSorter)this.procSorter);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                if (!ActivitySubprocessPropertyPage.this.loading && PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration") && (selection = (IStructuredSelection)tableViewer.getSelection()) != null && selection.getFirstElement() instanceof ProcessDefinitionType) {
                    ProcessDefinitionType pdt = (ProcessDefinitionType)selection.getFirstElement();
                    String defaultName = ((ProcessDefinitionType)selection.getFirstElement()).getName();
                    ((ActivityType)ActivitySubprocessPropertyPage.this.getModelElement()).setName(defaultName);
                    ModelType externalModel = (ModelType)pdt.eContainer();
                    ActivitySubprocessPropertyPage.this.comboViewer.refresh();
                    ActivitySubprocessPropertyPage.this.comboViewer.add(SubProcessModeType.VALUES.toArray());
                    if (((ActivityType)ActivitySubprocessPropertyPage.this.getModelElement()).getSubProcessMode().equals((Object)SubProcessModeType.SYNC_SHARED_LITERAL)) {
                        if (externalModel != ActivitySubprocessPropertyPage.this.model) {
                            ActivitySubprocessPropertyPage.this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)SubProcessModeType.SYNC_SEPARATE_LITERAL));
                        } else {
                            ActivitySubprocessPropertyPage.this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)((ActivityType)ActivitySubprocessPropertyPage.this.getModelElement()).getSubProcessMode()));
                        }
                    } else {
                        ActivitySubprocessPropertyPage.this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)((ActivityType)ActivitySubprocessPropertyPage.this.getModelElement()).getSubProcessMode()));
                    }
                    ActivitySubprocessPropertyPage.this.removePreferenceNodes(ActivitySubprocessPropertyPage.PAGE_ID, false);
                    ActivitySubprocessPropertyPage.this.addNodesTo(ActivitySubprocessPropertyPage.PAGE_ID);
                }
            }
        });
        this.labeledViewer = new LabeledViewer((StructuredViewer)tableViewer, label);
        this.groupingCheckbox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.LB_GroupModelElements);
        this.groupingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ActivitySubprocessPropertyPage.this.procSorter.setGrouped(ActivitySubprocessPropertyPage.this.groupingCheckbox.getSelection());
                ActivitySubprocessPropertyPage.this.labelProvider.setShowGroupInfo(ActivitySubprocessPropertyPage.this.groupingCheckbox.getSelection());
                TableViewer viewer = (TableViewer)ActivitySubprocessPropertyPage.this.labeledViewer.getViewer();
                ISelection selection = viewer.getSelection();
                viewer.getTable().removeAll();
                viewer.add(ActivitySubprocessPropertyPage.this.processes.toArray());
                viewer.setSelection(selection);
            }
        });
        LabelWithStatus comboLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.FORMBUILDER_LB_ExecutionType);
        this.comboViewer = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.comboViewer.add(SubProcessModeType.VALUES.toArray());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ModelUtils.getSubprocessModeTypeText((SubProcessModeType)((SubProcessModeType)element));
            }
        });
        this.labeledComboViewer = new LabeledViewer((StructuredViewer)this.comboViewer, comboLabel);
        this.checkCopyData = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BOX_COPY_ALL_DATA, (int)2);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((EditPart)ActivitySubprocessPropertyPage.this.getElement()).getModel();
                ActivityType activity = obj instanceof ActivitySymbolType ? ((ActivitySymbolType)obj).getActivity() : (ActivityType)obj;
                Object selection = ((IStructuredSelection)ActivitySubprocessPropertyPage.this.comboViewer.getSelection()).getFirstElement();
                if (selection != null) {
                    boolean isCopyAllData = selection.equals(SubProcessModeType.SYNC_SHARED_LITERAL) ? false : AttributeUtil.getBooleanValue((IExtensibleElement)activity, (String)"carnot:engine:subprocess:copyAllData");
                    ActivitySubprocessPropertyPage.this.checkCopyData.setSelection(isCopyAllData);
                    ActivitySubprocessPropertyPage.this.checkCopyData.setEnabled(!selection.equals(SubProcessModeType.SYNC_SHARED_LITERAL));
                    ActivitySubprocessPropertyPage.this.updateModelData();
                }
            }
        });
        this.checkCopyData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivitySubprocessPropertyPage.this.updateModelData();
            }
        });
        return composite;
    }

    private void updateModelData() {
        Object obj = ((EditPart)this.getElement()).getModel();
        ActivityType activity = obj instanceof ActivitySymbolType ? ((ActivitySymbolType)obj).getActivity() : (ActivityType)obj;
        IStructuredSelection selection = (IStructuredSelection)this.labeledComboViewer.getViewer().getSelection();
        SubProcessModeType subProcMode = (SubProcessModeType)selection.getFirstElement();
        if (!CompareHelper.areEqual((Object)subProcMode, (Object)activity.getSubProcessMode())) {
            activity.setSubProcessMode(subProcMode);
        }
        AttributeUtil.setBooleanAttribute((IExtensibleElement)activity, (String)"carnot:engine:subprocess:copyAllData", (Boolean)this.checkCopyData.getSelection());
    }

    private List<ProcessDefinitionType> collectProcessDefinitions(ModelType model) {
        ExternalPackages packages;
        List processesList = CollectionUtils.newList();
        EList processTypes = model.getProcessDefinition();
        if (processTypes != null) {
            processesList.addAll(processTypes);
        }
        if ((packages = model.getExternalPackages()) != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                EList externalProcesses;
                IConnectionManager manager;
                String uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
                if (StringUtils.isEmpty((String)uri) || (manager = model.getConnectionManager()) == null) continue;
                EObject externalModel = manager.find(uri);
                if (externalModel instanceof IObjectReference) {
                    externalModel = ((IObjectReference)externalModel).getEObject();
                }
                if (!(externalModel instanceof ModelType) || (externalProcesses = ((ModelType)externalModel).getProcessDefinition()) == null) continue;
                for (ProcessDefinitionType extProcess : externalProcesses) {
                    if (extProcess.getFormalParameters() == null) continue;
                    processesList.add(extProcess);
                }
            }
        }
        return processesList;
    }

    public ProcessDefinitionType getSelectedSubprocess() {
        TableViewer viewer = (TableViewer)this.labeledViewer.getViewer();
        IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
        return (ProcessDefinitionType)selection.getFirstElement();
    }
}

