/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.stardust.modeling.core.spi.SpiPropertyPage;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ConditionPropertyPage
extends SpiPropertyPage {
    private static final String CONSUME = Diagram_Messages.CONSUME;
    private static final String LOG = Diagram_Messages.LOG;
    private static final String AUTO_BIND = Diagram_Messages.AUTO_BIND;
    protected LabeledText txtId;
    protected LabeledText txtName;
    private Button autoBindCheckButton;
    private Button logHandlerCheckButton;
    private Button consumeOnMatchCheckButton;
    private Button[] buttons;
    private Button autoIdButton;
    private SelectionListener autoIdListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean selection = ((Button)e.widget).getSelection();
            if (selection) {
                ConditionPropertyPage.this.txtId.getText().setEditable(false);
                String computedId = ModelUtils.computeId((String)ConditionPropertyPage.this.txtName.getText().getText());
                ConditionPropertyPage.this.txtId.getText().setText(computedId);
            } else {
                ConditionPropertyPage.this.txtId.getText().setEditable(true);
            }
        }
    };
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            String name = text.getText();
            if (ConditionPropertyPage.this.autoIdButton.getSelection()) {
                ConditionPropertyPage.this.txtId.getText().setText(ModelUtils.computeId((String)name));
            }
        }
    };

    public ConditionPropertyPage(ConfigurationElement config) throws CoreException {
        super(config);
    }

    @Override
    public Control createBody(Composite content) {
        Composite composite = FormBuilder.createComposite((Composite)content, (int)2);
        this.txtName = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.txtId = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ID);
        this.autoIdButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BTN_AutoId, (int)2);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue(this.getModelElement());
        this.autoIdButton.setSelection(autoIdButtonValue);
        if (autoIdButtonValue) {
            this.txtId.getText().setEditable(false);
        }
        this.autoIdButton.addSelectionListener(this.autoIdListener);
        Composite checkBoxComposite = FormBuilder.createComposite((Composite)composite, (int)3);
        ((GridLayout)checkBoxComposite.getLayout()).marginHeight = 15;
        ((GridLayout)checkBoxComposite.getLayout()).marginWidth = 0;
        GridData gdCheckBoxComposite = new GridData();
        gdCheckBoxComposite.horizontalSpan = 2;
        checkBoxComposite.setLayoutData((Object)gdCheckBoxComposite);
        this.autoBindCheckButton = FormBuilder.createCheckBox((Composite)checkBoxComposite, (String)AUTO_BIND);
        this.logHandlerCheckButton = FormBuilder.createCheckBox((Composite)checkBoxComposite, (String)LOG);
        this.consumeOnMatchCheckButton = FormBuilder.createCheckBox((Composite)checkBoxComposite, (String)CONSUME);
        super.createBody(composite);
        return composite;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadElementFromFields(symbol, element);
        GenericUtils.setAutoIdValue(this.getModelElement(), this.autoIdButton.getSelection());
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        super.loadFieldsFromElement(symbol, element);
        this.txtName.getText().removeModifyListener(this.listener);
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        Map extensions = registry.getExtensions("conditionTypes");
        IConfigurationElement extension = (IConfigurationElement)extensions.get(((EventHandlerType)element).getType().getId());
        if (extension.getAttribute("implementation").equalsIgnoreCase("pull")) {
            this.consumeOnMatchCheckButton.setEnabled(false);
        } else {
            this.autoBindCheckButton.setEnabled(false);
        }
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.txtId, (EObject)element, (EStructuralFeature)PKG_CWM.getIIdentifiableElement_Id());
        wBndMgr.bind(this.txtName, (EObject)element, (EStructuralFeature)PKG_CWM.getIIdentifiableElement_Name());
        wBndMgr.getModelBindingManager().bind((EObject)element, (EStructuralFeature)PKG_CWM.getEventHandlerType_AutoBind(), this.autoBindCheckButton);
        wBndMgr.getModelBindingManager().bind((EObject)element, (EStructuralFeature)PKG_CWM.getEventHandlerType_ConsumeOnMatch(), this.consumeOnMatchCheckButton);
        wBndMgr.getModelBindingManager().bind((EObject)element, (EStructuralFeature)PKG_CWM.getEventHandlerType_LogHandler(), this.logHandlerCheckButton);
        wBndMgr.getModelBindingManager().updateWidgets((Object)element);
        this.txtName.getText().addModifyListener(this.listener);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
            manager.updateButtons(this.getModelElement(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        this.buttons = manager.createButtons(parent);
    }
}

