/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ElUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ScriptType;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EObjectAdapter;
import org.eclipse.stardust.modeling.core.properties.IdentifiablePropertyPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataPropertyPage
extends IdentifiablePropertyPage {
    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.setEditableText(((DataType)element).isPredefined());
        super.loadFieldsFromElement(symbol, element);
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        String dataId = ((DataType)element).getId();
        if (dataId != null) {
            this.bindTransitionConditions(model, dataId);
        }
        this.refreshTree();
    }

    @Override
    public Control createBody(Composite parent) {
        this.setProvidesVisibility(true);
        return super.createBody(parent);
    }

    private void bindTransitionConditions(ModelType model, String dataId) {
        final ModelType modelType = model;
        Iterator iter = model.getProcessDefinition().iterator();
        while (iter.hasNext()) {
            for (final TransitionType transition : ((ProcessDefinitionType)iter.next()).getTransition()) {
                String expression;
                String string = expression = transition.getExpression() == null ? null : ModelUtils.getCDataString((FeatureMap)transition.getExpression().getMixed());
                if (expression == null || expression.indexOf(dataId) < 0) continue;
                this.getWidgetBindingManager().bind(this.txtId, new EObjectAdapter((EObject)transition, (EStructuralFeature)PKG_CWM.getTransitionType_Expression(), dataId){
                    private String oldValue;
                    {
                        super($anonymous0, $anonymous1);
                        this.oldValue = string;
                    }

                    public void updateModel(Object value) {
                        String newValue = value.toString();
                        String oldExpression = ModelUtils.getCDataString((FeatureMap)transition.getExpression().getMixed());
                        if (oldExpression != null) {
                            try {
                                String newExpression = "";
                                ScriptType script = modelType.getScript();
                                newExpression = script == null || StringUtils.isEmpty((String)script.getType()) || script.getType().equals("text/carnotEL") ? ElUtils.patchExpressions((String)oldExpression, (String)this.oldValue, (String)newValue) : ElUtils.patchJsExpressions((String)oldExpression, (String)this.oldValue, (String)newValue);
                                ModelUtils.setCDataString((FeatureMap)transition.getExpression().getMixed(), (String)newExpression);
                                this.oldValue = newValue;
                            }
                            catch (Throwable throwable) {}
                        }
                    }

                    public Object getValue() {
                        return this.oldValue;
                    }
                });
            }
        }
    }

    private void setEditableText(boolean isPredefined) {
        if (isPredefined) {
            this.txtId.getText().setEditable(!isPredefined);
            this.txtName.getText().setEditable(!isPredefined);
            this.autoIdButton.setEnabled(false);
            this.txtDescription.getText().setEditable(!isPredefined);
        }
    }
}

