/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.StructuredTypeUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.BasicTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.DataTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.DeclaredTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.ModeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.tree.IdentifiableModelElementTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DataFilter;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FormalParameterPropertyPage
extends AbstractModelElementPropertyPage {
    private XpdlFactory xpdlFactory = XpdlFactory.eINSTANCE;
    private LabeledText idText;
    private LabeledText nameText;
    private LabeledViewer directionCombo;
    private LabeledViewer dataCombo;
    private Button[] buttons;
    private Button autoIdButton;
    private boolean isEditable = true;
    private EList<DataType> datas;
    private Map<String, TypeType> typeMapping;
    private static final Type[] TYPES = new Type[]{Type.Calendar, Type.String, Type.Timestamp, Type.Boolean, Type.Byte, Type.Char, Type.Double, Type.Float, Type.Integer, Type.Long, Type.Short};
    List<Type> primitiveTypes = Arrays.asList(TYPES);
    List<Object> dataTypes = new ArrayList<Object>();
    private FormalParameterType parameterType;
    private ProcessDefinitionType providingProcess;
    private boolean readOnly;
    private LabeledViewer dataTypeCombo;
    private DataFilter dataFilter;
    private ProcessDefinitionType implementingProcess;
    private List typeFilters = new ArrayList();
    private SelectionListener autoIdListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean selection = ((Button)e.widget).getSelection();
            if (selection) {
                FormalParameterPropertyPage.this.idText.getText().setEditable(false);
                String computedId = ModelUtils.computeId((String)FormalParameterPropertyPage.this.nameText.getText().getText());
                FormalParameterPropertyPage.this.idText.getText().setText(computedId);
            } else {
                FormalParameterPropertyPage.this.idText.getText().setEditable(true);
            }
        }
    };
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            String name = text.getText();
            if (FormalParameterPropertyPage.this.autoIdButton.getSelection()) {
                FormalParameterPropertyPage.this.idText.getText().setText(ModelUtils.computeId((String)name));
            }
        }
    };
    private LabeledViewer categoryCombo;

    @Override
    protected void performDefaults() {
        super.performDefaults();
        ISelection sel = this.directionCombo.getViewer().getSelection();
        if (sel.isEmpty()) {
            this.directionCombo.getViewer().setSelection((ISelection)new StructuredSelection((Object)DirectionType.IN_LITERAL));
        }
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        ModeType mode;
        ViewerFilter selectedFilter;
        this.implementingProcess = this.getProcess();
        this.nameText.getText().removeModifyListener(this.listener);
        this.typeMapping = CollectionUtils.newMap();
        this.typeMapping.put(Type.String.getId(), TypeType.STRING_LITERAL);
        this.typeMapping.put(Type.Integer.getId(), TypeType.INTEGER_LITERAL);
        this.typeMapping.put(Type.Boolean.getId(), TypeType.BOOLEAN_LITERAL);
        this.typeMapping.put(Type.Calendar.getId(), TypeType.DATETIME_LITERAL);
        this.typeMapping.put(Type.Timestamp.getId(), TypeType.DATETIME_LITERAL);
        this.typeMapping.put(Type.Long.getId(), TypeType.INTEGER_LITERAL);
        this.typeMapping.put(Type.Double.getId(), TypeType.FLOAT_LITERAL);
        this.typeMapping.put(Type.Short.getId(), TypeType.INTEGER_LITERAL);
        this.typeMapping.put(Type.Byte.getId(), TypeType.INTEGER_LITERAL);
        WidgetBindingManager binding = this.getWidgetBindingManager();
        this.parameterType = (FormalParameterType)element;
        this.nameText.getText().setText(this.parameterType.getName());
        this.idText.getText().setText(this.parameterType.getId());
        this.providingProcess = (ProcessDefinitionType)this.parameterType.eContainer().eContainer();
        this.readOnly = !this.providingProcess.equals(this.implementingProcess);
        ModelType referencedModelType = ModelUtils.findContainingModel((EObject)this.providingProcess);
        ModelType propertyModelType = ModelUtils.findContainingModel((EObject)this.implementingProcess);
        this.datas = propertyModelType.getData();
        for (TypeDeclarationType typeDec : referencedModelType.getTypeDeclarations().getTypeDeclaration()) {
            this.dataTypes.add(typeDec);
        }
        this.dataTypes.add(StructuredTypeUtils.getResourceTypeDeclaration());
        this.dataTypes.addAll(this.primitiveTypes);
        DataType selectedData = this.getSelectedData();
        Object selectedType = this.getInterfaceType();
        this.dataFilter.setFilterType(selectedType);
        this.dataFilter.setReferencedModel(referencedModelType);
        this.categoryCombo.getViewer().setInput((Object)this.typeFilters);
        String selectedCategory = null;
        DataTypeType selectedDataType = this.parameterType.getDataType();
        if (selectedDataType != null && (selectedCategory = this.parameterType.getDataType().getCarnotType()) == null) {
            if (this.parameterType.getDataType().getBasicType() != null) {
                selectedCategory = "primitive";
            }
            if (this.parameterType.getDataType().getDeclaredType() != null) {
                selectedCategory = "struct";
            }
        }
        if ((selectedFilter = this.getSelectedFilter(selectedCategory)) != null) {
            this.categoryCombo.getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedFilter));
            this.dataFilter.setCategoryFilter(selectedFilter);
            this.dataTypeCombo.getViewer().setFilters(new ViewerFilter[]{selectedFilter});
            this.dataTypeCombo.getViewer().setInput(this.dataTypes);
        }
        this.dataCombo.getViewer().setInput(this.datas);
        if (selectedType != null) {
            this.dataTypeCombo.getViewer().setSelection((ISelection)new StructuredSelection(selectedType));
        }
        if (selectedData != null) {
            this.dataCombo.getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedData));
        }
        if ((mode = this.parameterType.getMode()) != null) {
            if (mode.equals((Object)ModeType.IN)) {
                ((Combo)this.directionCombo.getViewer().getControl()).select(0);
            }
            if (mode.equals((Object)ModeType.OUT)) {
                ((Combo)this.directionCombo.getViewer().getControl()).select(1);
            }
            if (mode.equals((Object)ModeType.INOUT)) {
                ((Combo)this.directionCombo.getViewer().getControl()).select(2);
            }
        }
        this.nameText.getText().removeModifyListener(this.listener);
        binding.bind(this.idText, (EObject)this.parameterType, (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Id());
        binding.bind(this.nameText, (EObject)this.parameterType, (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Name());
        this.idText.getText().setEditable(false);
        this.nameText.getText().addModifyListener(this.listener);
        this.enableControls();
        this.validatePage();
    }

    private ViewerFilter getSelectedFilter(String category) {
        for (TypeFilter filter : this.typeFilters) {
            if (!filter.getName().equals(category)) continue;
            return filter;
        }
        return null;
    }

    @Override
    protected void updateApplyButton() {
        super.updateApplyButton();
        this.validatePage();
    }

    private Object getType(DataType selectedData) {
        if (selectedData == null) {
            return null;
        }
        for (Object o : this.dataTypes) {
            String typeName = AttributeUtil.getAttributeValue((List)selectedData.getAttribute(), (String)"carnot:engine:type");
            if (typeName == null) {
                typeName = AttributeUtil.getAttributeValue((List)selectedData.getAttribute(), (String)"carnot:engine:dataType");
            }
            if (typeName == null && selectedData.getType().getId().startsWith("dms") && (typeName = AttributeUtil.getAttributeValue((List)selectedData.getAttribute(), (String)"carnot:engine:dms:resourceMetadataSchema")) == null) {
                typeName = "ResourceProperty";
            }
            if (o instanceof Type && ((Type)o).getId().equalsIgnoreCase(typeName)) {
                return o;
            }
            if (!(o instanceof TypeDeclarationType) || !((TypeDeclarationType)o).getId().equalsIgnoreCase(typeName)) continue;
            return o;
        }
        return null;
    }

    private void enableControls() {
        this.autoIdButton.setEnabled(!this.readOnly && this.enablePage);
        this.idText.getText().setEnabled(!this.readOnly && this.enablePage);
        this.nameText.getText().setEnabled(!this.readOnly && this.enablePage);
        this.directionCombo.getViewer().getControl().setEnabled(!this.readOnly && this.enablePage);
        this.dataTypeCombo.getViewer().getControl().setEnabled(!this.readOnly && this.enablePage);
        this.categoryCombo.getViewer().getControl().setEnabled(!this.readOnly && this.enablePage);
    }

    private ProcessDefinitionType getProcess() {
        ProcessDefinitionType process = null;
        ModelElementPropertyDialog dialog = (ModelElementPropertyDialog)this.getContainer();
        process = dialog.getElement() instanceof IdentifiableModelElementTreeEditPart ? (ProcessDefinitionType)Reflect.getFieldValue((Object)dialog.getElement(), (String)"model") : (ProcessDefinitionType)this.getModelElement(dialog.getElement());
        return process;
    }

    private DataType getSelectedData() {
        FormalParameterMappingsType mappingsType = this.implementingProcess.getFormalParameterMappings();
        if (mappingsType.getMapping().isEmpty()) {
            return null;
        }
        mappingsType.getMappedData(this.parameterType);
        DataType dt = this.implementingProcess.getFormalParameterMappings().getMappedData(this.parameterType);
        return dt;
    }

    private Object getInterfaceType() {
        FormalParameterMappingsType mappingsType = this.providingProcess.getFormalParameterMappings();
        if (mappingsType.getMapping().isEmpty()) {
            return null;
        }
        mappingsType.getMappedData(this.parameterType);
        DataType dt = this.providingProcess.getFormalParameterMappings().getMappedData(this.parameterType);
        return this.getType(dt);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setVisible(boolean visible) {
        IButtonManager manager;
        if (visible && (manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class)) != null) {
            manager.updateButtons(this.getModelElement(), this.buttons);
        }
        super.setVisible(visible);
        this.validatePage();
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        if (manager != null) {
            this.buttons = manager.createButtons(parent);
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        this.typeFilters = this.getTypeFilters();
        this.implementingProcess = this.getProcess();
        this.providingProcess = (ProcessDefinitionType)((FormalParameterType)this.getModelElement()).eContainer().eContainer();
        this.readOnly = !this.providingProcess.equals(this.implementingProcess);
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.nameText = FormBuilder.createLabeledTextLeftAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.nameText.getText().setEnabled(this.enablePage);
        this.nameText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormalParameterPropertyPage.this.validatePage();
            }
        });
        this.idText = FormBuilder.createLabeledTextLeftAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_ID);
        this.idText.getText().setEditable(true);
        this.idText.getText().setEnabled(this.enablePage);
        this.idText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FormalParameterPropertyPage.this.validatePage();
            }
        });
        this.autoIdButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BTN_AutoId, (int)2);
        boolean autoIdButtonValue = PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoIdGeneration");
        this.autoIdButton.setSelection(autoIdButtonValue);
        this.autoIdButton.setEnabled(this.enablePage);
        if (autoIdButtonValue) {
            this.idText.getText().setEditable(false);
        }
        this.autoIdButton.addSelectionListener(this.autoIdListener);
        ArrayList<DirectionType> directions = new ArrayList<DirectionType>();
        directions.add(DirectionType.IN_LITERAL);
        directions.add(DirectionType.OUT_LITERAL);
        directions.add(DirectionType.INOUT_LITERAL);
        this.directionCombo = FormBuilder.createComboViewer((Composite)composite, (String)Diagram_Messages.LB_Direction, directions);
        this.directionCombo.getViewer().getControl().setEnabled(this.enablePage);
        ((Combo)this.directionCombo.getViewer().getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)FormalParameterPropertyPage.this.directionCombo.getViewer().getSelection();
                if (selection.getFirstElement().equals(DirectionType.IN_LITERAL)) {
                    FormalParameterPropertyPage.this.parameterType.setMode(ModeType.IN);
                }
                if (selection.getFirstElement().equals(DirectionType.OUT_LITERAL)) {
                    FormalParameterPropertyPage.this.parameterType.setMode(ModeType.OUT);
                }
                if (selection.getFirstElement().equals(DirectionType.INOUT_LITERAL)) {
                    FormalParameterPropertyPage.this.parameterType.setMode(ModeType.INOUT);
                }
                FormalParameterPropertyPage.this.validatePage();
            }
        });
        this.categoryCombo = FormBuilder.createComboViewer((Composite)composite, (String)Diagram_Messages.LBL_CATEGORY, new ArrayList());
        this.categoryCombo.getViewer().getControl().setEnabled(this.enablePage);
        this.categoryCombo.getViewer().setContentProvider((IContentProvider)new ArrayContentProvider());
        ((Combo)this.categoryCombo.getViewer().getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)FormalParameterPropertyPage.this.categoryCombo.getViewer().getSelection();
                ViewerFilter filter = (ViewerFilter)selection.getFirstElement();
                FormalParameterPropertyPage.this.dataTypeCombo.getViewer().setFilters(new ViewerFilter[]{filter});
                FormalParameterPropertyPage.this.dataFilter.setCategoryFilter(filter);
                FormalParameterPropertyPage.this.dataTypeCombo.getViewer().setInput(FormalParameterPropertyPage.this.dataTypes);
                FormalParameterPropertyPage.this.validatePage();
            }
        });
        this.dataTypeCombo = FormBuilder.createComboViewer((Composite)composite, (String)Diagram_Messages.LBL_DATA_TYPE, new ArrayList());
        this.dataTypeCombo.getViewer().getControl().setEnabled(this.enablePage);
        this.dataTypeCombo.getViewer().setSorter(new ViewerSorter());
        this.dataTypeCombo.getViewer().setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataTypeCombo.getViewer().setFilters(new ViewerFilter[]{new EmptyFilter("")});
        this.dataTypeCombo.getViewer().setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        ((Combo)this.dataTypeCombo.getViewer().getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                super.widgetDefaultSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Object dataType = ((StructuredSelection)FormalParameterPropertyPage.this.dataTypeCombo.getViewer().getSelection()).getFirstElement();
                FormalParameterPropertyPage.this.dataFilter.setFilterType(dataType);
                FormalParameterPropertyPage.this.dataCombo.getViewer().setInput((Object)FormalParameterPropertyPage.this.datas);
                FormalParameterPropertyPage.this.dataCombo.getViewer().refresh(true);
                FormalParameterPropertyPage.this.validatePage();
            }
        });
        this.dataCombo = FormBuilder.createComboViewer((Composite)composite, (String)Diagram_Messages.LB_Data, new ArrayList());
        this.dataCombo.getViewer().getControl().setEnabled(this.enablePage);
        this.dataCombo.getViewer().setSorter(new ViewerSorter());
        this.dataFilter = new DataFilter();
        this.dataCombo.getViewer().setFilters(new ViewerFilter[]{this.dataFilter});
        this.dataCombo.getViewer().setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataCombo.getViewer().setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        ((Combo)this.dataCombo.getViewer().getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeclaredTypeType declaredType;
                DataType data = (DataType)((StructuredSelection)FormalParameterPropertyPage.this.dataCombo.getViewer().getSelection()).getFirstElement();
                DataTypeType dataType = FormalParameterPropertyPage.this.xpdlFactory.createDataTypeType();
                String typeId = data.getType().getId();
                if ("primitive".equals(typeId)) {
                    BasicTypeType basicType = FormalParameterPropertyPage.this.xpdlFactory.createBasicTypeType();
                    String primitiveType = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:type");
                    TypeType tt = (TypeType)FormalParameterPropertyPage.this.typeMapping.get(primitiveType);
                    if (tt != null) {
                        basicType.setType(tt);
                    }
                    dataType.setBasicType(basicType);
                } else if ("struct".equals(typeId)) {
                    declaredType = FormalParameterPropertyPage.this.xpdlFactory.createDeclaredTypeType();
                    if (data.getExternalReference() != null) {
                        ExternalReferenceType extRef = data.getExternalReference();
                        declaredType.setId(extRef.getXref());
                    } else {
                        declaredType.setId(AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:dataType"));
                    }
                    dataType.setDeclaredType(declaredType);
                } else if ("dmsDocument".equals(typeId) || "dmsDocumentList".equals(typeId)) {
                    declaredType = FormalParameterPropertyPage.this.xpdlFactory.createDeclaredTypeType();
                    String declTypeId = AttributeUtil.getAttributeValue((IExtensibleElement)data, (String)"carnot:engine:dms:resourceMetadataSchema");
                    if (declTypeId == null) {
                        declTypeId = "ResourceProperty";
                    }
                    declaredType.setId(declTypeId);
                    dataType.setDeclaredType(declaredType);
                }
                FormalParameterPropertyPage.this.parameterType.setDataType(dataType);
                dataType.setCarnotType(typeId);
                if (!FormalParameterPropertyPage.this.implementingProcess.equals(FormalParameterPropertyPage.this.providingProcess)) {
                    FormalParameterType implementingType = FormalParameterPropertyPage.this.implementingProcess.getFormalParameters().getFormalParameter(FormalParameterPropertyPage.this.parameterType.getId());
                    if (implementingType == null) {
                        implementingType = ModelUtils.cloneFormalParameterType((FormalParameterType)FormalParameterPropertyPage.this.parameterType, null);
                        FormalParameterPropertyPage.this.implementingProcess.getFormalParameters().addFormalParameter(implementingType);
                    } else if (ModelUtils.haveDifferentTypes((FormalParameterType)FormalParameterPropertyPage.this.parameterType, (FormalParameterType)implementingType)) {
                        implementingType.setDataType((DataTypeType)EcoreUtil.copy((EObject)FormalParameterPropertyPage.this.parameterType.getDataType()));
                    }
                }
                FormalParameterPropertyPage.this.implementingProcess.getFormalParameterMappings().setMappedData(FormalParameterPropertyPage.this.parameterType, data);
                FormalParameterPropertyPage.this.validatePage();
            }
        });
        return composite;
    }

    private List<ViewerFilter> getTypeFilters() {
        ArrayList<ViewerFilter> result = new ArrayList<ViewerFilter>();
        result.add(new PrimitiveTypesFilter("primitive"));
        result.add(new StructuredTypesFilter("struct"));
        result.add(new DocumentTypesFilter("dmsDocument"));
        result.add(new DocumentListTypesFilter("dmsDocumentList"));
        return result;
    }

    private void validatePage() {
        boolean enable = true;
        if (this.directionCombo.getViewer().getSelection().isEmpty()) {
            this.directionCombo.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.directionCombo.getLabel().setToolTipText(Diagram_Messages.LBL_PLEASE_PROVIDE_A_DIRECTION);
            enable = false;
        } else {
            this.directionCombo.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        }
        if (this.categoryCombo.getViewer().getSelection().isEmpty()) {
            this.categoryCombo.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.categoryCombo.getLabel().setToolTipText(Diagram_Messages.LBL_PLEASE_PROVIDE_A_CATEGORY);
            enable = false;
        } else {
            this.categoryCombo.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        }
        if (this.dataTypeCombo.getViewer().getSelection().isEmpty()) {
            this.dataTypeCombo.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.dataTypeCombo.getLabel().setToolTipText(Diagram_Messages.LBL_TXT_PLEASE_PROVIDE_A_DATATYPE);
            enable = false;
        } else {
            this.dataTypeCombo.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        }
        if (this.dataCombo.getViewer().getSelection().isEmpty()) {
            this.dataCombo.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.dataCombo.getLabel().setToolTipText(Diagram_Messages.LBL_TXT_PLEASE_PROVIDE_A_DATA);
            enable = false;
        } else {
            this.dataCombo.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        }
        if (StringUtils.isEmpty(this.nameText.getText().getText())) {
            enable = false;
            this.nameText.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.nameText.getLabel().setToolTipText(Diagram_Messages.LBL_TXT_PLEASE_PROVIDE_A_NAME);
        } else {
            this.nameText.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        }
        if (StringUtils.isEmpty(this.idText.getText().getText())) {
            enable = false;
            this.idText.getLabel().setValidationStatus(IQuickValidationStatus.ERRORS);
            this.idText.getLabel().setToolTipText(Diagram_Messages.LBL_TXT_PLEASE_PROVIDE_A_ID);
        } else {
            this.idText.getLabel().setValidationStatus(IQuickValidationStatus.OK);
        }
        if (!this.readOnly) {
            this.enablePage(enable);
        }
    }

    private void enablePage(boolean enabled) {
        this.setValid(enabled);
        this.getApplyButton().setEnabled(enabled);
    }

    public class DocumentListTypesFilter
    extends TypeFilter {
        public DocumentListTypesFilter(String name) {
            super(name);
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof TypeDeclarationType;
        }

        public String toString() {
            return Diagram_Messages.TXT_DOCUMENT_LIST;
        }
    }

    public class DocumentTypesFilter
    extends TypeFilter {
        public DocumentTypesFilter(String name) {
            super(name);
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof TypeDeclarationType;
        }

        public String toString() {
            return Diagram_Messages.TXT_DOCUMENT;
        }
    }

    public class EmptyFilter
    extends TypeFilter {
        public EmptyFilter(String name) {
            super(name);
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return false;
        }
    }

    public class PrimitiveTypesFilter
    extends TypeFilter {
        public PrimitiveTypesFilter(String name) {
            super(name);
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return element instanceof Type;
        }

        public String toString() {
            return Diagram_Messages.TXT_PRIMITIVE_DATA;
        }
    }

    public class StructuredTypesFilter
    extends TypeFilter {
        public StructuredTypesFilter(String name) {
            super(name);
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TypeDeclarationType) {
                TypeDeclarationType decl = (TypeDeclarationType)element;
                return !decl.getName().equals("<default>");
            }
            return false;
        }

        public String toString() {
            return Diagram_Messages.TXT_STRUCTURED_TYPE;
        }
    }

    public class TypeFilter
    extends ViewerFilter {
        private String name;

        public TypeFilter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return false;
        }
    }
}

