/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ScopeUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.AccessPathBrowserComposite;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathModelAdapter2;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathWidgetAdapter2;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.stardust.modeling.validation.Validation_Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class OrganizationRuntimeBindingPropertyPage
extends AbstractModelElementPropertyPage {
    private ComboViewer dataText;
    private AccessPathBrowserComposite dataPathBrowser;
    private LabelWithStatus dataLabel;
    private LabelWithStatus dataPathLabel;
    private Group dataGroup;
    private Button departmentsCheckBox;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        WidgetBindingManager binding = this.getWidgetBindingManager();
        ModelType model = ModelUtils.findContainingModel((EObject)element);
        boolean hasDepartments = AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:bound");
        this.departmentsCheckBox.setSelection(hasDepartments);
        binding.getModelBindingManager().bind((IModelAdapter)new Data2DataPathModelAdapter2(model, model.getData()), (IWidgetAdapter)new Data2DataPathWidgetAdapter2((StructuredViewer)this.dataText, this.dataPathBrowser, DirectionType.IN_LITERAL));
        binding.bind(new LabeledViewer((StructuredViewer)this.dataText, this.dataLabel), (IExtensibleElement)element, "carnot:engine:dataId", (List)model.getData());
        binding.bind(new LabeledText(this.dataPathBrowser.getMethodText(), this.dataPathLabel), (IExtensibleElement)element, "carnot:engine:dataPath");
        this.dataGroup.setVisible(hasDepartments);
        this.validate(null);
    }

    private void validate(Object selection) {
        String dataPath = null;
        DataType dataType = null;
        if (selection != null) {
            if (selection instanceof String) {
                dataPath = (String)selection;
            } else if (selection instanceof DataType) {
                dataType = (DataType)selection;
            }
        }
        boolean isValid = true;
        IModelElement modelElement = (IModelElement)this.getModelElement();
        if (AttributeUtil.getBooleanValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:engine:bound") && !ScopeUtils.isValidScopeData((IExtensibleElement)((OrganizationType)modelElement), (String)dataPath, (DataType)dataType)) {
            isValid = false;
        }
        if (isValid) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(Validation_Messages.ERR_ORGANIZATION_InvalidScopeData);
            this.setValid(false);
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.createDataGroup(composite);
        return composite;
    }

    private void createDataGroup(Composite composite) {
        this.departmentsCheckBox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BOX_ORGANIZATION_SUPPORTS_DEPARTMENT, (int)2);
        this.departmentsCheckBox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ModelType modelType;
                boolean selection = OrganizationRuntimeBindingPropertyPage.this.departmentsCheckBox.getSelection();
                OrganizationRuntimeBindingPropertyPage.this.dataGroup.setVisible(selection);
                AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)OrganizationRuntimeBindingPropertyPage.this.getModelElement()), (String)"carnot:engine:bound", (Boolean)selection);
                if (selection) {
                    modelType = (ModelType)OrganizationRuntimeBindingPropertyPage.this.getModelElement().eContainer();
                    AttributeUtil.setReference((IExtensibleElement)((IExtensibleElement)OrganizationRuntimeBindingPropertyPage.this.getModelElement()), (String)"carnot:engine:dataId", (EObject)((EObject)modelType.getData().get(0)));
                } else {
                    AttributeUtil.setReference((IExtensibleElement)((IExtensibleElement)OrganizationRuntimeBindingPropertyPage.this.getModelElement()), (String)"carnot:engine:dataId", null);
                }
                if (selection) {
                    modelType = (ModelType)OrganizationRuntimeBindingPropertyPage.this.getModelElement().eContainer();
                    AttributeUtil.setReference((IExtensibleElement)((IExtensibleElement)OrganizationRuntimeBindingPropertyPage.this.getModelElement()), (String)"carnot:engine:dataId", (EObject)((EObject)modelType.getData().get(0)));
                } else {
                    AttributeUtil.setReference((IExtensibleElement)((IExtensibleElement)OrganizationRuntimeBindingPropertyPage.this.getModelElement()), (String)"carnot:engine:dataId", null);
                }
                OrganizationRuntimeBindingPropertyPage.this.validate(null);
            }
        });
        FormBuilder.createLabel((Composite)composite, (String)" ", (int)2);
        this.dataGroup = FormBuilder.createGroup((Composite)composite, (String)Diagram_Messages.LB_Department_Oid, (int)2, (int)2);
        GridData gridDataGroup = new GridData(4, 0, false, false);
        gridDataGroup.horizontalSpan = 2;
        this.dataGroup.setLayoutData((Object)gridDataGroup);
        this.dataLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataGroup, (String)Diagram_Messages.LB_Data);
        this.dataText = new ComboViewer(FormBuilder.createCombo((Composite)this.dataGroup));
        this.dataText.setSorter(new ViewerSorter());
        this.dataText.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataText.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.dataText.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    AttributeType attributeType;
                    Object element = ((StructuredSelection)event.getSelection()).getFirstElement();
                    if (element != null && !AttributeUtil.isReference((AttributeType)(attributeType = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)OrganizationRuntimeBindingPropertyPage.this.getModelElement()), (String)"carnot:engine:dataId")))) {
                        AttributeUtil.setReference((IExtensibleElement)((IExtensibleElement)OrganizationRuntimeBindingPropertyPage.this.getModelElement()), (String)"carnot:engine:dataId", (EObject)((EObject)element));
                    }
                    OrganizationRuntimeBindingPropertyPage.this.validate(element);
                }
            }
        });
        this.dataPathLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)this.dataGroup, (String)Diagram_Messages.LB_DataPath);
        this.dataPathBrowser = new AccessPathBrowserComposite(this.getEditor(), (Composite)this.dataGroup, Diagram_Messages.LB_DataPath);
        this.dataPathBrowser.getMethodText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text;
                if (e.getSource() instanceof Text && (text = (Text)e.getSource()).getText() != "") {
                    OrganizationRuntimeBindingPropertyPage.this.validate(text.getText());
                }
            }
        });
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }
}

