/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IdRef;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.ExtensionsFactory;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingType;
import org.eclipse.stardust.model.xpdl.carnot.extensions.FormalParameterMappingsType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IConnectionManager;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParameterType;
import org.eclipse.stardust.model.xpdl.xpdl2.FormalParametersType;
import org.eclipse.stardust.model.xpdl.xpdl2.ModeType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlFactory;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DefaultOutlineProvider;
import org.eclipse.stardust.modeling.core.properties.FormalParameterPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.IProcessInterfaceInvocationGenerator;
import org.eclipse.stardust.modeling.core.properties.ModelElementsOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.properties.ModelElementsTableContentProvider;
import org.eclipse.stardust.modeling.core.properties.ProcessDefinitionImplemetationLabelProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ProcessInterfacePropertyPage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    public static final String FORMAL_PARAMETERS_ID = "interface";
    public static final String SOAP_INVOCATION_TYPE = "SOAP";
    public static final String REST_INVOCATION_TYPE = "REST";
    public static final String BOTH_INVOCATION_TYPES = "BOTH";
    private static final int[] elementFeatureIds = new int[]{2, 4, 3};
    private static final String[] labelProperties = new String[]{Diagram_Messages.LBL_ID, Diagram_Messages.LBL_NAME};
    private Button[] buttons;
    private Object selection;
    private EObjectLabelProvider labelProvider;
    private TableViewer implementsViewer;
    private ModelElementsOutlineSynchronizer outlineSynchronizer;
    private boolean isImplementing = false;
    private boolean isProviding = false;
    private ProcessDefinitionType process = null;
    private Table implementsTable;
    private TableViewer parametersViewer;
    private List<ProcessDefinitionType> processes;
    private FormalParameterMappingsType parameterMappings;
    private FormalParametersType formalParameters;
    private Composite mainComposite;
    private Composite comboComposite;
    private Composite stackComposite;
    private Composite exposesComposite;
    private Composite implementsComposite;
    private Composite verticalButtonsComposite;
    private Combo combo;
    private StackLayout stackLayout;
    private Composite wsdlComposite;
    private LabelWithStatus wsdlLabel;
    private Button wsdlButton;
    private Button restButton;
    private static final String INVOCATION_GENERATOR_ID = "org.eclipse.stardust.modeling.core.processInterfaceInvocationGenerator";
    private IProcessInterfaceInvocationGenerator[] piInvocationGenerators;

    public ProcessInterfacePropertyPage() {
        IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(INVOCATION_GENERATOR_ID);
        List genList = CollectionUtils.newList();
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IProcessInterfaceInvocationGenerator) {
                    genList.add((IProcessInterfaceInvocationGenerator)o);
                }
                ++n2;
            }
            this.piInvocationGenerators = genList.toArray(new IProcessInterfaceInvocationGenerator[0]);
        }
        catch (CoreException ex) {
            System.out.println(ex.getMessage());
            this.piInvocationGenerators = new IProcessInterfaceInvocationGenerator[0];
        }
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.process = (ProcessDefinitionType)element;
        this.initializeImplementsPanel();
        this.initalizeExposePanel();
        if (this.isProviding) {
            this.combo.select(1);
        } else if (this.isImplementing) {
            this.combo.select(0);
        } else {
            this.combo.select(2);
        }
        this.updateStackLayout();
        this.updateOutline();
    }

    private void updateOutline() {
        this.outlineSynchronizer.setInit(false);
        if (this.isProviding) {
            this.outlineSynchronizer.init((EObject)this.formalParameters);
            this.updateButtons(null, this.buttons);
            this.expandTree();
        } else if (this.isImplementing) {
            ProcessDefinitionType selectedProcess;
            IdRef externalReference = this.process.getExternalRef();
            if (externalReference != null && (selectedProcess = this.findProcess(externalReference)) != null) {
                this.parametersViewer.getTable().select(this.processes.indexOf(selectedProcess));
                this.outlineSynchronizer.init((EObject)selectedProcess.getFormalParameters());
                this.expandTree();
            }
        } else {
            this.outlineSynchronizer.init(null);
        }
    }

    @Override
    public void apply() {
        if (!this.isImplementing) {
            this.process.setExternalRef(null);
        }
        if (!this.isProviding && !this.isImplementing) {
            this.process.setFormalParameters(null);
            this.process.setFormalParameterMappings(null);
        }
        this.validatePage();
    }

    private void initializeImplementsPanel() {
        ProcessDefinitionType selectedProcess;
        IdRef externalReference = this.process.getExternalRef();
        this.implementsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem tableItem;
                if (e.item != null && (tableItem = (TableItem)e.item).getData() != null) {
                    ProcessDefinitionType processDefinition = (ProcessDefinitionType)tableItem.getData();
                    ModelType referencedModel = (ModelType)processDefinition.eContainer();
                    ExternalPackage packageRef = ProcessInterfacePropertyPage.this.getEditor().getWorkflowModel().getExternalPackages().getExternalPackage(referencedModel.getId());
                    IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
                    idRef.setRef(processDefinition.getId());
                    idRef.setPackageRef(packageRef);
                    ProcessInterfacePropertyPage.this.process.setExternalRef(idRef);
                    ProcessInterfacePropertyPage.this.parameterMappings = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
                    FormalParametersType referencedParametersType = processDefinition.getFormalParameters();
                    ProcessInterfacePropertyPage.this.formalParameters = XpdlFactory.eINSTANCE.createFormalParametersType();
                    for (FormalParameterType referencedParameterType : referencedParametersType.getFormalParameter()) {
                        FormalParameterType parameterType = ModelUtils.cloneFormalParameterType((FormalParameterType)referencedParameterType, null);
                        ProcessInterfacePropertyPage.this.formalParameters.addFormalParameter(parameterType);
                        ProcessInterfacePropertyPage.this.parameterMappings.setMappedData(parameterType, null);
                    }
                    ProcessInterfacePropertyPage.this.process.setFormalParameters(ProcessInterfacePropertyPage.this.formalParameters);
                    ProcessInterfacePropertyPage.this.process.setFormalParameterMappings(ProcessInterfacePropertyPage.this.parameterMappings);
                    ProcessInterfacePropertyPage.this.updateOutline();
                }
            }
        });
        boolean bl = this.isImplementing = externalReference != null;
        if (externalReference != null && (selectedProcess = this.findProcess(externalReference)) != null) {
            this.implementsViewer.getTable().select(this.processes.indexOf(selectedProcess));
        }
    }

    private void initalizeExposePanel() {
        this.formalParameters = this.process.getFormalParameters();
        this.parameterMappings = this.process.getFormalParameterMappings();
        this.isProviding = this.parameterMappings != null && this.process.getExternalRef() == null;
        this.parametersViewer.setInput((Object)this.formalParameters);
        if (this.formalParameters != null) {
            AttributeType externalInvocationType = AttributeUtil.getAttribute((IExtensibleElement)this.process, (String)"carnot:engine:externalInvocationType");
            String externalInvocationTypeValue = null;
            if (externalInvocationType == null) {
                this.wsdlButton.setSelection(false);
                this.restButton.setSelection(false);
            } else {
                externalInvocationTypeValue = externalInvocationType.getValue();
                if (externalInvocationTypeValue.equalsIgnoreCase(SOAP_INVOCATION_TYPE)) {
                    this.wsdlButton.setSelection(true);
                    this.restButton.setSelection(false);
                } else if (externalInvocationTypeValue.equalsIgnoreCase(REST_INVOCATION_TYPE)) {
                    this.restButton.setSelection(true);
                    this.wsdlButton.setSelection(false);
                } else {
                    this.restButton.setSelection(true);
                    this.wsdlButton.setSelection(true);
                }
            }
            IProcessInterfaceInvocationGenerator[] iProcessInterfaceInvocationGeneratorArray = this.piInvocationGenerators;
            int n = this.piInvocationGenerators.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessInterfaceInvocationGenerator piInvocationGenerator = iProcessInterfaceInvocationGeneratorArray[n2];
                piInvocationGenerator.setComponentVisibility(externalInvocationTypeValue);
                ++n2;
            }
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public void dispose() {
        if (this.outlineSynchronizer != null) {
            this.outlineSynchronizer.dispose();
        }
        super.dispose();
    }

    private Object getSelectedItem() {
        if (this.parametersViewer != null) {
            IStructuredSelection sel = (IStructuredSelection)this.parametersViewer.getSelection();
            Object selection = sel.getFirstElement();
            return selection;
        }
        return null;
    }

    @Override
    public Control createBody(Composite parent) {
        this.stackLayout = new StackLayout();
        this.mainComposite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.comboComposite = FormBuilder.createComposite((Composite)this.mainComposite, (int)1);
        GridData gridData = new GridData();
        gridData.grabExcessVerticalSpace = false;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.comboComposite.setLayoutData((Object)gridData);
        this.combo = FormBuilder.createCombo((Composite)this.comboComposite, (int)1);
        this.combo.add(Diagram_Messages.COMBOBOX_Implement_Process_Interface);
        this.combo.add(Diagram_Messages.COMBOBOX_Provide_Process_Interface);
        this.combo.add(Diagram_Messages.COMBOBOX_No_Process_Interface);
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.updateModel();
                ProcessInterfacePropertyPage.this.updateStackLayout();
                ProcessInterfacePropertyPage.this.updateOutline();
            }
        });
        this.stackComposite = FormBuilder.createComposite((Composite)this.mainComposite, (int)1);
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.exposesComposite = this.createExposeComposite(this.stackComposite);
        this.implementsComposite = this.createImplementsPanel(this.stackComposite);
        this.stackLayout.topControl = this.implementsComposite;
        this.mainComposite.setEnabled(this.enablePage);
        return this.mainComposite;
    }

    private Composite createImplementsPanel(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.implementsTable = new Table(composite, 67584);
        this.implementsTable.setHeaderVisible(true);
        this.implementsTable.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)this.implementsTable);
        this.implementsViewer = new TableViewer(this.implementsTable);
        TableUtil.createColumns(this.implementsTable, new String[]{Diagram_Messages.COL_MD, Diagram_Messages.COL_PROCESS});
        TableUtil.setInitialColumnSizes(this.implementsTable, new int[]{35, 35});
        this.processes = this.collectReferencedProcessDefinitions(this.getEditor().getWorkflowModel());
        this.implementsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.implementsViewer.setLabelProvider((IBaseLabelProvider)new ProcessDefinitionImplemetationLabelProvider());
        this.implementsViewer.setInput(this.processes);
        this.implementsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TableItem tableItem;
                if (e.item != null && (tableItem = (TableItem)e.item).getData() != null) {
                    ProcessDefinitionType referencedProcess = (ProcessDefinitionType)tableItem.getData();
                    ModelType referencedModel = (ModelType)referencedProcess.eContainer();
                    ExternalPackage packageRef = ProcessInterfacePropertyPage.this.getEditor().getWorkflowModel().getExternalPackages().getExternalPackage(referencedModel.getId());
                    IdRef idRef = CarnotWorkflowModelFactory.eINSTANCE.createIdRef();
                    idRef.setRef(referencedProcess.getId());
                    idRef.setPackageRef(packageRef);
                    ProcessInterfacePropertyPage.this.process.setExternalRef(idRef);
                    ProcessInterfacePropertyPage.this.parameterMappings = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
                    for (FormalParameterMappingType mappingType : referencedProcess.getFormalParameterMappings().getMapping()) {
                        ProcessInterfacePropertyPage.this.parameterMappings.setMappedData(mappingType.getParameter(), null);
                    }
                    ProcessInterfacePropertyPage.this.process.setFormalParameterMappings(ProcessInterfacePropertyPage.this.parameterMappings);
                    ProcessInterfacePropertyPage.this.updateOutline();
                }
            }
        });
        return composite;
    }

    private void evaluateCheckBoxSelection() {
        String externalInvocationTypeValue = null;
        if (this.wsdlButton.getSelection() && this.restButton.getSelection()) {
            externalInvocationTypeValue = BOTH_INVOCATION_TYPES;
        } else if (!this.wsdlButton.getSelection() && this.restButton.getSelection()) {
            externalInvocationTypeValue = REST_INVOCATION_TYPE;
        } else if (this.wsdlButton.getSelection() && !this.restButton.getSelection()) {
            externalInvocationTypeValue = SOAP_INVOCATION_TYPE;
        }
        AttributeUtil.setAttribute((IExtensibleElement)this.process, (String)"carnot:engine:externalInvocationType", (String)externalInvocationTypeValue);
        IProcessInterfaceInvocationGenerator[] iProcessInterfaceInvocationGeneratorArray = this.piInvocationGenerators;
        int n = this.piInvocationGenerators.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessInterfaceInvocationGenerator piInvocationGenerator = iProcessInterfaceInvocationGeneratorArray[n2];
            piInvocationGenerator.setComponentVisibility(externalInvocationTypeValue);
            ++n2;
        }
        this.validatePage();
    }

    private Composite createExposeComposite(Composite parent) {
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.validatePage();
            }
        });
        TabItem definitionItem = new TabItem(tabFolder, 0);
        definitionItem.setText(Diagram_Messages.LB_PROCESSINTERFACE_FORMAL_PARAMETERS);
        TabItem wsdlItem = new TabItem(tabFolder, 0);
        wsdlItem.setText(Diagram_Messages.LB_PROCESSINTERFACE_REMOTE_INVOCATION);
        Composite exposeComposite = FormBuilder.createComposite((Composite)tabFolder, (int)2);
        definitionItem.setControl((Control)exposeComposite);
        this.wsdlComposite = FormBuilder.createComposite((Composite)tabFolder, (int)3);
        wsdlItem.setControl((Control)this.wsdlComposite);
        this.wsdlLabel = FormBuilder.createLabelWithLeftAlignedStatus((Composite)this.wsdlComposite, (String)Diagram_Messages.LBL_INVOCATION_TYPE);
        this.wsdlButton = FormBuilder.createCheckBox((Composite)this.wsdlComposite, (String)Diagram_Messages.BUT_BOX_SOAP);
        this.wsdlButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.evaluateCheckBoxSelection();
            }
        });
        this.restButton = FormBuilder.createCheckBox((Composite)this.wsdlComposite, (String)Diagram_Messages.BUT_BOX_REST);
        this.restButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.evaluateCheckBoxSelection();
            }
        });
        IProcessInterfaceInvocationGenerator.IProcessDefinitionTypeProvider processProvider = new IProcessInterfaceInvocationGenerator.IProcessDefinitionTypeProvider(){

            @Override
            public ProcessDefinitionType getProcessDefinitionType() {
                return ProcessInterfacePropertyPage.this.process;
            }
        };
        IProcessInterfaceInvocationGenerator[] iProcessInterfaceInvocationGeneratorArray = this.piInvocationGenerators;
        int n = this.piInvocationGenerators.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessInterfaceInvocationGenerator piInvocationGenerator = iProcessInterfaceInvocationGeneratorArray[n2];
            piInvocationGenerator.createExposeComposite(this.wsdlComposite, processProvider);
            ++n2;
        }
        Table table = new Table(exposeComposite, 67584);
        table.setHeaderVisible(true);
        table.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)table);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.updateButtons(ProcessInterfacePropertyPage.this.getSelectedItem(), ProcessInterfacePropertyPage.this.buttons);
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = ProcessInterfacePropertyPage.this.getSelectedItem();
                if (selection instanceof FormalParameterType) {
                    ProcessInterfacePropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        this.parametersViewer = new TableViewer(table);
        TableUtil.createColumns(table, new String[]{Diagram_Messages.COL_NAME_Id, Diagram_Messages.COL_NAME_Name, Diagram_Messages.COL_NAME_Mode});
        TableUtil.setInitialColumnSizes(table, new int[]{35, 35, 30});
        this.labelProvider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public String getText(String name, Object element) {
                FormalParameterType parameterType = (FormalParameterType)element;
                if ("id".equalsIgnoreCase(name)) {
                    return parameterType.getId();
                }
                if ("name".equalsIgnoreCase(name)) {
                    parameterType.getName();
                }
                if ("mode".equalsIgnoreCase(name)) {
                    if (parameterType.getMode().equals((Object)ModeType.IN)) {
                        return "IN";
                    }
                    if (parameterType.getMode().equals((Object)ModeType.OUT)) {
                        return "OUT";
                    }
                    if (parameterType.getMode().equals((Object)ModeType.INOUT)) {
                        return "INOUT";
                    }
                }
                return super.getText(name, element);
            }
        };
        TableUtil.setLabelProvider(this.parametersViewer, (TableLabelProvider)this.labelProvider, new String[]{"id", "name", "mode"});
        this.parametersViewer.setContentProvider((IContentProvider)new ModelElementsTableContentProvider((EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParametersType_FormalParameter(), elementFeatureIds, labelProperties));
        this.outlineSynchronizer = new ModelElementsOutlineSynchronizer(new DefaultOutlineProvider((AbstractModelElementPropertyPage)this, (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParametersType_FormalParameter(), (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Id(), (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Name(), FORMAL_PARAMETERS_ID, FormalParameterPropertyPage.class.getName()));
        this.addModelElementsOutlineSynchronizer(this.outlineSynchronizer);
        this.verticalButtonsComposite = FormBuilder.createComposite((Composite)exposeComposite, (int)1);
        return tabFolder;
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(this.verticalButtonsComposite);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateButtons(this.getSelectedItem(), this.buttons);
            this.validatePage();
        }
        super.setVisible(visible);
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        this.selection = selection;
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].isDisposed()) {
                return;
            }
            ++i;
        }
        buttons[0].setEnabled(true);
        buttons[1].setEnabled(selection instanceof FormalParameterType);
        buttons[2].setEnabled(selection instanceof FormalParameterType && this.canMoveUp((FormalParameterType)selection));
        buttons[3].setEnabled(selection instanceof FormalParameterType && this.canMoveDown((FormalParameterType)selection));
    }

    private boolean canMoveUp(FormalParameterType selection) {
        ProcessDefinitionType pd;
        Proxy proxy;
        InvocationHandler ih;
        Object value;
        if (selection instanceof Proxy && (value = Reflect.getFieldValue((Object)(ih = Proxy.getInvocationHandler(proxy = (Proxy)selection)), (String)"val$element")) != null) {
            selection = (FormalParameterType)value;
        }
        if ((pd = (ProcessDefinitionType)selection.eContainer().eContainer()) == null || pd.getFormalParameters() == null || pd.getFormalParameters().getFormalParameter() == null) {
            return false;
        }
        return pd.getFormalParameters().getFormalParameter().indexOf((Object)selection) > 0;
    }

    private boolean canMoveDown(FormalParameterType selection) {
        ProcessDefinitionType pd;
        Proxy proxy;
        InvocationHandler ih;
        Object value;
        if (selection instanceof Proxy && (value = Reflect.getFieldValue((Object)(ih = Proxy.getInvocationHandler(proxy = (Proxy)selection)), (String)"val$element")) != null) {
            selection = (FormalParameterType)value;
        }
        if ((pd = (ProcessDefinitionType)selection.eContainer().eContainer()) == null || pd.getFormalParameters() == null || pd.getFormalParameters().getFormalParameter() == null) {
            return false;
        }
        int index = pd.getFormalParameters().getFormalParameter().indexOf((Object)selection);
        return index >= 0 && index < pd.getFormalParameters().getFormalParameter().size() - 1;
    }

    @Override
    public Button[] createButtons(Composite parent) {
        Button[] buttons;
        buttons = new Button[]{FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.performAdd(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.performDelete(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveUp, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.performUp(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveDown, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProcessInterfacePropertyPage.this.performDown(buttons);
            }
        })};
        return buttons;
    }

    @Override
    public Object getSelection() {
        return this.selection == null ? this.getSelectedItem() : this.selection;
    }

    private void performUp(Button[] buttons) {
        EList params;
        int index;
        Proxy proxy;
        InvocationHandler ih;
        Object value;
        FormalParameterType fpt = (FormalParameterType)this.getSelection();
        if (fpt instanceof Proxy && (value = Reflect.getFieldValue((Object)(ih = Proxy.getInvocationHandler(proxy = (Proxy)fpt)), (String)"val$element")) != null) {
            fpt = (FormalParameterType)value;
        }
        if ((index = (params = this.process.getFormalParameters().getFormalParameter()).indexOf((Object)fpt)) > 0) {
            params.move(index - 1, index);
            this.updateButtons(params, buttons);
        }
    }

    private void performDown(Button[] buttons) {
        EList params;
        int index;
        Proxy proxy;
        InvocationHandler ih;
        Object value;
        FormalParameterType fpt = (FormalParameterType)this.getSelection();
        if (fpt instanceof Proxy && (value = Reflect.getFieldValue((Object)(ih = Proxy.getInvocationHandler(proxy = (Proxy)fpt)), (String)"val$element")) != null) {
            fpt = (FormalParameterType)value;
        }
        if ((index = (params = this.process.getFormalParameters().getFormalParameter()).indexOf((Object)fpt)) >= 0 && index < params.size() - 1) {
            params.move(index + 1, index);
            this.updateButtons(fpt, buttons);
        }
    }

    private void performDelete(Button[] buttons) {
        FormalParameterType fpt = (FormalParameterType)this.getSelection();
        if (fpt instanceof Proxy) {
            for (FormalParameterType t : this.process.getFormalParameters().getFormalParameter()) {
                if (t.getId() == null && fpt.getId() == null) {
                    fpt = t;
                    continue;
                }
                if (!t.getId().equalsIgnoreCase(fpt.getId())) continue;
                fpt = t;
            }
        }
        this.process.getFormalParameters().getFormalParameter().remove((Object)fpt);
        if (fpt.getId() == null) {
            fpt.setId("****");
        }
        this.process.getFormalParameterMappings().setMappedData(fpt, null);
        this.updateButtons(null, buttons);
        this.updateOutline();
        this.selectPage(FORMAL_PARAMETERS_ID);
    }

    private void performAdd(Button[] buttons) {
        IdFactory idFactory = new IdFactory(Diagram_Messages.ID_FormalParameter, Diagram_Messages.BASENAME_FormalParameter, XpdlPackage.eINSTANCE.getFormalParameterType(), (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Id(), (EStructuralFeature)XpdlPackage.eINSTANCE.getFormalParameterType_Name());
        idFactory.computeNames((List)this.process.getFormalParameters().getFormalParameter());
        XpdlFactory xpdlFactory = XpdlPackage.eINSTANCE.getXpdlFactory();
        FormalParameterType parameterType = xpdlFactory.createFormalParameterType();
        parameterType.setId(idFactory.getId());
        parameterType.setName(idFactory.getName());
        this.formalParameters.addFormalParameter(parameterType);
        this.selectPageForObject(parameterType);
    }

    private List<ProcessDefinitionType> collectReferencedProcessDefinitions(ModelType model) {
        List processesList = CollectionUtils.newList();
        ExternalPackages packages = model.getExternalPackages();
        if (packages != null) {
            for (ExternalPackage pkg : packages.getExternalPackage()) {
                EList externalDeclarations;
                IConnectionManager manager;
                String uri = ExtendedAttributeUtil.getAttributeValue((Extensible)pkg, (String)"carnot:connection:uri");
                if (StringUtils.isEmpty((String)uri) || (manager = model.getConnectionManager()) == null) continue;
                EObject externalModel = manager.find(uri);
                if (externalModel instanceof IObjectReference) {
                    externalModel = ((IObjectReference)externalModel).getEObject();
                }
                if (!(externalModel instanceof ModelType) || (externalDeclarations = ((ModelType)externalModel).getProcessDefinition()) == null) continue;
                for (ProcessDefinitionType externalProcess : externalDeclarations) {
                    if (externalProcess.getFormalParameters() == null) continue;
                    processesList.add(externalProcess);
                }
            }
        }
        return processesList;
    }

    private ProcessDefinitionType findProcess(IdRef externalReference) {
        for (ProcessDefinitionType proc : this.processes) {
            ModelType refModel = (ModelType)proc.eContainer();
            String pid = externalReference.getRef();
            String mid = externalReference.getPackageRef().getId();
            if (!refModel.getId().equalsIgnoreCase(mid) || !proc.getId().equalsIgnoreCase(pid)) continue;
            return proc;
        }
        return null;
    }

    private void updateStackLayout() {
        if (this.combo.getSelectionIndex() == 1) {
            this.isProviding = true;
            this.isImplementing = false;
            this.stackLayout.topControl = this.exposesComposite;
        }
        if (this.combo.getSelectionIndex() == 0) {
            this.isProviding = false;
            this.isImplementing = true;
            this.stackLayout.topControl = this.implementsComposite;
        }
        if (this.combo.getSelectionIndex() == 2) {
            this.isProviding = false;
            this.isImplementing = false;
            this.stackLayout.topControl = null;
        }
        this.stackComposite.layout();
    }

    private void updateModel() {
        if (this.combo.getSelectionIndex() == 0) {
            this.isProviding = false;
            this.isImplementing = true;
            this.outlineSynchronizer.init(null);
        }
        if (this.combo.getSelectionIndex() == 1) {
            this.formalParameters = this.process.getFormalParameters();
            if (this.formalParameters == null) {
                this.formalParameters = XpdlFactory.eINSTANCE.createFormalParametersType();
                this.process.setFormalParameters(this.formalParameters);
            }
            this.parameterMappings = this.process.getFormalParameterMappings();
            if (this.parameterMappings == null) {
                this.parameterMappings = ExtensionsFactory.eINSTANCE.createFormalParameterMappingsType();
                this.process.setFormalParameterMappings(this.parameterMappings);
            }
        }
    }

    @Override
    public void setEnablePage(boolean enablePage) {
        this.enablePage = enablePage;
    }

    private void validatePage() {
        String validationProblem = null;
        if (this.process != null && this.process.getFormalParameters() != null && AttributeUtil.getAttribute((IExtensibleElement)this.process, (String)"carnot:engine:externalInvocationType") != null) {
            for (FormalParameterType parameterType : this.process.getFormalParameters().getFormalParameter()) {
                DataType dataType;
                String typeValue;
                String category = parameterType.getDataType().getCarnotType();
                if (category == null) {
                    if (parameterType.getDataType().getBasicType() != null) {
                        category = "primitive";
                    }
                    if (parameterType.getDataType().getDeclaredType() != null) {
                        category = "struct";
                    }
                } else {
                    category = parameterType.getDataType().getCarnotType();
                }
                if (!"struct".equals(category) && !"primitive".equals(category)) {
                    validationProblem = Diagram_Messages.MODEL_ProcessInterface_InvalidForExternalInvocation;
                    continue;
                }
                if (!"primitive".equals(category) || !(typeValue = AttributeUtil.getAttributeValue((IExtensibleElement)(dataType = this.process.getFormalParameterMappings().getMappedData(parameterType)), (String)"carnot:engine:type")).equals(Type.Calendar.getId()) && !typeValue.equals(Type.Timestamp.getId())) continue;
                validationProblem = Diagram_Messages.MODEL_ProcessInterface_InvalidForExternalInvocation;
            }
        }
        IQuickValidationStatus status = null;
        if (validationProblem != null && this.restButton != null && this.wsdlButton != null) {
            status = IQuickValidationStatus.ERRORS;
            this.wsdlLabel.setValidationStatus(status);
            this.wsdlLabel.setToolTipText(validationProblem);
        } else if (this.restButton != null && this.wsdlButton != null) {
            status = IQuickValidationStatus.OK;
            this.wsdlLabel.setValidationStatus(status);
            this.wsdlLabel.getLabel().setToolTipText(null);
        }
        IProcessInterfaceInvocationGenerator[] iProcessInterfaceInvocationGeneratorArray = this.piInvocationGenerators;
        int n = this.piInvocationGenerators.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessInterfaceInvocationGenerator piInvocationGenerator = iProcessInterfaceInvocationGeneratorArray[n2];
            piInvocationGenerator.handleValidationStatusFromParent(status);
            ++n2;
        }
    }
}

