/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.jms;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.engine.extensions.jms.app.JMSLocation;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.TypeSelectionComposite;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class RequestAccessPointPropertyPage
extends AbstractModelElementPropertyPage {
    private static final String[][] LOCATION = new String[][]{{JMSLocation.HEADER.getId(), "Header"}, {JMSLocation.BODY.getId(), "Body"}};
    private LabeledCombo locationCombo;
    private LabeledText idText;
    private LabeledText nameText;
    private LabelWithStatus lblClassName;
    private TypeSelectionComposite classNameBrowser;
    private LabeledText valueText;
    private Button autoIdButton;
    private Button[] buttons;
    private SelectionListener autoIdListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            boolean selection = ((Button)e.widget).getSelection();
            if (selection) {
                RequestAccessPointPropertyPage.this.idText.getText().setEditable(false);
                String computedId = ModelUtils.computeId((String)RequestAccessPointPropertyPage.this.nameText.getText().getText());
                RequestAccessPointPropertyPage.this.idText.getText().setText(computedId);
            } else {
                RequestAccessPointPropertyPage.this.idText.getText().setEditable(true);
            }
        }
    };
    private ModifyListener idSyncListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.widget;
            String name = text.getText();
            if (RequestAccessPointPropertyPage.this.autoIdButton.getSelection()) {
                RequestAccessPointPropertyPage.this.idText.getText().setText(ModelUtils.computeId((String)name));
            }
        }
    };

    protected boolean includeDefaultValue() {
        return true;
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.nameText.getText().removeModifyListener(this.idSyncListener);
        WidgetBindingManager binding = this.getWidgetBindingManager();
        AccessPointType ap = (AccessPointType)element;
        binding.bind(this.idText, (EObject)ap, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id());
        binding.bind(this.nameText, (EObject)ap, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name());
        binding.getValidationBindingManager().bind((EObject)ap, (Object)"carnot:engine:jms.location", this.locationCombo.getLabel());
        String location = AttributeUtil.getAttributeValue((IExtensibleElement)ap, (String)"carnot:engine:jms.location");
        this.locationCombo.getCombo().select(-1);
        int i = 0;
        while (i < LOCATION.length) {
            if (LOCATION[i][0].equals(location)) {
                this.locationCombo.getCombo().select(i);
                break;
            }
            ++i;
        }
        binding.bind(new LabeledText(this.classNameBrowser.getText(), this.lblClassName), (IExtensibleElement)ap, "carnot:engine:className");
        if (this.includeDefaultValue()) {
            binding.bind(this.valueText, (IExtensibleElement)ap, "carnot:engine:defaultValue");
        }
        this.nameText.getText().addModifyListener(this.idSyncListener);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        AccessPointType ap = (AccessPointType)element;
        int locationIndex = this.locationCombo.getCombo().getSelectionIndex();
        if (locationIndex < 0) {
            AttributeUtil.setAttribute((IExtensibleElement)ap, (String)"carnot:engine:jms.location", null);
        } else {
            AttributeUtil.setAttribute((IExtensibleElement)ap, (String)"carnot:engine:jms.location", (String)JMSLocation.class.getName(), (String)LOCATION[locationIndex][0]);
        }
        GenericUtils.setAutoIdValue(this.getModelElement(), this.autoIdButton.getSelection());
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.locationCombo = FormBuilder.createLabeledCombo((Composite)composite, (String)Diagram_Messages.LB_Location);
        int i = 0;
        while (i < LOCATION.length) {
            this.locationCombo.getCombo().add(LOCATION[i][1]);
            ++i;
        }
        this.nameText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.idText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Id);
        this.autoIdButton = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BTN_AutoId, (int)2);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue(this.getModelElement());
        this.autoIdButton.setSelection(autoIdButtonValue);
        if (autoIdButtonValue) {
            this.idText.getText().setEditable(false);
        }
        this.autoIdButton.addSelectionListener(this.autoIdListener);
        this.lblClassName = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_SPI_Type);
        this.classNameBrowser = new TypeSelectionComposite(composite, Diagram_Messages.LB_SPI_Type);
        if (this.includeDefaultValue()) {
            this.valueText = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_DefaultValue);
        }
        return composite;
    }

    public void setVisible(boolean visible) {
        IButtonManager manager;
        if (visible && (manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class)) != null) {
            manager.updateButtons(this.getModelElement(), this.buttons);
        }
        super.setVisible(visible);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        if (manager != null) {
            this.buttons = manager.createButtons(parent);
        }
    }
}

